/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.ServerConstants;

public class Validator {
    public static final boolean ENABLE_CHECKS = true;
    private static final String CLASS_NAME = Validator.class.getName();
    private static final String[] PARAM_DESCRIPTIONS = new String[]{"** A ZERO-BASED INDEX IS INVALID **", "(1st parameter)", "(2nd parameter)", "(3rd parameter)", "(4th parameter)", "(5th parameter)", "(6th parameter)", "(7th parameter)", "(8th parameter)", "(9th parameter)", "(10th parameter)"};
    private static long _errorCount = 0L;

    public static boolean ensureNotNull(Object object) throws AssertionError {
        if (object == null) {
            Validator.throwNull("");
        }
        return true;
    }

    public static boolean ensureNotNull(Object object, Object object2) throws AssertionError {
        if (object == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[1]);
        }
        if (object2 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[2]);
        }
        return true;
    }

    public static boolean ensureNotNull(Object object, Object object2, Object object3) throws AssertionError {
        if (object == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[1]);
        }
        if (object2 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[2]);
        }
        if (object3 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[3]);
        }
        return true;
    }

    public static boolean ensureNotNull(Object object, Object object2, Object object3, Object object4) throws AssertionError {
        if (object == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[1]);
        }
        if (object2 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[2]);
        }
        if (object3 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[3]);
        }
        if (object4 == null) {
            Validator.throwNull(PARAM_DESCRIPTIONS[4]);
        }
        return true;
    }

    public static boolean ensureTrue(boolean bl) throws AssertionError {
        if (!bl) {
            Validator.ensureTrue(bl, "");
        }
        return true;
    }

    public static boolean ensureTrue(boolean bl, String string) throws AssertionError {
        if (!bl) {
            String string2 = Validator.generateLineSpecificErrorMessage("The specified condition must be true. " + string);
            Validator.logError(string2);
            throw new AssertionError((Object)string2);
        }
        return true;
    }

    public static synchronized long getErrorCount() {
        return _errorCount;
    }

    public static synchronized void resetErrorCount() {
        _errorCount = 0L;
    }

    private static synchronized void incrementErrorCount() {
        ++_errorCount;
    }

    private static String generateLineSpecificErrorMessage(String string) {
        return string + "  The error occurred at " + Validator.getOriginalCallerLineInfo();
    }

    private static void throwNull(String string) throws AssertionError {
        String string2 = Validator.generateLineSpecificErrorMessage("The specified parameter must not be null. " + string);
        Validator.logError(string2);
        throw new AssertionError((Object)string2);
    }

    private static void logError(String string) {
        Validator.incrementErrorCount();
        String string2 = string + ServerConstants.EOL + Validator.getCallingStack();
        Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.ERROR, CLASS_NAME, "logError", string2);
        Error.logError(ErrorLogCategory.CORE_SERVER, ErrorLogSeverity.SEVERE_ERROR, 5505172, string2);
    }

    private static String getOriginalCallerLineInfo() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n = Validator.getOriginalCallerStackIndex(stackTraceElementArray);
        return stackTraceElementArray[n].toString();
    }

    private static String getCallingStack() {
        StackTraceElement[] stackTraceElementArray = Thread.currentThread().getStackTrace();
        int n = Validator.getOriginalCallerStackIndex(stackTraceElementArray);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = n; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            stringBuilder.append(stackTraceElement).append(ServerConstants.EOL);
        }
        return stringBuilder.toString();
    }

    private static int getOriginalCallerStackIndex(StackTraceElement[] stackTraceElementArray) {
        int n;
        StackTraceElement stackTraceElement = null;
        for (n = 0; n < stackTraceElementArray.length && ((stackTraceElement = stackTraceElementArray[n]).getClassName().equals(Validator.class.getName()) || stackTraceElement.getClassName().equals(Thread.class.getName())); ++n) {
        }
        return n;
    }
}

