/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.util;

import java.nio.ByteBuffer;
import java.text.ParseException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.util.Validator;

public final class Base64 {
    private static final String CLASS_NAME = "org.opends.server.util.Base64";
    private static final char[] BASE64_ALPHABET = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".toCharArray();

    private Base64() {
    }

    public static String encode(byte[] byArray) {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "encode", String.valueOf(byArray)));
        Validator.ensureNotNull(byArray);
        StringBuilder stringBuilder = new StringBuilder(4 * byArray.length / 3);
        int n2 = 0;
        int n3 = byArray.length / 3;
        for (n = 0; n < n3; ++n) {
            int n4 = (byArray[n2++] & 0xFF) << 16 | (byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF;
            stringBuilder.append(BASE64_ALPHABET[n4 >>> 18 & 0x3F]);
            stringBuilder.append(BASE64_ALPHABET[n4 >>> 12 & 0x3F]);
            stringBuilder.append(BASE64_ALPHABET[n4 >>> 6 & 0x3F]);
            stringBuilder.append(BASE64_ALPHABET[n4 & 0x3F]);
        }
        switch (byArray.length % 3) {
            case 1: {
                stringBuilder.append(BASE64_ALPHABET[byArray[n2] >>> 2 & 0x3F]);
                stringBuilder.append(BASE64_ALPHABET[byArray[n2] << 4 & 0x3F]);
                stringBuilder.append("==");
                break;
            }
            case 2: {
                n = (byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF;
                stringBuilder.append(BASE64_ALPHABET[n >>> 10 & 0x3F]);
                stringBuilder.append(BASE64_ALPHABET[n >>> 4 & 0x3F]);
                stringBuilder.append(BASE64_ALPHABET[n << 2 & 0x3F]);
                stringBuilder.append("=");
            }
        }
        return stringBuilder.toString();
    }

    public static byte[] decode(String string) throws ParseException {
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(string)));
        Validator.ensureNotNull(string);
        int n = string.length();
        if (n % 4 != 0) {
            int n2 = 5439489;
            String string2 = MessageHandler.getMessage(n2, string);
            throw new ParseException(string2, 0);
        }
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        for (int i = 0; i < n; i += 4) {
            boolean bl = true;
            int n3 = 0;
            for (int j = 0; j < 4; ++j) {
                switch (string.charAt(i + j)) {
                    case 'A': {
                        n3 <<= 6;
                        break;
                    }
                    case 'B': {
                        n3 = n3 << 6 | 1;
                        break;
                    }
                    case 'C': {
                        n3 = n3 << 6 | 2;
                        break;
                    }
                    case 'D': {
                        n3 = n3 << 6 | 3;
                        break;
                    }
                    case 'E': {
                        n3 = n3 << 6 | 4;
                        break;
                    }
                    case 'F': {
                        n3 = n3 << 6 | 5;
                        break;
                    }
                    case 'G': {
                        n3 = n3 << 6 | 6;
                        break;
                    }
                    case 'H': {
                        n3 = n3 << 6 | 7;
                        break;
                    }
                    case 'I': {
                        n3 = n3 << 6 | 8;
                        break;
                    }
                    case 'J': {
                        n3 = n3 << 6 | 9;
                        break;
                    }
                    case 'K': {
                        n3 = n3 << 6 | 0xA;
                        break;
                    }
                    case 'L': {
                        n3 = n3 << 6 | 0xB;
                        break;
                    }
                    case 'M': {
                        n3 = n3 << 6 | 0xC;
                        break;
                    }
                    case 'N': {
                        n3 = n3 << 6 | 0xD;
                        break;
                    }
                    case 'O': {
                        n3 = n3 << 6 | 0xE;
                        break;
                    }
                    case 'P': {
                        n3 = n3 << 6 | 0xF;
                        break;
                    }
                    case 'Q': {
                        n3 = n3 << 6 | 0x10;
                        break;
                    }
                    case 'R': {
                        n3 = n3 << 6 | 0x11;
                        break;
                    }
                    case 'S': {
                        n3 = n3 << 6 | 0x12;
                        break;
                    }
                    case 'T': {
                        n3 = n3 << 6 | 0x13;
                        break;
                    }
                    case 'U': {
                        n3 = n3 << 6 | 0x14;
                        break;
                    }
                    case 'V': {
                        n3 = n3 << 6 | 0x15;
                        break;
                    }
                    case 'W': {
                        n3 = n3 << 6 | 0x16;
                        break;
                    }
                    case 'X': {
                        n3 = n3 << 6 | 0x17;
                        break;
                    }
                    case 'Y': {
                        n3 = n3 << 6 | 0x18;
                        break;
                    }
                    case 'Z': {
                        n3 = n3 << 6 | 0x19;
                        break;
                    }
                    case 'a': {
                        n3 = n3 << 6 | 0x1A;
                        break;
                    }
                    case 'b': {
                        n3 = n3 << 6 | 0x1B;
                        break;
                    }
                    case 'c': {
                        n3 = n3 << 6 | 0x1C;
                        break;
                    }
                    case 'd': {
                        n3 = n3 << 6 | 0x1D;
                        break;
                    }
                    case 'e': {
                        n3 = n3 << 6 | 0x1E;
                        break;
                    }
                    case 'f': {
                        n3 = n3 << 6 | 0x1F;
                        break;
                    }
                    case 'g': {
                        n3 = n3 << 6 | 0x20;
                        break;
                    }
                    case 'h': {
                        n3 = n3 << 6 | 0x21;
                        break;
                    }
                    case 'i': {
                        n3 = n3 << 6 | 0x22;
                        break;
                    }
                    case 'j': {
                        n3 = n3 << 6 | 0x23;
                        break;
                    }
                    case 'k': {
                        n3 = n3 << 6 | 0x24;
                        break;
                    }
                    case 'l': {
                        n3 = n3 << 6 | 0x25;
                        break;
                    }
                    case 'm': {
                        n3 = n3 << 6 | 0x26;
                        break;
                    }
                    case 'n': {
                        n3 = n3 << 6 | 0x27;
                        break;
                    }
                    case 'o': {
                        n3 = n3 << 6 | 0x28;
                        break;
                    }
                    case 'p': {
                        n3 = n3 << 6 | 0x29;
                        break;
                    }
                    case 'q': {
                        n3 = n3 << 6 | 0x2A;
                        break;
                    }
                    case 'r': {
                        n3 = n3 << 6 | 0x2B;
                        break;
                    }
                    case 's': {
                        n3 = n3 << 6 | 0x2C;
                        break;
                    }
                    case 't': {
                        n3 = n3 << 6 | 0x2D;
                        break;
                    }
                    case 'u': {
                        n3 = n3 << 6 | 0x2E;
                        break;
                    }
                    case 'v': {
                        n3 = n3 << 6 | 0x2F;
                        break;
                    }
                    case 'w': {
                        n3 = n3 << 6 | 0x30;
                        break;
                    }
                    case 'x': {
                        n3 = n3 << 6 | 0x31;
                        break;
                    }
                    case 'y': {
                        n3 = n3 << 6 | 0x32;
                        break;
                    }
                    case 'z': {
                        n3 = n3 << 6 | 0x33;
                        break;
                    }
                    case '0': {
                        n3 = n3 << 6 | 0x34;
                        break;
                    }
                    case '1': {
                        n3 = n3 << 6 | 0x35;
                        break;
                    }
                    case '2': {
                        n3 = n3 << 6 | 0x36;
                        break;
                    }
                    case '3': {
                        n3 = n3 << 6 | 0x37;
                        break;
                    }
                    case '4': {
                        n3 = n3 << 6 | 0x38;
                        break;
                    }
                    case '5': {
                        n3 = n3 << 6 | 0x39;
                        break;
                    }
                    case '6': {
                        n3 = n3 << 6 | 0x3A;
                        break;
                    }
                    case '7': {
                        n3 = n3 << 6 | 0x3B;
                        break;
                    }
                    case '8': {
                        n3 = n3 << 6 | 0x3C;
                        break;
                    }
                    case '9': {
                        n3 = n3 << 6 | 0x3D;
                        break;
                    }
                    case '+': {
                        n3 = n3 << 6 | 0x3E;
                        break;
                    }
                    case '/': {
                        n3 = n3 << 6 | 0x3F;
                        break;
                    }
                    case '=': {
                        bl = false;
                        switch (j) {
                            case 2: {
                                byteBuffer.put((byte)(n3 >>> 4 & 0xFF));
                                break;
                            }
                            case 3: {
                                byteBuffer.put((byte)(n3 >>> 10 & 0xFF));
                                byteBuffer.put((byte)(n3 >>> 2 & 0xFF));
                            }
                        }
                        break;
                    }
                    default: {
                        int n4 = 5439490;
                        String string3 = MessageHandler.getMessage(n4, string, Character.valueOf(string.charAt(i + j)));
                        throw new ParseException(string3, i + j);
                    }
                }
                if (!bl) break;
            }
            if (!bl) break;
            byteBuffer.put((byte)(n3 >>> 16 & 0xFF));
            byteBuffer.put((byte)(n3 >>> 8 & 0xFF));
            byteBuffer.put((byte)(n3 & 0xFF));
        }
        byteBuffer.flip();
        byte[] byArray = new byte[byteBuffer.limit()];
        byteBuffer.get(byArray);
        return byArray;
    }
}

