/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opends.server.api.MatchingRule;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DN;
import org.opends.server.types.DebugLogCategory;
import org.opends.server.types.DebugLogSeverity;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.FilterType;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchFilter {
    private static final String CLASS_NAME = "org.opends.server.types.SearchFilter";
    private AttributeType attributeType;
    private AttributeValue assertionValue;
    private boolean dnAttributes;
    private ByteString subFinalElement;
    private ByteString subInitialElement;
    private FilterType filterType;
    private List<ByteString> subAnyElements;
    private List<SearchFilter> filterComponents;
    private SearchFilter notComponent;
    private Set<String> attributeOptions;
    private String matchingRuleID;

    public SearchFilter(FilterType filterType, List<SearchFilter> list, SearchFilter searchFilter, AttributeType attributeType, Set<String> set, AttributeValue attributeValue, ByteString byteString, List<ByteString> list2, ByteString byteString2, String string, boolean bl) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf((Object)filterType), String.valueOf(list), String.valueOf(searchFilter), String.valueOf(attributeType), String.valueOf(set), String.valueOf(attributeValue), String.valueOf(byteString), String.valueOf(list2), String.valueOf(byteString2), String.valueOf(string), String.valueOf(bl)));
        this.filterType = filterType;
        this.filterComponents = list;
        this.notComponent = searchFilter;
        this.attributeType = attributeType;
        this.attributeOptions = set;
        this.assertionValue = attributeValue;
        this.subInitialElement = byteString;
        this.subAnyElements = list2;
        this.subFinalElement = byteString2;
        this.matchingRuleID = string;
        this.dnAttributes = bl;
    }

    public static SearchFilter createANDFilter(List<SearchFilter> list) {
        assert (Debug.debugEnter(CLASS_NAME, "createANDFilter", String.valueOf(list)));
        return new SearchFilter(FilterType.AND, list, null, null, null, null, null, null, null, null, false);
    }

    public static SearchFilter createORFilter(List<SearchFilter> list) {
        assert (Debug.debugEnter(CLASS_NAME, "createORFilter", String.valueOf(list)));
        return new SearchFilter(FilterType.OR, list, null, null, null, null, null, null, null, null, false);
    }

    public static SearchFilter createNOTFilter(SearchFilter searchFilter) {
        assert (Debug.debugEnter(CLASS_NAME, "createNOTFilter", String.valueOf(searchFilter)));
        return new SearchFilter(FilterType.NOT, null, searchFilter, null, null, null, null, null, null, null, false);
    }

    public static SearchFilter createEqualityFilter(AttributeType attributeType, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "createEqualityFilter", String.valueOf(attributeType), String.valueOf(attributeValue)));
        return new SearchFilter(FilterType.EQUALITY, null, null, attributeType, null, attributeValue, null, null, null, null, false);
    }

    public static SearchFilter createEqualityFilter(AttributeType attributeType, Set<String> set, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "createEqualityFilter", String.valueOf(attributeType), String.valueOf(set), String.valueOf(attributeValue)));
        return new SearchFilter(FilterType.EQUALITY, null, null, attributeType, set, attributeValue, null, null, null, null, false);
    }

    public static SearchFilter createSubstringFilter(AttributeType attributeType, ByteString byteString, List<ByteString> list, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "createSubstringFilter", String.valueOf(attributeType), String.valueOf(byteString), String.valueOf(list), String.valueOf(byteString2)));
        return new SearchFilter(FilterType.SUBSTRING, null, null, attributeType, null, null, byteString, list, byteString2, null, false);
    }

    public static SearchFilter createSubstringFilter(AttributeType attributeType, Set<String> set, ByteString byteString, List<ByteString> list, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "createSubstringFilter", String.valueOf(attributeType), String.valueOf(set), String.valueOf(byteString), String.valueOf(list), String.valueOf(byteString2)));
        return new SearchFilter(FilterType.SUBSTRING, null, null, attributeType, set, null, byteString, list, byteString2, null, false);
    }

    public static SearchFilter createGreaterOrEqualFilter(AttributeType attributeType, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "createGreaterOrEqualFilter", String.valueOf(attributeType), String.valueOf(attributeValue)));
        return new SearchFilter(FilterType.GREATER_OR_EQUAL, null, null, attributeType, null, attributeValue, null, null, null, null, false);
    }

    public static SearchFilter createGreaterOrEqualFilter(AttributeType attributeType, Set<String> set, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "createGreaterOrEqualFilter", String.valueOf(attributeType), String.valueOf(set), String.valueOf(attributeValue)));
        return new SearchFilter(FilterType.GREATER_OR_EQUAL, null, null, attributeType, set, attributeValue, null, null, null, null, false);
    }

    public static SearchFilter createLessOrEqualFilter(AttributeType attributeType, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "createLessOrEqualFilter", String.valueOf(attributeType), String.valueOf(attributeValue)));
        return new SearchFilter(FilterType.LESS_OR_EQUAL, null, null, attributeType, null, attributeValue, null, null, null, null, false);
    }

    public static SearchFilter createLessOrEqualFilter(AttributeType attributeType, Set<String> set, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "createLessOrEqualFilter", String.valueOf(attributeType), String.valueOf(set), String.valueOf(attributeValue)));
        return new SearchFilter(FilterType.LESS_OR_EQUAL, null, null, attributeType, set, attributeValue, null, null, null, null, false);
    }

    public static SearchFilter createPresenceFilter(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "createPresenceFilter", String.valueOf(attributeType)));
        return new SearchFilter(FilterType.PRESENT, null, null, attributeType, null, null, null, null, null, null, false);
    }

    public static SearchFilter createPresenceFilter(AttributeType attributeType, Set<String> set) {
        assert (Debug.debugEnter(CLASS_NAME, "createPresenceFilter", String.valueOf(attributeType), String.valueOf(set)));
        return new SearchFilter(FilterType.PRESENT, null, null, attributeType, set, null, null, null, null, null, false);
    }

    public static SearchFilter createApproximateFilter(AttributeType attributeType, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "createApproximateFilter", String.valueOf(attributeType), String.valueOf(attributeValue)));
        return new SearchFilter(FilterType.APPROXIMATE_MATCH, null, null, attributeType, null, attributeValue, null, null, null, null, false);
    }

    public static SearchFilter createApproximateFilter(AttributeType attributeType, Set<String> set, AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "createApproximateFilter", String.valueOf(attributeType), String.valueOf(set), String.valueOf(attributeValue)));
        return new SearchFilter(FilterType.APPROXIMATE_MATCH, null, null, attributeType, set, attributeValue, null, null, null, null, false);
    }

    public static SearchFilter createExtensibleMatchFilter(AttributeType attributeType, AttributeValue attributeValue, String string, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "createExtensibleMatchFilter", String.valueOf(attributeType), String.valueOf(attributeValue), String.valueOf(string), String.valueOf(bl)));
        return new SearchFilter(FilterType.EXTENSIBLE_MATCH, null, null, attributeType, null, attributeValue, null, null, null, string, bl);
    }

    public static SearchFilter createExtensibleMatchFilter(AttributeType attributeType, Set<String> set, AttributeValue attributeValue, String string, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "createExtensibleMatchFilter", String.valueOf(attributeType), String.valueOf(set), String.valueOf(attributeValue), String.valueOf(string), String.valueOf(bl)));
        return new SearchFilter(FilterType.EXTENSIBLE_MATCH, null, null, attributeType, set, attributeValue, null, null, null, string, bl);
    }

    public static SearchFilter createFilterFromString(String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "createFilterFromString", String.valueOf(string)));
        if (string == null) {
            int n = 196751;
            String string2 = MessageHandler.getMessage(n);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string2, n);
        }
        try {
            return SearchFilter.createFilterFromString(string, 0, string.length());
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "createFilterFromString", directoryException));
            throw directoryException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "createFilterFromString", exception));
            int n = 196752;
            String string3 = MessageHandler.getMessage(n, string, String.valueOf(exception));
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string3, n, exception);
        }
    }

    private static SearchFilter createFilterFromString(String string, int n, int n2) throws DirectoryException {
        ASN1OctetString aSN1OctetString;
        Object object;
        String string2;
        int n3;
        FilterType filterType;
        int n4;
        char c;
        assert (Debug.debugEnter(CLASS_NAME, "createFilterFromString", String.valueOf(string), String.valueOf(n), String.valueOf(n2)));
        int n5 = n2 - n;
        if (n5 <= 0) {
            int n6 = 196751;
            String string3 = MessageHandler.getMessage(n6);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string3, n6);
        }
        if (string.charAt(n) == '(') {
            if (string.charAt(n2 - 1) == ')') {
                ++n;
                --n2;
            } else {
                int n7 = 196753;
                String string4 = MessageHandler.getMessage(n7, string, n, n2);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string4, n7);
            }
        }
        if ((c = string.charAt(n)) == '&') {
            return SearchFilter.decodeCompoundFilter(FilterType.AND, string, n + 1, n2);
        }
        if (c == '|') {
            return SearchFilter.decodeCompoundFilter(FilterType.OR, string, n + 1, n2);
        }
        if (c == '!') {
            SearchFilter searchFilter = SearchFilter.createFilterFromString(string, n + 1, n2);
            return new SearchFilter(FilterType.NOT, null, searchFilter, null, null, null, null, null, null, null, false);
        }
        int n8 = -1;
        for (n4 = n; n4 < n2; ++n4) {
            if (string.charAt(n4) != '=') continue;
            n8 = n4;
            break;
        }
        if (n8 <= n) {
            n4 = 196754;
            String string5 = MessageHandler.getMessage(n4, string, n, n2);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string5, n4);
        }
        switch (string.charAt(n8 - 1)) {
            case '~': {
                filterType = FilterType.APPROXIMATE_MATCH;
                n4 = n8 - 1;
                break;
            }
            case '>': {
                filterType = FilterType.GREATER_OR_EQUAL;
                n4 = n8 - 1;
                break;
            }
            case '<': {
                filterType = FilterType.LESS_OR_EQUAL;
                n4 = n8 - 1;
                break;
            }
            case ':': {
                return SearchFilter.decodeExtensibleMatchFilter(string, n, n8, n2);
            }
            default: {
                filterType = FilterType.EQUALITY;
                n4 = n8;
            }
        }
        String string6 = string.substring(n, n4);
        StringBuilder stringBuilder = new StringBuilder(string6.length());
        HashSet<String> hashSet = new HashSet<String>();
        int n9 = string6.indexOf(59);
        if (n9 < 0) {
            for (n3 = 0; n3 < string6.length(); ++n3) {
                stringBuilder.append(Character.toLowerCase(string6.charAt(n3)));
            }
        } else {
            for (n3 = 0; n3 < n9; ++n3) {
                stringBuilder.append(Character.toLowerCase(string6.charAt(n3)));
            }
            n3 = string6.indexOf(59, n9 + 1);
            while (n3 > 0) {
                hashSet.add(string6.substring(n9 + 1, n3));
                n9 = n3;
                n3 = string6.indexOf(59, n9 + 1);
            }
            hashSet.add(string6.substring(n9 + 1));
        }
        AttributeType attributeType = DirectoryServer.getAttributeType(stringBuilder.toString());
        if (attributeType == null) {
            string2 = string6.substring(0, stringBuilder.length());
            attributeType = DirectoryServer.getDefaultAttributeType(string2);
        }
        if ((string2 = string.substring(n8 + 1, n2)).length() == 0) {
            return new SearchFilter(filterType, null, null, attributeType, hashSet, new AttributeValue(new ASN1OctetString(), (ByteString)new ASN1OctetString()), null, null, null, null, false);
        }
        if (string2.equals("*")) {
            return new SearchFilter(FilterType.PRESENT, null, null, attributeType, hashSet, null, null, null, null, null, false);
        }
        if (string2.indexOf(42) >= 0) {
            return SearchFilter.decodeSubstringFilter(string, attributeType, hashSet, n8, n2);
        }
        boolean bl = false;
        byte[] byArray = StaticUtils.getBytes(string2);
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 92) continue;
            bl = true;
            break;
        }
        if (bl) {
            object = ByteBuffer.allocate(string2.length());
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == 92) {
                    if (i + 2 >= byArray.length) {
                        int n6 = 196755;
                        String n10 = MessageHandler.getMessage(n6, string, n8 + i + 1);
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, n10, n6);
                    }
                    byte by = 0;
                    switch (byArray[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            by = 16;
                            break;
                        }
                        case 50: {
                            by = 32;
                            break;
                        }
                        case 51: {
                            by = 48;
                            break;
                        }
                        case 52: {
                            by = 64;
                            break;
                        }
                        case 53: {
                            by = 80;
                            break;
                        }
                        case 54: {
                            by = 96;
                            break;
                        }
                        case 55: {
                            by = 112;
                            break;
                        }
                        case 56: {
                            by = -128;
                            break;
                        }
                        case 57: {
                            by = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            by = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            by = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            by = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            by = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            by = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            by = -16;
                            break;
                        }
                        default: {
                            int n11 = 196755;
                            String string9 = MessageHandler.getMessage(n11, string, n8 + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string9, n11);
                        }
                    }
                    switch (byArray[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            by = (byte)(by | 1);
                            break;
                        }
                        case 50: {
                            by = (byte)(by | 2);
                            break;
                        }
                        case 51: {
                            by = (byte)(by | 3);
                            break;
                        }
                        case 52: {
                            by = (byte)(by | 4);
                            break;
                        }
                        case 53: {
                            by = (byte)(by | 5);
                            break;
                        }
                        case 54: {
                            by = (byte)(by | 6);
                            break;
                        }
                        case 55: {
                            by = (byte)(by | 7);
                            break;
                        }
                        case 56: {
                            by = (byte)(by | 8);
                            break;
                        }
                        case 57: {
                            by = (byte)(by | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            by = (byte)(by | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            by = (byte)(by | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            by = (byte)(by | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            by = (byte)(by | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            by = (byte)(by | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            by = (byte)(by | 0xF);
                            break;
                        }
                        default: {
                            int n7 = 196755;
                            String string3 = MessageHandler.getMessage(n7, string, n8 + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string3, n7);
                        }
                    }
                    ((ByteBuffer)object).put(by);
                    continue;
                }
                ((ByteBuffer)object).put(byArray[i]);
            }
            byArray = new byte[((Buffer)object).position()];
            ((ByteBuffer)object).flip();
            ((ByteBuffer)object).get(byArray);
            aSN1OctetString = new ASN1OctetString(byArray);
        } else {
            aSN1OctetString = new ASN1OctetString(byArray);
        }
        object = new AttributeValue(attributeType, (ByteString)aSN1OctetString);
        return new SearchFilter(filterType, null, null, attributeType, hashSet, (AttributeValue)object, null, null, null, null, false);
    }

    private static SearchFilter decodeCompoundFilter(FilterType filterType, String string, int n, int n2) throws DirectoryException {
        int n3;
        assert (Debug.debugEnter(CLASS_NAME, "decodeCompoundFilter", String.valueOf((Object)filterType), String.valueOf(string), String.valueOf(n), String.valueOf(n2)));
        ArrayList<SearchFilter> arrayList = new ArrayList<SearchFilter>();
        if (n == n2) {
            return new SearchFilter(filterType, arrayList, null, null, null, null, null, null, null, null, false);
        }
        if (string.charAt(n) != '(' || string.charAt(n2 - 1) != ')') {
            int n4 = 196756;
            String string2 = MessageHandler.getMessage(n4, string, n, n2);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string2, n4);
        }
        int n5 = 0;
        int n6 = -1;
        for (n3 = n; n3 < n2; ++n3) {
            char c = string.charAt(n3);
            if (c == '(') {
                if (n6 < 0) {
                    n6 = n3;
                }
                ++n5;
                continue;
            }
            if (c == ')') {
                if (--n5 == 0) {
                    arrayList.add(SearchFilter.createFilterFromString(string, n6, n3 + 1));
                    n6 = -1;
                    continue;
                }
                if (n5 >= 0) continue;
                int n7 = 196757;
                String string3 = MessageHandler.getMessage(n7, string, n3);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string3, n7);
            }
            if (n5 > 0) continue;
            int n8 = 196756;
            String string4 = MessageHandler.getMessage(n8, string, n, n2);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string4, n8);
        }
        if (n5 != 0) {
            n3 = 196758;
            String string5 = MessageHandler.getMessage(n3, string, n6);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string5, n3);
        }
        return new SearchFilter(filterType, arrayList, null, null, null, null, null, null, null, null, false);
    }

    private static SearchFilter decodeSubstringFilter(String string, AttributeType attributeType, Set<String> set, int n, int n2) throws DirectoryException {
        Object object;
        int n3;
        ArrayList<ByteString> arrayList;
        ASN1OctetString aSN1OctetString;
        int n4;
        assert (Debug.debugEnter(CLASS_NAME, "decodeSubstringFilter", String.valueOf(string), String.valueOf(attributeType), String.valueOf(set), String.valueOf(n), String.valueOf(n2)));
        byte[] byArray = StaticUtils.getBytes(string.substring(n + 1, n2));
        boolean bl = false;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        for (n4 = 0; n4 < byArray.length; ++n4) {
            if (byArray[n4] == 42) {
                linkedList.add(n4);
                continue;
            }
            if (byArray[n4] != 92) continue;
            bl = true;
        }
        if (linkedList.isEmpty()) {
            n4 = 196759;
            String string2 = MessageHandler.getMessage(n4, string, n + 1, n2);
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string2, n4);
        }
        n2 = byArray.length;
        int n5 = (Integer)linkedList.removeFirst();
        if (n5 == 0) {
            aSN1OctetString = null;
        } else if (bl) {
            arrayList = ByteBuffer.allocate(n5);
            for (int i = 0; i < n5; ++i) {
                if (byArray[i] == 92) {
                    if (i + 2 >= byArray.length) {
                        n3 = 196755;
                        String string3 = MessageHandler.getMessage(n3, string, n + i + 1);
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string3, n3);
                    }
                    n3 = 0;
                    switch (byArray[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            n3 = 16;
                            break;
                        }
                        case 50: {
                            n3 = 32;
                            break;
                        }
                        case 51: {
                            n3 = 48;
                            break;
                        }
                        case 52: {
                            n3 = 64;
                            break;
                        }
                        case 53: {
                            n3 = 80;
                            break;
                        }
                        case 54: {
                            n3 = 96;
                            break;
                        }
                        case 55: {
                            n3 = 112;
                            break;
                        }
                        case 56: {
                            n3 = -128;
                            break;
                        }
                        case 57: {
                            n3 = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            n3 = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            n3 = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            n3 = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            n3 = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            n3 = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            n3 = -16;
                            break;
                        }
                        default: {
                            int n6 = 196755;
                            String string4 = MessageHandler.getMessage(n6, string, n + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string4, n6);
                        }
                    }
                    switch (byArray[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            n3 = (byte)(n3 | 1);
                            break;
                        }
                        case 50: {
                            n3 = (byte)(n3 | 2);
                            break;
                        }
                        case 51: {
                            n3 = (byte)(n3 | 3);
                            break;
                        }
                        case 52: {
                            n3 = (byte)(n3 | 4);
                            break;
                        }
                        case 53: {
                            n3 = (byte)(n3 | 5);
                            break;
                        }
                        case 54: {
                            n3 = (byte)(n3 | 6);
                            break;
                        }
                        case 55: {
                            n3 = (byte)(n3 | 7);
                            break;
                        }
                        case 56: {
                            n3 = (byte)(n3 | 8);
                            break;
                        }
                        case 57: {
                            n3 = (byte)(n3 | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            n3 = (byte)(n3 | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            n3 = (byte)(n3 | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            n3 = (byte)(n3 | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            n3 = (byte)(n3 | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            n3 = (byte)(n3 | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            n3 = (byte)(n3 | 0xF);
                            break;
                        }
                        default: {
                            int n7 = 196755;
                            String string5 = MessageHandler.getMessage(n7, string, n + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string5, n7);
                        }
                    }
                    ((ByteBuffer)((Object)arrayList)).put((byte)n3);
                    continue;
                }
                ((ByteBuffer)((Object)arrayList)).put(byArray[i]);
            }
            object = new byte[((Buffer)((Object)arrayList)).position()];
            ((ByteBuffer)((Object)arrayList)).flip();
            ((ByteBuffer)((Object)arrayList)).get((byte[])object);
            aSN1OctetString = new ASN1OctetString((byte[])object);
        } else {
            arrayList = (ArrayList<ByteString>)new byte[n5];
            System.arraycopy(byArray, 0, arrayList, 0, n5);
            aSN1OctetString = new ASN1OctetString((byte[])arrayList);
        }
        arrayList = new ArrayList<ByteString>();
        object = linkedList.iterator();
        while (object.hasNext()) {
            Object object2;
            n3 = (Integer)object.next();
            int n8 = n3 - n5 - 1;
            if (bl) {
                object2 = ByteBuffer.allocate(n8);
                for (int i = n5 + 1; i < n3; ++i) {
                    if (byArray[i] == 92) {
                        if (i + 2 >= byArray.length) {
                            int string9 = 196755;
                            String string10 = MessageHandler.getMessage(string9, string, n + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string10, string9);
                        }
                        byte by = 0;
                        switch (byArray[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                by = 16;
                                break;
                            }
                            case 50: {
                                by = 32;
                                break;
                            }
                            case 51: {
                                by = 48;
                                break;
                            }
                            case 52: {
                                by = 64;
                                break;
                            }
                            case 53: {
                                by = 80;
                                break;
                            }
                            case 54: {
                                by = 96;
                                break;
                            }
                            case 55: {
                                by = 112;
                                break;
                            }
                            case 56: {
                                by = -128;
                                break;
                            }
                            case 57: {
                                by = -112;
                                break;
                            }
                            case 65: 
                            case 97: {
                                by = -96;
                                break;
                            }
                            case 66: 
                            case 98: {
                                by = -80;
                                break;
                            }
                            case 67: 
                            case 99: {
                                by = -64;
                                break;
                            }
                            case 68: 
                            case 100: {
                                by = -48;
                                break;
                            }
                            case 69: 
                            case 101: {
                                by = -32;
                                break;
                            }
                            case 70: 
                            case 102: {
                                by = -16;
                                break;
                            }
                            default: {
                                int string11 = 196755;
                                String string2 = MessageHandler.getMessage(string11, string, n + i + 1);
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string2, string11);
                            }
                        }
                        switch (byArray[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                by = (byte)(by | 1);
                                break;
                            }
                            case 50: {
                                by = (byte)(by | 2);
                                break;
                            }
                            case 51: {
                                by = (byte)(by | 3);
                                break;
                            }
                            case 52: {
                                by = (byte)(by | 4);
                                break;
                            }
                            case 53: {
                                by = (byte)(by | 5);
                                break;
                            }
                            case 54: {
                                by = (byte)(by | 6);
                                break;
                            }
                            case 55: {
                                by = (byte)(by | 7);
                                break;
                            }
                            case 56: {
                                by = (byte)(by | 8);
                                break;
                            }
                            case 57: {
                                by = (byte)(by | 9);
                                break;
                            }
                            case 65: 
                            case 97: {
                                by = (byte)(by | 0xA);
                                break;
                            }
                            case 66: 
                            case 98: {
                                by = (byte)(by | 0xB);
                                break;
                            }
                            case 67: 
                            case 99: {
                                by = (byte)(by | 0xC);
                                break;
                            }
                            case 68: 
                            case 100: {
                                by = (byte)(by | 0xD);
                                break;
                            }
                            case 69: 
                            case 101: {
                                by = (byte)(by | 0xE);
                                break;
                            }
                            case 70: 
                            case 102: {
                                by = (byte)(by | 0xF);
                                break;
                            }
                            default: {
                                int n6 = 196755;
                                String string3 = MessageHandler.getMessage(n6, string, n + i + 1);
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string3, n6);
                            }
                        }
                        ((ByteBuffer)object2).put(by);
                        continue;
                    }
                    ((ByteBuffer)object2).put(byArray[i]);
                }
                byte[] byArray2 = new byte[((Buffer)object2).position()];
                ((ByteBuffer)object2).flip();
                ((ByteBuffer)object2).get(byArray2);
                arrayList.add(new ASN1OctetString(byArray2));
            } else {
                object2 = new byte[n8];
                System.arraycopy(byArray, n5 + 1, object2, 0, n8);
                arrayList.add(new ASN1OctetString((byte[])object2));
            }
            n5 = n3;
        }
        if (n5 == n2 - 1) {
            object = null;
        } else {
            n3 = n2 - n5 - 1;
            if (bl) {
                ByteBuffer byteBuffer = ByteBuffer.allocate(n3);
                for (int i = n5 + 1; i < n2; ++i) {
                    if (byArray[i] == 92) {
                        if (i + 2 >= byArray.length) {
                            int n11 = 196755;
                            String string4 = MessageHandler.getMessage(n11, string, n + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string4, n11);
                        }
                        byte by2 = 0;
                        switch (byArray[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                by2 = 16;
                                break;
                            }
                            case 50: {
                                by2 = 32;
                                break;
                            }
                            case 51: {
                                by2 = 48;
                                break;
                            }
                            case 52: {
                                by2 = 64;
                                break;
                            }
                            case 53: {
                                by2 = 80;
                                break;
                            }
                            case 54: {
                                by2 = 96;
                                break;
                            }
                            case 55: {
                                by2 = 112;
                                break;
                            }
                            case 56: {
                                by2 = -128;
                                break;
                            }
                            case 57: {
                                by2 = -112;
                                break;
                            }
                            case 65: 
                            case 97: {
                                by2 = -96;
                                break;
                            }
                            case 66: 
                            case 98: {
                                by2 = -80;
                                break;
                            }
                            case 67: 
                            case 99: {
                                by2 = -64;
                                break;
                            }
                            case 68: 
                            case 100: {
                                by2 = -48;
                                break;
                            }
                            case 69: 
                            case 101: {
                                by2 = -32;
                                break;
                            }
                            case 70: 
                            case 102: {
                                by2 = -16;
                                break;
                            }
                            default: {
                                int n7 = 196755;
                                String string5 = MessageHandler.getMessage(n7, string, n + i + 1);
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string5, n7);
                            }
                        }
                        switch (byArray[++i]) {
                            case 48: {
                                break;
                            }
                            case 49: {
                                by2 = (byte)(by2 | 1);
                                break;
                            }
                            case 50: {
                                by2 = (byte)(by2 | 2);
                                break;
                            }
                            case 51: {
                                by2 = (byte)(by2 | 3);
                                break;
                            }
                            case 52: {
                                by2 = (byte)(by2 | 4);
                                break;
                            }
                            case 53: {
                                by2 = (byte)(by2 | 5);
                                break;
                            }
                            case 54: {
                                by2 = (byte)(by2 | 6);
                                break;
                            }
                            case 55: {
                                by2 = (byte)(by2 | 7);
                                break;
                            }
                            case 56: {
                                by2 = (byte)(by2 | 8);
                                break;
                            }
                            case 57: {
                                by2 = (byte)(by2 | 9);
                                break;
                            }
                            case 65: 
                            case 97: {
                                by2 = (byte)(by2 | 0xA);
                                break;
                            }
                            case 66: 
                            case 98: {
                                by2 = (byte)(by2 | 0xB);
                                break;
                            }
                            case 67: 
                            case 99: {
                                by2 = (byte)(by2 | 0xC);
                                break;
                            }
                            case 68: 
                            case 100: {
                                by2 = (byte)(by2 | 0xD);
                                break;
                            }
                            case 69: 
                            case 101: {
                                by2 = (byte)(by2 | 0xE);
                                break;
                            }
                            case 70: 
                            case 102: {
                                by2 = (byte)(by2 | 0xF);
                                break;
                            }
                            default: {
                                int n8 = 196755;
                                String string6 = MessageHandler.getMessage(n8, string, n + i + 1);
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string6, n8);
                            }
                        }
                        byteBuffer.put(by2);
                        continue;
                    }
                    byteBuffer.put(byArray[i]);
                }
                byte[] byArray3 = new byte[byteBuffer.position()];
                byteBuffer.flip();
                byteBuffer.get(byArray3);
                object = new ASN1OctetString(byArray3);
            } else {
                byte[] byArray4 = new byte[n3];
                System.arraycopy(byArray, n5 + 1, byArray4, 0, n3);
                object = new ASN1OctetString(byArray4);
            }
        }
        return new SearchFilter(FilterType.SUBSTRING, null, null, attributeType, set, null, aSN1OctetString, arrayList, (ByteString)object, null, false);
    }

    private static SearchFilter decodeExtensibleMatchFilter(String string, int n, int n2, int n3) throws DirectoryException {
        ASN1OctetString aSN1OctetString;
        assert (Debug.debugEnter(CLASS_NAME, "decodeExtensibleMatchFilter", String.valueOf(string), String.valueOf(n), String.valueOf(n2), String.valueOf(n3)));
        AttributeType attributeType = null;
        HashSet<String> hashSet = new HashSet<String>();
        boolean bl = false;
        String string2 = null;
        String string3 = StaticUtils.toLowerCase(string.substring(n, n2));
        if (string.charAt(n) == ':') {
            if (string3.startsWith(":dn:")) {
                bl = true;
                string2 = string.substring(n + 4, n2 - 1);
            } else {
                string2 = string.substring(n + 1, n2 - 1);
            }
        } else {
            int n4;
            int n5 = string.indexOf(58, n);
            if (n5 < 0) {
                int n6 = 196760;
                String string4 = MessageHandler.getMessage(n6, string, n);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string4, n6);
            }
            String string5 = string.substring(n, n5);
            StringBuilder stringBuilder = new StringBuilder(string5.length());
            int n7 = string5.indexOf(59);
            if (n7 < 0) {
                for (n4 = 0; n4 < string5.length(); ++n4) {
                    stringBuilder.append(Character.toLowerCase(string5.charAt(n4)));
                }
            } else {
                for (n4 = 0; n4 < n7; ++n4) {
                    stringBuilder.append(Character.toLowerCase(string5.charAt(n4)));
                }
                n4 = string5.indexOf(59, n7 + 1);
                while (n4 > 0) {
                    hashSet.add(string5.substring(n7 + 1, n4));
                    n7 = n4;
                    n4 = string5.indexOf(59, n7 + 1);
                }
                hashSet.add(string5.substring(n7 + 1));
            }
            attributeType = DirectoryServer.getAttributeType(stringBuilder.toString());
            if (attributeType == null) {
                String string6 = string5.substring(0, stringBuilder.length());
                attributeType = DirectoryServer.getDefaultAttributeType(string6);
            }
            if (n5 < n2 - 1) {
                if (string3.startsWith(":dn:", n5)) {
                    bl = true;
                    if (n5 + 4 < n2 - 1) {
                        string2 = string.substring(n5 + 4, n2 - 1);
                    }
                } else {
                    string2 = string.substring(n5 + 1, n2 - 1);
                }
            }
        }
        byte[] byArray = StaticUtils.getBytes(string.substring(n2 + 1, n3));
        boolean bl2 = false;
        for (int i = 0; i < byArray.length; ++i) {
            if (byArray[i] != 92) continue;
            bl2 = true;
            break;
        }
        if (bl2) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(byArray.length);
            for (int i = 0; i < byArray.length; ++i) {
                if (byArray[i] == 92) {
                    if (i + 2 >= byArray.length) {
                        int n4 = 196755;
                        String n8 = MessageHandler.getMessage(n4, string, n2 + i + 1);
                        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, n8, n4);
                    }
                    byte by = 0;
                    switch (byArray[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            by = 16;
                            break;
                        }
                        case 50: {
                            by = 32;
                            break;
                        }
                        case 51: {
                            by = 48;
                            break;
                        }
                        case 52: {
                            by = 64;
                            break;
                        }
                        case 53: {
                            by = 80;
                            break;
                        }
                        case 54: {
                            by = 96;
                            break;
                        }
                        case 55: {
                            by = 112;
                            break;
                        }
                        case 56: {
                            by = -128;
                            break;
                        }
                        case 57: {
                            by = -112;
                            break;
                        }
                        case 65: 
                        case 97: {
                            by = -96;
                            break;
                        }
                        case 66: 
                        case 98: {
                            by = -80;
                            break;
                        }
                        case 67: 
                        case 99: {
                            by = -64;
                            break;
                        }
                        case 68: 
                        case 100: {
                            by = -48;
                            break;
                        }
                        case 69: 
                        case 101: {
                            by = -32;
                            break;
                        }
                        case 70: 
                        case 102: {
                            by = -16;
                            break;
                        }
                        default: {
                            int n9 = 196755;
                            String string9 = MessageHandler.getMessage(n9, string, n2 + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string9, n9);
                        }
                    }
                    switch (byArray[++i]) {
                        case 48: {
                            break;
                        }
                        case 49: {
                            by = (byte)(by | 1);
                            break;
                        }
                        case 50: {
                            by = (byte)(by | 2);
                            break;
                        }
                        case 51: {
                            by = (byte)(by | 3);
                            break;
                        }
                        case 52: {
                            by = (byte)(by | 4);
                            break;
                        }
                        case 53: {
                            by = (byte)(by | 5);
                            break;
                        }
                        case 54: {
                            by = (byte)(by | 6);
                            break;
                        }
                        case 55: {
                            by = (byte)(by | 7);
                            break;
                        }
                        case 56: {
                            by = (byte)(by | 8);
                            break;
                        }
                        case 57: {
                            by = (byte)(by | 9);
                            break;
                        }
                        case 65: 
                        case 97: {
                            by = (byte)(by | 0xA);
                            break;
                        }
                        case 66: 
                        case 98: {
                            by = (byte)(by | 0xB);
                            break;
                        }
                        case 67: 
                        case 99: {
                            by = (byte)(by | 0xC);
                            break;
                        }
                        case 68: 
                        case 100: {
                            by = (byte)(by | 0xD);
                            break;
                        }
                        case 69: 
                        case 101: {
                            by = (byte)(by | 0xE);
                            break;
                        }
                        case 70: 
                        case 102: {
                            by = (byte)(by | 0xF);
                            break;
                        }
                        default: {
                            int n5 = 196755;
                            String string4 = MessageHandler.getMessage(n5, string, n2 + i + 1);
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string4, n5);
                        }
                    }
                    byteBuffer.put(by);
                    continue;
                }
                byteBuffer.put(byArray[i]);
            }
            byArray = new byte[byteBuffer.position()];
            byteBuffer.flip();
            byteBuffer.get(byArray);
            aSN1OctetString = new ASN1OctetString(byArray);
        } else {
            aSN1OctetString = new ASN1OctetString(byArray);
        }
        AttributeValue attributeValue = new AttributeValue(attributeType, (ByteString)aSN1OctetString);
        return new SearchFilter(FilterType.EXTENSIBLE_MATCH, null, null, attributeType, hashSet, attributeValue, null, null, null, string2, bl);
    }

    public FilterType getFilterType() {
        assert (Debug.debugEnter(CLASS_NAME, "getFilterType", new String[0]));
        return this.filterType;
    }

    public List<SearchFilter> getFilterComponents() {
        assert (Debug.debugEnter(CLASS_NAME, "getFilterComponents", new String[0]));
        if (this.filterComponents == null) {
            this.filterComponents = new ArrayList<SearchFilter>(0);
        }
        return this.filterComponents;
    }

    public SearchFilter getNotComponent() {
        assert (Debug.debugEnter(CLASS_NAME, "getNotComponent", new String[0]));
        return this.notComponent;
    }

    public AttributeType getAttributeType() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeType", new String[0]));
        return this.attributeType;
    }

    public void setAttributeType(AttributeType attributeType) {
        assert (Debug.debugEnter(CLASS_NAME, "setAttributeType", String.valueOf(attributeType)));
        this.attributeType = attributeType;
    }

    public AttributeValue getAssertionValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getAssertionValue", new String[0]));
        return this.assertionValue;
    }

    public void setAssertionValue(AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "setAssertionValue", String.valueOf(attributeValue)));
        this.assertionValue = attributeValue;
    }

    public ByteString getSubInitialElement() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubInitialElement", new String[0]));
        return this.subInitialElement;
    }

    public void setSubInitialElement(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "setSubInitialElement", String.valueOf(byteString)));
        this.subInitialElement = byteString;
    }

    public List<ByteString> getSubAnyElements() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubAnyElements", new String[0]));
        if (this.subAnyElements == null) {
            this.subAnyElements = new ArrayList<ByteString>(0);
        }
        return this.subAnyElements;
    }

    public ByteString getSubFinalElement() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubFinalElement", new String[0]));
        return this.subFinalElement;
    }

    public void setSubFinalElement(ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "setSubFinalElement", String.valueOf(byteString)));
        this.subFinalElement = byteString;
    }

    public String getMatchingRuleID() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRuleID", new String[0]));
        return this.matchingRuleID;
    }

    public void setMatchingRuleID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setMatchingRuleID", String.valueOf(string)));
        this.matchingRuleID = string;
    }

    public boolean getDNAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getDNAttributes", new String[0]));
        return this.dnAttributes;
    }

    public void setDNAttributes(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setDNAttributes", String.valueOf(bl)));
        this.dnAttributes = bl;
    }

    public boolean matchesEntry(Entry entry) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "matchesEntry", String.valueOf(entry)));
        ConditionResult conditionResult = this.matchesEntryInternal(this, entry, 0);
        switch (conditionResult) {
            case TRUE: {
                return true;
            }
            case FALSE: 
            case UNDEFINED: {
                return false;
            }
        }
        int n = 196762;
        String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), this.toString(), String.valueOf((Object)conditionResult));
        Error.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.MILD_ERROR, string, n);
        return false;
    }

    private ConditionResult matchesEntryInternal(SearchFilter searchFilter, Entry entry, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "matchesEntryInternal", String.valueOf(searchFilter), String.valueOf(entry), String.valueOf(n)));
        switch (this.filterType) {
            case AND: {
                if (this.filterComponents == null) {
                    int n2 = 196763;
                    String string = MessageHandler.getMessage(n2, String.valueOf(entry.getDN()), String.valueOf(searchFilter), String.valueOf((Object)this.filterType));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n2);
                }
                if (this.filterComponents.isEmpty()) {
                    assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.INFO, CLASS_NAME, "matchesEntryInternal", "Returning TRUE for LDAP TRUE filter (&)"));
                    return ConditionResult.TRUE;
                }
                if (n >= 100) {
                    int n3 = 196764;
                    String string = MessageHandler.getMessage(n3, String.valueOf(entry.getDN()), String.valueOf(searchFilter));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n3);
                }
                block47: for (SearchFilter searchFilter2 : this.filterComponents) {
                    ConditionResult conditionResult = searchFilter2.matchesEntryInternal(searchFilter, entry, n + 1);
                    switch (conditionResult) {
                        case TRUE: {
                            continue block47;
                        }
                        case FALSE: {
                            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning FALSE for AND component " + searchFilter2.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                            return conditionResult;
                        }
                        case UNDEFINED: {
                            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.INFO, CLASS_NAME, "matchesEntryInternal", "Undefined result for AND component " + searchFilter2.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                            return conditionResult;
                        }
                    }
                    int n4 = 196762;
                    String string = MessageHandler.getMessage(n4, String.valueOf(entry.getDN()), String.valueOf(searchFilter), String.valueOf((Object)conditionResult));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n4);
                }
                assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning TRUE for AND component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                return ConditionResult.TRUE;
            }
            case OR: {
                if (this.filterComponents == null) {
                    int n5 = 196763;
                    String string = MessageHandler.getMessage(n5, String.valueOf(entry.getDN()), String.valueOf(searchFilter), String.valueOf((Object)this.filterType));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n5);
                }
                if (this.filterComponents.isEmpty()) {
                    assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.INFO, CLASS_NAME, "matchesEntryInternal", "Returning FALSE for LDAP FALSE filter (|)"));
                    return ConditionResult.FALSE;
                }
                if (n >= 100) {
                    int n6 = 196764;
                    String string = MessageHandler.getMessage(n6, String.valueOf(entry.getDN()), String.valueOf(searchFilter));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n6);
                }
                ConditionResult conditionResult = ConditionResult.FALSE;
                block48: for (SearchFilter searchFilter3 : this.filterComponents) {
                    switch (searchFilter3.matchesEntryInternal(searchFilter, entry, n + 1)) {
                        case TRUE: {
                            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning TRUE for OR component " + searchFilter3.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                            return ConditionResult.TRUE;
                        }
                        case FALSE: {
                            continue block48;
                        }
                        case UNDEFINED: {
                            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.INFO, CLASS_NAME, "matchesEntryInternal", "Undefined result for OR component " + searchFilter3.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                            conditionResult = ConditionResult.UNDEFINED;
                            continue block48;
                        }
                    }
                    int n7 = 196762;
                    String string = MessageHandler.getMessage(n7, String.valueOf(entry.getDN()), String.valueOf(searchFilter), String.valueOf((Object)conditionResult));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n7);
                }
                assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning " + (Object)((Object)conditionResult) + " for OR component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                return conditionResult;
            }
            case NOT: {
                if (this.notComponent == null) {
                    int n8 = 196765;
                    String string = MessageHandler.getMessage(n8, String.valueOf(entry.getDN()), String.valueOf(searchFilter));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n8);
                }
                if (n >= 100) {
                    int n9 = 196764;
                    String string = MessageHandler.getMessage(n9, String.valueOf(entry.getDN()), String.valueOf(searchFilter));
                    throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n9);
                }
                ConditionResult conditionResult = this.notComponent.matchesEntryInternal(searchFilter, entry, n + 1);
                switch (conditionResult) {
                    case TRUE: {
                        assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning FALSE for NOT component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                        return ConditionResult.FALSE;
                    }
                    case FALSE: {
                        assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning TRUE for NOT component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                        return ConditionResult.TRUE;
                    }
                    case UNDEFINED: {
                        assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.INFO, CLASS_NAME, "matchesEntryInternal", "Undefined result for NOT component " + this.notComponent.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                        return ConditionResult.UNDEFINED;
                    }
                }
                int n10 = 196762;
                String string = MessageHandler.getMessage(n10, String.valueOf(entry.getDN()), String.valueOf(searchFilter), String.valueOf((Object)conditionResult));
                throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n10);
            }
            case EQUALITY: {
                if (this.attributeType == null) {
                    int n11 = 196766;
                    String string = MessageHandler.getMessage(n11, String.valueOf(entry.getDN()), this.toString());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n11);
                }
                if (this.assertionValue == null) {
                    int n12 = 196767;
                    String string = MessageHandler.getMessage(n12, String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n12);
                }
                List<Attribute> list = entry.getAttribute(this.attributeType, this.attributeOptions);
                if (list == null || list.isEmpty()) {
                    assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning FALSE for equality component " + this.toString() + " in filter " + searchFilter.toString() + " because entry " + entry.getDN() + " didn't have attribute type " + this.attributeType.getNameOrOID()));
                    return ConditionResult.FALSE;
                }
                for (Attribute attribute : list) {
                    if (!attribute.hasValue(this.assertionValue)) continue;
                    assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning TRUE for equality component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                    return ConditionResult.TRUE;
                }
                assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning FALSE for equality component " + this.toString() + " in filter " + searchFilter.toString() + " because entry " + entry.getDN() + " didn't have attribute type " + this.attributeType.getNameOrOID() + " with value " + this.assertionValue.getStringValue()));
                return ConditionResult.FALSE;
            }
            case SUBSTRING: {
                if (this.attributeType == null) {
                    int n13 = 196768;
                    String string = MessageHandler.getMessage(n13, String.valueOf(entry.getDN()), this.toString());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n13);
                }
                if (this.subInitialElement == null && this.subFinalElement == null && (this.subAnyElements == null || this.subAnyElements.isEmpty())) {
                    int n14 = 196769;
                    String string = MessageHandler.getMessage(n14, String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n14);
                }
                List<Attribute> list = entry.getAttribute(this.attributeType, this.attributeOptions);
                if (list == null || list.isEmpty()) {
                    assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning FALSE for substring component " + this.toString() + " in filter " + searchFilter.toString() + " because entry " + entry.getDN() + " didn't have attribute type " + this.attributeType.getNameOrOID()));
                    return ConditionResult.FALSE;
                }
                ConditionResult conditionResult = ConditionResult.FALSE;
                for (Attribute attribute : list) {
                    switch (attribute.matchesSubstring(this.subInitialElement, this.subAnyElements, this.subFinalElement)) {
                        case TRUE: {
                            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning TRUE for substring component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                            return ConditionResult.TRUE;
                        }
                        case FALSE: {
                            break;
                        }
                        case UNDEFINED: {
                            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Undefined result encountered for substring component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                            conditionResult = ConditionResult.UNDEFINED;
                            break;
                        }
                    }
                }
                assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning " + (Object)((Object)conditionResult) + " for substring " + "component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                return conditionResult;
            }
            case GREATER_OR_EQUAL: {
                if (this.attributeType == null) {
                    int n15 = 196770;
                    String string = MessageHandler.getMessage(n15, String.valueOf(entry.getDN()), this.toString());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n15);
                }
                if (this.assertionValue == null) {
                    int n16 = 196771;
                    String string = MessageHandler.getMessage(n16, String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n16);
                }
                List<Attribute> list = entry.getAttribute(this.attributeType, this.attributeOptions);
                if (list == null || list.isEmpty()) {
                    assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning FALSE for greater-or-equal component " + this.toString() + " in filter " + searchFilter.toString() + " because entry " + entry.getDN() + " didn't have attribute type " + this.attributeType.getNameOrOID()));
                    return ConditionResult.FALSE;
                }
                ConditionResult conditionResult = ConditionResult.FALSE;
                for (Attribute attribute : list) {
                    switch (attribute.greaterThanOrEqualTo(this.assertionValue)) {
                        case TRUE: {
                            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning TRUE for greater-or-equal component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                            return ConditionResult.TRUE;
                        }
                        case FALSE: {
                            break;
                        }
                        case UNDEFINED: {
                            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Undefined result encountered for greater-or-equal component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                            conditionResult = ConditionResult.UNDEFINED;
                            break;
                        }
                    }
                }
                assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning " + (Object)((Object)conditionResult) + " for greater-or-equal " + "component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                return conditionResult;
            }
            case LESS_OR_EQUAL: {
                if (this.attributeType == null) {
                    int n17 = 196772;
                    String string = MessageHandler.getMessage(n17, String.valueOf(entry.getDN()), this.toString());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n17);
                }
                if (this.assertionValue == null) {
                    int n18 = 196773;
                    String string = MessageHandler.getMessage(n18, String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n18);
                }
                List<Attribute> list = entry.getAttribute(this.attributeType, this.attributeOptions);
                if (list == null || list.isEmpty()) {
                    assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning FALSE for less-or-equal component " + this.toString() + " in filter " + searchFilter.toString() + " because entry " + entry.getDN() + " didn't have attribute type " + this.attributeType.getNameOrOID()));
                    return ConditionResult.FALSE;
                }
                ConditionResult conditionResult = ConditionResult.FALSE;
                for (Attribute attribute : list) {
                    switch (attribute.lessThanOrEqualTo(this.assertionValue)) {
                        case TRUE: {
                            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning TRUE for less-or-equal component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                            return ConditionResult.TRUE;
                        }
                        case FALSE: {
                            break;
                        }
                        case UNDEFINED: {
                            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Undefined result encountered for less-or-equal component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                            conditionResult = ConditionResult.UNDEFINED;
                            break;
                        }
                    }
                }
                assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning " + (Object)((Object)conditionResult) + " for less-or-equal " + "component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                return conditionResult;
            }
            case PRESENT: {
                if (this.attributeType == null) {
                    int n19 = 196774;
                    String string = MessageHandler.getMessage(n19, String.valueOf(entry.getDN()), this.toString());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n19);
                }
                if (entry.hasAttribute(this.attributeType, this.attributeOptions)) {
                    assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning TRUE for presence component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                    return ConditionResult.TRUE;
                }
                assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning FALSE for presence component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                return ConditionResult.FALSE;
            }
            case APPROXIMATE_MATCH: {
                if (this.attributeType == null) {
                    int n20 = 196775;
                    String string = MessageHandler.getMessage(n20, String.valueOf(entry.getDN()), this.toString());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n20);
                }
                if (this.assertionValue == null) {
                    int n21 = 196776;
                    String string = MessageHandler.getMessage(n21, String.valueOf(entry.getDN()), this.toString(), this.attributeType.getNameOrOID());
                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n21);
                }
                List<Attribute> list = entry.getAttribute(this.attributeType, this.attributeOptions);
                if (list == null || list.isEmpty()) {
                    assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning FALSE for approximate component " + this.toString() + " in filter " + searchFilter.toString() + " because entry " + entry.getDN() + " didn't have attribute type " + this.attributeType.getNameOrOID()));
                    return ConditionResult.FALSE;
                }
                ConditionResult conditionResult = ConditionResult.FALSE;
                for (Attribute attribute : list) {
                    switch (attribute.approximatelyEqualTo(this.assertionValue)) {
                        case TRUE: {
                            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning TRUE for approximate component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                            return ConditionResult.TRUE;
                        }
                        case FALSE: {
                            break;
                        }
                        case UNDEFINED: {
                            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Undefined result encountered for approximate component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                            conditionResult = ConditionResult.UNDEFINED;
                            break;
                        }
                    }
                }
                assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.VERBOSE, CLASS_NAME, "matchesEntryInternal", "Returning " + (Object)((Object)conditionResult) + " for approximate " + "component " + this.toString() + " in filter " + searchFilter.toString() + " for entry " + entry.getDN()));
                return conditionResult;
            }
            case EXTENSIBLE_MATCH: {
                return this.processExtensibleMatch(searchFilter, entry);
            }
        }
        int n22 = 196761;
        String string = MessageHandler.getMessage(n22, String.valueOf(entry.getDN()), this.toString(), this.filterType.toString());
        throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n22);
    }

    /*
     * WARNING - void declaration
     */
    private ConditionResult processExtensibleMatch(SearchFilter searchFilter, Entry entry) throws DirectoryException {
        List<Attribute> list;
        Object object;
        Object object2;
        Object object32;
        Object object4;
        assert (Debug.debugEnter(CLASS_NAME, "processExtensibleMatch", String.valueOf(searchFilter), String.valueOf(entry)));
        if (this.assertionValue == null) {
            int n = 196777;
            String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), String.valueOf(searchFilter));
            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n);
        }
        MatchingRule matchingRule = null;
        if (this.matchingRuleID != null) {
            matchingRule = DirectoryServer.getMatchingRule(StaticUtils.toLowerCase(this.matchingRuleID));
            if (matchingRule == null) {
                assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.INFO, CLASS_NAME, "processExtensibleMatch", "Unknown matching rule " + this.matchingRuleID + " defined in extensibleMatch component of " + "filter " + this.toString() + " -- returning undefined."));
                return ConditionResult.UNDEFINED;
            }
        } else {
            if (this.attributeType == null) {
                int n = 196778;
                String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), String.valueOf(searchFilter));
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n);
            }
            matchingRule = this.attributeType.getEqualityMatchingRule();
            if (matchingRule == null) {
                assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.INFO, CLASS_NAME, "processExtensibleMatch", "Attribute type " + this.attributeType.getNameOrOID() + " does not have an equality matching rule -- " + "returning undefined."));
                return ConditionResult.UNDEFINED;
            }
        }
        if (this.attributeType != null && (object4 = DirectoryServer.getMatchingRuleUse(matchingRule)) != null && !((MatchingRuleUse)object4).appliesToAttribute(this.attributeType)) {
            assert (Debug.debugMessage(DebugLogCategory.CORE_SERVER, DebugLogSeverity.INFO, CLASS_NAME, "processExtensibleMatch", "Attribute type " + this.attributeType.getNameOrOID() + " is not allowed for use with matching rule " + matchingRule.getNameOrOID() + " because of " + "matching rule use definition " + ((MatchingRuleUse)object4).getName()));
            return ConditionResult.UNDEFINED;
        }
        try {
            object4 = matchingRule.normalizeValue(this.assertionValue.getValue());
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "processExtensibleMatch", exception));
            return ConditionResult.UNDEFINED;
        }
        ConditionResult conditionResult = ConditionResult.FALSE;
        if (this.attributeType == null) {
            for (List iterator : entry.getUserAttributes().values()) {
                for (Object object32 : iterator) {
                    for (AttributeValue attributeValue : ((Attribute)object32).getValues()) {
                        try {
                            object2 = matchingRule.normalizeValue(attributeValue.getValue());
                            object = matchingRule.valuesMatch((ByteString)object2, (ByteString)object4);
                            switch (1.$SwitchMap$org$opends$server$types$ConditionResult[((Enum)object).ordinal()]) {
                                case 1: {
                                    return ConditionResult.TRUE;
                                }
                                case 2: {
                                    break;
                                }
                                case 3: {
                                    conditionResult = ConditionResult.UNDEFINED;
                                    break;
                                }
                                default: {
                                    int n = 196762;
                                    String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), String.valueOf(searchFilter), String.valueOf(object));
                                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n);
                                }
                            }
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "processExtensibleMatch", exception));
                            conditionResult = ConditionResult.UNDEFINED;
                        }
                    }
                }
            }
            for (List list2 : entry.getOperationalAttributes().values()) {
                for (Object object32 : list2) {
                    for (AttributeValue attributeValue : ((Attribute)object32).getValues()) {
                        try {
                            object2 = matchingRule.normalizeValue(attributeValue.getValue());
                            object = matchingRule.valuesMatch((ByteString)object2, (ByteString)object4);
                            switch (1.$SwitchMap$org$opends$server$types$ConditionResult[((Enum)object).ordinal()]) {
                                case 1: {
                                    return ConditionResult.TRUE;
                                }
                                case 2: {
                                    break;
                                }
                                case 3: {
                                    conditionResult = ConditionResult.UNDEFINED;
                                    break;
                                }
                                default: {
                                    int n = 196762;
                                    String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), String.valueOf(searchFilter), String.valueOf(object));
                                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n);
                                }
                            }
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "processExtensibleMatch", exception));
                            conditionResult = ConditionResult.UNDEFINED;
                        }
                    }
                }
            }
            list = entry.getObjectClassAttribute();
            for (AttributeValue attributeValue : ((Attribute)((Object)list)).getValues()) {
                try {
                    object32 = matchingRule.normalizeValue(attributeValue.getValue());
                    ConditionResult conditionResult2 = matchingRule.valuesMatch((ByteString)object32, (ByteString)object4);
                    switch (conditionResult2) {
                        case TRUE: {
                            return ConditionResult.TRUE;
                        }
                        case FALSE: {
                            break;
                        }
                        case UNDEFINED: {
                            conditionResult = ConditionResult.UNDEFINED;
                            break;
                        }
                        default: {
                            int n = 196762;
                            object2 = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), String.valueOf(searchFilter), String.valueOf((Object)conditionResult2));
                            throw new DirectoryException(ResultCode.PROTOCOL_ERROR, (String)object2, n);
                        }
                    }
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "processExtensibleMatch", exception));
                    conditionResult = ConditionResult.UNDEFINED;
                }
            }
        } else {
            list = entry.getAttribute(this.attributeType, this.attributeOptions);
            if (list != null) {
                for (Attribute attribute : list) {
                    for (AttributeValue attributeValue : attribute.getValues()) {
                        try {
                            ByteString byteString = matchingRule.normalizeValue(attributeValue.getValue());
                            object2 = matchingRule.valuesMatch(byteString, (ByteString)object4);
                            switch (1.$SwitchMap$org$opends$server$types$ConditionResult[((Enum)object2).ordinal()]) {
                                case 1: {
                                    return ConditionResult.TRUE;
                                }
                                case 2: {
                                    break;
                                }
                                case 3: {
                                    conditionResult = ConditionResult.UNDEFINED;
                                    break;
                                }
                                default: {
                                    int n = 196762;
                                    String string = MessageHandler.getMessage(n, String.valueOf(entry.getDN()), String.valueOf(searchFilter), String.valueOf(object2));
                                    throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n);
                                }
                            }
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "processExtensibleMatch", exception));
                            conditionResult = ConditionResult.UNDEFINED;
                        }
                    }
                }
            }
        }
        if (this.dnAttributes) {
            void var8_27;
            list = entry.getDN();
            int n = ((DN)((Object)list)).getNumComponents();
            boolean bl = false;
            while (var8_27 < n) {
                object32 = ((DN)((Object)list)).getRDN((int)var8_27);
                int n2 = ((RDN)object32).getNumValues();
                for (int i = 0; i < n2; ++i) {
                    try {
                        if (this.attributeType != null && !this.attributeType.equals(((RDN)object32).getAttributeType(i))) continue;
                        object2 = ((RDN)object32).getAttributeValue(i);
                        object = matchingRule.normalizeValue(((AttributeValue)object2).getValue());
                        ConditionResult conditionResult3 = matchingRule.valuesMatch((ByteString)object, (ByteString)object4);
                        switch (conditionResult3) {
                            case TRUE: {
                                return ConditionResult.TRUE;
                            }
                            case FALSE: {
                                break;
                            }
                            case UNDEFINED: {
                                conditionResult = ConditionResult.UNDEFINED;
                                break;
                            }
                            default: {
                                int n3 = 196762;
                                String string = MessageHandler.getMessage(n3, String.valueOf(entry.getDN()), String.valueOf(searchFilter), String.valueOf((Object)conditionResult3));
                                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n3);
                            }
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "processExtensibleMatch", exception));
                        conditionResult = ConditionResult.UNDEFINED;
                    }
                }
                ++var8_27;
            }
        }
        return conditionResult;
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", String.valueOf(object)));
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof SearchFilter)) {
            return false;
        }
        SearchFilter searchFilter = (SearchFilter)object;
        if (this.filterType != searchFilter.filterType) {
            return false;
        }
        switch (this.filterType) {
            case AND: 
            case OR: {
                if (this.filterComponents.size() != searchFilter.filterComponents.size()) {
                    return false;
                }
                block11: for (SearchFilter searchFilter2 : this.filterComponents) {
                    for (SearchFilter searchFilter3 : searchFilter.filterComponents) {
                        if (!searchFilter2.equals(searchFilter3)) continue;
                        continue block11;
                    }
                    return false;
                }
                return true;
            }
            case NOT: {
                return this.notComponent.equals(searchFilter.notComponent);
            }
            case EQUALITY: {
                return this.attributeType.equals(searchFilter.attributeType) && this.assertionValue.equals(searchFilter.assertionValue);
            }
            case SUBSTRING: {
                if (this.subInitialElement == null ? searchFilter.subInitialElement != null : !this.subInitialElement.equals(searchFilter.subInitialElement)) {
                    return false;
                }
                if (this.subFinalElement == null ? searchFilter.subFinalElement != null : !this.subFinalElement.equals(searchFilter.subFinalElement)) {
                    return false;
                }
                if (this.subAnyElements.size() != searchFilter.subAnyElements.size()) {
                    return false;
                }
                block13: for (ByteString byteString : this.subAnyElements) {
                    for (ByteString byteString2 : searchFilter.subAnyElements) {
                        if (!byteString.equals(byteString2)) continue;
                        continue block13;
                    }
                    return false;
                }
                return true;
            }
            case GREATER_OR_EQUAL: {
                return this.attributeType.equals(searchFilter.attributeType) && this.assertionValue.equals(searchFilter.assertionValue);
            }
            case LESS_OR_EQUAL: {
                return this.attributeType.equals(searchFilter.attributeType) && this.assertionValue.equals(searchFilter.assertionValue);
            }
            case PRESENT: {
                return this.attributeType.equals(searchFilter.attributeType);
            }
            case APPROXIMATE_MATCH: {
                return this.attributeType.equals(searchFilter.attributeType) && this.assertionValue.equals(searchFilter.assertionValue);
            }
            case EXTENSIBLE_MATCH: {
                if (this.attributeType == null ? searchFilter.attributeType != null : !this.attributeType.equals(searchFilter.attributeType)) {
                    return false;
                }
                if (this.dnAttributes != searchFilter.dnAttributes) {
                    return false;
                }
                if (this.matchingRuleID == null ? searchFilter.matchingRuleID != null : !this.matchingRuleID.equals(searchFilter.matchingRuleID)) {
                    return false;
                }
                return !(this.assertionValue == null ? searchFilter.assertionValue != null : !this.assertionValue.equals(searchFilter.assertionValue));
            }
        }
        return false;
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        switch (this.filterType) {
            case AND: 
            case OR: {
                int n = 0;
                for (SearchFilter searchFilter : this.filterComponents) {
                    n += searchFilter.hashCode();
                }
                return n;
            }
            case NOT: {
                return this.notComponent.hashCode();
            }
            case EQUALITY: {
                return this.attributeType.hashCode() + this.assertionValue.hashCode();
            }
            case SUBSTRING: {
                int n = 0;
                if (this.subInitialElement != null) {
                    n += this.subInitialElement.hashCode();
                }
                if (this.subAnyElements != null) {
                    for (ByteString byteString : this.subAnyElements) {
                        n += byteString.hashCode();
                    }
                }
                if (this.subFinalElement != null) {
                    n += this.subFinalElement.hashCode();
                }
                return n;
            }
            case GREATER_OR_EQUAL: {
                return this.attributeType.hashCode() + this.assertionValue.hashCode();
            }
            case LESS_OR_EQUAL: {
                return this.attributeType.hashCode() + this.assertionValue.hashCode();
            }
            case PRESENT: {
                return this.attributeType.hashCode();
            }
            case APPROXIMATE_MATCH: {
                return this.attributeType.hashCode() + this.assertionValue.hashCode();
            }
            case EXTENSIBLE_MATCH: {
                int n = 0;
                if (this.attributeType != null) {
                    n += this.attributeType.hashCode();
                }
                if (this.dnAttributes) {
                    ++n;
                }
                if (this.matchingRuleID != null) {
                    n += this.matchingRuleID.hashCode();
                }
                if (this.assertionValue != null) {
                    n += this.assertionValue.hashCode();
                }
                return n;
            }
        }
        return 1;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        switch (this.filterType) {
            case AND: {
                stringBuilder.append("(&");
                for (SearchFilter searchFilter : this.filterComponents) {
                    searchFilter.toString(stringBuilder);
                }
                stringBuilder.append(")");
                break;
            }
            case OR: {
                stringBuilder.append("(|");
                for (SearchFilter searchFilter : this.filterComponents) {
                    searchFilter.toString(stringBuilder);
                }
                stringBuilder.append(")");
                break;
            }
            case NOT: {
                stringBuilder.append("(!");
                this.notComponent.toString(stringBuilder);
                stringBuilder.append(")");
                break;
            }
            case EQUALITY: {
                stringBuilder.append("(");
                stringBuilder.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String string : this.attributeOptions) {
                        stringBuilder.append(";");
                        stringBuilder.append(string);
                    }
                }
                stringBuilder.append("=");
                this.valueToFilterString(stringBuilder, this.assertionValue.getValue());
                stringBuilder.append(")");
                break;
            }
            case SUBSTRING: {
                stringBuilder.append("(");
                stringBuilder.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String object : this.attributeOptions) {
                        stringBuilder.append(";");
                        stringBuilder.append(object);
                    }
                }
                stringBuilder.append("=");
                if (this.subInitialElement != null) {
                    this.valueToFilterString(stringBuilder, this.subInitialElement);
                }
                if (this.subAnyElements != null && !this.subAnyElements.isEmpty()) {
                    for (ByteString string : this.subAnyElements) {
                        stringBuilder.append("*");
                        this.valueToFilterString(stringBuilder, string);
                    }
                }
                stringBuilder.append("*");
                if (this.subFinalElement != null) {
                    this.valueToFilterString(stringBuilder, this.subFinalElement);
                }
                stringBuilder.append(")");
                break;
            }
            case GREATER_OR_EQUAL: {
                stringBuilder.append("(");
                stringBuilder.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String string : this.attributeOptions) {
                        stringBuilder.append(";");
                        stringBuilder.append(string);
                    }
                }
                stringBuilder.append(">=");
                this.valueToFilterString(stringBuilder, this.assertionValue.getValue());
                stringBuilder.append(")");
                break;
            }
            case LESS_OR_EQUAL: {
                stringBuilder.append("(");
                stringBuilder.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String string : this.attributeOptions) {
                        stringBuilder.append(";");
                        stringBuilder.append(string);
                    }
                }
                stringBuilder.append("<=");
                this.valueToFilterString(stringBuilder, this.assertionValue.getValue());
                stringBuilder.append(")");
                break;
            }
            case PRESENT: {
                stringBuilder.append("(");
                stringBuilder.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String string : this.attributeOptions) {
                        stringBuilder.append(";");
                        stringBuilder.append(string);
                    }
                }
                stringBuilder.append("=*)");
                break;
            }
            case APPROXIMATE_MATCH: {
                stringBuilder.append("(");
                stringBuilder.append(this.attributeType.getNameOrOID());
                if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                    for (String string : this.attributeOptions) {
                        stringBuilder.append(";");
                        stringBuilder.append(string);
                    }
                }
                stringBuilder.append("~=");
                this.valueToFilterString(stringBuilder, this.assertionValue.getValue());
                stringBuilder.append(")");
                break;
            }
            case EXTENSIBLE_MATCH: {
                stringBuilder.append("(");
                if (this.attributeType != null) {
                    stringBuilder.append(this.attributeType.getNameOrOID());
                    if (this.attributeOptions != null && !this.attributeOptions.isEmpty()) {
                        for (String string : this.attributeOptions) {
                            stringBuilder.append(";");
                            stringBuilder.append(string);
                        }
                    }
                }
                if (this.dnAttributes) {
                    stringBuilder.append(":dn");
                }
                if (this.matchingRuleID != null) {
                    stringBuilder.append(":");
                    stringBuilder.append(this.matchingRuleID);
                }
                stringBuilder.append(":=");
                this.valueToFilterString(stringBuilder, this.assertionValue.getValue());
                stringBuilder.append(")");
            }
        }
    }

    private void valueToFilterString(StringBuilder stringBuilder, ByteString byteString) {
        assert (Debug.debugEnter(CLASS_NAME, "valueToFilterString", "java.lang.StringBuilder", String.valueOf(byteString)));
        if (byteString == null) {
            return;
        }
        byte[] byArray = byteString.value();
        stringBuilder.ensureCapacity(stringBuilder.length() + byArray.length);
        for (byte by : byArray) {
            if ((by & 0x7F) != by || by <= 31 || by == 40 || by == 41 || by == 42 || by == 92 || by == 127) {
                stringBuilder.append("\\");
                stringBuilder.append(StaticUtils.byteToHex(by));
                continue;
            }
            stringBuilder.append((char)by);
        }
    }
}

