/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum OperatingSystem {
    AIX("AIX"),
    FREEBSD("FreeBSD"),
    HPUX("HP-UX"),
    LINUX("Linux"),
    MACOS("Mac OS X"),
    SOLARIS("Solaris"),
    WINDOWS("Windows"),
    ZOS("z/OS"),
    UNKNOWN("Unknown");

    private String osName;

    private OperatingSystem(String string2) {
        this.osName = string2;
    }

    public String toString() {
        return this.osName;
    }

    public static OperatingSystem forName(String string) {
        if (string == null) {
            return UNKNOWN;
        }
        String string2 = StaticUtils.toLowerCase(string);
        if (string2.indexOf("solaris") >= 0 || string2.indexOf("sunos") >= 0) {
            return SOLARIS;
        }
        if (string2.indexOf("linux") >= 0) {
            return LINUX;
        }
        if (string2.indexOf("hp-ux") >= 0 || string2.indexOf("hp ux") >= 0 || string2.indexOf("hpux") >= 0) {
            return HPUX;
        }
        if (string2.indexOf("aix") >= 0) {
            return AIX;
        }
        if (string2.indexOf("windows") >= 0) {
            return WINDOWS;
        }
        if (string2.indexOf("freebsd") >= 0 || string2.indexOf("free bsd") >= 0) {
            return FREEBSD;
        }
        if (string2.indexOf("macos") >= 0 || string2.indexOf("mac os") >= 0) {
            return MACOS;
        }
        if (string2.indexOf("z/os") >= 0) {
            return ZOS;
        }
        return UNKNOWN;
    }

    public static boolean isUNIXBased(OperatingSystem operatingSystem) {
        switch (operatingSystem) {
            case SOLARIS: 
            case LINUX: 
            case HPUX: 
            case AIX: 
            case FREEBSD: 
            case MACOS: {
                return true;
            }
        }
        return false;
    }
}

