/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.loggers.Debug;
import org.opends.server.types.Attribute;
import org.opends.server.types.ModificationType;
import org.opends.server.util.ServerConstants;

public class Modification {
    private static final String CLASS_NAME = "org.opends.server.types.Modification";
    private Attribute attribute;
    private boolean isInternal;
    private ModificationType modificationType;

    public Modification(ModificationType modificationType, Attribute attribute) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf((Object)modificationType), String.valueOf(attribute)));
        this.modificationType = modificationType;
        this.attribute = attribute;
        this.isInternal = false;
    }

    public Modification(ModificationType modificationType, Attribute attribute, boolean bl) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf((Object)modificationType), String.valueOf(attribute)));
        this.modificationType = modificationType;
        this.attribute = attribute;
        this.isInternal = bl;
    }

    public ModificationType getModificationType() {
        assert (Debug.debugEnter(CLASS_NAME, "getModificationType", new String[0]));
        return this.modificationType;
    }

    public void setModificationType(ModificationType modificationType) {
        assert (Debug.debugEnter(CLASS_NAME, "setModificationType", String.valueOf((Object)modificationType)));
        this.modificationType = modificationType;
    }

    public Attribute getAttribute() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttribute", new String[0]));
        return this.attribute;
    }

    public void setAttribute(Attribute attribute) {
        assert (Debug.debugEnter(CLASS_NAME, "setAttribute", String.valueOf(attribute)));
        this.attribute = attribute;
    }

    public boolean isInternal() {
        assert (Debug.debugEnter(CLASS_NAME, "isInternal", new String[0]));
        return this.isInternal;
    }

    public void setInternal(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setInternal", String.valueOf(bl)));
        this.isInternal = bl;
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", String.valueOf(object)));
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Modification)) {
            return false;
        }
        Modification modification = (Modification)object;
        if (this.modificationType != modification.modificationType) {
            return false;
        }
        return this.attribute.equals(modification.attribute);
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        return this.attribute.hashCode();
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("Modification(");
        stringBuilder.append(this.modificationType.toString());
        stringBuilder.append(", ");
        stringBuilder.append(this.attribute.toString());
    }

    public String toLDIF() {
        assert (Debug.debugEnter(CLASS_NAME, "toLDIF", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toLDIF(stringBuilder);
        return stringBuilder.toString();
    }

    public void toLDIF(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toLDIF", "java.lang.StringBuilder"));
        stringBuilder.append(this.modificationType.toString());
        stringBuilder.append(": ");
        stringBuilder.append(this.attribute.getName());
        stringBuilder.append(ServerConstants.EOL);
        this.attribute.toLDIF(stringBuilder);
    }
}

