/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.StringTokenizer;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchScope;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPURL {
    private static final String CLASS_NAME = "org.opends.server.types.LDAPURL";
    public static final String DEFAULT_SCHEME = "ldap";
    public static final int DEFAULT_PORT = 389;
    public static final DN DEFAULT_BASE_DN = DN.nullDN();
    public static final SearchScope DEFAULT_SEARCH_SCOPE = SearchScope.BASE_OBJECT;
    public static final SearchFilter DEFAULT_SEARCH_FILTER = SearchFilter.createPresenceFilter(DirectoryServer.getObjectClassAttributeType());
    private DN baseDN;
    private int port;
    private LinkedHashSet<String> attributes;
    private LinkedList<String> extensions;
    private SearchScope scope;
    private SearchFilter filter;
    private String host;
    private String rawBaseDN;
    private String rawFilter;
    private String scheme;

    public LDAPURL(String string, String string2, int n, String string3, LinkedHashSet<String> linkedHashSet, SearchScope searchScope, String string4, LinkedList<String> linkedList) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(n), String.valueOf(string3), String.valueOf(linkedHashSet), String.valueOf((Object)searchScope), String.valueOf(string4), String.valueOf(linkedList)));
        this.host = StaticUtils.toLowerCase(string2);
        this.baseDN = null;
        this.filter = null;
        this.scheme = string == null ? DEFAULT_SCHEME : StaticUtils.toLowerCase(string);
        this.port = n <= 0 || n > 65535 ? 389 : n;
        this.rawBaseDN = string3 == null ? "" : string3;
        this.attributes = linkedHashSet == null ? new LinkedHashSet() : linkedHashSet;
        this.scope = searchScope == null ? DEFAULT_SEARCH_SCOPE : searchScope;
        this.rawFilter = string4 == null ? "(objectClass=*)" : string4;
        this.extensions = linkedList == null ? new LinkedList() : linkedList;
    }

    public LDAPURL(String string, String string2, int n, DN dN, LinkedHashSet<String> linkedHashSet, SearchScope searchScope, SearchFilter searchFilter, LinkedList<String> linkedList) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(string2), String.valueOf(n), String.valueOf(dN), String.valueOf(linkedHashSet), String.valueOf((Object)searchScope), String.valueOf(searchFilter), String.valueOf(linkedList)));
        this.host = StaticUtils.toLowerCase(string2);
        this.scheme = string == null ? DEFAULT_SCHEME : StaticUtils.toLowerCase(string);
        this.port = n <= 0 || n > 65535 ? 389 : n;
        if (dN == null) {
            this.baseDN = DEFAULT_BASE_DN;
            this.rawBaseDN = DEFAULT_BASE_DN.toString();
        } else {
            this.baseDN = dN;
            this.rawBaseDN = dN.toString();
        }
        this.attributes = linkedHashSet == null ? new LinkedHashSet() : linkedHashSet;
        this.scope = searchScope == null ? DEFAULT_SEARCH_SCOPE : searchScope;
        if (searchFilter == null) {
            this.filter = DEFAULT_SEARCH_FILTER;
            this.rawFilter = DEFAULT_SEARCH_FILTER.toString();
        } else {
            this.filter = searchFilter;
            this.rawFilter = searchFilter.toString();
        }
        this.extensions = linkedList == null ? new LinkedList() : linkedList;
    }

    public static LDAPURL decode(String string, boolean bl) throws DirectoryException {
        SearchFilter searchFilter;
        String string2;
        SearchScope searchScope;
        String string3;
        String string4;
        int n;
        char c;
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(string)));
        int n3 = string.indexOf("://");
        if (n3 < 0) {
            int n4 = 5505134;
            String string5 = MessageHandler.getMessage(n4, String.valueOf(string));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n4);
        }
        if (n3 == 0) {
            int n5 = 5505135;
            String string6 = MessageHandler.getMessage(n5, String.valueOf(string));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n5);
        }
        String string7 = LDAPURL.urlDecode(string.substring(0, n3));
        int n6 = string.length();
        if (n6 == n3 + 3) {
            return new LDAPURL(string7, null, 389, DEFAULT_BASE_DN, null, DEFAULT_SEARCH_SCOPE, DEFAULT_SEARCH_FILTER, null);
        }
        String string8 = null;
        int n7 = 389;
        for (n2 = n = n3 + 3; n2 < n6 && (c = string.charAt(n2)) != '/'; ++n2) {
        }
        if (n2 > n) {
            String string9 = string.substring(n, n2);
            int n8 = string9.indexOf(58);
            if (n8 < 0) {
                string8 = LDAPURL.urlDecode(string9);
            } else {
                if (n8 == 0) {
                    int n9 = 5505136;
                    String string10 = MessageHandler.getMessage(n9, String.valueOf(string));
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string10, n9);
                }
                if (n8 == string9.length() - 1) {
                    int n10 = 5505137;
                    String string11 = MessageHandler.getMessage(n10, String.valueOf(string));
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string11, n10);
                }
                string8 = LDAPURL.urlDecode(string9.substring(0, n8));
                try {
                    n7 = Integer.parseInt(string9.substring(n8 + 1));
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "decode", exception));
                    int n11 = 5505138;
                    String string12 = MessageHandler.getMessage(n11, String.valueOf(string), string9.substring(n8 + 1));
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string12, n11);
                }
                if (n7 <= 0 || n7 > 65535) {
                    int n12 = 5505139;
                    String string13 = MessageHandler.getMessage(n12, String.valueOf(string), n7);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string13, n12);
                }
            }
        }
        if (++n2 > n6) {
            return new LDAPURL(string7, string8, n7, DEFAULT_BASE_DN, null, DEFAULT_SEARCH_SCOPE, DEFAULT_SEARCH_FILTER, null);
        }
        n = n2;
        String string14 = null;
        n2 = string.indexOf(63, n);
        if (n2 < 0) {
            string14 = string.substring(n);
            n = n6;
        } else {
            string14 = string.substring(n, n2);
            n = n2 + 1;
        }
        DN dN = bl ? DN.decode(LDAPURL.urlDecode(string14)) : null;
        if (n >= n6) {
            if (bl) {
                return new LDAPURL(string7, string8, n7, dN, null, DEFAULT_SEARCH_SCOPE, DEFAULT_SEARCH_FILTER, null);
            }
            return new LDAPURL(string7, string8, n7, string14, null, DEFAULT_SEARCH_SCOPE, null, null);
        }
        n2 = string.indexOf(63, n);
        if (n2 < 0) {
            string4 = string.substring(n);
            n = n6;
        } else {
            string4 = string.substring(n, n2);
            n = n2 + 1;
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
        while (stringTokenizer.hasMoreTokens()) {
            linkedHashSet.add(LDAPURL.urlDecode(stringTokenizer.nextToken()));
        }
        if (n >= n6) {
            if (bl) {
                return new LDAPURL(string7, string8, n7, dN, linkedHashSet, DEFAULT_SEARCH_SCOPE, DEFAULT_SEARCH_FILTER, null);
            }
            return new LDAPURL(string7, string8, n7, string14, linkedHashSet, DEFAULT_SEARCH_SCOPE, null, null);
        }
        n2 = string.indexOf(63, n);
        if (n2 < 0) {
            string3 = StaticUtils.toLowerCase(LDAPURL.urlDecode(string.substring(n)));
            n = n6;
        } else {
            string3 = StaticUtils.toLowerCase(LDAPURL.urlDecode(string.substring(n, n2)));
            n = n2 + 1;
        }
        if (string3.equals("")) {
            searchScope = DEFAULT_SEARCH_SCOPE;
        } else if (string3.equals("base")) {
            searchScope = SearchScope.BASE_OBJECT;
        } else if (string3.equals("one")) {
            searchScope = SearchScope.SINGLE_LEVEL;
        } else if (string3.equals("sub")) {
            searchScope = SearchScope.WHOLE_SUBTREE;
        } else if (string3.equals("subord") || string3.equals("subordinate")) {
            searchScope = SearchScope.SUBORDINATE_SUBTREE;
        } else {
            int n13 = 5505140;
            String string15 = MessageHandler.getMessage(n13, String.valueOf(string), String.valueOf(string3));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string15, n13);
        }
        if (n >= n6) {
            if (bl) {
                return new LDAPURL(string7, string8, n7, dN, linkedHashSet, searchScope, DEFAULT_SEARCH_FILTER, null);
            }
            return new LDAPURL(string7, string8, n7, string14, linkedHashSet, searchScope, null, null);
        }
        n2 = string.indexOf(63, n);
        if (n2 < 0) {
            string2 = LDAPURL.urlDecode(string.substring(n));
            n = n6;
        } else {
            string2 = LDAPURL.urlDecode(string.substring(n, n2));
            n = n2 + 1;
        }
        if (bl) {
            searchFilter = string2.equals("") ? DEFAULT_SEARCH_FILTER : SearchFilter.createFilterFromString(string2);
            if (n >= n6) {
                if (bl) {
                    return new LDAPURL(string7, string8, n7, dN, linkedHashSet, searchScope, searchFilter, null);
                }
                return new LDAPURL(string7, string8, n7, string14, linkedHashSet, searchScope, string2, null);
            }
        } else {
            searchFilter = null;
        }
        String string16 = string.substring(n);
        LinkedList<String> linkedList = new LinkedList<String>();
        stringTokenizer = new StringTokenizer(string16, ",");
        while (stringTokenizer.hasMoreTokens()) {
            linkedList.add(LDAPURL.urlDecode(stringTokenizer.nextToken()));
        }
        if (bl) {
            return new LDAPURL(string7, string8, n7, dN, linkedHashSet, searchScope, searchFilter, linkedList);
        }
        return new LDAPURL(string7, string8, n7, string14, linkedHashSet, searchScope, string2, linkedList);
    }

    private static String urlDecode(String string) throws DirectoryException {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "urlDecode", String.valueOf(string)));
        if (string == null) {
            return "";
        }
        byte[] byArray = StaticUtils.getBytes(string);
        int n2 = byArray.length;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            if (byArray[i] == 37) {
                if (i + 2 > n2) {
                    n = 5505141;
                    String string2 = MessageHandler.getMessage(n, String.valueOf(string), i);
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n);
                }
                switch (byArray[++i]) {
                    case 48: {
                        n = 0;
                        break;
                    }
                    case 49: {
                        n = 16;
                        break;
                    }
                    case 50: {
                        n = 32;
                        break;
                    }
                    case 51: {
                        n = 48;
                        break;
                    }
                    case 52: {
                        n = 64;
                        break;
                    }
                    case 53: {
                        n = 80;
                        break;
                    }
                    case 54: {
                        n = 96;
                        break;
                    }
                    case 55: {
                        n = 112;
                        break;
                    }
                    case 56: {
                        n = -128;
                        break;
                    }
                    case 57: {
                        n = -112;
                        break;
                    }
                    case 65: 
                    case 97: {
                        n = -96;
                        break;
                    }
                    case 66: 
                    case 98: {
                        n = -80;
                        break;
                    }
                    case 67: 
                    case 99: {
                        n = -64;
                        break;
                    }
                    case 68: 
                    case 100: {
                        n = -48;
                        break;
                    }
                    case 69: 
                    case 101: {
                        n = -32;
                        break;
                    }
                    case 70: 
                    case 102: {
                        n = -16;
                        break;
                    }
                    default: {
                        int n4 = 5505142;
                        String string3 = MessageHandler.getMessage(n4, String.valueOf(string), i);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
                    }
                }
                switch (byArray[++i]) {
                    case 48: {
                        break;
                    }
                    case 49: {
                        n = (byte)(n | 1);
                        break;
                    }
                    case 50: {
                        n = (byte)(n | 2);
                        break;
                    }
                    case 51: {
                        n = (byte)(n | 3);
                        break;
                    }
                    case 52: {
                        n = (byte)(n | 4);
                        break;
                    }
                    case 53: {
                        n = (byte)(n | 5);
                        break;
                    }
                    case 54: {
                        n = (byte)(n | 6);
                        break;
                    }
                    case 55: {
                        n = (byte)(n | 7);
                        break;
                    }
                    case 56: {
                        n = (byte)(n | 8);
                        break;
                    }
                    case 57: {
                        n = (byte)(n | 9);
                        break;
                    }
                    case 65: 
                    case 97: {
                        n = (byte)(n | 0xA);
                        break;
                    }
                    case 66: 
                    case 98: {
                        n = (byte)(n | 0xB);
                        break;
                    }
                    case 67: 
                    case 99: {
                        n = (byte)(n | 0xC);
                        break;
                    }
                    case 68: 
                    case 100: {
                        n = (byte)(n | 0xD);
                        break;
                    }
                    case 69: 
                    case 101: {
                        n = (byte)(n | 0xE);
                        break;
                    }
                    case 70: 
                    case 102: {
                        n = (byte)(n | 0xF);
                        break;
                    }
                    default: {
                        int n5 = 5505142;
                        String string4 = MessageHandler.getMessage(n5, String.valueOf(string), i);
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n5);
                    }
                }
                byArray2[n3++] = n;
                continue;
            }
            byArray2[n3++] = byArray[i];
        }
        try {
            return new String(byArray2, 0, n3, "UTF-8");
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "urlDecode", exception));
            n = 5505143;
            String string5 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n);
        }
    }

    private static String urlEncode(String string, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "urlEncode", String.valueOf(string)));
        if (string == null) {
            return "";
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        LDAPURL.urlEncode(string, bl, stringBuilder);
        return stringBuilder.toString();
    }

    private static void urlEncode(String string, boolean bl, StringBuilder stringBuilder) {
        if (string == null) {
            return;
        }
        int n = string.length();
        block3: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c)) {
                stringBuilder.append(c);
                continue;
            }
            if (c == ',') {
                if (bl) {
                    LDAPURL.hexEncode(c, stringBuilder);
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            switch (c) {
                case '!': 
                case '#': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '@': 
                case '[': 
                case ']': 
                case '_': 
                case '~': {
                    stringBuilder.append(c);
                    continue block3;
                }
                default: {
                    LDAPURL.hexEncode(c, stringBuilder);
                }
            }
        }
    }

    private static void hexEncode(char c, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "hexEncode", new String[0]));
        if ((c & 0xFFFFFFFF) == c) {
            stringBuilder.append('%');
            stringBuilder.append(StaticUtils.byteToHex((byte)c));
        } else {
            stringBuilder.append('%');
            byte by = (byte)(c >>> 8 & 0xFF);
            stringBuilder.append(StaticUtils.byteToHex(by));
            stringBuilder.append('%');
            byte by2 = (byte)(c & 0xFF);
            stringBuilder.append(StaticUtils.byteToHex(by2));
        }
    }

    public String getScheme() {
        assert (Debug.debugEnter(CLASS_NAME, "getScheme", new String[0]));
        return this.scheme;
    }

    public void setScheme(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setScheme", String.valueOf(string)));
        this.scheme = string == null ? DEFAULT_SCHEME : string;
    }

    public String getHost() {
        assert (Debug.debugEnter(CLASS_NAME, "getHost", new String[0]));
        return this.host;
    }

    public void setHost(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setHost", String.valueOf(string)));
        this.host = string;
    }

    public int getPort() {
        assert (Debug.debugEnter(CLASS_NAME, "getPort", new String[0]));
        return this.port;
    }

    public void setPort(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setPort", String.valueOf(n)));
        this.port = n <= 0 || n > 65535 ? 389 : n;
    }

    public String getRawBaseDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawBaseDN", new String[0]));
        return this.rawBaseDN;
    }

    public void setRawBaseDN(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawBaseDN", new String[0]));
        this.rawBaseDN = string;
        this.baseDN = null;
    }

    public DN getBaseDN() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getBaseDN", new String[0]));
        if (this.baseDN == null) {
            if (this.rawBaseDN == null || this.rawBaseDN.length() == 0) {
                return DEFAULT_BASE_DN;
            }
            this.baseDN = DN.decode(this.rawBaseDN);
        }
        return this.baseDN;
    }

    public void setBaseDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setDN", String.valueOf(dN)));
        if (dN == null) {
            this.baseDN = null;
            this.rawBaseDN = null;
        } else {
            this.baseDN = dN;
            this.rawBaseDN = dN.toString();
        }
    }

    public LinkedHashSet<String> getAttributes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributes", new String[0]));
        return this.attributes;
    }

    public SearchScope getScope() {
        assert (Debug.debugEnter(CLASS_NAME, "getScope", new String[0]));
        return this.scope;
    }

    public void setScope(SearchScope searchScope) {
        assert (Debug.debugEnter(CLASS_NAME, "setScope", String.valueOf((Object)searchScope)));
        this.scope = searchScope == null ? DEFAULT_SEARCH_SCOPE : searchScope;
    }

    public String getRawFilter() {
        assert (Debug.debugEnter(CLASS_NAME, "getRawFilter", new String[0]));
        return this.rawFilter;
    }

    public void setRawFilter(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setRawFilter", String.valueOf(string)));
        this.rawFilter = string;
        this.filter = null;
    }

    public SearchFilter getFilter() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getFilter", new String[0]));
        if (this.filter == null) {
            this.filter = this.rawFilter == null ? DEFAULT_SEARCH_FILTER : SearchFilter.createFilterFromString(this.rawFilter);
        }
        return this.filter;
    }

    public void setFilter(SearchFilter searchFilter) {
        assert (Debug.debugEnter(CLASS_NAME, "setFilter", String.valueOf(searchFilter)));
        if (searchFilter == null) {
            this.rawFilter = null;
            this.filter = null;
        } else {
            this.rawFilter = searchFilter.toString();
            this.filter = searchFilter;
        }
    }

    public LinkedList<String> getExtensions() {
        assert (Debug.debugEnter(CLASS_NAME, "getExtensions", new String[0]));
        return this.extensions;
    }

    public boolean equals(Object object) {
        LinkedHashSet<String> linkedHashSet;
        LDAPURL lDAPURL;
        block23: {
            block22: {
                assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
                if (object == null) {
                    return false;
                }
                if (object == this) {
                    return true;
                }
                if (!(object instanceof LDAPURL)) {
                    return false;
                }
                lDAPURL = (LDAPURL)object;
                if (!this.scheme.equals(lDAPURL.getScheme())) {
                    return false;
                }
                if (this.host == null ? lDAPURL.getHost() != null : !this.host.equalsIgnoreCase(lDAPURL.getHost())) {
                    return false;
                }
                if (this.port != lDAPURL.getPort()) {
                    return false;
                }
                try {
                    linkedHashSet = this.getBaseDN();
                    if (!((DN)((Object)linkedHashSet)).equals(lDAPURL.getBaseDN())) {
                        return false;
                    }
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "equals", exception));
                    if (!(this.rawBaseDN == null ? lDAPURL.getRawBaseDN() != null : !this.rawBaseDN.equals(lDAPURL.getRawBaseDN()))) break block22;
                    return false;
                }
            }
            if (this.scope != lDAPURL.getScope()) {
                return false;
            }
            try {
                linkedHashSet = this.getFilter();
                if (!((SearchFilter)((Object)linkedHashSet)).equals(lDAPURL.getFilter())) {
                    return false;
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "equals", exception));
                if (!(this.rawFilter == null ? lDAPURL.getRawFilter() != null : !this.rawFilter.equals(lDAPURL.getRawFilter()))) break block23;
                return false;
            }
        }
        if (this.attributes.size() != lDAPURL.getAttributes().size()) {
            return false;
        }
        linkedHashSet = lDAPURL.getAttributes();
        block4: for (String string : this.attributes) {
            if (linkedHashSet.contains(string)) continue;
            for (String string2 : linkedHashSet) {
                if (!string.equalsIgnoreCase(string2)) continue;
                continue block4;
            }
            return false;
        }
        if (this.extensions.size() != lDAPURL.getExtensions().size()) {
            return false;
        }
        block6: for (String string : this.extensions) {
            for (String string2 : lDAPURL.getExtensions()) {
                if (!string.equals(string2)) continue;
                continue block6;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n;
        block11: {
            block10: {
                assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
                n = 0;
                n += this.scheme.hashCode();
                if (this.host != null) {
                    n += StaticUtils.toLowerCase(this.host).hashCode();
                }
                n += this.port;
                try {
                    n += this.getBaseDN().hashCode();
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "hashCode", exception));
                    if (this.rawBaseDN == null) break block10;
                    n += this.rawBaseDN.hashCode();
                }
            }
            n += this.getScope().intValue();
            for (String string : this.attributes) {
                n += StaticUtils.toLowerCase(string).hashCode();
            }
            try {
                n += this.getFilter().hashCode();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "hashCode", exception));
                if (this.rawFilter == null) break block11;
                n += this.rawFilter.hashCode();
            }
        }
        for (String string : this.extensions) {
            n += string.hashCode();
        }
        return n;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, false);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder, boolean bl) {
        Iterator iterator;
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(bl)));
        LDAPURL.urlEncode(this.scheme, false, stringBuilder);
        stringBuilder.append("://");
        if (this.host != null) {
            LDAPURL.urlEncode(this.host, false, stringBuilder);
            stringBuilder.append(":");
            stringBuilder.append(this.port);
        }
        stringBuilder.append("/");
        LDAPURL.urlEncode(this.rawBaseDN, false, stringBuilder);
        if (bl) {
            if (!this.extensions.isEmpty()) {
                stringBuilder.append("????");
                Iterator iterator2 = this.extensions.iterator();
                LDAPURL.urlEncode((String)iterator2.next(), true, stringBuilder);
                while (iterator2.hasNext()) {
                    stringBuilder.append(",");
                    LDAPURL.urlEncode((String)iterator2.next(), true, stringBuilder);
                }
            }
            return;
        }
        stringBuilder.append("?");
        if (!this.attributes.isEmpty()) {
            iterator = this.attributes.iterator();
            LDAPURL.urlEncode((String)iterator.next(), false, stringBuilder);
            while (iterator.hasNext()) {
                stringBuilder.append(",");
                LDAPURL.urlEncode((String)iterator.next(), false, stringBuilder);
            }
        }
        stringBuilder.append("?");
        switch (this.scope) {
            case BASE_OBJECT: {
                stringBuilder.append("base");
                break;
            }
            case SINGLE_LEVEL: {
                stringBuilder.append("one");
                break;
            }
            case WHOLE_SUBTREE: {
                stringBuilder.append("sub");
                break;
            }
            case SUBORDINATE_SUBTREE: {
                stringBuilder.append("subordinate");
            }
        }
        stringBuilder.append("?");
        LDAPURL.urlEncode(this.rawFilter, false, stringBuilder);
        if (!this.extensions.isEmpty()) {
            stringBuilder.append("?");
            iterator = this.extensions.iterator();
            LDAPURL.urlEncode((String)iterator.next(), true, stringBuilder);
            while (iterator.hasNext()) {
                stringBuilder.append(",");
                LDAPURL.urlEncode((String)iterator.next(), true, stringBuilder);
            }
        }
    }
}

