/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.HashMap;
import org.opends.server.messages.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ErrorLogSeverity {
    FATAL_ERROR(54),
    GENERIC_DEBUG(55),
    INFORMATIONAL(56),
    MILD_ERROR(57),
    MILD_WARNING(58),
    NOTICE(131),
    SEVERE_ERROR(59),
    SEVERE_WARNING(60),
    SHUTDOWN_DEBUG(61),
    STARTUP_DEBUG(62);

    private static HashMap<String, ErrorLogSeverity> nameMap;
    private int severityID;
    private String severityName;

    private ErrorLogSeverity(int n2) {
        this.severityID = n2;
        this.severityName = null;
    }

    public static ErrorLogSeverity getByName(String string) {
        return nameMap.get(string);
    }

    public int getSeverityID() {
        return this.severityID;
    }

    public String getSeverityName() {
        if (this.severityName == null) {
            this.severityName = MessageHandler.getMessage(this.severityID);
        }
        return this.severityName;
    }

    public String toString() {
        return this.getSeverityName();
    }

    static {
        nameMap = new HashMap(10);
        nameMap.put("DEBUG", GENERIC_DEBUG);
        nameMap.put("FATAL_ERROR", FATAL_ERROR);
        nameMap.put("INFO", INFORMATIONAL);
        nameMap.put("MILD_ERROR", MILD_ERROR);
        nameMap.put("MILD_WARNING", MILD_WARNING);
        nameMap.put("NOTICE", NOTICE);
        nameMap.put("SEVERE_ERROR", SEVERE_ERROR);
        nameMap.put("SEVERE_WARNING", SEVERE_WARNING);
        nameMap.put("SHUTDOWN", SHUTDOWN_DEBUG);
        nameMap.put("STARTUP", STARTUP_DEBUG);
    }
}

