/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Map;
import java.util.Set;
import org.opends.server.api.AlertGenerator;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.ChangeNotificationListener;
import org.opends.server.api.ConfigHandler;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.ExtendedOperationHandler;
import org.opends.server.api.InvokableComponent;
import org.opends.server.api.MatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SASLMechanismHandler;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.types.AttributeType;
import org.opends.server.types.CryptoManager;
import org.opends.server.types.DITContentRule;
import org.opends.server.types.DITStructureRule;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.MatchingRuleUse;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.types.OperatingSystem;
import org.opends.server.types.ResultCode;
import org.opends.server.types.Schema;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DirectoryConfig {
    private static final String CLASS_NAME = "org.opends.server.types.DirectoryConfig";

    public static final CryptoManager getCryptoManager() {
        assert (Debug.debugEnter(CLASS_NAME, "getCryptoManager", new String[0]));
        return DirectoryServer.getCryptoManager();
    }

    public static final OperatingSystem getOperatingSystem() {
        assert (Debug.debugEnter(CLASS_NAME, "getOperatingSystem", new String[0]));
        return DirectoryServer.getOperatingSystem();
    }

    public static final ConfigHandler getConfigHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigHandler", new String[0]));
        return DirectoryServer.getConfigHandler();
    }

    public static final ConfigEntry getConfigEntry(DN dN) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "getConfigEntry", String.valueOf(dN)));
        return DirectoryServer.getConfigEntry(dN);
    }

    public static final String getServerRoot() {
        assert (Debug.debugEnter(CLASS_NAME, "getServerRoot", new String[0]));
        return DirectoryServer.getServerRoot();
    }

    public static final long getStartTime() {
        assert (Debug.debugEnter(CLASS_NAME, "getStartTime", new String[0]));
        return DirectoryServer.getStartTime();
    }

    public static final String getStartTimeUTC() {
        assert (Debug.debugEnter(CLASS_NAME, "getStartTimeUTC", new String[0]));
        return DirectoryServer.getStartTimeUTC();
    }

    public static final Schema getSchema() {
        assert (Debug.debugEnter(CLASS_NAME, "getSchema", new String[0]));
        return DirectoryServer.getSchema();
    }

    public static Map<String, MatchingRule> getMatchingRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRules", new String[0]));
        return DirectoryServer.getMatchingRules();
    }

    public static final MatchingRule getMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRule", String.valueOf(string)));
        return DirectoryServer.getMatchingRule(string);
    }

    public static final ApproximateMatchingRule getApproximateMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", String.valueOf(string)));
        return DirectoryServer.getApproximateMatchingRule(string);
    }

    public static final EqualityMatchingRule getEqualityMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", String.valueOf(string)));
        return DirectoryServer.getEqualityMatchingRule(string);
    }

    public static final OrderingMatchingRule getOrderingMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", String.valueOf(string)));
        return DirectoryServer.getOrderingMatchingRule(string);
    }

    public static final SubstringMatchingRule getSubstringMatchingRule(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", String.valueOf(string)));
        return DirectoryServer.getSubstringMatchingRule(string);
    }

    public static final Map<String, ObjectClass> getObjectClasses() {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClasses", new String[0]));
        return DirectoryServer.getObjectClasses();
    }

    public static final ObjectClass getObjectClass(String string, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClass", String.valueOf(string), String.valueOf(bl)));
        return DirectoryServer.getObjectClass(string, bl);
    }

    public static final ObjectClass getTopObjectClass() {
        assert (Debug.debugEnter(CLASS_NAME, "getTopObjectClass", new String[0]));
        return DirectoryServer.getTopObjectClass();
    }

    public static final Map<String, AttributeType> getAttributeTypes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeTypes", new String[0]));
        return DirectoryServer.getAttributeTypes();
    }

    public static final AttributeType getAttributeType(String string, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeType", String.valueOf(string), String.valueOf(bl)));
        return DirectoryServer.getAttributeType(string, bl);
    }

    public static final AttributeType getObjectClassAttributeType() {
        assert (Debug.debugEnter(CLASS_NAME, "getObjectClassAttributeType", new String[0]));
        return DirectoryServer.getObjectClassAttributeType();
    }

    public static final Map<String, AttributeSyntax> getAttributeSyntaxes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeSyntaxes", new String[0]));
        return DirectoryServer.getAttributeSyntaxes();
    }

    public static final AttributeSyntax getAttributeSyntax(String string, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeSyntax", String.valueOf(string), String.valueOf(bl)));
        return DirectoryServer.getAttributeSyntax(string, bl);
    }

    public static final AttributeSyntax getDefaultAttributeSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultAttributeSyntax", new String[0]));
        return DirectoryServer.getDefaultAttributeSyntax();
    }

    public static final AttributeSyntax getDefaultBinarySyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultBinarySyntax", new String[0]));
        return DirectoryServer.getDefaultBinarySyntax();
    }

    public static final AttributeSyntax getDefaultBooleanSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultBooleanSyntax", new String[0]));
        return DirectoryServer.getDefaultBooleanSyntax();
    }

    public static final AttributeSyntax getDefaultDNSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultDNSyntax", new String[0]));
        return DirectoryServer.getDefaultDNSyntax();
    }

    public static final AttributeSyntax getDefaultIntegerSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultIntegerSyntax", new String[0]));
        return DirectoryServer.getDefaultIntegerSyntax();
    }

    public static final AttributeSyntax getDefaultStringSyntax() {
        assert (Debug.debugEnter(CLASS_NAME, "getDefaultStringSyntax", new String[0]));
        return DirectoryServer.getDefaultStringSyntax();
    }

    public static final Map<MatchingRule, MatchingRuleUse> getMatchingRuleUses() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRuleUses", new String[0]));
        return DirectoryServer.getMatchingRuleUses();
    }

    public static final MatchingRuleUse getMatchingRuleUse(MatchingRule matchingRule) {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchingRuleUse", String.valueOf(matchingRule)));
        return DirectoryServer.getMatchingRuleUse(matchingRule);
    }

    public static final Map<ObjectClass, DITContentRule> getDITContentRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getDITContentRules", new String[0]));
        return DirectoryServer.getDITContentRules();
    }

    public static final DITContentRule getDITContentRule(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "getDITContentRule", String.valueOf(objectClass)));
        return DirectoryServer.getDITContentRule(objectClass);
    }

    public static final Map<NameForm, DITStructureRule> getDITStructureRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getDITStructureRules", new String[0]));
        return DirectoryServer.getDITStructureRules();
    }

    public static final DITStructureRule getDITStructureRule(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "getDITStructureRule", String.valueOf(n)));
        return DirectoryServer.getDITStructureRule(n);
    }

    public static final DITStructureRule getDITStructureRule(NameForm nameForm) {
        assert (Debug.debugEnter(CLASS_NAME, "getDITStructureRule", String.valueOf(nameForm)));
        return DirectoryServer.getDITStructureRule(nameForm);
    }

    public static final Map<ObjectClass, NameForm> getNameForms() {
        assert (Debug.debugEnter(CLASS_NAME, "getNameForms", new String[0]));
        return DirectoryServer.getNameForms();
    }

    public static final NameForm getNameForm(ObjectClass objectClass) {
        assert (Debug.debugEnter(CLASS_NAME, "getNameForm", String.valueOf(objectClass)));
        return DirectoryServer.getNameForm(objectClass);
    }

    public static final NameForm getNameForm(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getNameForm", String.valueOf(string)));
        return DirectoryServer.getNameForm(string);
    }

    public static final void registerConfigurableComponent(ConfigurableComponent configurableComponent) {
        assert (Debug.debugEnter(CLASS_NAME, "registerConfigurableComponent", String.valueOf(configurableComponent)));
        DirectoryServer.registerConfigurableComponent(configurableComponent);
    }

    public static final void deregisterConfigurableComponent(ConfigurableComponent configurableComponent) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterConfigurableComponent", String.valueOf(configurableComponent)));
        DirectoryServer.deregisterConfigurableComponent(configurableComponent);
    }

    public static final void registerInvokableComponent(InvokableComponent invokableComponent) {
        assert (Debug.debugEnter(CLASS_NAME, "registerInvokableComponent", String.valueOf(invokableComponent)));
        DirectoryServer.registerInvokableComponent(invokableComponent);
    }

    public static final void deregisterInvokableComponent(InvokableComponent invokableComponent) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterInvokableComponent", String.valueOf(invokableComponent)));
        DirectoryServer.deregisterInvokableComponent(invokableComponent);
    }

    public static final void registerAlertGenerator(AlertGenerator alertGenerator) {
        assert (Debug.debugEnter(CLASS_NAME, "registerAlertGenerator", new String[0]));
        DirectoryServer.registerAlertGenerator(alertGenerator);
    }

    public static final void deregisterAlertGenerator(AlertGenerator alertGenerator) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterAlertGenerator", new String[0]));
        DirectoryServer.deregisterAlertGenerator(alertGenerator);
    }

    public static final void sendAlertNotification(AlertGenerator alertGenerator, String string, int n, String string2) {
        assert (Debug.debugEnter(CLASS_NAME, "sendAlertNotification", String.valueOf(alertGenerator), String.valueOf(string), String.valueOf(n), String.valueOf(string2)));
        DirectoryServer.sendAlertNotification(alertGenerator, string, n, string2);
    }

    public static final ResultCode getServerErrorResultCode() {
        assert (Debug.debugEnter(CLASS_NAME, "getServerErrorResultCode", new String[0]));
        return DirectoryServer.getServerErrorResultCode();
    }

    public static final Entry getEntry(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getEntry", String.valueOf(dN)));
        return DirectoryServer.getEntry(dN);
    }

    public static final boolean entryExists(DN dN) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "entryExists", String.valueOf(dN)));
        return DirectoryServer.entryExists(dN);
    }

    public static final Set<String> getSupportedControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedControls", new String[0]));
        return DirectoryServer.getSupportedControls();
    }

    public static final boolean isSupportedControl(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isSupportedControl", String.valueOf(string)));
        return DirectoryServer.isSupportedControl(string);
    }

    public static final void registerSupportedControl(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "registerSupportedControl", String.valueOf(string)));
        DirectoryServer.registerSupportedControl(string);
    }

    public static final void deregisterSupportedControl(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterSupportedControl", String.valueOf(string)));
        DirectoryServer.deregisterSupportedControl(string);
    }

    public static final Set<String> getSupportedFeatures() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedFeatures", new String[0]));
        return DirectoryServer.getSupportedFeatures();
    }

    public static final boolean isSupportedFeature(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isSupportedFeature", String.valueOf(string)));
        return DirectoryServer.isSupportedFeature(string);
    }

    public static final void registerSupportedFeature(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "registerSupportedFeature", String.valueOf(string)));
        DirectoryServer.registerSupportedFeature(string);
    }

    public static final void deregisterSupportedFeature(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterSupportedFeature", String.valueOf(string)));
        DirectoryServer.deregisterSupportedFeature(string);
    }

    public static final Map<String, ExtendedOperationHandler> getSupportedExtensions() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedExtensions", new String[0]));
        return DirectoryServer.getSupportedExtensions();
    }

    public static final ExtendedOperationHandler getExtendedOperationHandler(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getExtendedOperationHandler", String.valueOf(string)));
        return DirectoryServer.getExtendedOperationHandler(string);
    }

    public static final void registerSupportedExtension(String string, ExtendedOperationHandler extendedOperationHandler) {
        assert (Debug.debugEnter(CLASS_NAME, "registerSupportedExtension", String.valueOf(string), String.valueOf(extendedOperationHandler)));
        DirectoryServer.registerSupportedExtension(string, extendedOperationHandler);
    }

    public static final void deregisterSupportedExtension(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterSupportedExtension", String.valueOf(string)));
        DirectoryServer.deregisterSupportedExtension(string);
    }

    public static final Map<String, SASLMechanismHandler> getSupportedSASLMechanisms() {
        assert (Debug.debugEnter(CLASS_NAME, "getSupportedSASLMechanisms", new String[0]));
        return DirectoryServer.getSupportedSASLMechanisms();
    }

    public static final SASLMechanismHandler getSASLMechanismHandler(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getSASLMechanismHandler", String.valueOf(string)));
        return DirectoryServer.getSASLMechanismHandler(string);
    }

    public static final void registerSASLMechanismHandler(String string, SASLMechanismHandler sASLMechanismHandler) {
        assert (Debug.debugEnter(CLASS_NAME, "registerSASLMechanismHandler", String.valueOf(string), String.valueOf(sASLMechanismHandler)));
        DirectoryServer.registerSASLMechanismHandler(string, sASLMechanismHandler);
    }

    public static final void deregisterSASLMechanismHandler(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterSASLMechanismHandler", String.valueOf(string)));
        DirectoryServer.deregisterSASLMechanismHandler(string);
    }

    public static final void registerChangeNotificationListener(ChangeNotificationListener changeNotificationListener) {
        assert (Debug.debugEnter(CLASS_NAME, "registerChangeNotificationListener", String.valueOf(changeNotificationListener)));
        DirectoryServer.registerChangeNotificationListener(changeNotificationListener);
    }

    public static final void deregisterChangeNotificationListener(ChangeNotificationListener changeNotificationListener) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterChangeNotificationListener", String.valueOf(changeNotificationListener)));
        DirectoryServer.deregisterChangeNotificationListener(changeNotificationListener);
    }

    public static final void registerShutdownListener(ServerShutdownListener serverShutdownListener) {
        assert (Debug.debugEnter(CLASS_NAME, "registerShutdownListener", String.valueOf(serverShutdownListener)));
        DirectoryServer.registerShutdownListener(serverShutdownListener);
    }

    public static final void deregisterShutdownListener(ServerShutdownListener serverShutdownListener) {
        assert (Debug.debugEnter(CLASS_NAME, "deregisterShutdownListener", String.valueOf(serverShutdownListener)));
        DirectoryServer.deregisterShutdownListener(serverShutdownListener);
    }

    public static final String getVersionString() {
        return DirectoryServer.getVersionString();
    }
}

