/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.HashMap;
import org.opends.server.messages.MessageHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DebugLogCategory {
    ACCESS_CONTROL(393234),
    BACKEND(393235),
    CONFIGURATION(393236),
    CONNECTION_HANDLING(393237),
    CONSTRUCTOR(393238),
    CORE_SERVER(393239),
    DATA_READ(393240),
    DATA_WRITE(393241),
    EXCEPTION(393242),
    EXTENDED_OPERATION(393243),
    EXTENSIONS(393352),
    METHOD_ENTER(393244),
    PASSWORD_POLICY(393719),
    PLUGIN(393245),
    PROTOCOL_READ(393246),
    PROTOCOL_WRITE(393247),
    SASL_MECHANISM(393248),
    SCHEMA(393344),
    SHUTDOWN(393268),
    STARTUP(393269),
    SYNCHRONIZATION(393249),
    DATABASE_READ(393393),
    DATABASE_WRITE(393394),
    DATABASE_ACCESS(393395);

    private static HashMap<String, DebugLogCategory> nameMap;
    private int categoryID;
    private String categoryName;

    private DebugLogCategory(int n2) {
        this.categoryID = n2;
        this.categoryName = null;
    }

    public static DebugLogCategory getByName(String string) {
        return nameMap.get(string);
    }

    public int getCategoryID() {
        return this.categoryID;
    }

    public String getCategoryName() {
        if (this.categoryName == null) {
            this.categoryName = MessageHandler.getMessage(this.categoryID);
        }
        return this.categoryName;
    }

    public String toString() {
        return this.getCategoryName();
    }

    static {
        nameMap = new HashMap(19);
        nameMap.put("ACCESS_CONTROL", ACCESS_CONTROL);
        nameMap.put("BACKEND", BACKEND);
        nameMap.put("CONFIG", CONFIGURATION);
        nameMap.put("CONNECTION", CONNECTION_HANDLING);
        nameMap.put("CONSTRUCTOR", CONSTRUCTOR);
        nameMap.put("CORE", CORE_SERVER);
        nameMap.put("DATA_READ", DATA_READ);
        nameMap.put("DATA_WRITE", DATA_WRITE);
        nameMap.put("ENTER", METHOD_ENTER);
        nameMap.put("EXCEPTION", EXCEPTION);
        nameMap.put("EXTENDED_OP", EXTENDED_OPERATION);
        nameMap.put("EXTENSIONS", EXTENSIONS);
        nameMap.put("PWPOLICY", PASSWORD_POLICY);
        nameMap.put("PLUGIN", PLUGIN);
        nameMap.put("PROTOCOL_READ", PROTOCOL_READ);
        nameMap.put("PROTOCOL_WRITE", PROTOCOL_WRITE);
        nameMap.put("SASL", SASL_MECHANISM);
        nameMap.put("SCHEMA", SCHEMA);
        nameMap.put("SHUTDOWN", SHUTDOWN);
        nameMap.put("STARTUP", STARTUP);
        nameMap.put("SYNCH", SYNCHRONIZATION);
        nameMap.put("DATABASE_READ", DATABASE_READ);
        nameMap.put("DATABASE_WRITE", DATABASE_WRITE);
        nameMap.put("DATABASE_ACCESS", DATABASE_ACCESS);
    }
}

