/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.opends.server.loggers.Debug;
import org.opends.server.types.NameForm;
import org.opends.server.types.ObjectClass;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DITStructureRule {
    private static final String CLASS_NAME = "org.opends.server.types.DITStructureRule";
    private boolean isObsolete;
    private ConcurrentHashMap<String, CopyOnWriteArrayList<String>> extraProperties;
    private ConcurrentHashMap<String, String> names;
    private CopyOnWriteArraySet<DITStructureRule> superiorRules;
    private int ruleID;
    private NameForm nameForm;
    private String description;
    private String schemaFile;

    public DITStructureRule(ConcurrentHashMap<String, String> concurrentHashMap, int n, String string, boolean bl, NameForm nameForm, CopyOnWriteArraySet<DITStructureRule> copyOnWriteArraySet, ConcurrentHashMap<String, CopyOnWriteArrayList<String>> concurrentHashMap2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(concurrentHashMap), String.valueOf(n), String.valueOf(string), String.valueOf(bl), String.valueOf(nameForm), String.valueOf(copyOnWriteArraySet), String.valueOf(concurrentHashMap2)));
        this.names = concurrentHashMap;
        this.ruleID = n;
        this.description = string;
        this.isObsolete = bl;
        this.nameForm = nameForm;
        this.superiorRules = copyOnWriteArraySet;
        this.schemaFile = null;
        this.extraProperties = concurrentHashMap2;
    }

    public ConcurrentHashMap<String, String> getNames() {
        assert (Debug.debugEnter(CLASS_NAME, "getNames", new String[0]));
        return this.names;
    }

    public void setNames(ConcurrentHashMap<String, String> concurrentHashMap) {
        assert (Debug.debugEnter(CLASS_NAME, "setNames", String.valueOf(concurrentHashMap)));
        this.names = concurrentHashMap;
    }

    public boolean hasName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasName", String.valueOf(string)));
        return this.names.containsKey(string);
    }

    public void addName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "addName", String.valueOf(string)));
        String string2 = StaticUtils.toLowerCase(string);
        this.names.put(string2, string);
    }

    public void removeName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "removeName", String.valueOf(string)));
        this.names.remove(string);
    }

    public int getRuleID() {
        assert (Debug.debugEnter(CLASS_NAME, "getRuleID", new String[0]));
        return this.ruleID;
    }

    public void setRuleID(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setRuleID", String.valueOf(n)));
        this.ruleID = n;
    }

    public String getNameOrRuleID() {
        assert (Debug.debugEnter(CLASS_NAME, "getNameOrRuleID", new String[0]));
        if (this.names.isEmpty()) {
            return String.valueOf(this.ruleID);
        }
        return this.names.values().iterator().next();
    }

    public boolean hasNameOrOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasNameOrOID", String.valueOf(string)));
        if (this.names.containsKey(string)) {
            return true;
        }
        return string.equals(String.valueOf(this.ruleID));
    }

    public String getSchemaFile() {
        assert (Debug.debugEnter(CLASS_NAME, "getSchemaFile", new String[0]));
        return this.schemaFile;
    }

    public void setSchemaFile(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setSchemaFile", String.valueOf(string)));
        this.schemaFile = string;
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return this.description;
    }

    public void setDescription(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setDescription", string));
        this.description = string;
    }

    public NameForm getNameForm() {
        assert (Debug.debugEnter(CLASS_NAME, "getNameForm", new String[0]));
        return this.nameForm;
    }

    public void setNameForm(NameForm nameForm) {
        assert (Debug.debugEnter(CLASS_NAME, "setNameForm", String.valueOf(nameForm)));
        this.nameForm = nameForm;
    }

    public ObjectClass getStructuralClass() {
        assert (Debug.debugEnter(CLASS_NAME, "getStructuralObjectClass", new String[0]));
        return this.nameForm.getStructuralClass();
    }

    public CopyOnWriteArraySet<DITStructureRule> getSuperiorRules() {
        assert (Debug.debugEnter(CLASS_NAME, "getSuperiorRules", new String[0]));
        return this.superiorRules;
    }

    public boolean hasSuperiorRules() {
        assert (Debug.debugEnter(CLASS_NAME, "hasSuperiorRules", new String[0]));
        return this.superiorRules != null && !this.superiorRules.isEmpty();
    }

    public void setSuperiorRules(CopyOnWriteArraySet<DITStructureRule> copyOnWriteArraySet) {
        assert (Debug.debugEnter(CLASS_NAME, "setSuperiorRules", String.valueOf(copyOnWriteArraySet)));
        this.superiorRules = copyOnWriteArraySet;
    }

    public void addSuperiorRule(DITStructureRule dITStructureRule) {
        assert (Debug.debugEnter(CLASS_NAME, "addSuperiorRule", String.valueOf(dITStructureRule)));
        this.superiorRules.add(dITStructureRule);
    }

    public void removeSuperiorRule(DITStructureRule dITStructureRule) {
        assert (Debug.debugEnter(CLASS_NAME, "removeSuperiorRule", String.valueOf(dITStructureRule)));
        this.superiorRules.remove(dITStructureRule);
    }

    public boolean isObsolete() {
        assert (Debug.debugEnter(CLASS_NAME, "isObsolete", new String[0]));
        return this.isObsolete;
    }

    public void setObsolete(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setObsolete", String.valueOf(bl)));
        this.isObsolete = bl;
    }

    public ConcurrentHashMap<String, CopyOnWriteArrayList<String>> getExtraProperties() {
        assert (Debug.debugEnter(CLASS_NAME, "getExtraProperties", new String[0]));
        return this.extraProperties;
    }

    public CopyOnWriteArrayList<String> getExtraProperty(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getExtraProperty", String.valueOf(string)));
        return this.extraProperties.get(string);
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof DITStructureRule)) {
            return false;
        }
        return this.ruleID == ((DITStructureRule)object).ruleID;
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        return this.ruleID;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, true);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder, boolean bl) {
        Iterator<Object> iterator;
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(bl)));
        stringBuilder.append("( ");
        stringBuilder.append(this.ruleID);
        if (!this.names.isEmpty()) {
            iterator = this.names.values().iterator();
            String string = iterator.next();
            if (iterator.hasNext()) {
                stringBuilder.append(" NAME ( '");
                stringBuilder.append(string);
                while (iterator.hasNext()) {
                    stringBuilder.append("' '");
                    stringBuilder.append((String)iterator.next());
                }
                stringBuilder.append("' )");
            } else {
                stringBuilder.append(" NAME '");
                stringBuilder.append(string);
                stringBuilder.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            stringBuilder.append(" DESC '");
            stringBuilder.append(this.description);
            stringBuilder.append("'");
        }
        if (this.isObsolete) {
            stringBuilder.append(" OBSOLETE");
        }
        stringBuilder.append(" FORM ");
        stringBuilder.append(this.nameForm.getNameOrOID());
        if (this.superiorRules != null && !this.superiorRules.isEmpty()) {
            iterator = this.superiorRules.iterator();
            int n = ((DITStructureRule)iterator.next()).getRuleID();
            if (iterator.hasNext()) {
                stringBuilder.append(" SUP ( ");
                stringBuilder.append(n);
                while (iterator.hasNext()) {
                    stringBuilder.append(" ");
                    stringBuilder.append(((DITStructureRule)iterator.next()).getRuleID());
                }
                stringBuilder.append(" )");
            } else {
                stringBuilder.append(" SUP ");
                stringBuilder.append(n);
            }
        }
        if (!this.extraProperties.isEmpty()) {
            for (String string : this.extraProperties.keySet()) {
                CopyOnWriteArrayList<String> copyOnWriteArrayList = this.extraProperties.get(string);
                stringBuilder.append(" ");
                stringBuilder.append(string);
                if (copyOnWriteArrayList.size() == 1) {
                    stringBuilder.append(" '");
                    stringBuilder.append(copyOnWriteArrayList.get(0));
                    stringBuilder.append("'");
                    continue;
                }
                stringBuilder.append(" ( ");
                for (String string2 : copyOnWriteArrayList) {
                    stringBuilder.append("'");
                    stringBuilder.append(string2);
                    stringBuilder.append("' ");
                }
                stringBuilder.append(")");
            }
        }
        if (bl && this.schemaFile != null && !this.extraProperties.containsKey("X-SCHEMA-FILE")) {
            stringBuilder.append(" ");
            stringBuilder.append("X-SCHEMA-FILE");
            stringBuilder.append(" '");
            stringBuilder.append(this.schemaFile);
            stringBuilder.append("'");
        }
        stringBuilder.append(" )");
    }
}

