/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opends.server.loggers.Debug;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonSchemaElements {
    private static final String CLASS_NAME = "org.opends.server.types.CommonSchemaElements";
    private final boolean isObsolete;
    private final Map<String, List<String>> extraProperties;
    private final Map<String, String> names;
    private final String description;
    private final String oid;
    private final String primaryName;
    private final String lowerName;

    protected CommonSchemaElements(String string, Collection<String> collection, String string2, String string3, boolean bl, Map<String, List<String>> map) throws NullPointerException {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string), String.valueOf(collection), String.valueOf(string2), String.valueOf(string3), String.valueOf(bl), String.valueOf(map)));
        if (string2 == null) {
            throw new NullPointerException("No oid specified in constructor");
        }
        this.oid = string2;
        this.description = string3;
        this.isObsolete = bl;
        this.primaryName = string == null ? (collection != null && !collection.isEmpty() ? collection.iterator().next() : null) : string;
        this.lowerName = StaticUtils.toLowerCase(string);
        if (collection != null) {
            this.names = new LinkedHashMap<String, String>(collection.size());
            this.names.put(this.lowerName, this.primaryName);
            for (String string4 : collection) {
                this.names.put(StaticUtils.toLowerCase(string4), string4);
            }
        } else {
            this.names = this.primaryName != null ? Collections.singletonMap(this.lowerName, this.primaryName) : Collections.emptyMap();
        }
        this.extraProperties = map != null ? new LinkedHashMap<String, List<String>>(map) : Collections.emptyMap();
    }

    public final String getPrimaryName() {
        assert (Debug.debugEnter(CLASS_NAME, "getPrimaryName", new String[0]));
        return this.primaryName;
    }

    public final String getNormalizedPrimaryName() {
        assert (Debug.debugEnter(CLASS_NAME, "getNormalizedPrimaryName", new String[0]));
        return this.lowerName;
    }

    public final Iterable<String> getNormalizedNames() {
        assert (Debug.debugEnter(CLASS_NAME, "getNormalizedNames", new String[0]));
        return this.names.keySet();
    }

    public final Iterable<String> getUserDefinedNames() {
        assert (Debug.debugEnter(CLASS_NAME, "getUserDefinedNames", new String[0]));
        return this.names.values();
    }

    public final boolean hasName(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasName", String.valueOf(string)));
        return this.names.containsKey(string);
    }

    public final String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return this.oid;
    }

    public final String getNameOrOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getNameOrOID", new String[0]));
        if (this.primaryName != null) {
            return this.primaryName;
        }
        return this.oid;
    }

    public final boolean hasNameOrOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasNameOrOID", String.valueOf(string)));
        if (this.names.containsKey(string)) {
            return true;
        }
        return this.oid.equals(string);
    }

    public final String getSchemaFile() {
        assert (Debug.debugEnter(CLASS_NAME, "getSchemaFile", new String[0]));
        List<String> list = this.extraProperties.get("X-SCHEMA-FILE");
        if (list != null && !list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public final String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return this.description;
    }

    public final boolean isObsolete() {
        assert (Debug.debugEnter(CLASS_NAME, "isObsolete", new String[0]));
        return this.isObsolete;
    }

    public final Iterable<String> getExtraPropertyNames() {
        assert (Debug.debugEnter(CLASS_NAME, "getExtraPropertyNames", new String[0]));
        return this.extraProperties.keySet();
    }

    public final Iterable<String> getExtraProperty(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "getExtraProperty", String.valueOf(string)));
        return this.extraProperties.get(string);
    }

    public final boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", new String[0]));
        if (this == object) {
            return true;
        }
        if (object instanceof CommonSchemaElements) {
            CommonSchemaElements commonSchemaElements = (CommonSchemaElements)object;
            return this.oid.equals(commonSchemaElements.oid);
        }
        return false;
    }

    public final int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        return this.oid.hashCode();
    }

    public final String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder, true);
        return stringBuilder.toString();
    }

    public final void toString(StringBuilder stringBuilder, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(bl)));
        stringBuilder.append("( ");
        stringBuilder.append(this.oid);
        if (!this.names.isEmpty()) {
            Iterator<Object> iterator = this.names.values().iterator();
            String object = iterator.next();
            if (iterator.hasNext()) {
                stringBuilder.append(" NAME ( '");
                stringBuilder.append(object);
                while (iterator.hasNext()) {
                    stringBuilder.append("' '");
                    stringBuilder.append((String)iterator.next());
                }
                stringBuilder.append("' )");
            } else {
                stringBuilder.append(" NAME '");
                stringBuilder.append(object);
                stringBuilder.append("'");
            }
        }
        if (this.description != null && this.description.length() > 0) {
            stringBuilder.append(" DESC '");
            stringBuilder.append(this.description);
            stringBuilder.append("'");
        }
        if (this.isObsolete) {
            stringBuilder.append(" OBSOLETE");
        }
        this.toStringContent(stringBuilder);
        if (!this.extraProperties.isEmpty()) {
            for (Map.Entry entry : this.extraProperties.entrySet()) {
                String string = (String)entry.getKey();
                if (!bl && string.equals("X-SCHEMA-FILE")) continue;
                List list = (List)entry.getValue();
                stringBuilder.append(" ");
                stringBuilder.append(string);
                if (list.size() == 1) {
                    stringBuilder.append(" '");
                    stringBuilder.append((String)list.get(0));
                    stringBuilder.append("'");
                    continue;
                }
                stringBuilder.append(" ( ");
                for (String string2 : list) {
                    stringBuilder.append("'");
                    stringBuilder.append(string2);
                    stringBuilder.append("' ");
                }
                stringBuilder.append(")");
            }
        }
        stringBuilder.append(" )");
    }

    protected abstract void toStringContent(StringBuilder var1);
}

