/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.opends.server.loggers.Debug;
import org.opends.server.types.AuthenticationType;
import org.opends.server.types.ByteString;
import org.opends.server.types.DN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationInfo {
    private static final String CLASS_NAME = "org.opends.server.types.AuthenticationInfo";
    private ByteString simplePassword;
    private boolean isAuthenticated;
    private boolean isRoot;
    private boolean mustChangePassword;
    private DN authenticationDN;
    private DN authorizationDN;
    private Set<AuthenticationType> authenticationTypes;
    private Set<String> saslMechanisms;

    public AuthenticationInfo() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.isAuthenticated = false;
        this.isRoot = false;
        this.mustChangePassword = false;
        this.simplePassword = null;
        this.authenticationTypes = new HashSet<AuthenticationType>(0);
        this.authenticationDN = null;
        this.authorizationDN = null;
        this.saslMechanisms = new HashSet<String>(0);
    }

    public AuthenticationInfo(DN dN, boolean bl) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(dN), String.valueOf(bl)));
        this.authenticationDN = dN;
        this.isRoot = bl;
        this.isAuthenticated = true;
        this.mustChangePassword = false;
        this.simplePassword = null;
        this.authorizationDN = dN;
        this.saslMechanisms = new HashSet<String>(0);
        this.authenticationTypes = new HashSet<AuthenticationType>(1);
        this.authenticationTypes.add(AuthenticationType.INTERNAL);
    }

    public AuthenticationInfo(DN dN, ByteString byteString, boolean bl) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(dN), String.valueOf(byteString), String.valueOf(bl)));
        this.authenticationDN = dN;
        this.simplePassword = byteString;
        this.isRoot = bl;
        this.isAuthenticated = true;
        this.mustChangePassword = false;
        this.authorizationDN = dN;
        this.saslMechanisms = new HashSet<String>(0);
        this.authenticationTypes = new HashSet<AuthenticationType>(1);
        this.authenticationTypes.add(AuthenticationType.SIMPLE);
    }

    public AuthenticationInfo(DN dN, String string, boolean bl) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(dN), String.valueOf(string), String.valueOf(bl)));
        this.authenticationDN = dN;
        this.isRoot = bl;
        this.isAuthenticated = true;
        this.mustChangePassword = false;
        this.authorizationDN = dN;
        this.simplePassword = null;
        this.authenticationTypes = new HashSet<AuthenticationType>(1);
        this.authenticationTypes.add(AuthenticationType.SASL);
        this.saslMechanisms = new HashSet<String>(1);
        this.saslMechanisms.add(string);
    }

    public AuthenticationInfo(DN dN, DN dN2, String string, boolean bl) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(dN), String.valueOf(dN2), String.valueOf(string), String.valueOf(bl)));
        this.authenticationDN = dN;
        this.isRoot = bl;
        this.authorizationDN = dN2 == null ? dN : dN2;
        this.isAuthenticated = true;
        this.mustChangePassword = false;
        this.simplePassword = null;
        this.authenticationTypes = new HashSet<AuthenticationType>(1);
        this.authenticationTypes.add(AuthenticationType.SASL);
        this.saslMechanisms = new HashSet<String>(1);
        this.saslMechanisms.add(string);
    }

    public boolean isAuthenticated() {
        assert (Debug.debugEnter(CLASS_NAME, "isAuthenticated", new String[0]));
        return this.isAuthenticated;
    }

    public void setUnauthenticated() {
        assert (Debug.debugEnter(CLASS_NAME, "setUnauthenticated", new String[0]));
        this.isAuthenticated = false;
        this.isRoot = false;
        this.mustChangePassword = false;
        this.simplePassword = null;
        this.authenticationDN = null;
        this.authorizationDN = null;
        this.authenticationTypes.clear();
        this.saslMechanisms.clear();
    }

    public boolean isRoot() {
        assert (Debug.debugEnter(CLASS_NAME, "isRoot", new String[0]));
        return this.isRoot;
    }

    public boolean mustChangePassword() {
        assert (Debug.debugEnter(CLASS_NAME, "mustChangePassword", new String[0]));
        return this.mustChangePassword;
    }

    public void setMustChangePassword(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setMustChangePassword", String.valueOf(bl)));
        this.mustChangePassword = bl;
    }

    public boolean hasAuthenticationType(AuthenticationType authenticationType) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAuthenticationType", String.valueOf((Object)authenticationType)));
        return this.authenticationTypes.contains((Object)authenticationType);
    }

    public boolean hasAnyAuthenticationType(Collection<AuthenticationType> collection) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAnyAuthenticationType", String.valueOf(collection)));
        for (AuthenticationType authenticationType : collection) {
            if (!this.authenticationTypes.contains((Object)authenticationType)) continue;
            return true;
        }
        return false;
    }

    public Set<AuthenticationType> getAuthenticationTypes() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthenticationTypes", new String[0]));
        return this.authenticationTypes;
    }

    public void addAuthenticationType(AuthenticationType authenticationType) {
        assert (Debug.debugEnter(CLASS_NAME, "addAuthenticationType", new String[0]));
        this.authenticationTypes.add(authenticationType);
    }

    public DN getAuthenticationDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthenticationDN", new String[0]));
        return this.authenticationDN;
    }

    public DN getAuthorizationDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthorizationDN", new String[0]));
        return this.authorizationDN;
    }

    public ByteString getSimplePassword() {
        assert (Debug.debugEnter(CLASS_NAME, "getSimplePassword", new String[0]));
        return this.simplePassword;
    }

    public boolean hasSASLMechanism(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "hasSASLMechanism", String.valueOf(string)));
        return this.saslMechanisms.contains(string);
    }

    public boolean hasAnySASLMechanism(Collection<String> collection) {
        assert (Debug.debugEnter(CLASS_NAME, "hasAnySASLMechanism", String.valueOf(collection)));
        for (String string : collection) {
            if (!this.saslMechanisms.contains(string)) continue;
            return true;
        }
        return false;
    }

    public Set<String> getSASLMechanisms() {
        assert (Debug.debugEnter(CLASS_NAME, "getSASLMechanisms", new String[0]));
        return this.saslMechanisms;
    }

    public void addSASLMechanism(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "addSASLMechanism", String.valueOf(string)));
        this.saslMechanisms.add(string);
    }

    public boolean isMemberOf(DN dN) {
        return false;
    }

    public Collection<DN> getMembershipDNs() {
        return null;
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        Object object;
        Iterator<Object> iterator;
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("AuthenticationInfo(isAuthenticated=");
        stringBuilder.append(this.isAuthenticated);
        stringBuilder.append(",isRoot=");
        stringBuilder.append(this.isRoot);
        stringBuilder.append(",mustChangePassword=");
        stringBuilder.append(this.mustChangePassword);
        stringBuilder.append(",authenticationDN=\"");
        stringBuilder.append(this.authenticationDN);
        if (this.authorizationDN == null || this.authorizationDN.equals(this.authenticationDN)) {
            stringBuilder.append("\",authorizationDN=\"");
            stringBuilder.append(this.authorizationDN);
        }
        stringBuilder.append("\"");
        if (!this.authenticationTypes.isEmpty()) {
            iterator = this.authenticationTypes.iterator();
            object = iterator.next();
            if (iterator.hasNext()) {
                stringBuilder.append(",authTypes={");
                stringBuilder.append(object);
                while (iterator.hasNext()) {
                    stringBuilder.append(",");
                    stringBuilder.append(iterator.next());
                }
                stringBuilder.append("}");
            } else {
                stringBuilder.append(",authType=");
                stringBuilder.append(object);
            }
        }
        if (!this.saslMechanisms.isEmpty()) {
            iterator = this.saslMechanisms.iterator();
            object = (String)iterator.next();
            if (iterator.hasNext()) {
                stringBuilder.append(",saslMechanisms={");
                stringBuilder.append((String)object);
                while (iterator.hasNext()) {
                    stringBuilder.append(",");
                    stringBuilder.append((String)iterator.next());
                }
                stringBuilder.append("}");
            } else {
                stringBuilder.append(",saslMechanism=");
                stringBuilder.append((String)object);
            }
        }
        stringBuilder.append(")");
    }
}

