/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.opends.server.loggers.Debug;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeValueIterable
implements Iterable<AttributeValue> {
    private static final String CLASS_NAME = AttributeValueIterable.class.getName();
    private Iterable<Attribute> attributes;
    private HashSet<String> options;

    public AttributeValueIterable(Iterable<Attribute> iterable) {
        this(iterable, null);
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public AttributeValueIterable(Iterable<Attribute> iterable, HashSet<String> hashSet) {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.attributes = iterable;
        this.options = hashSet;
    }

    @Override
    public Iterator<AttributeValue> iterator() {
        assert (Debug.debugEnter(CLASS_NAME, "iterator", new String[0]));
        return new AttributeValueIterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class AttributeValueIterator
    implements Iterator<AttributeValue> {
        private boolean hasNext;
        private Iterator<Attribute> attributeIterator;
        private Iterator<AttributeValue> valueIterator;

        private AttributeValueIterator() {
            assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
            this.valueIterator = null;
            if (AttributeValueIterable.this.attributes != null) {
                this.attributeIterator = AttributeValueIterable.this.attributes.iterator();
                this.hasNext = this.skipNonMatchingAttributes();
            } else {
                this.attributeIterator = null;
                this.hasNext = false;
            }
        }

        @Override
        public boolean hasNext() {
            assert (Debug.debugEnter(CLASS_NAME, "hasNext", new String[0]));
            return this.hasNext;
        }

        @Override
        public AttributeValue next() {
            assert (Debug.debugEnter(CLASS_NAME, "next", new String[0]));
            if (!this.hasNext) {
                throw new NoSuchElementException();
            }
            AttributeValue attributeValue = this.valueIterator.next();
            if (!this.valueIterator.hasNext()) {
                this.hasNext = this.skipNonMatchingAttributes();
            }
            return attributeValue;
        }

        @Override
        public void remove() {
            assert (Debug.debugEnter(CLASS_NAME, "remove", new String[0]));
            throw new UnsupportedOperationException();
        }

        private boolean skipNonMatchingAttributes() {
            assert (Debug.debugEnter(CLASS_NAME, "skipNonMatchingAttributes", new String[0]));
            while (this.attributeIterator.hasNext()) {
                Attribute attribute = this.attributeIterator.next();
                if (!attribute.hasOptions(AttributeValueIterable.this.options)) continue;
                this.valueIterator = attribute.getValues().iterator();
                if (!this.valueIterator.hasNext()) continue;
                return true;
            }
            return false;
        }
    }
}

