/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.ConditionResult;
import org.opends.server.types.DirectoryException;
import org.opends.server.util.Validator;

public class AttributeValue {
    private static final String CLASS_NAME = "org.opends.server.types.AttributeValue";
    private ByteString normalizedValue;
    private final ByteString value;
    private final AttributeType attributeType;

    public AttributeValue(AttributeType attributeType, ByteString byteString) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(attributeType), String.valueOf(byteString)));
        Validator.ensureNotNull(attributeType, byteString);
        this.attributeType = attributeType;
        this.value = byteString;
        this.normalizedValue = null;
    }

    public AttributeValue(AttributeType attributeType, String string) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(attributeType), String.valueOf(string)));
        Validator.ensureNotNull(attributeType, string);
        this.attributeType = attributeType;
        this.value = new ASN1OctetString(string);
        this.normalizedValue = null;
    }

    public AttributeValue(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(byteString), String.valueOf(byteString2)));
        Validator.ensureNotNull(byteString, byteString2);
        this.value = byteString;
        this.normalizedValue = byteString2;
        this.attributeType = null;
    }

    public ByteString getValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getValue", new String[0]));
        return this.value;
    }

    public byte[] getValueBytes() {
        assert (Debug.debugEnter(CLASS_NAME, "getValueBytes", new String[0]));
        return this.value.value();
    }

    public String getStringValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getStringValue", new String[0]));
        return this.value.stringValue();
    }

    public ByteString getNormalizedValue() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getNormalizedValue", new String[0]));
        if (this.normalizedValue == null) {
            this.normalizedValue = this.attributeType.normalize(this.value);
        }
        return this.normalizedValue;
    }

    public byte[] getNormalizedValueBytes() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getValueBytes", new String[0]));
        return this.getNormalizedValue().value();
    }

    public String getNormalizedStringValue() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "getNormalizedStringValue", new String[0]));
        if (this.normalizedValue == null) {
            this.normalizedValue = this.attributeType.normalize(this.value);
        }
        return this.normalizedValue.stringValue();
    }

    public boolean equals(Object object) {
        assert (Debug.debugEnter(CLASS_NAME, "equals", String.valueOf(object)));
        if (this == object) {
            return true;
        }
        if (object != null && object instanceof AttributeValue) {
            AttributeValue attributeValue = (AttributeValue)object;
            try {
                if (this.attributeType != null) {
                    EqualityMatchingRule equalityMatchingRule = this.attributeType.getEqualityMatchingRule();
                    if (equalityMatchingRule == null) {
                        return this.getNormalizedValue().equals(attributeValue.getNormalizedValue());
                    }
                    return equalityMatchingRule.valuesMatch(this.getNormalizedValue(), attributeValue.getNormalizedValue()) == ConditionResult.TRUE;
                }
                if (attributeValue.attributeType != null) {
                    EqualityMatchingRule equalityMatchingRule = attributeValue.attributeType.getEqualityMatchingRule();
                    if (equalityMatchingRule == null) {
                        return this.getNormalizedValue().equals(attributeValue.getNormalizedValue());
                    }
                    return equalityMatchingRule.valuesMatch(this.getNormalizedValue(), attributeValue.getNormalizedValue()) == ConditionResult.TRUE;
                }
                return this.normalizedValue.equals(attributeValue.getNormalizedValue());
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "equals", exception));
                return this.value.equals(attributeValue.getValue());
            }
        }
        return false;
    }

    public int hashCode() {
        assert (Debug.debugEnter(CLASS_NAME, "hashCode", new String[0]));
        try {
            if (this.attributeType == null) {
                return this.normalizedValue.hashCode();
            }
            return this.attributeType.generateHashCode(this);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hashCode", exception));
            return this.value.hashCode();
        }
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        if (this.value == null) {
            return "null";
        }
        return this.value.stringValue();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append(((Object)this.value).toString());
    }
}

