/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.types;

import org.opends.server.messages.MessageHandler;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AccountStatusNotificationType {
    ACCOUNT_TEMPORARILY_LOCKED(5243009),
    ACCOUNT_PERMANENTLY_LOCKED(5243010),
    ACCOUNT_UNLOCKED(5243011),
    ACCOUNT_IDLE_LOCKED(5243012),
    ACCOUNT_RESET_LOCKED(0x500085),
    ACCOUNT_DISABLED(5243014),
    ACCOUNT_ENABLED(5243015),
    ACCOUNT_EXPIRED(0x500088),
    PASSWORD_EXPIRED(5243017),
    PASSWORD_EXPIRING(5243018),
    PASSWORD_RESET(5243019),
    PASSWORD_CHANGED(5243020);

    private int notificationTypeID;

    private AccountStatusNotificationType(int n2) {
        this.notificationTypeID = n2;
    }

    public static AccountStatusNotificationType typeForID(int n) {
        switch (n) {
            case 5243009: {
                return ACCOUNT_TEMPORARILY_LOCKED;
            }
            case 5243010: {
                return ACCOUNT_PERMANENTLY_LOCKED;
            }
            case 5243011: {
                return ACCOUNT_UNLOCKED;
            }
            case 5243012: {
                return ACCOUNT_IDLE_LOCKED;
            }
            case 0x500085: {
                return ACCOUNT_RESET_LOCKED;
            }
            case 5243014: {
                return ACCOUNT_DISABLED;
            }
            case 5243015: {
                return ACCOUNT_ENABLED;
            }
            case 0x500088: {
                return ACCOUNT_EXPIRED;
            }
            case 5243017: {
                return PASSWORD_EXPIRED;
            }
            case 5243018: {
                return PASSWORD_EXPIRING;
            }
            case 5243019: {
                return PASSWORD_RESET;
            }
            case 5243020: {
                return PASSWORD_CHANGED;
            }
        }
        return null;
    }

    public static AccountStatusNotificationType typeForName(String string) {
        String string2 = StaticUtils.toLowerCase(string);
        if (string2.equals(MessageHandler.getMessage(5243009))) {
            return ACCOUNT_TEMPORARILY_LOCKED;
        }
        if (string2.equals(MessageHandler.getMessage(5243010))) {
            return ACCOUNT_PERMANENTLY_LOCKED;
        }
        if (string2.equals(MessageHandler.getMessage(5243011))) {
            return ACCOUNT_UNLOCKED;
        }
        if (string2.equals(MessageHandler.getMessage(5243012))) {
            return ACCOUNT_IDLE_LOCKED;
        }
        if (string2.equals(MessageHandler.getMessage(0x500085))) {
            return ACCOUNT_RESET_LOCKED;
        }
        if (string2.equals(MessageHandler.getMessage(5243014))) {
            return ACCOUNT_DISABLED;
        }
        if (string2.equals(MessageHandler.getMessage(5243015))) {
            return ACCOUNT_ENABLED;
        }
        if (string2.equals(MessageHandler.getMessage(0x500088))) {
            return ACCOUNT_EXPIRED;
        }
        if (string2.equals(MessageHandler.getMessage(5243017))) {
            return PASSWORD_EXPIRED;
        }
        if (string2.equals(MessageHandler.getMessage(5243018))) {
            return PASSWORD_EXPIRING;
        }
        if (string2.equals(MessageHandler.getMessage(5243019))) {
            return PASSWORD_RESET;
        }
        if (string2.equals(MessageHandler.getMessage(5243020))) {
            return PASSWORD_CHANGED;
        }
        return null;
    }

    public int getNotificationTypeID() {
        return this.notificationTypeID;
    }

    public String getNotificationTypeName() {
        return MessageHandler.getMessage(this.notificationTypeID);
    }

    public String toString() {
        return MessageHandler.getMessage(this.notificationTypeID);
    }
}

