/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.DN;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnderscoreParentDNTag
extends Tag {
    @Override
    public String getName() {
        return "_ParentDN";
    }

    @Override
    public boolean allowedInBranch() {
        return false;
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] stringArray, int n, List<String> list) throws InitializationException {
        if (stringArray.length != 0) {
            int n2 = 10682903;
            String string = MessageHandler.getMessage(n2, this.getName(), n, 0, stringArray.length);
            throw new InitializationException(n2, string);
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        DN dN = templateEntry.getParentDN();
        if (dN == null || dN.isNullDN()) {
            return TagResult.SUCCESS_RESULT;
        }
        dN.getRDN(0).toString(templateValue.getValue());
        for (int i = 1; i < dN.getNumComponents(); ++i) {
            templateValue.append("_");
            dN.getRDN(i).toString(templateValue.getValue());
        }
        return TagResult.SUCCESS_RESULT;
    }
}

