/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.util.List;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tools.makeldif.Branch;
import org.opends.server.tools.makeldif.Tag;
import org.opends.server.tools.makeldif.TagResult;
import org.opends.server.tools.makeldif.Template;
import org.opends.server.tools.makeldif.TemplateEntry;
import org.opends.server.tools.makeldif.TemplateFile;
import org.opends.server.tools.makeldif.TemplateValue;
import org.opends.server.types.InitializationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequentialTag
extends Tag {
    private boolean resetOnNewParents;
    private int initialValue;
    private int nextValue;

    @Override
    public String getName() {
        return "Sequential";
    }

    @Override
    public boolean allowedInBranch() {
        return true;
    }

    @Override
    public void initializeForBranch(TemplateFile templateFile, Branch branch, String[] stringArray, int n, List<String> list) throws InitializationException {
        this.initializeInternal(templateFile, stringArray, n);
    }

    @Override
    public void initializeForTemplate(TemplateFile templateFile, Template template, String[] stringArray, int n, List<String> list) throws InitializationException {
        this.initializeInternal(templateFile, stringArray, n);
    }

    private void initializeInternal(TemplateFile templateFile, String[] stringArray, int n) throws InitializationException {
        switch (stringArray.length) {
            case 0: {
                this.initialValue = 0;
                this.nextValue = 0;
                this.resetOnNewParents = true;
                break;
            }
            case 1: {
                try {
                    this.initialValue = Integer.parseInt(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    int n2 = 10682907;
                    String string = MessageHandler.getMessage(n2, stringArray[0], this.getName(), n);
                    throw new InitializationException(n2, string);
                }
                this.nextValue = this.initialValue;
                this.resetOnNewParents = true;
                break;
            }
            case 2: {
                try {
                    this.initialValue = Integer.parseInt(stringArray[0]);
                }
                catch (NumberFormatException numberFormatException) {
                    int n3 = 10682907;
                    String string = MessageHandler.getMessage(n3, stringArray[0], this.getName(), n);
                    throw new InitializationException(n3, string);
                }
                if (stringArray[1].equalsIgnoreCase("true")) {
                    this.resetOnNewParents = true;
                } else if (stringArray[1].equalsIgnoreCase("false")) {
                    this.resetOnNewParents = false;
                } else {
                    int n4 = 10682910;
                    String string = MessageHandler.getMessage(n4, stringArray[1], this.getName(), n);
                    throw new InitializationException(n4, string);
                }
                this.nextValue = this.initialValue;
                break;
            }
            default: {
                int n5 = 10682904;
                String string = MessageHandler.getMessage(n5, this.getName(), n, 0, 2, stringArray.length);
                throw new InitializationException(n5, string);
            }
        }
    }

    @Override
    public void initializeForParent(TemplateEntry templateEntry) {
        if (this.resetOnNewParents) {
            this.nextValue = this.initialValue;
        }
    }

    @Override
    public TagResult generateValue(TemplateEntry templateEntry, TemplateValue templateValue) {
        templateValue.getValue().append(this.nextValue++);
        return TagResult.SUCCESS_RESULT;
    }
}

