/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools.makeldif;

import java.io.IOException;
import org.opends.server.api.DirectoryThread;
import org.opends.server.tools.makeldif.MakeLDIFException;
import org.opends.server.tools.makeldif.MakeLDIFInputStream;
import org.opends.server.tools.makeldif.TemplateFile;

class MakeLDIFInputStreamThread
extends DirectoryThread {
    private MakeLDIFInputStream inputStream;
    private TemplateFile templateFile;

    public MakeLDIFInputStreamThread(MakeLDIFInputStream makeLDIFInputStream, TemplateFile templateFile) {
        super("MakeLDIF Input Stream Thread");
        this.inputStream = makeLDIFInputStream;
        this.templateFile = templateFile;
    }

    public void run() {
        try {
            this.templateFile.generateLDIF(this.inputStream);
        }
        catch (MakeLDIFException makeLDIFException) {
            this.inputStream.setIOException(new IOException(makeLDIFException.getMessage()));
            this.inputStream.closeEntryWriter();
        }
        catch (IOException iOException) {
            this.inputStream.setIOException(iOException);
            this.inputStream.closeEntryWriter();
        }
    }
}

