/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.opends.server.api.Backend;
import org.opends.server.api.ErrorLogger;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.Error;
import org.opends.server.loggers.StartupErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.BackupDirectory;
import org.opends.server.types.BackupInfo;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.RestoreConfig;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestoreDB {
    public static void main(String[] stringArray) {
        int n = RestoreDB.mainRestoreDB(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    public static int mainRestoreDB(String[] stringArray) {
        String string;
        Object object;
        Object object2;
        int n;
        Object object3;
        Object object4;
        BooleanArgument booleanArgument = null;
        BooleanArgument booleanArgument2 = null;
        BooleanArgument booleanArgument3 = null;
        StringArgument stringArgument = null;
        StringArgument stringArgument2 = null;
        StringArgument stringArgument3 = null;
        StringArgument stringArgument4 = null;
        String string2 = MessageHandler.getMessage(10486458);
        ArgumentParser argumentParser = new ArgumentParser("org.opends.server.tools.RestoreDB", string2, false);
        try {
            stringArgument2 = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 10486049, new Object[0]);
            stringArgument2.setHidden(true);
            argumentParser.addArgument(stringArgument2);
            stringArgument3 = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, "{configFile}", null, null, 10486050, new Object[0]);
            stringArgument3.setHidden(true);
            argumentParser.addArgument(stringArgument3);
            stringArgument = new StringArgument("backupid", Character.valueOf('I'), "backupID", false, false, true, "{backupID}", null, null, 10486052, new Object[0]);
            argumentParser.addArgument(stringArgument);
            stringArgument4 = new StringArgument("backupdirectory", Character.valueOf('d'), "backupDirectory", true, false, true, "{backupDir}", null, null, 10486053, new Object[0]);
            argumentParser.addArgument(stringArgument4);
            booleanArgument2 = new BooleanArgument("listbackups", Character.valueOf('l'), "listBackups", 10486054, new Object[0]);
            argumentParser.addArgument(booleanArgument2);
            booleanArgument3 = new BooleanArgument("verifyonly", Character.valueOf('V'), "verifyOnly", 10486055, new Object[0]);
            argumentParser.addArgument(booleanArgument3);
            booleanArgument = new BooleanArgument("help", Character.valueOf('H'), "help", 10486056, new Object[0]);
            argumentParser.addArgument(booleanArgument);
            argumentParser.setUsageArgument(booleanArgument);
        }
        catch (ArgumentException argumentException) {
            int n2 = 10748201;
            String string3 = MessageHandler.getMessage(n2, argumentException.getMessage());
            System.err.println(StaticUtils.wrapText(string3, 79));
            return 1;
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            int n3 = 10748202;
            String string4 = MessageHandler.getMessage(n3, argumentException.getMessage());
            System.err.println(StaticUtils.wrapText(string4, 79));
            System.err.println(argumentParser.getUsage());
            return 1;
        }
        if (booleanArgument.isPresent()) {
            return 0;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        try {
            directoryServer.bootstrapClient();
            directoryServer.initializeJMX();
        }
        catch (Exception exception) {
            int n4 = 10748203;
            String string5 = MessageHandler.getMessage(n4, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(StaticUtils.wrapText(string5, 79));
            return 1;
        }
        try {
            directoryServer.initializeConfiguration(stringArgument2.getValue(), stringArgument3.getValue());
        }
        catch (InitializationException initializationException) {
            int n5 = 10748204;
            String string6 = MessageHandler.getMessage(n5, initializationException.getMessage());
            System.err.println(StaticUtils.wrapText(string6, 79));
            return 1;
        }
        catch (Exception exception) {
            int n6 = 10748204;
            String string7 = MessageHandler.getMessage(n6, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(StaticUtils.wrapText(string7, 79));
            return 1;
        }
        try {
            directoryServer.initializeSchema();
        }
        catch (ConfigException configException) {
            int n7 = 10748205;
            String string8 = MessageHandler.getMessage(n7, configException.getMessage());
            System.err.println(StaticUtils.wrapText(string8, 79));
            return 1;
        }
        catch (InitializationException initializationException) {
            int n8 = 10748205;
            String string9 = MessageHandler.getMessage(n8, initializationException.getMessage());
            System.err.println(StaticUtils.wrapText(string9, 79));
            return 1;
        }
        catch (Exception exception) {
            int n9 = 10748205;
            String string10 = MessageHandler.getMessage(n9, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(StaticUtils.wrapText(string10, 79));
            return 1;
        }
        try {
            object4 = new CoreConfigManager();
            ((CoreConfigManager)object4).initializeCoreConfig();
        }
        catch (ConfigException configException) {
            int n10 = 10748206;
            String string11 = MessageHandler.getMessage(n10, configException.getMessage());
            System.err.println(StaticUtils.wrapText(string11, 79));
            return 1;
        }
        catch (InitializationException initializationException) {
            int n11 = 10748206;
            String string12 = MessageHandler.getMessage(n11, initializationException.getMessage());
            System.err.println(StaticUtils.wrapText(string12, 79));
            return 1;
        }
        catch (Exception exception) {
            int n12 = 10748206;
            String string13 = MessageHandler.getMessage(n12, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(StaticUtils.wrapText(string13, 79));
            return 1;
        }
        try {
            directoryServer.initializeCryptoManager();
        }
        catch (ConfigException configException) {
            int n13 = 10748207;
            String string14 = MessageHandler.getMessage(n13, configException.getMessage());
            System.err.println(StaticUtils.wrapText(string14, 79));
            return 1;
        }
        catch (InitializationException initializationException) {
            int n14 = 10748207;
            String string15 = MessageHandler.getMessage(n14, initializationException.getMessage());
            System.err.println(StaticUtils.wrapText(string15, 79));
            return 1;
        }
        catch (Exception exception) {
            int n15 = 10748207;
            String string16 = MessageHandler.getMessage(n15, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(StaticUtils.wrapText(string16, 79));
            return 1;
        }
        object4 = new StartupErrorLogger();
        ((StartupErrorLogger)object4).initializeErrorLogger(null);
        Error.addErrorLogger((ErrorLogger)object4);
        BackupDirectory backupDirectory = null;
        try {
            backupDirectory = BackupDirectory.readBackupDirectoryDescriptor(stringArgument4.getValue());
        }
        catch (Exception exception) {
            int n16 = 10748208;
            String string17 = MessageHandler.getMessage(n16, stringArgument4.getValue(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string17, n16);
            return 1;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss Z");
        if (booleanArgument2.isPresent()) {
            for (BackupInfo backupInfo : backupDirectory.getBackups().values()) {
                int n17 = 10486065;
                String string18 = MessageHandler.getMessage(n17, backupInfo.getBackupID());
                System.out.println(string18);
                n17 = 10486066;
                string18 = MessageHandler.getMessage(n17, simpleDateFormat.format(backupInfo.getBackupDate()));
                System.out.println(string18);
                n17 = 10486067;
                string18 = MessageHandler.getMessage(n17, String.valueOf(backupInfo.isIncremental()));
                System.out.println(string18);
                n17 = 10486068;
                string18 = MessageHandler.getMessage(n17, String.valueOf(backupInfo.isCompressed()));
                System.out.println(string18);
                n17 = 10486069;
                string18 = MessageHandler.getMessage(n17, String.valueOf(backupInfo.isEncrypted()));
                System.out.println(string18);
                byte[] byArray = backupInfo.getUnsignedHash();
                n17 = 10486070;
                string18 = MessageHandler.getMessage(n17, String.valueOf(byArray != null));
                System.out.println(string18);
                byte[] byArray2 = backupInfo.getSignedHash();
                n17 = 10486071;
                string18 = MessageHandler.getMessage(n17, String.valueOf(byArray2 != null));
                System.out.println(string18);
                StringBuilder stringBuilder = new StringBuilder();
                HashSet<String> hashSet = backupInfo.getDependencies();
                if (!hashSet.isEmpty()) {
                    Iterator<String> iterator = hashSet.iterator();
                    stringBuilder.append(iterator.next());
                    while (iterator.hasNext()) {
                        stringBuilder.append(", ");
                        stringBuilder.append(iterator.next());
                    }
                } else {
                    stringBuilder.append("none");
                }
                n17 = 10486072;
                string18 = MessageHandler.getMessage(n17, stringBuilder.toString());
                System.out.println(string18);
                System.out.println();
            }
            return 1;
        }
        String string19 = null;
        if (stringArgument.isPresent()) {
            string19 = stringArgument.getValue();
            object3 = backupDirectory.getBackupInfo(string19);
            if (object3 == null) {
                int n18 = 10748217;
                String string20 = MessageHandler.getMessage(n18, string19, stringArgument4.getValue());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string20, n18);
                return 1;
            }
        } else {
            object3 = backupDirectory.getLatestBackup();
            if (object3 == null) {
                int n19 = 10748218;
                String string21 = MessageHandler.getMessage(n19, stringArgument4.getValue());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string21, n19);
                return 1;
            }
            string19 = ((BackupInfo)object3).getBackupID();
        }
        object3 = backupDirectory.getConfigEntryDN();
        ArrayList<Backend> arrayList = new ArrayList<Backend>();
        ArrayList<ConfigEntry> arrayList2 = new ArrayList<ConfigEntry>();
        ArrayList<List<DN>> arrayList3 = new ArrayList<List<DN>>();
        RestoreDB.getBackends(arrayList, arrayList2, arrayList3);
        Backend backend = null;
        ConfigEntry configEntry = null;
        int n20 = arrayList.size();
        for (n = 0; n < n20; ++n) {
            object2 = arrayList.get(n);
            object = arrayList2.get(n);
            if (!((ConfigEntry)object).getDN().equals(object3)) continue;
            backend = object2;
            configEntry = object;
            break;
        }
        if (backend == null) {
            n = 10748219;
            object2 = MessageHandler.getMessage(n, stringArgument4.getValue(), ((DN)object3).toString());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object2, n);
            return 1;
        }
        if (!backend.supportsRestore()) {
            n = 10748220;
            object2 = MessageHandler.getMessage(n, backend.getBackendID());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object2, n);
            return 1;
        }
        RestoreConfig restoreConfig = new RestoreConfig(backupDirectory, string19, booleanArgument3.isPresent());
        try {
            object2 = LockFileManager.getBackendLockFileName(backend);
            object = new StringBuilder();
            if (!LockFileManager.acquireExclusiveLock((String)object2, (StringBuilder)object)) {
                int n21 = 10748234;
                String string22 = MessageHandler.getMessage(n21, backend.getBackendID(), String.valueOf(object));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string22, n21);
                return 0;
            }
        }
        catch (Exception exception) {
            int n22 = 10748234;
            String string23 = MessageHandler.getMessage(n22, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string23, n22);
            return 0;
        }
        try {
            backend.restoreBackup(configEntry, restoreConfig);
        }
        catch (DirectoryException directoryException) {
            int n23 = 10748221;
            string = MessageHandler.getMessage(n23, string19, backupDirectory.getPath(), directoryException.getErrorMessage());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n23);
        }
        catch (Exception exception) {
            int n24 = 10748221;
            string = MessageHandler.getMessage(n24, string19, backupDirectory.getPath(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n24);
        }
        try {
            object2 = LockFileManager.getBackendLockFileName(backend);
            StringBuilder stringBuilder = new StringBuilder();
            if (!LockFileManager.releaseLock((String)object2, stringBuilder)) {
                int n25 = 10617163;
                String string24 = MessageHandler.getMessage(n25, backend.getBackendID(), String.valueOf(stringBuilder));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, string24, n25);
            }
        }
        catch (Exception exception) {
            int n26 = 10617163;
            string = MessageHandler.getMessage(n26, backend.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, string, n26);
        }
        return 0;
    }

    private static void getBackends(ArrayList<Backend> arrayList, ArrayList<ConfigEntry> arrayList2, ArrayList<List<DN>> arrayList3) {
        String string;
        String string2;
        int n;
        DN dN = null;
        try {
            dN = DN.decode("cn=Backends,cn=config");
        }
        catch (DirectoryException directoryException) {
            n = 10748222;
            string2 = MessageHandler.getMessage(n, "cn=Backends,cn=config", directoryException.getErrorMessage());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string2, n);
            System.exit(1);
        }
        catch (Exception exception) {
            n = 10748222;
            string2 = MessageHandler.getMessage(n, "cn=Backends,cn=config", StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string2, n);
            System.exit(1);
        }
        ConfigEntry configEntry = null;
        try {
            configEntry = DirectoryServer.getConfigEntry(dN);
        }
        catch (ConfigException configException) {
            int n2 = 10748223;
            string = MessageHandler.getMessage(n2, "cn=Backends,cn=config", configException.getMessage());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n2);
            System.exit(1);
        }
        catch (Exception exception) {
            int n3 = 10748223;
            string = MessageHandler.getMessage(n3, "cn=Backends,cn=config", StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n3);
            System.exit(1);
        }
        for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            Object object;
            Object object2;
            List<DN> list;
            Object object3;
            string = null;
            try {
                int n4 = 3146110;
                StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-backend-id", MessageHandler.getMessage(n4), true, false, true);
                object3 = (StringConfigAttribute)configEntry2.getConfigAttribute(stringConfigAttribute);
                if (object3 == null) continue;
                string = ((StringConfigAttribute)object3).activeValue();
            }
            catch (ConfigException configException) {
                int n5 = 10748229;
                object3 = MessageHandler.getMessage(n5, String.valueOf(configEntry2.getDN()), configException.getMessage());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object3, n5);
                System.exit(1);
            }
            catch (Exception exception) {
                int n6 = 10748229;
                object3 = MessageHandler.getMessage(n6, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object3, n6);
                System.exit(1);
            }
            String string3 = null;
            try {
                int n7 = 3145837;
                object3 = new StringConfigAttribute("ds-cfg-backend-class", MessageHandler.getMessage(n7), true, false, false);
                list = (StringConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object3);
                if (list == null) continue;
                string3 = ((StringConfigAttribute)((Object)list)).activeValue();
            }
            catch (ConfigException configException) {
                int n8 = 10748224;
                list = MessageHandler.getMessage(n8, String.valueOf(configEntry2.getDN()), configException.getMessage());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)((Object)list), n8);
                System.exit(1);
            }
            catch (Exception exception) {
                int n9 = 10748224;
                list = MessageHandler.getMessage(n9, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)((Object)list), n9);
                System.exit(1);
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string3);
            }
            catch (Exception exception) {
                int n10 = 10748225;
                String string4 = MessageHandler.getMessage(n10, string3, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string4, n10);
                System.exit(1);
            }
            object3 = null;
            try {
                object3 = (Backend)clazz.newInstance();
                ((Backend)object3).setBackendID(string);
            }
            catch (Exception exception) {
                int n11 = 10748226;
                object2 = MessageHandler.getMessage(n11, string3, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object2, n11);
                System.exit(1);
            }
            list = null;
            try {
                int n12 = 0x300131;
                object2 = new DNConfigAttribute("ds-cfg-backend-base-dn", MessageHandler.getMessage(n12), true, true, true);
                object = (DNConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object2);
                if (object == null) {
                    n12 = 10748227;
                    String string5 = MessageHandler.getMessage(n12, String.valueOf(configEntry2.getDN()));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string5, n12);
                } else {
                    list = ((DNConfigAttribute)object).activeValues();
                }
            }
            catch (Exception exception) {
                int n13 = 10748228;
                object = MessageHandler.getMessage(n13, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object, n13);
                System.exit(1);
            }
            arrayList.add((Backend)object3);
            arrayList2.add(configEntry2);
            arrayList3.add(list);
        }
    }
}

