/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicInteger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Reader;
import org.opends.server.protocols.asn1.ASN1Writer;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPResultCode;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.tools.ClientException;
import org.opends.server.util.Base64;
import org.opends.server.util.PasswordReader;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPAuthenticationHandler
implements PrivilegedExceptionAction<Object>,
CallbackHandler {
    private ASN1OctetString gssapiBindDN;
    private ASN1Reader reader;
    private ASN1Writer writer;
    private AtomicInteger nextMessageID;
    private byte[] iPad;
    private byte[] oPad;
    private char[] gssapiAuthPW;
    private MessageDigest md5Digest;
    private SecureRandom secureRandom;
    private String gssapiAuthID;
    private String gssapiAuthzID;
    private String gssapiQoP;
    private String hostName;
    private String saslMechanism;

    public LDAPAuthenticationHandler(ASN1Reader aSN1Reader, ASN1Writer aSN1Writer, String string, AtomicInteger atomicInteger) {
        this.reader = aSN1Reader;
        this.writer = aSN1Writer;
        this.hostName = string;
        this.nextMessageID = atomicInteger;
        this.md5Digest = null;
        this.secureRandom = null;
        this.iPad = null;
        this.oPad = null;
    }

    public static String[] getSupportedSASLMechanisms() {
        return new String[]{"ANONYMOUS", "CRAM-MD5", "DIGEST-MD5", "EXTERNAL", "GSSAPI", "PLAIN"};
    }

    public static LinkedHashMap<String, String> getSASLProperties(String string) {
        String string2 = StaticUtils.toUpperCase(string);
        if (string2.equals("ANONYMOUS")) {
            return LDAPAuthenticationHandler.getSASLAnonymousProperties();
        }
        if (string2.equals("CRAM-MD5")) {
            return LDAPAuthenticationHandler.getSASLCRAMMD5Properties();
        }
        if (string2.equals("DIGEST-MD5")) {
            return LDAPAuthenticationHandler.getSASLDigestMD5Properties();
        }
        if (string2.equals("EXTERNAL")) {
            return LDAPAuthenticationHandler.getSASLExternalProperties();
        }
        if (string2.equals("GSSAPI")) {
            return LDAPAuthenticationHandler.getSASLGSSAPIProperties();
        }
        if (string2.equals("PLAIN")) {
            return LDAPAuthenticationHandler.getSASLPlainProperties();
        }
        return null;
    }

    public String doSimpleBind(int n, ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, ArrayList<LDAPControl> arrayList, ArrayList<LDAPControl> arrayList2) throws ClientException, LDAPException {
        LDAPMessage lDAPMessage;
        Serializable serializable;
        Object object;
        if (aSN1OctetString2 == null) {
            if (aSN1OctetString == null) {
                aSN1OctetString2 = new ASN1OctetString();
            } else {
                System.out.print(MessageHandler.getMessage(10485959, aSN1OctetString.stringValue()));
                object = PasswordReader.readPassword();
                if (object == null) {
                    aSN1OctetString2 = new ASN1OctetString();
                } else {
                    aSN1OctetString2 = new ASN1OctetString(StaticUtils.getBytes((char[])object));
                    Arrays.fill((char[])object, '\u0000');
                }
            }
        }
        if (aSN1OctetString == null) {
            aSN1OctetString = new ASN1OctetString();
        }
        object = new BindRequestProtocolOp(aSN1OctetString, n, aSN1OctetString2);
        LDAPMessage lDAPMessage2 = new LDAPMessage(this.nextMessageID.getAndIncrement(), (ProtocolOp)object, arrayList);
        try {
            this.writer.writeElement(lDAPMessage2.encode());
        }
        catch (IOException iOException) {
            int n2 = 10748040;
            String string = MessageHandler.getMessage(n2, StaticUtils.stackTraceToSingleLineString(iOException));
            throw new ClientException(81, n2, string, iOException);
        }
        catch (Exception exception) {
            int n3 = 10748040;
            String string = MessageHandler.getMessage(n3, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(83, n3, string, exception);
        }
        try {
            serializable = this.reader.readElement();
            lDAPMessage = LDAPMessage.decode(((ASN1Element)serializable).decodeAsSequence());
        }
        catch (IOException iOException) {
            int n4 = 10748041;
            String string = MessageHandler.getMessage(n4, StaticUtils.stackTraceToSingleLineString(iOException));
            throw new ClientException(81, n4, string, iOException);
        }
        catch (ASN1Exception aSN1Exception) {
            int n5 = 10748041;
            String string = MessageHandler.getMessage(n5, StaticUtils.stackTraceToSingleLineString(aSN1Exception));
            throw new ClientException(84, n5, string, aSN1Exception);
        }
        catch (LDAPException lDAPException) {
            int n6 = 10748041;
            String string = MessageHandler.getMessage(n6, StaticUtils.stackTraceToSingleLineString(lDAPException));
            throw new ClientException(84, n6, string, lDAPException);
        }
        catch (Exception exception) {
            int n7 = 10748041;
            String string = MessageHandler.getMessage(n7, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(82, n7, string, exception);
        }
        serializable = lDAPMessage.getControls();
        if (serializable != null && !((ArrayList)serializable).isEmpty()) {
            arrayList2.addAll((Collection<LDAPControl>)((Object)serializable));
        }
        switch (lDAPMessage.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponseProtocolOp = lDAPMessage.getExtendedResponseProtocolOp();
                String string = extendedResponseProtocolOp.getOID();
                if (string != null && string.equals("1.3.6.1.4.1.1466.20036")) {
                    int n8 = 10748042;
                    String string2 = MessageHandler.getMessage(n8, extendedResponseProtocolOp.getResultCode(), extendedResponseProtocolOp.getErrorMessage());
                    throw new LDAPException(extendedResponseProtocolOp.getResultCode(), n8, string2);
                }
                int n9 = 10748043;
                String string3 = MessageHandler.getMessage(n9, String.valueOf(extendedResponseProtocolOp));
                throw new ClientException(82, n9, string3);
            }
            default: {
                int n10 = 10748044;
                String string = MessageHandler.getMessage(n10, String.valueOf(lDAPMessage.getProtocolOp()));
                throw new ClientException(82, n10, string);
            }
        }
        BindResponseProtocolOp bindResponseProtocolOp = lDAPMessage.getBindResponseProtocolOp();
        int n11 = bindResponseProtocolOp.getResultCode();
        if (n11 == 0) {
            return null;
        }
        int n12 = 10682509;
        String string = MessageHandler.getMessage(n12, n11, LDAPResultCode.toString(n11), bindResponseProtocolOp.getErrorMessage());
        throw new LDAPException(bindResponseProtocolOp.getResultCode(), n12, string);
    }

    public String doSASLBind(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, String string, Map<String, List<String>> map, ArrayList<LDAPControl> arrayList, ArrayList<LDAPControl> arrayList2) throws ClientException, LDAPException {
        if (aSN1OctetString == null) {
            aSN1OctetString = new ASN1OctetString();
        }
        if (string == null || string.length() == 0) {
            int n = 10748046;
            String string2 = MessageHandler.getMessage(n);
            throw new ClientException(89, n, string2);
        }
        this.saslMechanism = StaticUtils.toUpperCase(string);
        if (this.saslMechanism.equals("ANONYMOUS")) {
            return this.doSASLAnonymous(aSN1OctetString, map, arrayList, arrayList2);
        }
        if (this.saslMechanism.equals("CRAM-MD5")) {
            return this.doSASLCRAMMD5(aSN1OctetString, aSN1OctetString2, map, arrayList, arrayList2);
        }
        if (this.saslMechanism.equals("DIGEST-MD5")) {
            return this.doSASLDigestMD5(aSN1OctetString, aSN1OctetString2, map, arrayList, arrayList2);
        }
        if (this.saslMechanism.equals("EXTERNAL")) {
            return this.doSASLExternal(aSN1OctetString, map, arrayList, arrayList2);
        }
        if (this.saslMechanism.equals("GSSAPI")) {
            return this.doSASLGSSAPI(aSN1OctetString, aSN1OctetString2, map, arrayList, arrayList2);
        }
        if (this.saslMechanism.equals("PLAIN")) {
            return this.doSASLPlain(aSN1OctetString, aSN1OctetString2, map, arrayList, arrayList2);
        }
        int n = 10682511;
        String string3 = MessageHandler.getMessage(n, string);
        throw new ClientException(86, n, string3);
    }

    public String doSASLAnonymous(ASN1OctetString aSN1OctetString, Map<String, List<String>> map, ArrayList<LDAPControl> arrayList, ArrayList<LDAPControl> arrayList2) throws ClientException, LDAPException {
        Iterator iOException2;
        String string = null;
        if (map != null && !map.isEmpty()) {
            for (String object2 : map.keySet()) {
                if (object2.equalsIgnoreCase("trace")) {
                    List<String> n = map.get("trace");
                    iOException2 = n.iterator();
                    if (!iOException2.hasNext()) continue;
                    string = (String)iOException2.next();
                    if (!iOException2.hasNext()) continue;
                    int n3 = 10682512;
                    String string3 = MessageHandler.getMessage(n3);
                    throw new ClientException(89, n3, string3);
                }
                int n = 10682513;
                iOException2 = MessageHandler.getMessage(n, object2, "ANONYMOUS");
                throw new ClientException(89, n, (String)((Object)iOException2));
            }
        }
        Object object3 = string == null ? null : new ASN1OctetString(string);
        BindRequestProtocolOp bindRequestProtocolOp = new BindRequestProtocolOp(aSN1OctetString, "ANONYMOUS", (ASN1OctetString)object3);
        n = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequestProtocolOp, arrayList);
        try {
            this.writer.writeElement(((LDAPMessage)((Object)n)).encode());
        }
        catch (IOException exception) {
            int n = 10748050;
            String string4 = MessageHandler.getMessage(n, "ANONYMOUS", StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(81, n, string4, exception);
        }
        catch (Exception exception) {
            int serializable = 10748050;
            String n = MessageHandler.getMessage(serializable, "ANONYMOUS", StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(83, serializable, n, exception);
        }
        try {
            Serializable iOException = this.reader.readElement();
            iOException2 = LDAPMessage.decode(((ASN1Element)iOException).decodeAsSequence());
        }
        catch (IOException aSN1Exception) {
            int n = 10748041;
            String string6 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(aSN1Exception));
            throw new ClientException(81, n, string6, aSN1Exception);
        }
        catch (ASN1Exception lDAPException) {
            int n = 10748041;
            String string7 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(lDAPException));
            throw new ClientException(84, n, string7, lDAPException);
        }
        catch (LDAPException exception) {
            int n = 10748041;
            String string8 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(84, n, string8, exception);
        }
        catch (Exception exception) {
            int extendedResponseProtocolOp = 10748041;
            String string9 = MessageHandler.getMessage(extendedResponseProtocolOp, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(82, extendedResponseProtocolOp, string9, exception);
        }
        iOException = ((LDAPMessage)((Object)iOException2)).getControls();
        if (iOException != null && !((ArrayList)iOException).isEmpty()) {
            arrayList2.addAll((Collection<LDAPControl>)((Object)iOException));
        }
        switch (((LDAPMessage)((Object)iOException2)).getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp bindResponseProtocolOp = ((LDAPMessage)((Object)iOException2)).getExtendedResponseProtocolOp();
                String n = bindResponseProtocolOp.getOID();
                if (n != null && n.equals("1.3.6.1.4.1.1466.20036")) {
                    int n2 = 10748042;
                    String string11 = MessageHandler.getMessage(n2, bindResponseProtocolOp.getResultCode(), bindResponseProtocolOp.getErrorMessage());
                    throw new LDAPException(bindResponseProtocolOp.getResultCode(), n2, string11);
                }
                int n3 = 10748043;
                String string12 = MessageHandler.getMessage(n3, String.valueOf(bindResponseProtocolOp));
                throw new ClientException(82, n3, string12);
            }
            default: {
                int n2 = 10748044;
                String string13 = MessageHandler.getMessage(n2, String.valueOf(((LDAPMessage)((Object)iOException2)).getProtocolOp()));
                throw new ClientException(82, n2, string13);
            }
        }
        BindResponseProtocolOp bindResponseProtocolOp = ((LDAPMessage)((Object)iOException2)).getBindResponseProtocolOp();
        int n = bindResponseProtocolOp.getResultCode();
        if (n == 0) {
            return null;
        }
        int n4 = 10682515;
        String string2 = MessageHandler.getMessage(n4, "ANONYMOUS", n, LDAPResultCode.toString(n), bindResponseProtocolOp.getErrorMessage());
        throw new LDAPException(bindResponseProtocolOp.getResultCode(), n4, string2);
    }

    public static LinkedHashMap<String, String> getSASLAnonymousProperties() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(1);
        linkedHashMap.put("trace", MessageHandler.getMessage(0xA000B0));
        return linkedHashMap;
    }

    public String doSASLCRAMMD5(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, Map<String, List<String>> map, ArrayList<LDAPControl> arrayList, ArrayList<LDAPControl> arrayList2) throws ClientException, LDAPException {
        LDAPMessage lDAPMessage;
        Serializable lDAPException;
        Iterator<String> iOException;
        List<String> exception;
        Object object;
        String string = null;
        if (map == null || map.isEmpty()) {
            int n = 10682516;
            String string2 = MessageHandler.getMessage(n, "CRAM-MD5");
            throw new ClientException(89, n, string2);
        }
        for (String object22 : map.keySet()) {
            object = StaticUtils.toLowerCase(object22);
            if (((String)object).equals("authid")) {
                exception = map.get("authid");
                iOException = exception.iterator();
                if (!iOException.hasNext()) continue;
                string = iOException.next();
                if (!iOException.hasNext()) continue;
                int n = 10682517;
                String string8 = MessageHandler.getMessage(n);
                throw new ClientException(89, n, string8);
            }
            int n = 10682513;
            iOException = MessageHandler.getMessage(n, object22, "CRAM-MD5");
            throw new ClientException(89, n, (String)((Object)iOException));
        }
        if (string == null || string.length() == 0) {
            int n = 10682518;
            object = MessageHandler.getMessage(n, "CRAM-MD5");
            throw new ClientException(89, n, (String)object);
        }
        if (aSN1OctetString2 == null) {
            System.out.print(MessageHandler.getMessage(10485959, string));
            char[] cArray = PasswordReader.readPassword();
            if (cArray == null) {
                aSN1OctetString2 = new ASN1OctetString();
            } else {
                aSN1OctetString2 = new ASN1OctetString(StaticUtils.getBytes(cArray));
                Arrays.fill(cArray, '\u0000');
            }
        }
        BindRequestProtocolOp bindRequestProtocolOp = new BindRequestProtocolOp(aSN1OctetString, "CRAM-MD5", null);
        object = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequestProtocolOp);
        try {
            this.writer.writeElement(((LDAPMessage)object).encode());
        }
        catch (IOException iOException2) {
            int aSN1Exception = 10682519;
            String n = MessageHandler.getMessage(aSN1Exception, "CRAM-MD5", StaticUtils.stackTraceToSingleLineString(iOException2));
            throw new ClientException(81, aSN1Exception, n, iOException2);
        }
        catch (Exception exception2) {
            int lDAPException2 = 10682519;
            String n = MessageHandler.getMessage(lDAPException2, "CRAM-MD5", StaticUtils.stackTraceToSingleLineString(exception2));
            throw new ClientException(83, lDAPException2, n, exception2);
        }
        try {
            iOException = this.reader.readElement();
            exception = LDAPMessage.decode(((ASN1Element)((Object)iOException)).decodeAsSequence());
        }
        catch (IOException exception3) {
            int n = 10682520;
            String string9 = MessageHandler.getMessage(n, "CRAM-MD5", StaticUtils.stackTraceToSingleLineString(exception3));
            throw new ClientException(81, n, string9, exception3);
        }
        catch (ASN1Exception aSN1Exception) {
            int string10 = 10682520;
            String n = MessageHandler.getMessage(string10, "CRAM-MD5", StaticUtils.stackTraceToSingleLineString(aSN1Exception));
            throw new ClientException(84, string10, n, aSN1Exception);
        }
        catch (LDAPException lDAPException3) {
            int n = 10682520;
            String n15 = MessageHandler.getMessage(n, "CRAM-MD5", StaticUtils.stackTraceToSingleLineString(lDAPException3));
            throw new ClientException(84, n, n15, lDAPException3);
        }
        catch (Exception exception4) {
            int n = 10682520;
            String n16 = MessageHandler.getMessage(n, "CRAM-MD5", StaticUtils.stackTraceToSingleLineString(exception4));
            throw new ClientException(82, n, n16, exception4);
        }
        switch (((LDAPMessage)((Object)exception)).getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                iOException = ((LDAPMessage)((Object)exception)).getExtendedResponseProtocolOp();
                String string2 = ((ExtendedResponseProtocolOp)((Object)iOException)).getOID();
                if (string2 != null && string2.equals("1.3.6.1.4.1.1466.20036")) {
                    int n2 = 10748042;
                    String string14 = MessageHandler.getMessage(n2, ((ExtendedResponseProtocolOp)((Object)iOException)).getResultCode(), ((ExtendedResponseProtocolOp)((Object)iOException)).getErrorMessage());
                    throw new LDAPException(((ExtendedResponseProtocolOp)((Object)iOException)).getResultCode(), n2, string14);
                }
                int aSN1OctetString3 = 10748043;
                String n3 = MessageHandler.getMessage(aSN1OctetString3, String.valueOf(iOException));
                throw new ClientException(82, aSN1OctetString3, n3);
            }
            default: {
                int n = 10748044;
                String stringBuilder = MessageHandler.getMessage(n, String.valueOf(((LDAPMessage)((Object)exception)).getProtocolOp()));
                throw new ClientException(82, n, stringBuilder);
            }
        }
        iOException = ((LDAPMessage)((Object)exception)).getBindResponseProtocolOp();
        int n = ((BindResponseProtocolOp)((Object)iOException)).getResultCode();
        if (n != 14) {
            int n2 = 10682521;
            String string3 = MessageHandler.getMessage(n2, "CRAM-MD5", n, LDAPResultCode.toString(n), ((BindResponseProtocolOp)((Object)iOException)).getErrorMessage());
            throw new LDAPException(n, n2, string3);
        }
        ASN1OctetString aSN1OctetString3 = ((BindResponseProtocolOp)((Object)iOException)).getServerSASLCredentials();
        if (aSN1OctetString3 == null) {
            int n3 = 10682522;
            String string4 = MessageHandler.getMessage(n3);
            throw new LDAPException(2, n3, string4);
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(' ');
        stringBuilder.append(this.generateCRAMMD5Digest(aSN1OctetString2, aSN1OctetString3));
        BindRequestProtocolOp bindRequestProtocolOp2 = new BindRequestProtocolOp(aSN1OctetString, "CRAM-MD5", new ASN1OctetString(stringBuilder.toString()));
        LDAPMessage lDAPMessage2 = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequestProtocolOp2, arrayList);
        try {
            this.writer.writeElement(lDAPMessage2.encode());
        }
        catch (IOException iOException3) {
            int iOException4 = 10682524;
            String n7 = MessageHandler.getMessage(iOException4, "CRAM-MD5", StaticUtils.stackTraceToSingleLineString(iOException3));
            throw new ClientException(81, iOException4, n7, iOException3);
        }
        catch (Exception exception5) {
            int aSN1Exception = 10682524;
            String n8 = MessageHandler.getMessage(aSN1Exception, "CRAM-MD5", StaticUtils.stackTraceToSingleLineString(exception5));
            throw new ClientException(82, aSN1Exception, n8, exception5);
        }
        try {
            lDAPException = this.reader.readElement();
            lDAPMessage = LDAPMessage.decode(((ASN1Element)lDAPException).decodeAsSequence());
        }
        catch (IOException exception6) {
            int n9 = 10682525;
            String string21 = MessageHandler.getMessage(n9, "CRAM-MD5", StaticUtils.stackTraceToSingleLineString(exception6));
            throw new ClientException(81, n9, string21, exception6);
        }
        catch (ASN1Exception aSN1Exception) {
            int extendedResponseProtocolOp = 10682525;
            String string22 = MessageHandler.getMessage(extendedResponseProtocolOp, "CRAM-MD5", StaticUtils.stackTraceToSingleLineString(aSN1Exception));
            throw new ClientException(84, extendedResponseProtocolOp, string22, aSN1Exception);
        }
        catch (LDAPException lDAPException4) {
            int bindResponseProtocolOp = 10682525;
            String n13 = MessageHandler.getMessage(bindResponseProtocolOp, "CRAM-MD5", StaticUtils.stackTraceToSingleLineString(lDAPException4));
            throw new ClientException(84, bindResponseProtocolOp, n13, lDAPException4);
        }
        catch (Exception exception7) {
            int n4 = 10682525;
            String string5 = MessageHandler.getMessage(n4, "CRAM-MD5", StaticUtils.stackTraceToSingleLineString(exception7));
            throw new ClientException(82, n4, string5, exception7);
        }
        lDAPException = lDAPMessage.getControls();
        if (lDAPException != null && !((ArrayList)lDAPException).isEmpty()) {
            arrayList2.addAll((Collection<LDAPControl>)((Object)lDAPException));
        }
        switch (lDAPMessage.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponseProtocolOp = lDAPMessage.getExtendedResponseProtocolOp();
                String string6 = extendedResponseProtocolOp.getOID();
                if (string6 != null && string6.equals("1.3.6.1.4.1.1466.20036")) {
                    int n14 = 10748042;
                    String string26 = MessageHandler.getMessage(n14, extendedResponseProtocolOp.getResultCode(), extendedResponseProtocolOp.getErrorMessage());
                    throw new LDAPException(extendedResponseProtocolOp.getResultCode(), n14, string26);
                }
                int n5 = 10748043;
                String string7 = MessageHandler.getMessage(n5, String.valueOf(extendedResponseProtocolOp));
                throw new ClientException(82, n5, string7);
            }
            default: {
                int n6 = 10748044;
                String string8 = MessageHandler.getMessage(n6, String.valueOf(lDAPMessage.getProtocolOp()));
                throw new ClientException(82, n6, string8);
            }
        }
        BindResponseProtocolOp bindResponseProtocolOp = lDAPMessage.getBindResponseProtocolOp();
        int n7 = bindResponseProtocolOp.getResultCode();
        if (n7 == 0) {
            return null;
        }
        int n8 = 10682515;
        String string9 = MessageHandler.getMessage(n8, "CRAM-MD5", n7, LDAPResultCode.toString(n7), bindResponseProtocolOp.getErrorMessage());
        throw new LDAPException(bindResponseProtocolOp.getResultCode(), n8, string9);
    }

    private String generateCRAMMD5Digest(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2) throws ClientException {
        if (this.md5Digest == null) {
            try {
                this.md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (Exception exception) {
                int n = 10682523;
                String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
                throw new ClientException(82, n, string, exception);
            }
        }
        if (this.iPad == null) {
            this.iPad = new byte[64];
            this.oPad = new byte[64];
            Arrays.fill(this.iPad, (byte)54);
            Arrays.fill(this.oPad, (byte)92);
        }
        byte[] byArray = aSN1OctetString.value();
        byte[] byArray2 = aSN1OctetString2.value();
        if (byArray.length > 64) {
            byArray = this.md5Digest.digest(byArray);
        }
        byte[] byArray3 = new byte[64 + byArray2.length];
        System.arraycopy(this.iPad, 0, byArray3, 0, 64);
        System.arraycopy(byArray2, 0, byArray3, 64, byArray2.length);
        byte[] byArray4 = new byte[80];
        System.arraycopy(this.oPad, 0, byArray4, 0, 64);
        for (int i = 0; i < byArray.length; ++i) {
            int n = i;
            byArray3[n] = (byte)(byArray3[n] ^ byArray[i]);
            int n2 = i;
            byArray4[n2] = (byte)(byArray4[n2] ^ byArray[i]);
        }
        System.arraycopy(this.md5Digest.digest(byArray3), 0, byArray4, 64, 16);
        byte[] byArray5 = this.md5Digest.digest(byArray4);
        StringBuilder stringBuilder = new StringBuilder(2 * byArray5.length);
        for (byte by : byArray5) {
            stringBuilder.append(StaticUtils.byteToLowerHex(by));
        }
        return stringBuilder.toString();
    }

    public static LinkedHashMap<String, String> getSASLCRAMMD5Properties() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(1);
        linkedHashMap.put("authid", MessageHandler.getMessage(10485937));
        return linkedHashMap;
    }

    public String doSASLDigestMD5(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, Map<String, List<String>> map, ArrayList<LDAPControl> arrayList, ArrayList<LDAPControl> arrayList2) throws ClientException, LDAPException {
        byte[] byArray;
        byte[] byArray2;
        LDAPMessage lDAPMessage;
        Serializable lDAPException;
        Object exception;
        Object object;
        String string;
        String string2;
        CharSequence charSequence;
        int n;
        Iterator<String> iOException;
        List<String> exception2;
        Object object2;
        String string3 = null;
        String string4 = null;
        String string5 = "auth";
        String string6 = "ldap/" + this.hostName;
        String string7 = null;
        boolean bl = false;
        if (map == null || map.isEmpty()) {
            int n2 = 10682516;
            String string8 = MessageHandler.getMessage(n2, "DIGEST-MD5");
            throw new ClientException(89, n2, string8);
        }
        for (String object42 : map.keySet()) {
            object2 = StaticUtils.toLowerCase(object42);
            if (((String)object2).equals("authid")) {
                exception2 = map.get("authid");
                iOException = exception2.iterator();
                if (!iOException.hasNext()) continue;
                string3 = iOException.next();
                if (!iOException.hasNext()) continue;
                int n6 = 10682517;
                String string12 = MessageHandler.getMessage(n6);
                throw new ClientException(89, n6, string12);
            }
            if (((String)object2).equals("realm")) {
                exception2 = map.get("realm");
                iOException = exception2.iterator();
                if (!iOException.hasNext()) continue;
                string4 = iOException.next();
                bl = true;
                if (!iOException.hasNext()) continue;
                int n7 = 0xA300A0;
                String string13 = MessageHandler.getMessage(n7);
                throw new ClientException(89, n7, string13);
            }
            if (((String)object2).equals("qop")) {
                exception2 = map.get("qop");
                iOException = exception2.iterator();
                if (!iOException.hasNext()) continue;
                string5 = StaticUtils.toLowerCase(iOException.next());
                if (iOException.hasNext()) {
                    int n8 = 10682529;
                    String string14 = MessageHandler.getMessage(n8);
                    throw new ClientException(89, n8, string14);
                }
                if (string5.equals("auth")) continue;
                if (string5.equals("auth-int") || string5.equals("auth-conf")) {
                    int n9 = 10682530;
                    String string15 = MessageHandler.getMessage(n9, string5);
                    throw new ClientException(89, n9, string15);
                }
                int string16 = 0xA300A3;
                String string18 = MessageHandler.getMessage(string16, string5);
                throw new ClientException(89, string16, string18);
            }
            if (((String)object2).equals("digest-uri")) {
                exception2 = map.get("digest-uri");
                iOException = exception2.iterator();
                if (!iOException.hasNext()) continue;
                string6 = StaticUtils.toLowerCase(iOException.next());
                if (!iOException.hasNext()) continue;
                int string17 = 10682532;
                String string19 = MessageHandler.getMessage(string17);
                throw new ClientException(89, string17, string19);
            }
            if (((String)object2).equals("authzid")) {
                exception2 = map.get("authzid");
                iOException = exception2.iterator();
                if (!iOException.hasNext()) continue;
                string7 = StaticUtils.toLowerCase((String)iOException.next());
                if (!iOException.hasNext()) continue;
                int n14 = 10682527;
                String string20 = MessageHandler.getMessage(n14);
                throw new ClientException(89, n14, string20);
            }
            int n2 = 10682513;
            iOException = MessageHandler.getMessage(n2, object42, "DIGEST-MD5");
            throw new ClientException(89, n2, (String)((Object)iOException));
        }
        if (string3 == null || string3.length() == 0) {
            int n11 = 10682518;
            object2 = MessageHandler.getMessage(n11, "DIGEST-MD5");
            throw new ClientException(89, n11, (String)object2);
        }
        if (aSN1OctetString2 == null) {
            System.out.print(MessageHandler.getMessage(10485959, string3));
            char[] cArray = PasswordReader.readPassword();
            if (cArray == null) {
                aSN1OctetString2 = new ASN1OctetString();
            } else {
                aSN1OctetString2 = new ASN1OctetString(StaticUtils.getBytes(cArray));
                Arrays.fill(cArray, '\u0000');
            }
        }
        BindRequestProtocolOp bindRequestProtocolOp = new BindRequestProtocolOp(aSN1OctetString, "DIGEST-MD5", null);
        object2 = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequestProtocolOp);
        try {
            this.writer.writeElement(((LDAPMessage)object2).encode());
        }
        catch (IOException iOException2) {
            int aSN1Exception = 10682519;
            String n15 = MessageHandler.getMessage(aSN1Exception, "DIGEST-MD5", StaticUtils.stackTraceToSingleLineString(iOException2));
            throw new ClientException(81, aSN1Exception, n15, iOException2);
        }
        catch (Exception exception3) {
            int lDAPException2 = 10682519;
            String n16 = MessageHandler.getMessage(lDAPException2, "DIGEST-MD5", StaticUtils.stackTraceToSingleLineString(exception3));
            throw new ClientException(83, lDAPException2, n16, exception3);
        }
        try {
            iOException = this.reader.readElement();
            exception2 = LDAPMessage.decode(((ASN1Element)((Object)iOException)).decodeAsSequence());
        }
        catch (IOException exception4) {
            int n17 = 10682520;
            String string21 = MessageHandler.getMessage(n17, "DIGEST-MD5", StaticUtils.stackTraceToSingleLineString(exception4));
            throw new ClientException(81, n17, string21, exception4);
        }
        catch (ASN1Exception aSN1Exception) {
            int string22 = 10682520;
            String n18 = MessageHandler.getMessage(string22, "DIGEST-MD5", StaticUtils.stackTraceToSingleLineString(aSN1Exception));
            throw new ClientException(84, string22, n18, aSN1Exception);
        }
        catch (LDAPException lDAPException3) {
            int n21 = 10682520;
            String n19 = MessageHandler.getMessage(n21, "DIGEST-MD5", StaticUtils.stackTraceToSingleLineString(lDAPException3));
            throw new ClientException(84, n21, n19, lDAPException3);
        }
        catch (Exception exception5) {
            int n3 = 10682520;
            String n20 = MessageHandler.getMessage(n3, "DIGEST-MD5", StaticUtils.stackTraceToSingleLineString(exception5));
            throw new ClientException(82, n3, n20, exception5);
        }
        switch (((LDAPMessage)((Object)exception2)).getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                iOException = ((LDAPMessage)((Object)exception2)).getExtendedResponseProtocolOp();
                String string8 = ((ExtendedResponseProtocolOp)((Object)iOException)).getOID();
                if (string8 != null && string8.equals("1.3.6.1.4.1.1466.20036")) {
                    int n22 = 10748042;
                    String string26 = MessageHandler.getMessage(n22, ((ExtendedResponseProtocolOp)((Object)iOException)).getResultCode(), ((ExtendedResponseProtocolOp)((Object)iOException)).getErrorMessage());
                    throw new LDAPException(((ExtendedResponseProtocolOp)((Object)iOException)).getResultCode(), n22, string26);
                }
                int aSN1OctetString3 = 10748043;
                String n23 = MessageHandler.getMessage(aSN1OctetString3, String.valueOf(iOException));
                throw new ClientException(82, aSN1OctetString3, n23);
            }
            default: {
                int n4 = 10748044;
                String string28 = MessageHandler.getMessage(n4, String.valueOf(((LDAPMessage)((Object)exception2)).getProtocolOp()));
                throw new ClientException(82, n4, string28);
            }
        }
        iOException = ((LDAPMessage)((Object)exception2)).getBindResponseProtocolOp();
        int n5 = ((BindResponseProtocolOp)((Object)iOException)).getResultCode();
        if (n5 != 14) {
            int n6 = 10682521;
            String string9 = MessageHandler.getMessage(n6, "DIGEST-MD5", n5, LDAPResultCode.toString(n5), ((BindResponseProtocolOp)((Object)iOException)).getErrorMessage());
            throw new LDAPException(n5, n6, string9);
        }
        ASN1OctetString aSN1OctetString3 = ((BindResponseProtocolOp)((Object)iOException)).getServerSASLCredentials();
        if (aSN1OctetString3 == null) {
            int n7 = 10682533;
            String string10 = MessageHandler.getMessage(n7);
            throw new LDAPException(2, n7, string10);
        }
        String string11 = aSN1OctetString3.stringValue();
        String string12 = StaticUtils.toLowerCase(string11);
        String string13 = null;
        boolean bl2 = false;
        int n8 = 0;
        int n9 = string11.length();
        while (n8 < n9) {
            n = string11.indexOf(61, n8 + 1);
            if (n < 0) {
                int n10 = 10682534;
                charSequence = MessageHandler.getMessage(n10, n8);
                throw new LDAPException(2, n10, (String)charSequence);
            }
            string2 = string12.substring(n8, n);
            charSequence = new StringBuilder();
            n8 = this.readToken(string11, n + 1, n9, (StringBuilder)charSequence);
            string = ((StringBuilder)charSequence).toString();
            if (string2.equals("charset")) {
                if (!string.equalsIgnoreCase("utf-8")) {
                    int n11 = 10682535;
                    object = MessageHandler.getMessage(n11, string);
                    throw new LDAPException(2, n11, (String)object);
                }
                bl2 = true;
                continue;
            }
            if (string2.equals("realm")) {
                if (bl) continue;
                if (string4 == null) {
                    string4 = string;
                    continue;
                }
                string4 = null;
                bl = true;
                continue;
            }
            if (string2.equals("nonce")) {
                string13 = string;
                continue;
            }
            if (!string2.equals("qop")) continue;
            exception = new StringTokenizer(string, ",");
            object = new LinkedList();
            while (((StringTokenizer)exception).hasMoreTokens()) {
                ((LinkedList)object).add(StaticUtils.toLowerCase(((StringTokenizer)exception).nextToken().trim()));
            }
            if (((LinkedList)object).contains(string5)) continue;
            int n12 = 10682536;
            String lDAPMessage2 = MessageHandler.getMessage(n12, string5, string);
            throw new ClientException(89, n12, lDAPMessage2);
        }
        if (string13 == null) {
            n = 10682537;
            string2 = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string2);
        }
        String string14 = this.generateCNonce();
        string2 = "00000001";
        charSequence = bl2 ? "UTF-8" : "ISO-8859-1";
        try {
            string = this.generateDigestMD5Response(string3, string7, aSN1OctetString2.value(), string4, string13, string14, string2, string6, string5, (String)charSequence);
        }
        catch (ClientException clientException) {
            throw clientException;
        }
        catch (Exception exception6) {
            int n13 = 0xA300AA;
            String string15 = MessageHandler.getMessage(n13, StaticUtils.stackTraceToSingleLineString(exception6));
            throw new ClientException(82, n13, string15, exception6);
        }
        exception = new StringBuilder();
        ((StringBuilder)exception).append("username=\"");
        ((StringBuilder)exception).append(string3);
        ((StringBuilder)exception).append("\"");
        if (string4 != null) {
            ((StringBuilder)exception).append(",realm=\"");
            ((StringBuilder)exception).append(string4);
            ((StringBuilder)exception).append("\"");
        }
        ((StringBuilder)exception).append(",nonce=\"");
        ((StringBuilder)exception).append(string13);
        ((StringBuilder)exception).append("\",cnonce=\"");
        ((StringBuilder)exception).append(string14);
        ((StringBuilder)exception).append("\",nc=");
        ((StringBuilder)exception).append(string2);
        ((StringBuilder)exception).append(",qop=");
        ((StringBuilder)exception).append(string5);
        ((StringBuilder)exception).append(",digest-uri=\"");
        ((StringBuilder)exception).append(string6);
        ((StringBuilder)exception).append("\",response=");
        ((StringBuilder)exception).append(string);
        if (bl2) {
            ((StringBuilder)exception).append(",charset=utf-8");
        }
        if (string7 != null) {
            ((StringBuilder)exception).append(",authzid=\"");
            ((StringBuilder)exception).append(string7);
            ((StringBuilder)exception).append("\"");
        }
        object = new BindRequestProtocolOp(aSN1OctetString, "DIGEST-MD5", new ASN1OctetString(((StringBuilder)exception).toString()));
        LDAPMessage lDAPMessage3 = new LDAPMessage(this.nextMessageID.getAndIncrement(), (ProtocolOp)object, arrayList);
        try {
            this.writer.writeElement(lDAPMessage3.encode());
        }
        catch (IOException iOException3) {
            int iOException4 = 10682524;
            String n33 = MessageHandler.getMessage(iOException4, "DIGEST-MD5", StaticUtils.stackTraceToSingleLineString(iOException3));
            throw new ClientException(81, iOException4, n33, iOException3);
        }
        catch (Exception exception7) {
            int aSN1Exception = 10682524;
            String n34 = MessageHandler.getMessage(aSN1Exception, "DIGEST-MD5", StaticUtils.stackTraceToSingleLineString(exception7));
            throw new ClientException(83, aSN1Exception, n34, exception7);
        }
        try {
            lDAPException = this.reader.readElement();
            lDAPMessage = LDAPMessage.decode(((ASN1Element)lDAPException).decodeAsSequence());
        }
        catch (IOException exception22) {
            int n35 = 10682525;
            String string39 = MessageHandler.getMessage(n35, "DIGEST-MD5", StaticUtils.stackTraceToSingleLineString(exception22));
            throw new ClientException(81, n35, string39, exception22);
        }
        catch (ASN1Exception aSN1Exception) {
            int extendedResponseProtocolOp = 10682525;
            String string40 = MessageHandler.getMessage(extendedResponseProtocolOp, "DIGEST-MD5", StaticUtils.stackTraceToSingleLineString(aSN1Exception));
            throw new ClientException(84, extendedResponseProtocolOp, string40, aSN1Exception);
        }
        catch (LDAPException lDAPException4) {
            int bindResponseProtocolOp = 10682525;
            String n39 = MessageHandler.getMessage(bindResponseProtocolOp, "DIGEST-MD5", StaticUtils.stackTraceToSingleLineString(lDAPException4));
            throw new ClientException(84, bindResponseProtocolOp, n39, lDAPException4);
        }
        catch (Exception exception8) {
            int n14 = 10682525;
            String string16 = MessageHandler.getMessage(n14, "DIGEST-MD5", StaticUtils.stackTraceToSingleLineString(exception8));
            throw new ClientException(82, n14, string16, exception8);
        }
        lDAPException = lDAPMessage.getControls();
        if (lDAPException != null && !((ArrayList)lDAPException).isEmpty()) {
            arrayList2.addAll((Collection<LDAPControl>)((Object)lDAPException));
        }
        switch (lDAPMessage.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponseProtocolOp = lDAPMessage.getExtendedResponseProtocolOp();
                String string17 = extendedResponseProtocolOp.getOID();
                if (string17 != null && string17.equals("1.3.6.1.4.1.1466.20036")) {
                    int n40 = 10748042;
                    String string44 = MessageHandler.getMessage(n40, extendedResponseProtocolOp.getResultCode(), extendedResponseProtocolOp.getErrorMessage());
                    throw new LDAPException(extendedResponseProtocolOp.getResultCode(), n40, string44);
                }
                int aSN1OctetString4 = 10748043;
                String n41 = MessageHandler.getMessage(aSN1OctetString4, String.valueOf(extendedResponseProtocolOp));
                throw new ClientException(82, aSN1OctetString4, n41);
            }
            default: {
                int n15 = 10748044;
                String string46 = MessageHandler.getMessage(n15, String.valueOf(lDAPMessage.getProtocolOp()));
                throw new ClientException(82, n15, string46);
            }
        }
        BindResponseProtocolOp bindResponseProtocolOp = lDAPMessage.getBindResponseProtocolOp();
        int n16 = bindResponseProtocolOp.getResultCode();
        if (n16 != 0) {
            int n17 = 10682515;
            String string18 = MessageHandler.getMessage(n17, "DIGEST-MD5", n16, LDAPResultCode.toString(n16), bindResponseProtocolOp.getErrorMessage());
            throw new LDAPException(bindResponseProtocolOp.getResultCode(), n17, string18);
        }
        ASN1OctetString aSN1OctetString4 = bindResponseProtocolOp.getServerSASLCredentials();
        if (aSN1OctetString4 == null) {
            int n18 = 10682539;
            String string19 = MessageHandler.getMessage(n18);
            throw new LDAPException(2, n18, string19);
        }
        String string20 = StaticUtils.toLowerCase(aSN1OctetString4.stringValue());
        if (!string20.startsWith("rspauth=")) {
            int n19 = 10682539;
            String string21 = MessageHandler.getMessage(n19);
            throw new LDAPException(2, n19, string21);
        }
        try {
            byArray2 = StaticUtils.hexStringToByteArray(string20.substring(8));
        }
        catch (Exception exception9) {
            int n20 = 10682540;
            String string22 = MessageHandler.getMessage(n20, StaticUtils.stackTraceToSingleLineString(exception9));
            throw new LDAPException(2, n20, string22);
        }
        try {
            byArray = this.generateDigestMD5RspAuth(string3, string7, aSN1OctetString2.value(), string4, string13, string14, string2, string6, string5, (String)charSequence);
        }
        catch (Exception exception10) {
            int n21 = 10682541;
            String string23 = MessageHandler.getMessage(n21, StaticUtils.stackTraceToSingleLineString(exception10));
            throw new ClientException(82, n21, string23);
        }
        if (!Arrays.equals(byArray2, byArray)) {
            int n22 = 10682542;
            String string24 = MessageHandler.getMessage(n22);
            throw new ClientException(82, n22, string24);
        }
        return null;
    }

    private int readToken(String string, int n, int n2, StringBuilder stringBuilder) throws LDAPException {
        char c;
        if (n >= n2) {
            return n;
        }
        boolean bl = false;
        boolean bl2 = false;
        int n3 = n;
        if ((c = string.charAt(n3++)) == ',') {
            return n3;
        }
        if (c == '\"') {
            bl2 = true;
        } else if (c == '\\') {
            bl = true;
        } else {
            stringBuilder.append(c);
        }
        while (n3 < n2) {
            c = string.charAt(n3++);
            if (bl) {
                stringBuilder.append(c);
                bl = false;
                continue;
            }
            if (c == ',') {
                if (!bl2) break;
                stringBuilder.append(c);
                continue;
            }
            if (c == '\"') {
                if (bl2) {
                    char c2;
                    if (n3 >= n2 || (c2 = string.charAt(n3++)) == ',') break;
                    int n4 = 10682543;
                    String string2 = MessageHandler.getMessage(n4, n3 - 2);
                    throw new LDAPException(49, n4, string2);
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == '\\') {
                bl = true;
                continue;
            }
            stringBuilder.append(c);
        }
        return n3;
    }

    private String generateCNonce() {
        if (this.secureRandom == null) {
            this.secureRandom = new SecureRandom();
        }
        byte[] byArray = new byte[16];
        this.secureRandom.nextBytes(byArray);
        return Base64.encode(byArray);
    }

    private String generateDigestMD5Response(String string, String string2, byte[] byArray, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws ClientException, UnsupportedEncodingException {
        if (this.md5Digest == null) {
            try {
                this.md5Digest = MessageDigest.getInstance("MD5");
            }
            catch (Exception exception) {
                int n = 10682523;
                String string10 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
                throw new ClientException(82, n, string10, exception);
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(string3 == null ? "" : string3);
        stringBuilder.append(':');
        byte[] byArray2 = stringBuilder.toString().getBytes(string9);
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        byte[] byArray4 = this.md5Digest.digest(byArray3);
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(':');
        stringBuilder2.append(string4);
        stringBuilder2.append(':');
        stringBuilder2.append(string5);
        if (string2 != null) {
            stringBuilder2.append(':');
            stringBuilder2.append(string2);
        }
        byte[] byArray5 = stringBuilder2.toString().getBytes(string9);
        byte[] byArray6 = new byte[byArray4.length + byArray5.length];
        System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
        System.arraycopy(byArray5, 0, byArray6, byArray4.length, byArray5.length);
        byte[] byArray7 = this.md5Digest.digest(byArray6);
        byte[] byArray8 = ("AUTHENTICATE:" + string7).getBytes(string9);
        byte[] byArray9 = this.md5Digest.digest(byArray8);
        String string11 = this.getHexString(byArray7);
        String string12 = this.getHexString(byArray9);
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder3.append(string11);
        stringBuilder3.append(':');
        stringBuilder3.append(string4);
        stringBuilder3.append(':');
        stringBuilder3.append(string6);
        stringBuilder3.append(':');
        stringBuilder3.append(string5);
        stringBuilder3.append(':');
        stringBuilder3.append(string8);
        stringBuilder3.append(':');
        stringBuilder3.append(string12);
        return this.getHexString(this.md5Digest.digest(stringBuilder3.toString().getBytes(string9)));
    }

    public byte[] generateDigestMD5RspAuth(String string, String string2, byte[] byArray, String string3, String string4, String string5, String string6, String string7, String string8, String string9) throws UnsupportedEncodingException {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(string3);
        stringBuilder.append(':');
        byte[] byArray2 = stringBuilder.toString().getBytes(string9);
        byte[] byArray3 = new byte[byArray2.length + byArray.length];
        System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
        System.arraycopy(byArray, 0, byArray3, byArray2.length, byArray.length);
        byte[] byArray4 = this.md5Digest.digest(byArray3);
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append(':');
        stringBuilder2.append(string4);
        stringBuilder2.append(':');
        stringBuilder2.append(string5);
        if (string2 != null) {
            stringBuilder2.append(':');
            stringBuilder2.append(string2);
        }
        byte[] byArray5 = stringBuilder2.toString().getBytes(string9);
        byte[] byArray6 = new byte[byArray4.length + byArray5.length];
        System.arraycopy(byArray4, 0, byArray6, 0, byArray4.length);
        System.arraycopy(byArray5, 0, byArray6, byArray4.length, byArray5.length);
        byte[] byArray7 = this.md5Digest.digest(byArray6);
        String string10 = ":" + string7;
        if (string8.equals("auth-int") || string8.equals("auth-conf")) {
            string10 = string10 + ":00000000000000000000000000000000";
        }
        byte[] byArray8 = string10.getBytes(string9);
        byte[] byArray9 = this.md5Digest.digest(byArray8);
        String string11 = this.getHexString(byArray7);
        String string12 = this.getHexString(byArray9);
        StringBuilder stringBuilder3 = new StringBuilder();
        stringBuilder3.append(string11);
        stringBuilder3.append(':');
        stringBuilder3.append(string4);
        stringBuilder3.append(':');
        stringBuilder3.append(string6);
        stringBuilder3.append(':');
        stringBuilder3.append(string5);
        stringBuilder3.append(':');
        stringBuilder3.append(string8);
        stringBuilder3.append(':');
        stringBuilder3.append(string12);
        return this.md5Digest.digest(stringBuilder3.toString().getBytes(string9));
    }

    private String getHexString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(2 * byArray.length);
        for (byte by : byArray) {
            stringBuilder.append(StaticUtils.byteToLowerHex(by));
        }
        return stringBuilder.toString();
    }

    public static LinkedHashMap<String, String> getSASLDigestMD5Properties() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(5);
        linkedHashMap.put("authid", MessageHandler.getMessage(10485937));
        linkedHashMap.put("realm", MessageHandler.getMessage(10485938));
        linkedHashMap.put("qop", MessageHandler.getMessage(10485939));
        linkedHashMap.put("digest-uri", MessageHandler.getMessage(10485940));
        linkedHashMap.put("authzid", MessageHandler.getMessage(10485941));
        return linkedHashMap;
    }

    public String doSASLExternal(ASN1OctetString aSN1OctetString, Map<String, List<String>> map, ArrayList<LDAPControl> arrayList, ArrayList<LDAPControl> arrayList2) throws ClientException, LDAPException {
        LDAPMessage lDAPMessage;
        Serializable serializable;
        if (map != null && !map.isEmpty()) {
            int n = 10682526;
            String string = MessageHandler.getMessage(n, "EXTERNAL");
            throw new ClientException(89, n, string);
        }
        BindRequestProtocolOp bindRequestProtocolOp = new BindRequestProtocolOp(aSN1OctetString, "EXTERNAL", null);
        LDAPMessage lDAPMessage2 = new LDAPMessage(this.nextMessageID.getAndIncrement(), bindRequestProtocolOp, arrayList);
        try {
            this.writer.writeElement(lDAPMessage2.encode());
        }
        catch (IOException iOException) {
            int n = 10748050;
            String string = MessageHandler.getMessage(n, "EXTERNAL", StaticUtils.stackTraceToSingleLineString(iOException));
            throw new ClientException(81, n, string, iOException);
        }
        catch (Exception exception) {
            int n = 10748050;
            String string = MessageHandler.getMessage(n, "EXTERNAL", StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(83, n, string, exception);
        }
        try {
            serializable = this.reader.readElement();
            lDAPMessage = LDAPMessage.decode(((ASN1Element)serializable).decodeAsSequence());
        }
        catch (IOException iOException) {
            int n = 10748041;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(iOException));
            throw new ClientException(81, n, string, iOException);
        }
        catch (ASN1Exception aSN1Exception) {
            int n = 10748041;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(aSN1Exception));
            throw new ClientException(84, n, string, aSN1Exception);
        }
        catch (LDAPException lDAPException) {
            int n = 10748041;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(lDAPException));
            throw new ClientException(84, n, string, lDAPException);
        }
        catch (Exception exception) {
            int n = 10748041;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(82, n, string, exception);
        }
        serializable = lDAPMessage.getControls();
        if (serializable != null && !((ArrayList)serializable).isEmpty()) {
            arrayList2.addAll((Collection<LDAPControl>)((Object)serializable));
        }
        switch (lDAPMessage.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponseProtocolOp = lDAPMessage.getExtendedResponseProtocolOp();
                String string = extendedResponseProtocolOp.getOID();
                if (string != null && string.equals("1.3.6.1.4.1.1466.20036")) {
                    int n = 10748042;
                    String string2 = MessageHandler.getMessage(n, extendedResponseProtocolOp.getResultCode(), extendedResponseProtocolOp.getErrorMessage());
                    throw new LDAPException(extendedResponseProtocolOp.getResultCode(), n, string2);
                }
                int n = 10748043;
                String string3 = MessageHandler.getMessage(n, String.valueOf(extendedResponseProtocolOp));
                throw new ClientException(82, n, string3);
            }
            default: {
                int n = 10748044;
                String string = MessageHandler.getMessage(n, String.valueOf(lDAPMessage.getProtocolOp()));
                throw new ClientException(82, n, string);
            }
        }
        BindResponseProtocolOp bindResponseProtocolOp = lDAPMessage.getBindResponseProtocolOp();
        int n = bindResponseProtocolOp.getResultCode();
        if (n == 0) {
            return null;
        }
        int n2 = 10682515;
        String string = MessageHandler.getMessage(n2, "EXTERNAL", n, LDAPResultCode.toString(n), bindResponseProtocolOp.getErrorMessage());
        throw new LDAPException(bindResponseProtocolOp.getResultCode(), n2, string);
    }

    public static LinkedHashMap<String, String> getSASLExternalProperties() {
        return new LinkedHashMap<String, String>(0);
    }

    public String doSASLGSSAPI(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, Map<String, List<String>> map, ArrayList<LDAPControl> arrayList, ArrayList<LDAPControl> arrayList2) throws ClientException, LDAPException {
        Iterator<String> iterator;
        List<String> list;
        Object object;
        String string5;
        String string2 = null;
        String string3 = null;
        this.gssapiBindDN = aSN1OctetString;
        this.gssapiAuthID = null;
        this.gssapiAuthzID = null;
        this.gssapiQoP = "auth";
        this.gssapiAuthPW = (char[])(aSN1OctetString2 == null ? null : aSN1OctetString2.stringValue().toCharArray());
        if (map == null || map.isEmpty()) {
            int n = 10682516;
            String string4 = MessageHandler.getMessage(n, "GSSAPI");
            throw new ClientException(89, n, string4);
        }
        for (String string5 : map.keySet()) {
            object = StaticUtils.toLowerCase(string5);
            if (((String)object).equals("authid")) {
                list = map.get("authid");
                iterator = list.iterator();
                if (!iterator.hasNext()) continue;
                this.gssapiAuthID = iterator.next();
                if (!iterator.hasNext()) continue;
                int n = 10682517;
                String string6 = MessageHandler.getMessage(n);
                throw new ClientException(89, n, string6);
            }
            if (((String)object).equals("authzid")) {
                list = map.get("authzid");
                iterator = list.iterator();
                if (!iterator.hasNext()) continue;
                this.gssapiAuthzID = iterator.next();
                if (!iterator.hasNext()) continue;
                int n = 10682527;
                String string7 = MessageHandler.getMessage(n);
                throw new ClientException(89, n, string7);
            }
            if (((String)object).equals("kdc")) {
                list = map.get("kdc");
                iterator = list.iterator();
                if (!iterator.hasNext()) continue;
                string2 = iterator.next();
                if (!iterator.hasNext()) continue;
                int n = 10682552;
                String string8 = MessageHandler.getMessage(n);
                throw new ClientException(89, n, string8);
            }
            if (((String)object).equals("qop")) {
                list = map.get("qop");
                iterator = list.iterator();
                if (!iterator.hasNext()) continue;
                this.gssapiQoP = StaticUtils.toLowerCase(iterator.next());
                if (iterator.hasNext()) {
                    int n = 10682529;
                    String string9 = MessageHandler.getMessage(n);
                    throw new ClientException(89, n, string9);
                }
                if (this.gssapiQoP.equals("auth")) continue;
                if (this.gssapiQoP.equals("auth-int") || this.gssapiQoP.equals("auth-conf")) {
                    int n = 10682530;
                    String string10 = MessageHandler.getMessage(n, this.gssapiQoP);
                    throw new ClientException(89, n, string10);
                }
                int n = 10682553;
                String string11 = MessageHandler.getMessage(n, this.gssapiQoP);
                throw new ClientException(89, n, string11);
            }
            if (((String)object).equals("realm")) {
                list = map.get("realm");
                iterator = list.iterator();
                if (!iterator.hasNext()) continue;
                string3 = iterator.next();
                if (!iterator.hasNext()) continue;
                int n = 0xA300A0;
                String string12 = MessageHandler.getMessage(n);
                throw new ClientException(89, n, string12);
            }
            int n = 10682513;
            iterator = MessageHandler.getMessage(n, string5, "GSSAPI");
            throw new ClientException(89, n, (String)((Object)iterator));
        }
        if (this.gssapiAuthID == null || this.gssapiAuthID.length() == 0) {
            int n = 10682518;
            object = MessageHandler.getMessage(n, "GSSAPI");
            throw new ClientException(89, n, (String)object);
        }
        if (this.gssapiAuthzID == null) {
            this.gssapiAuthzID = this.gssapiAuthID;
        }
        if (string3 != null) {
            System.setProperty("java.security.krb5.realm", string3);
        }
        if (string2 != null) {
            System.setProperty("java.security.krb5.kdc", string2);
        }
        try {
            object = File.createTempFile("login", "conf");
            string5 = ((File)object).getAbsolutePath();
            ((File)object).deleteOnExit();
            list = new BufferedWriter(new FileWriter((File)object, false));
            ((Writer)((Object)list)).write(this.getClass().getName() + " {");
            ((BufferedWriter)((Object)list)).newLine();
            ((Writer)((Object)list)).write("  com.sun.security.auth.module.Krb5LoginModule required client=TRUE useTicketCache=TRUE;");
            ((BufferedWriter)((Object)list)).newLine();
            ((Writer)((Object)list)).write("};");
            ((BufferedWriter)((Object)list)).newLine();
            ((BufferedWriter)((Object)list)).flush();
            ((BufferedWriter)((Object)list)).close();
        }
        catch (Exception exception) {
            int n = 10748090;
            iterator = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(82, n, (String)((Object)iterator), exception);
        }
        System.setProperty("java.security.auth.login.config", string5);
        System.setProperty("javax.security.auth.useSubjectCredsOnly", "true");
        try {
            object = new LoginContext(this.getClass().getName(), this);
            ((LoginContext)object).login();
        }
        catch (Exception exception) {
            int n = 10682555;
            String string13 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(82, n, string13, exception);
        }
        try {
            Subject.doAs(((LoginContext)object).getSubject(), this);
        }
        catch (Exception exception) {
            if (exception instanceof ClientException) {
                throw (ClientException)exception;
            }
            if (exception instanceof LDAPException) {
                throw (LDAPException)exception;
            }
            int n = 10682556;
            String string14 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(82, n, string14, exception);
        }
        return null;
    }

    public static LinkedHashMap<String, String> getSASLGSSAPIProperties() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(4);
        linkedHashMap.put("authid", MessageHandler.getMessage(10485937));
        linkedHashMap.put("authzid", MessageHandler.getMessage(10485941));
        linkedHashMap.put("kdc", MessageHandler.getMessage(10485943));
        linkedHashMap.put("realm", MessageHandler.getMessage(10485938));
        return linkedHashMap;
    }

    public String doSASLPlain(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, Map<String, List<String>> map, ArrayList<LDAPControl> arrayList, ArrayList<LDAPControl> arrayList2) throws ClientException, LDAPException {
        LDAPMessage lDAPMessage;
        Serializable lDAPException;
        Iterator<String> iterator;
        List<String> list;
        Object object;
        String string = null;
        String string2 = null;
        if (map == null || map.isEmpty()) {
            int n = 10682516;
            String string3 = MessageHandler.getMessage(n, "PLAIN");
            throw new ClientException(89, n, string3);
        }
        for (String object22 : map.keySet()) {
            object = StaticUtils.toLowerCase(object22);
            if (((String)object).equals("authid")) {
                list = map.get("authid");
                iterator = list.iterator();
                if (!iterator.hasNext()) continue;
                string = iterator.next();
                if (!iterator.hasNext()) continue;
                int exception = 10682517;
                String n = MessageHandler.getMessage(exception);
                throw new ClientException(89, exception, n);
            }
            if (((String)object).equals("authzid")) {
                list = map.get("authzid");
                iterator = list.iterator();
                if (!iterator.hasNext()) continue;
                string2 = iterator.next();
                if (!iterator.hasNext()) continue;
                int lDAPMessage2 = 10682527;
                String serializable = MessageHandler.getMessage(lDAPMessage2);
                throw new ClientException(89, lDAPMessage2, serializable);
            }
            int n = 10682513;
            iterator = MessageHandler.getMessage(n, object22, "PLAIN");
            throw new ClientException(89, n, (String)((Object)iterator));
        }
        if (string == null || string.length() == 0) {
            int n = 10682518;
            object = MessageHandler.getMessage(n, "PLAIN");
            throw new ClientException(89, n, (String)object);
        }
        if (aSN1OctetString2 == null) {
            System.out.print(MessageHandler.getMessage(10485959, string));
            char[] cArray = PasswordReader.readPassword();
            if (cArray == null) {
                aSN1OctetString2 = new ASN1OctetString();
            } else {
                aSN1OctetString2 = new ASN1OctetString(StaticUtils.getBytes(cArray));
                Arrays.fill(cArray, '\u0000');
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (string2 != null) {
            stringBuilder.append(string2);
        }
        stringBuilder.append('\u0000');
        stringBuilder.append(string);
        stringBuilder.append('\u0000');
        stringBuilder.append(aSN1OctetString2.stringValue());
        object = new ASN1OctetString(stringBuilder.toString());
        list = new BindRequestProtocolOp(aSN1OctetString, "PLAIN", (ASN1OctetString)object);
        iterator = new LDAPMessage(this.nextMessageID.getAndIncrement(), (ProtocolOp)((Object)list), arrayList);
        try {
            this.writer.writeElement(((LDAPMessage)((Object)iterator)).encode());
        }
        catch (IOException iOException) {
            int iOException2 = 10748050;
            String n = MessageHandler.getMessage(iOException2, "PLAIN", StaticUtils.stackTraceToSingleLineString(iOException));
            throw new ClientException(81, iOException2, n, iOException);
        }
        catch (Exception exception) {
            int aSN1Exception = 10748050;
            String n = MessageHandler.getMessage(aSN1Exception, "PLAIN", StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(83, aSN1Exception, n, exception);
        }
        try {
            lDAPException = this.reader.readElement();
            lDAPMessage = LDAPMessage.decode(((ASN1Element)lDAPException).decodeAsSequence());
        }
        catch (IOException exception) {
            int n = 10748041;
            String string11 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(81, n, string11, exception);
        }
        catch (ASN1Exception aSN1Exception) {
            int extendedResponseProtocolOp = 10748041;
            String string12 = MessageHandler.getMessage(extendedResponseProtocolOp, StaticUtils.stackTraceToSingleLineString(aSN1Exception));
            throw new ClientException(84, extendedResponseProtocolOp, string12, aSN1Exception);
        }
        catch (LDAPException lDAPException2) {
            int bindResponseProtocolOp = 10748041;
            String n = MessageHandler.getMessage(bindResponseProtocolOp, StaticUtils.stackTraceToSingleLineString(lDAPException2));
            throw new ClientException(84, bindResponseProtocolOp, n, lDAPException2);
        }
        catch (Exception exception) {
            int n = 10748041;
            String string3 = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(82, n, string3, exception);
        }
        lDAPException = lDAPMessage.getControls();
        if (lDAPException != null && !((ArrayList)lDAPException).isEmpty()) {
            arrayList2.addAll((Collection<LDAPControl>)((Object)lDAPException));
        }
        switch (lDAPMessage.getProtocolOpType()) {
            case 97: {
                break;
            }
            case 120: {
                ExtendedResponseProtocolOp extendedResponseProtocolOp = lDAPMessage.getExtendedResponseProtocolOp();
                String string4 = extendedResponseProtocolOp.getOID();
                if (string4 != null && string4.equals("1.3.6.1.4.1.1466.20036")) {
                    int n2 = 10748042;
                    String string16 = MessageHandler.getMessage(n2, extendedResponseProtocolOp.getResultCode(), extendedResponseProtocolOp.getErrorMessage());
                    throw new LDAPException(extendedResponseProtocolOp.getResultCode(), n2, string16);
                }
                int n = 10748043;
                String string5 = MessageHandler.getMessage(n, String.valueOf(extendedResponseProtocolOp));
                throw new ClientException(82, n, string5);
            }
            default: {
                int n = 10748044;
                String string6 = MessageHandler.getMessage(n, String.valueOf(lDAPMessage.getProtocolOp()));
                throw new ClientException(82, n, string6);
            }
        }
        BindResponseProtocolOp bindResponseProtocolOp = lDAPMessage.getBindResponseProtocolOp();
        int n = bindResponseProtocolOp.getResultCode();
        if (n == 0) {
            return null;
        }
        int n2 = 10682515;
        String string7 = MessageHandler.getMessage(n2, "PLAIN", n, LDAPResultCode.toString(n), bindResponseProtocolOp.getErrorMessage());
        throw new LDAPException(bindResponseProtocolOp.getResultCode(), n2, string7);
    }

    public static LinkedHashMap<String, String> getSASLPlainProperties() {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>(2);
        linkedHashMap.put("authid", MessageHandler.getMessage(10485937));
        linkedHashMap.put("authzid", MessageHandler.getMessage(10485941));
        return linkedHashMap;
    }

    @Override
    public Object run() throws ClientException, LDAPException {
        block42: {
            if (this.saslMechanism == null) {
                int n = 10748093;
                String string = MessageHandler.getMessage(n, StaticUtils.getBacktrace());
                throw new ClientException(82, n, string);
            }
            if (this.saslMechanism.equals("GSSAPI")) {
                Object object;
                int n;
                LDAPMessage lDAPMessage;
                Object object2;
                ASN1OctetString aSN1OctetString;
                Object object3;
                SaslClient saslClient;
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("javax.security.sasl.qop", this.gssapiQoP);
                hashMap.put("javax.security.sasl.server.authentication", "true");
                try {
                    saslClient = Sasl.createSaslClient(new String[]{"GSSAPI"}, this.gssapiAuthzID, "ldap", this.hostName, hashMap, this);
                }
                catch (Exception exception) {
                    int n2 = 10748095;
                    String string = MessageHandler.getMessage(n2, StaticUtils.stackTraceToSingleLineString(exception));
                    throw new ClientException(82, n2, string, exception);
                }
                if (saslClient.hasInitialResponse()) {
                    try {
                        object3 = saslClient.evaluateChallenge(new byte[0]);
                        aSN1OctetString = new ASN1OctetString((byte[])object3);
                    }
                    catch (Exception exception) {
                        int n3 = 10748096;
                        String string = MessageHandler.getMessage(n3, StaticUtils.stackTraceToSingleLineString(exception));
                        throw new ClientException(82, n3, string, exception);
                    }
                } else {
                    aSN1OctetString = null;
                }
                object3 = new BindRequestProtocolOp(this.gssapiBindDN, "GSSAPI", aSN1OctetString);
                LDAPMessage lDAPMessage2 = new LDAPMessage(this.nextMessageID.getAndIncrement(), (ProtocolOp)object3);
                try {
                    this.writer.writeElement(lDAPMessage2.encode());
                }
                catch (IOException iOException) {
                    int n4 = 10748050;
                    String string = MessageHandler.getMessage(n4, "GSSAPI", StaticUtils.stackTraceToSingleLineString(iOException));
                    throw new ClientException(81, n4, string, iOException);
                }
                catch (Exception exception) {
                    int n5 = 10748050;
                    String string = MessageHandler.getMessage(n5, "GSSAPI", StaticUtils.stackTraceToSingleLineString(exception));
                    throw new ClientException(83, n5, string, exception);
                }
                try {
                    object2 = this.reader.readElement();
                    lDAPMessage = LDAPMessage.decode(((ASN1Element)object2).decodeAsSequence());
                }
                catch (IOException iOException) {
                    int n6 = 10748041;
                    String string = MessageHandler.getMessage(n6, StaticUtils.stackTraceToSingleLineString(iOException));
                    throw new ClientException(81, n6, string, iOException);
                }
                catch (ASN1Exception aSN1Exception) {
                    int n7 = 10748041;
                    String string = MessageHandler.getMessage(n7, StaticUtils.stackTraceToSingleLineString(aSN1Exception));
                    throw new ClientException(84, n7, string, aSN1Exception);
                }
                catch (LDAPException lDAPException) {
                    int n8 = 10748041;
                    String string = MessageHandler.getMessage(n8, StaticUtils.stackTraceToSingleLineString(lDAPException));
                    throw new ClientException(84, n8, string, lDAPException);
                }
                catch (Exception exception) {
                    int n9 = 10748041;
                    String string = MessageHandler.getMessage(n9, StaticUtils.stackTraceToSingleLineString(exception));
                    throw new ClientException(82, n9, string, exception);
                }
                switch (lDAPMessage.getProtocolOpType()) {
                    case 97: {
                        break;
                    }
                    case 120: {
                        object2 = lDAPMessage.getExtendedResponseProtocolOp();
                        String string = ((ExtendedResponseProtocolOp)object2).getOID();
                        if (string != null && string.equals("1.3.6.1.4.1.1466.20036")) {
                            int n10 = 10748042;
                            String string2 = MessageHandler.getMessage(n10, ((ExtendedResponseProtocolOp)object2).getResultCode(), ((ExtendedResponseProtocolOp)object2).getErrorMessage());
                            throw new LDAPException(((ExtendedResponseProtocolOp)object2).getResultCode(), n10, string2);
                        }
                        int n11 = 10748043;
                        String string3 = MessageHandler.getMessage(n11, String.valueOf(object2));
                        throw new ClientException(82, n11, string3);
                    }
                    default: {
                        int n12 = 10748044;
                        String string = MessageHandler.getMessage(n12, String.valueOf(lDAPMessage.getProtocolOp()));
                        throw new ClientException(82, n12, string);
                    }
                }
                while (true) {
                    Object object4;
                    ASN1OctetString aSN1OctetString2;
                    if ((n = ((BindResponseProtocolOp)(object2 = lDAPMessage.getBindResponseProtocolOp())).getResultCode()) == 0) {
                        aSN1OctetString2 = ((BindResponseProtocolOp)object2).getServerSASLCredentials();
                        if (aSN1OctetString2 != null) {
                            try {
                                saslClient.evaluateChallenge(aSN1OctetString2.value());
                            }
                            catch (Exception exception) {
                                int n13 = 10682561;
                                String string = MessageHandler.getMessage(n13, StaticUtils.stackTraceToSingleLineString(exception));
                                throw new ClientException(82, n13, string, exception);
                            }
                        }
                        if (!saslClient.isComplete()) {
                            int n14 = 10682562;
                            object4 = MessageHandler.getMessage(n14);
                            throw new ClientException(82, n14, (String)object4);
                        }
                        break block42;
                    }
                    if (n != 14) break;
                    aSN1OctetString2 = ((BindResponseProtocolOp)object2).getServerSASLCredentials();
                    try {
                        object = aSN1OctetString2 == null ? saslClient.evaluateChallenge(new byte[0]) : saslClient.evaluateChallenge(aSN1OctetString2.value());
                    }
                    catch (Exception exception) {
                        int n15 = 10682561;
                        String string = MessageHandler.getMessage(n15, StaticUtils.stackTraceToSingleLineString(exception));
                        throw new ClientException(82, n15, string, exception);
                    }
                    object3 = new BindRequestProtocolOp(this.gssapiBindDN, "GSSAPI", new ASN1OctetString((byte[])object));
                    lDAPMessage2 = new LDAPMessage(this.nextMessageID.getAndIncrement(), (ProtocolOp)object3);
                    try {
                        this.writer.writeElement(lDAPMessage2.encode());
                    }
                    catch (IOException iOException) {
                        int n16 = 10748050;
                        String string = MessageHandler.getMessage(n16, "GSSAPI", StaticUtils.stackTraceToSingleLineString(iOException));
                        throw new ClientException(81, n16, string, iOException);
                    }
                    catch (Exception exception) {
                        int n17 = 10748050;
                        String string = MessageHandler.getMessage(n17, "GSSAPI", StaticUtils.stackTraceToSingleLineString(exception));
                        throw new ClientException(83, n17, string, exception);
                    }
                    try {
                        object4 = this.reader.readElement();
                        lDAPMessage = LDAPMessage.decode(((ASN1Element)object4).decodeAsSequence());
                    }
                    catch (IOException iOException) {
                        int n18 = 10748041;
                        String string = MessageHandler.getMessage(n18, StaticUtils.stackTraceToSingleLineString(iOException));
                        throw new ClientException(81, n18, string, iOException);
                    }
                    catch (ASN1Exception aSN1Exception) {
                        int n19 = 10748041;
                        String string = MessageHandler.getMessage(n19, StaticUtils.stackTraceToSingleLineString(aSN1Exception));
                        throw new ClientException(84, n19, string, aSN1Exception);
                    }
                    catch (LDAPException lDAPException) {
                        int n20 = 10748041;
                        String string = MessageHandler.getMessage(n20, StaticUtils.stackTraceToSingleLineString(lDAPException));
                        throw new ClientException(84, n20, string, lDAPException);
                    }
                    catch (Exception exception) {
                        int n21 = 10748041;
                        String string = MessageHandler.getMessage(n21, StaticUtils.stackTraceToSingleLineString(exception));
                        throw new ClientException(82, n21, string, exception);
                    }
                    switch (lDAPMessage.getProtocolOpType()) {
                        case 97: {
                            break;
                        }
                        case 120: {
                            object4 = lDAPMessage.getExtendedResponseProtocolOp();
                            String string = ((ExtendedResponseProtocolOp)object4).getOID();
                            if (string != null && string.equals("1.3.6.1.4.1.1466.20036")) {
                                int n22 = 10748042;
                                String string4 = MessageHandler.getMessage(n22, ((ExtendedResponseProtocolOp)object4).getResultCode(), ((ExtendedResponseProtocolOp)object4).getErrorMessage());
                                throw new LDAPException(((ExtendedResponseProtocolOp)object4).getResultCode(), n22, string4);
                            }
                            int n23 = 10748043;
                            String string5 = MessageHandler.getMessage(n23, String.valueOf(object4));
                            throw new ClientException(82, n23, string5);
                        }
                        default: {
                            int n24 = 10748044;
                            String string = MessageHandler.getMessage(n24, String.valueOf(lDAPMessage.getProtocolOp()));
                            throw new ClientException(82, n24, string);
                        }
                    }
                }
                int n25 = 10682563;
                object = MessageHandler.getMessage(n25, n, LDAPResultCode.toString(n), ((BindResponseProtocolOp)object2).getErrorMessage());
                throw new LDAPException(n, n25, (String)object);
            }
            int n = 10748094;
            String string = MessageHandler.getMessage(n, this.saslMechanism, StaticUtils.getBacktrace());
            throw new ClientException(82, n, string);
        }
        return null;
    }

    @Override
    public void handle(Callback[] callbackArray) throws UnsupportedCallbackException {
        if (this.saslMechanism == null) {
            int n = 10748100;
            String string = MessageHandler.getMessage(n, StaticUtils.getBacktrace());
            throw new UnsupportedCallbackException(callbackArray[0], string);
        }
        if (this.saslMechanism.equals("GSSAPI")) {
            for (Callback callback : callbackArray) {
                if (callback instanceof NameCallback) {
                    ((NameCallback)callback).setName(this.gssapiAuthID);
                    continue;
                }
                if (callback instanceof PasswordCallback) {
                    if (this.gssapiAuthPW == null) {
                        System.out.print(MessageHandler.getMessage(10485959, this.gssapiAuthID));
                        this.gssapiAuthPW = PasswordReader.readPassword();
                    }
                    ((PasswordCallback)callback).setPassword(this.gssapiAuthPW);
                    continue;
                }
                int n = 10748101;
                String string = MessageHandler.getMessage(n, String.valueOf(callback));
                throw new UnsupportedCallbackException(callback, string);
            }
        } else {
            int n = 10748102;
            String string = MessageHandler.getMessage(n, this.saslMechanism, StaticUtils.getBacktrace());
            throw new UnsupportedCallbackException(callbackArray[0], string);
        }
    }

    public ASN1OctetString requestAuthorizationIdentity() throws ClientException, LDAPException {
        LDAPMessage lDAPMessage;
        Object object;
        ExtendedRequestProtocolOp extendedRequestProtocolOp = new ExtendedRequestProtocolOp("1.3.6.1.4.1.4203.1.11.3");
        LDAPMessage lDAPMessage2 = new LDAPMessage(this.nextMessageID.getAndIncrement(), extendedRequestProtocolOp);
        try {
            this.writer.writeElement(lDAPMessage2.encode());
        }
        catch (IOException iOException) {
            int n = 10748106;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(iOException));
            throw new ClientException(81, n, string, iOException);
        }
        catch (Exception exception) {
            int n = 10748106;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(83, n, string, exception);
        }
        try {
            object = this.reader.readElement();
            lDAPMessage = LDAPMessage.decode(((ASN1Element)object).decodeAsSequence());
        }
        catch (IOException iOException) {
            int n = 10748107;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(iOException));
            throw new ClientException(81, n, string, iOException);
        }
        catch (ASN1Exception aSN1Exception) {
            int n = 10748107;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(aSN1Exception));
            throw new ClientException(84, n, string, aSN1Exception);
        }
        catch (LDAPException lDAPException) {
            int n = 10748107;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(lDAPException));
            throw new ClientException(84, n, string, lDAPException);
        }
        catch (Exception exception) {
            int n = 10748107;
            String string = MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception));
            throw new ClientException(82, n, string, exception);
        }
        if (lDAPMessage.getProtocolOpType() != 120) {
            int n = 10748044;
            String string = MessageHandler.getMessage(n, String.valueOf(lDAPMessage.getProtocolOp()));
            throw new ClientException(82, n, string);
        }
        object = lDAPMessage.getExtendedResponseProtocolOp();
        String string = ((ExtendedResponseProtocolOp)object).getOID();
        if (string != null && string.equals("1.3.6.1.4.1.1466.20036")) {
            int n = 10748042;
            String string2 = MessageHandler.getMessage(n, ((ExtendedResponseProtocolOp)object).getResultCode(), ((ExtendedResponseProtocolOp)object).getErrorMessage());
            throw new LDAPException(((ExtendedResponseProtocolOp)object).getResultCode(), n, string2);
        }
        int n = ((ExtendedResponseProtocolOp)object).getResultCode();
        if (n != 0) {
            int n2 = 10682572;
            String string3 = MessageHandler.getMessage(n2, n, LDAPResultCode.toString(n), ((ExtendedResponseProtocolOp)object).getErrorMessage());
            throw new LDAPException(n, n2, string3);
        }
        ASN1OctetString aSN1OctetString = ((ExtendedResponseProtocolOp)object).getValue();
        if (aSN1OctetString == null || aSN1OctetString.value() == null || aSN1OctetString.value().length == 0) {
            return null;
        }
        String string4 = aSN1OctetString.stringValue();
        if (string4 == null || string4.length() == 0 || string4.equalsIgnoreCase("dn:")) {
            return null;
        }
        return aSN1OctetString;
    }
}

