/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tools;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.opends.server.api.Backend;
import org.opends.server.api.ErrorLogger;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.CoreConfigManager;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.LockFileManager;
import org.opends.server.extensions.ConfigFileHandler;
import org.opends.server.loggers.Error;
import org.opends.server.loggers.StartupErrorLogger;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.AttributeType;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ExistingFileBehavior;
import org.opends.server.types.InitializationException;
import org.opends.server.types.LDIFExportConfig;
import org.opends.server.types.SearchFilter;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.args.ArgumentException;
import org.opends.server.util.args.ArgumentParser;
import org.opends.server.util.args.BooleanArgument;
import org.opends.server.util.args.IntegerArgument;
import org.opends.server.util.args.StringArgument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExportLDIF {
    public static void main(String[] stringArray) {
        int n = ExportLDIF.mainExportLDIF(stringArray);
        if (n != 0) {
            System.exit(n);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int mainExportLDIF(String[] stringArray) {
        String string;
        String string2;
        void var24_87;
        void var23_79;
        void var35_139;
        DN[] dNArray;
        ArrayList<DN> arrayList;
        void var25_98;
        int n;
        Object object4;
        HashSet<PluginType> hashSet;
        Object object8;
        BooleanArgument booleanArgument = null;
        BooleanArgument booleanArgument2 = null;
        BooleanArgument booleanArgument3 = null;
        BooleanArgument booleanArgument4 = null;
        BooleanArgument booleanArgument5 = null;
        IntegerArgument integerArgument = null;
        StringArgument stringArgument = null;
        StringArgument stringArgument2 = null;
        StringArgument stringArgument3 = null;
        StringArgument stringArgument4 = null;
        StringArgument stringArgument5 = null;
        StringArgument stringArgument6 = null;
        StringArgument stringArgument7 = null;
        StringArgument stringArgument8 = null;
        StringArgument stringArgument9 = null;
        StringArgument stringArgument10 = null;
        String string3 = MessageHandler.getMessage(10486446);
        ArgumentParser argumentParser = new ArgumentParser("org.opends.server.tools.ExportLDIF", string3, false);
        try {
            stringArgument2 = new StringArgument("configclass", Character.valueOf('C'), "configClass", true, false, true, "{configClass}", ConfigFileHandler.class.getName(), null, 10485791, new Object[0]);
            stringArgument2.setHidden(true);
            argumentParser.addArgument(stringArgument2);
            stringArgument3 = new StringArgument("configfile", Character.valueOf('f'), "configFile", true, false, true, "{configFile}", null, null, 0xA00020, new Object[0]);
            stringArgument3.setHidden(true);
            argumentParser.addArgument(stringArgument3);
            stringArgument10 = new StringArgument("ldiffile", Character.valueOf('l'), "ldifFile", true, false, true, "{ldifFile}", null, null, 10485793, new Object[0]);
            argumentParser.addArgument(stringArgument10);
            booleanArgument = new BooleanArgument("appendldif", Character.valueOf('a'), "appendToLDIF", 0xA00022, new Object[0]);
            argumentParser.addArgument(booleanArgument);
            stringArgument = new StringArgument("backendid", Character.valueOf('n'), "backendID", true, false, true, "{backendID}", null, null, 10485795, new Object[0]);
            argumentParser.addArgument(stringArgument);
            stringArgument8 = new StringArgument("includebranch", Character.valueOf('b'), "includeBranch", false, true, true, "{branchDN}", null, null, 0xA000F0, new Object[0]);
            argumentParser.addArgument(stringArgument8);
            stringArgument5 = new StringArgument("excludebranch", Character.valueOf('B'), "excludeBranch", false, true, true, "{branchDN}", null, null, 10485796, new Object[0]);
            argumentParser.addArgument(stringArgument5);
            stringArgument7 = new StringArgument("includeattribute", Character.valueOf('i'), "includeAttribute", false, true, true, "{attribute}", null, null, 10485797, new Object[0]);
            argumentParser.addArgument(stringArgument7);
            stringArgument4 = new StringArgument("excludeattribute", Character.valueOf('e'), "excludeAttribute", false, true, true, "{attribute}", null, null, 10485798, new Object[0]);
            argumentParser.addArgument(stringArgument4);
            stringArgument9 = new StringArgument("includefilter", Character.valueOf('I'), "includeFilter", false, true, true, "{filter}", null, null, 10485799, new Object[0]);
            argumentParser.addArgument(stringArgument9);
            stringArgument6 = new StringArgument("excludefilter", Character.valueOf('E'), "excludeFilter", false, true, true, "{filter}", null, null, 10485800, new Object[0]);
            argumentParser.addArgument(stringArgument6);
            integerArgument = new IntegerArgument("wrapcolumn", Character.valueOf('w'), "wrapColumn", false, false, true, "{wrapColumn}", 0, null, true, 0, false, 0, 10485801, new Object[0]);
            argumentParser.addArgument(integerArgument);
            booleanArgument2 = new BooleanArgument("compressldif", Character.valueOf('c'), "compressLDIF", 0xA0002A, new Object[0]);
            argumentParser.addArgument(booleanArgument2);
            booleanArgument4 = new BooleanArgument("encryptldif", Character.valueOf('y'), "encryptLDIF", 10485803, new Object[0]);
            argumentParser.addArgument(booleanArgument4);
            booleanArgument5 = new BooleanArgument("signhash", Character.valueOf('s'), "signHash", 10485804, new Object[0]);
            argumentParser.addArgument(booleanArgument5);
            booleanArgument3 = new BooleanArgument("help", Character.valueOf('H'), "help", 10485805, new Object[0]);
            argumentParser.addArgument(booleanArgument3);
            argumentParser.setUsageArgument(booleanArgument3);
        }
        catch (ArgumentException argumentException) {
            int n2 = 10747950;
            String string4 = MessageHandler.getMessage(n2, argumentException.getMessage());
            System.err.println(StaticUtils.wrapText(string4, 79));
            return 1;
        }
        try {
            argumentParser.parseArguments(stringArray);
        }
        catch (ArgumentException argumentException) {
            int n3 = 10747951;
            String string5 = MessageHandler.getMessage(n3, argumentException.getMessage());
            System.err.println(StaticUtils.wrapText(string5, 79));
            System.err.println(argumentParser.getUsage());
            return 1;
        }
        if (booleanArgument3.isPresent()) {
            return 0;
        }
        DirectoryServer directoryServer = DirectoryServer.getInstance();
        try {
            directoryServer.bootstrapClient();
            directoryServer.initializeJMX();
        }
        catch (Exception exception) {
            int n4 = 10747952;
            String string6 = MessageHandler.getMessage(n4, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(StaticUtils.wrapText(string6, 79));
            return 1;
        }
        try {
            directoryServer.initializeConfiguration(stringArgument2.getValue(), stringArgument3.getValue());
        }
        catch (InitializationException initializationException) {
            int n5 = 10747953;
            String string7 = MessageHandler.getMessage(n5, initializationException.getMessage());
            System.err.println(StaticUtils.wrapText(string7, 79));
            return 1;
        }
        catch (Exception exception) {
            int n6 = 10747953;
            String string8 = MessageHandler.getMessage(n6, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(StaticUtils.wrapText(string8, 79));
            return 1;
        }
        try {
            directoryServer.initializeSchema();
        }
        catch (ConfigException configException) {
            int n7 = 10747954;
            String string9 = MessageHandler.getMessage(n7, configException.getMessage());
            System.err.println(StaticUtils.wrapText(string9, 79));
            return 1;
        }
        catch (InitializationException initializationException) {
            int n8 = 10747954;
            String string10 = MessageHandler.getMessage(n8, initializationException.getMessage());
            System.err.println(StaticUtils.wrapText(string10, 79));
            return 1;
        }
        catch (Exception exception) {
            int n9 = 10747954;
            String string11 = MessageHandler.getMessage(n9, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(StaticUtils.wrapText(string11, 79));
            return 1;
        }
        try {
            object8 = new CoreConfigManager();
            ((CoreConfigManager)object8).initializeCoreConfig();
        }
        catch (ConfigException configException) {
            int n10 = 10747955;
            String string12 = MessageHandler.getMessage(n10, configException.getMessage());
            System.err.println(StaticUtils.wrapText(string12, 79));
            return 1;
        }
        catch (InitializationException initializationException) {
            int n11 = 10747955;
            String string13 = MessageHandler.getMessage(n11, initializationException.getMessage());
            System.err.println(StaticUtils.wrapText(string13, 79));
            return 1;
        }
        catch (Exception exception) {
            int n12 = 10747955;
            String string14 = MessageHandler.getMessage(n12, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(StaticUtils.wrapText(string14, 79));
            return 1;
        }
        try {
            directoryServer.initializeCryptoManager();
        }
        catch (ConfigException configException) {
            int n13 = 10748188;
            String string15 = MessageHandler.getMessage(n13, configException.getMessage());
            System.err.println(StaticUtils.wrapText(string15, 79));
            return 1;
        }
        catch (InitializationException initializationException) {
            int n14 = 10748188;
            String string16 = MessageHandler.getMessage(n14, initializationException.getMessage());
            System.err.println(StaticUtils.wrapText(string16, 79));
            return 1;
        }
        catch (Exception exception) {
            int n15 = 10748188;
            String string17 = MessageHandler.getMessage(n15, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(StaticUtils.wrapText(string17, 79));
            return 1;
        }
        object8 = new StartupErrorLogger();
        ((StartupErrorLogger)object8).initializeErrorLogger(null);
        Error.addErrorLogger((ErrorLogger)object8);
        try {
            hashSet = new HashSet<PluginType>(1);
            hashSet.add(PluginType.LDIF_EXPORT);
            directoryServer.initializePlugins(hashSet);
        }
        catch (ConfigException configException) {
            int n16 = 10748244;
            String string18 = MessageHandler.getMessage(n16, configException.getMessage());
            System.err.println(StaticUtils.wrapText(string18, 79));
            return 1;
        }
        catch (InitializationException initializationException) {
            int n17 = 10748244;
            String string19 = MessageHandler.getMessage(n17, initializationException.getMessage());
            System.err.println(StaticUtils.wrapText(string19, 79));
            return 1;
        }
        catch (Exception exception) {
            int n18 = 10748244;
            String string20 = MessageHandler.getMessage(n18, StaticUtils.stackTraceToSingleLineString(exception));
            System.err.println(StaticUtils.wrapText(string20, 79));
            return 1;
        }
        if (stringArgument4 == null) {
            hashSet = null;
        } else {
            hashSet = new HashSet();
            for (String object72 : stringArgument4.getValues()) {
                void var25_88;
                String string4 = object72.toLowerCase();
                AttributeType attributeType = DirectoryServer.getAttributeType(string4);
                if (attributeType == null) {
                    AttributeType attributeType2 = DirectoryServer.getDefaultAttributeType(object72);
                }
                hashSet.add((PluginType)var25_88);
            }
        }
        if (stringArgument7 == null) {
            object4 = null;
        } else {
            object4 = new HashSet();
            for (String string5 : stringArgument7.getValues()) {
                void var26_100;
                String string6 = string5.toLowerCase();
                AttributeType attributeType = DirectoryServer.getAttributeType(string6);
                if (attributeType == null) {
                    AttributeType attributeType3 = DirectoryServer.getDefaultAttributeType(string5);
                }
                ((HashSet)object4).add(var26_100);
            }
        }
        if (stringArgument6 == null) {
            Object var23_77 = null;
        } else {
            ArrayList<SearchFilter> arrayList2 = new ArrayList<SearchFilter>();
            for (String string7 : stringArgument6.getValues()) {
                try {
                    arrayList2.add(SearchFilter.createFilterFromString(string7));
                }
                catch (DirectoryException directoryException) {
                    int n2 = 10747956;
                    String string8 = MessageHandler.getMessage(n2, string7, directoryException.getErrorMessage());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string8, n2);
                    return 1;
                }
                catch (Exception exception) {
                    int n3 = 10747956;
                    String string9 = MessageHandler.getMessage(n3, string7, StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string9, n3);
                    return 1;
                }
            }
        }
        if (stringArgument9 == null) {
            Object var24_85 = null;
        } else {
            ArrayList<SearchFilter> arrayList3 = new ArrayList<SearchFilter>();
            for (String string10 : stringArgument9.getValues()) {
                try {
                    arrayList3.add(SearchFilter.createFilterFromString(string10));
                }
                catch (DirectoryException directoryException) {
                    int n4 = 10747957;
                    String string11 = MessageHandler.getMessage(n4, string10, directoryException.getErrorMessage());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string11, n4);
                    return 1;
                }
                catch (Exception exception) {
                    int n5 = 10747957;
                    String string12 = MessageHandler.getMessage(n5, string10, StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string12, n5);
                    return 1;
                }
            }
        }
        Object var25_97 = null;
        Object var26_107 = null;
        List<DN> list = null;
        ArrayList<DN> arrayList4 = null;
        ArrayList<DN> arrayList5 = null;
        ArrayList<Backend> arrayList6 = new ArrayList<Backend>();
        ArrayList<ConfigEntry> arrayList7 = new ArrayList<ConfigEntry>();
        ArrayList<List<DN>> arrayList8 = new ArrayList<List<DN>>();
        ExportLDIF.getBackends(arrayList6, arrayList7, arrayList8);
        int n6 = arrayList6.size();
        for (n = 0; n < n6; ++n) {
            Backend backend = arrayList6.get(n);
            if (!stringArgument.getValue().equals(backend.getBackendID())) continue;
            if (var25_98 == null) {
                Backend backend2 = backend;
                ConfigEntry configEntry = arrayList7.get(n);
                list = arrayList8.get(n);
                arrayList4 = arrayList8.get(n);
                continue;
            }
            int n7 = 10747959;
            String string13 = MessageHandler.getMessage(n7, stringArgument.getValue());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string13, n7);
            return 1;
        }
        if (var25_98 == null) {
            n = 10747960;
            String string14 = MessageHandler.getMessage(n, stringArgument.getValue());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string14, n);
            return 1;
        }
        if (!var25_98.supportsLDIFExport()) {
            n = 10748117;
            String string15 = MessageHandler.getMessage(n, stringArgument.getValue());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string15, n);
            return 1;
        }
        if (stringArgument5.isPresent()) {
            arrayList5 = new ArrayList<DN>();
            for (String string16 : stringArgument5.getValues()) {
                DN dN;
                Object var36_142 = null;
                try {
                    dN = DN.decode(string16);
                }
                catch (DirectoryException directoryException) {
                    int n8 = 10747961;
                    String string17 = MessageHandler.getMessage(n8, string16, directoryException.getErrorMessage());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string17, n8);
                    return 1;
                }
                catch (Exception exception) {
                    int n9 = 10747961;
                    String string18 = MessageHandler.getMessage(n9, string16, StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string18, n9);
                    return 1;
                }
                if (arrayList5.contains(dN)) continue;
                arrayList5.add(dN);
            }
        }
        if (stringArgument8.isPresent()) {
            arrayList = new ArrayList<DN>();
            for (String string19 : stringArgument8.getValues()) {
                dNArray = null;
                try {
                    dNArray = DN.decode(string19);
                }
                catch (DirectoryException directoryException) {
                    int n10 = 10748122;
                    String string20 = MessageHandler.getMessage(n10, string19, directoryException.getErrorMessage());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string20, n10);
                    return 1;
                }
                catch (Exception exception) {
                    int n11 = 10748122;
                    String string21 = MessageHandler.getMessage(n11, string19, StaticUtils.stackTraceToSingleLineString(exception));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string21, n11);
                    return 1;
                }
                if (!Backend.handlesEntry((DN)dNArray, arrayList4, arrayList5)) {
                    int n12 = 10748146;
                    String string22 = MessageHandler.getMessage(n12, string19, stringArgument.getValue());
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string22, n12);
                    return 1;
                }
                arrayList.add((DN)dNArray);
            }
        } else {
            arrayList = arrayList4;
        }
        if (booleanArgument.isPresent()) {
            ExistingFileBehavior existingFileBehavior = ExistingFileBehavior.APPEND;
        } else {
            ExistingFileBehavior existingFileBehavior = ExistingFileBehavior.OVERWRITE;
        }
        LDIFExportConfig lDIFExportConfig = new LDIFExportConfig(stringArgument10.getValue(), (ExistingFileBehavior)var35_139);
        lDIFExportConfig.setCompressData(booleanArgument2.isPresent());
        lDIFExportConfig.setEncryptData(booleanArgument4.isPresent());
        lDIFExportConfig.setExcludeAttributes(hashSet);
        lDIFExportConfig.setExcludeBranches(arrayList5);
        lDIFExportConfig.setExcludeFilters((List<SearchFilter>)var23_79);
        lDIFExportConfig.setIncludeAttributes((Set<AttributeType>)object4);
        lDIFExportConfig.setIncludeBranches(arrayList);
        lDIFExportConfig.setIncludeFilters((List<SearchFilter>)var24_87);
        lDIFExportConfig.setSignHash(booleanArgument5.isPresent());
        lDIFExportConfig.setInvokeExportPlugins(true);
        try {
            lDIFExportConfig.setWrapColumn(integerArgument.getIntValue());
        }
        catch (ArgumentException argumentException) {
            int n13 = 10747962;
            String string23 = MessageHandler.getMessage(n13, integerArgument.getValue());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string23, n13);
            return 1;
        }
        dNArray = new DN[list.size()];
        list.toArray(dNArray);
        try {
            string2 = LockFileManager.getBackendLockFileName((Backend)var25_98);
            StringBuilder stringBuilder = new StringBuilder();
            if (!LockFileManager.acquireSharedLock(string2, stringBuilder)) {
                int n14 = 10748238;
                String string24 = MessageHandler.getMessage(n14, var25_98.getBackendID(), String.valueOf(stringBuilder));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string24, n14);
                return 0;
            }
        }
        catch (Exception exception) {
            int n15 = 10748238;
            String string25 = MessageHandler.getMessage(n15, var25_98.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string25, n15);
            return 0;
        }
        try {
            void var26_108;
            var25_98.exportLDIF((ConfigEntry)var26_108, dNArray, lDIFExportConfig);
        }
        catch (DirectoryException directoryException) {
            int n16 = 10747963;
            string = MessageHandler.getMessage(n16, directoryException.getErrorMessage());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n16);
        }
        catch (Exception exception) {
            int n17 = 10747963;
            string = MessageHandler.getMessage(n17, StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n17);
        }
        try {
            string2 = LockFileManager.getBackendLockFileName((Backend)var25_98);
            StringBuilder stringBuilder = new StringBuilder();
            if (!LockFileManager.releaseLock(string2, stringBuilder)) {
                int n18 = 10617167;
                String string26 = MessageHandler.getMessage(n18, var25_98.getBackendID(), String.valueOf(stringBuilder));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, string26, n18);
            }
        }
        catch (Exception exception) {
            int n19 = 10617167;
            string = MessageHandler.getMessage(n19, var25_98.getBackendID(), StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_WARNING, string, n19);
        }
        lDIFExportConfig.close();
        return 0;
    }

    private static void getBackends(ArrayList<Backend> arrayList, ArrayList<ConfigEntry> arrayList2, ArrayList<List<DN>> arrayList3) {
        String string;
        String string2;
        int n;
        DN dN = null;
        try {
            dN = DN.decode("cn=Backends,cn=config");
        }
        catch (DirectoryException directoryException) {
            n = 10747964;
            string2 = MessageHandler.getMessage(n, "cn=Backends,cn=config", directoryException.getErrorMessage());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string2, n);
            System.exit(1);
        }
        catch (Exception exception) {
            n = 10747964;
            string2 = MessageHandler.getMessage(n, "cn=Backends,cn=config", StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string2, n);
            System.exit(1);
        }
        ConfigEntry configEntry = null;
        try {
            configEntry = DirectoryServer.getConfigEntry(dN);
        }
        catch (ConfigException configException) {
            int n2 = 10747965;
            string = MessageHandler.getMessage(n2, "cn=Backends,cn=config", configException.getMessage());
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n2);
            System.exit(1);
        }
        catch (Exception exception) {
            int n3 = 10747965;
            string = MessageHandler.getMessage(n3, "cn=Backends,cn=config", StaticUtils.stackTraceToSingleLineString(exception));
            Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string, n3);
            System.exit(1);
        }
        for (ConfigEntry configEntry2 : configEntry.getChildren().values()) {
            Object object;
            Object object2;
            List<DN> list;
            Object object3;
            string = null;
            try {
                int n4 = 3146110;
                StringConfigAttribute stringConfigAttribute = new StringConfigAttribute("ds-cfg-backend-id", MessageHandler.getMessage(n4), true, false, true);
                object3 = (StringConfigAttribute)configEntry2.getConfigAttribute(stringConfigAttribute);
                if (object3 == null) continue;
                string = ((StringConfigAttribute)object3).activeValue();
            }
            catch (ConfigException configException) {
                int n5 = 10748143;
                object3 = MessageHandler.getMessage(n5, String.valueOf(configEntry2.getDN()), configException.getMessage());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object3, n5);
                System.exit(1);
            }
            catch (Exception exception) {
                int n6 = 10748143;
                object3 = MessageHandler.getMessage(n6, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object3, n6);
                System.exit(1);
            }
            String string3 = null;
            try {
                int n7 = 3145837;
                object3 = new StringConfigAttribute("ds-cfg-backend-class", MessageHandler.getMessage(n7), true, false, false);
                list = (StringConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object3);
                if (list == null) continue;
                string3 = ((StringConfigAttribute)((Object)list)).activeValue();
            }
            catch (ConfigException configException) {
                int n8 = 10747966;
                list = MessageHandler.getMessage(n8, String.valueOf(configEntry2.getDN()), configException.getMessage());
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)((Object)list), n8);
                System.exit(1);
            }
            catch (Exception exception) {
                int n9 = 10747966;
                list = MessageHandler.getMessage(n9, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)((Object)list), n9);
                System.exit(1);
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(string3);
            }
            catch (Exception exception) {
                int n10 = 10747967;
                String string4 = MessageHandler.getMessage(n10, string3, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string4, n10);
                System.exit(1);
            }
            object3 = null;
            try {
                object3 = (Backend)clazz.newInstance();
                ((Backend)object3).setBackendID(string);
            }
            catch (Exception exception) {
                int n11 = 0xA40040;
                object2 = MessageHandler.getMessage(n11, string3, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object2, n11);
                System.exit(1);
            }
            list = null;
            try {
                int n12 = 0x300131;
                object2 = new DNConfigAttribute("ds-cfg-backend-base-dn", MessageHandler.getMessage(n12), true, true, true);
                object = (DNConfigAttribute)configEntry2.getConfigAttribute((ConfigAttribute)object2);
                if (object == null) {
                    n12 = 10747969;
                    String string5 = MessageHandler.getMessage(n12, String.valueOf(configEntry2.getDN()));
                    Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, string5, n12);
                } else {
                    list = ((DNConfigAttribute)object).activeValues();
                }
            }
            catch (Exception exception) {
                int n13 = 10747970;
                object = MessageHandler.getMessage(n13, String.valueOf(configEntry2.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                Error.logError(ErrorLogCategory.BACKEND, ErrorLogSeverity.SEVERE_ERROR, (String)object, n13);
                System.exit(1);
            }
            arrayList.add((Backend)object3);
            arrayList2.add(configEntry2);
            arrayList3.add(list);
        }
    }
}

