/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.tasks;

import java.util.LinkedHashSet;
import java.util.List;
import org.opends.server.backends.task.Task;
import org.opends.server.backends.task.TaskState;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.tasks.RestartTaskThread;
import org.opends.server.tasks.ShutdownTaskThread;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.util.StaticUtils;

public class ShutdownTask
extends Task {
    private static final String CLASS_NAME = "org.opends.server.tasks.ShutdownTask";
    private boolean restart;
    private String shutdownMessage;

    public void initializeTask() throws DirectoryException {
        String string;
        Attribute attribute;
        LinkedHashSet<AttributeValue> linkedHashSet;
        assert (Debug.debugEnter(CLASS_NAME, "initializeTask", new String[0]));
        Entry entry = this.getTaskEntry();
        this.restart = false;
        this.shutdownMessage = MessageHandler.getMessage(0x100003, String.valueOf(entry.getDN()));
        AttributeType attributeType = DirectoryServer.getAttributeType("ds-task-shutdown-message", true);
        List<Attribute> list = entry.getAttribute(attributeType);
        if (list != null && list.size() > 0 && (linkedHashSet = (attribute = list.get(0)).getValues()) != null && !linkedHashSet.isEmpty()) {
            string = ((AttributeValue)linkedHashSet.iterator().next()).getStringValue();
            this.shutdownMessage = MessageHandler.getMessage(0x100004, String.valueOf(entry.getDN()), String.valueOf(string));
        }
        if ((list = entry.getAttribute(attributeType = DirectoryServer.getAttributeType("ds-task-restart-server", true))) != null && list.size() > 0 && (linkedHashSet = (attribute = list.get(0)).getValues()) != null && !linkedHashSet.isEmpty()) {
            string = StaticUtils.toLowerCase(((AttributeValue)linkedHashSet.iterator().next()).getStringValue());
            this.restart = string.equals("true") || string.equals("yes") || string.equals("on") || string.equals("1");
        }
    }

    public TaskState runTask() {
        assert (Debug.debugEnter(CLASS_NAME, "runTask", new String[0]));
        if (this.restart) {
            RestartTaskThread restartTaskThread = new RestartTaskThread(this.shutdownMessage);
            restartTaskThread.start();
        } else {
            ShutdownTaskThread shutdownTaskThread = new ShutdownTaskThread(this.shutdownMessage);
            shutdownTaskThread.start();
        }
        return TaskState.COMPLETED_SUCCESSFULLY;
    }
}

