/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.zip.DataFormatException;
import org.opends.server.synchronization.SynchronizationDomain;
import org.opends.server.synchronization.SynchronizationMessage;
import org.opends.server.synchronization.UpdateMessage;

public class WindowMessage
extends SynchronizationMessage
implements Serializable {
    private static final long serialVersionUID = 8442267608764026867L;
    private final int numAck;

    public WindowMessage(int n) {
        this.numAck = n;
    }

    public WindowMessage(byte[] byArray) throws DataFormatException {
        try {
            if (byArray[0] != 8) {
                throw new DataFormatException("input is not a valid Window Message");
            }
            int n = 1;
            int n2 = this.getNextLength(byArray, n);
            String string = new String(byArray, n, n2, "UTF-8");
            n += n2 + 1;
            this.numAck = Integer.parseInt(string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    public byte[] getBytes() {
        try {
            byte[] byArray = String.valueOf(this.numAck).getBytes("UTF-8");
            int n = 1 + byArray.length + 1;
            byte[] byArray2 = new byte[n];
            byArray2[0] = 8;
            int n2 = 1;
            n2 = this.addByteArray(byArray, byArray2, n2);
            return byArray2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public int getNumAck() {
        return this.numAck;
    }

    public UpdateMessage processReceive(SynchronizationDomain synchronizationDomain) {
        return null;
    }
}

