/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.opends.server.api.MonitorProvider;
import org.opends.server.config.ConfigEntry;
import org.opends.server.core.DirectoryServer;
import org.opends.server.synchronization.SynchronizationDomain;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizationMonitor
extends MonitorProvider {
    private SynchronizationDomain domain;

    public SynchronizationMonitor(SynchronizationDomain synchronizationDomain) {
        super("Synchronization monitor " + synchronizationDomain.getBaseDN().toString());
        this.domain = synchronizationDomain;
    }

    @Override
    public void initializeMonitorProvider(ConfigEntry configEntry) {
    }

    @Override
    public String getMonitorInstanceName() {
        return "synchronization plugin " + this.domain.getBaseDN().toString();
    }

    public ArrayList<Attribute> getMonitorData() {
        ArrayList<Attribute> arrayList = new ArrayList<Attribute>();
        Attribute attribute = new Attribute("base-dn", this.domain.getBaseDN().toString());
        arrayList.add(attribute);
        attribute = new Attribute("connected-to", this.domain.getChangelogServer());
        arrayList.add(attribute);
        this.addMonitorData(arrayList, "received-updates", this.domain.getNumRcvdUpdates());
        this.addMonitorData(arrayList, "sent-updates", this.domain.getNumSentUpdates());
        this.addMonitorData(arrayList, "pending-updates", this.domain.getPendingUpdatesCount());
        this.addMonitorData(arrayList, "replayed-updates", this.domain.getNumProcessedUpdates());
        this.addMonitorData(arrayList, "replayed-updates-ok", this.domain.getNumReplayedPostOpCalled());
        this.addMonitorData(arrayList, "max-rcv-window", this.domain.getMaxRcvWindow());
        this.addMonitorData(arrayList, "current-rcv-window", this.domain.getCurrentRcvWindow());
        this.addMonitorData(arrayList, "max-send-window", this.domain.getMaxSendWindow());
        this.addMonitorData(arrayList, "current-send-window", this.domain.getCurrentSendWindow());
        AttributeType attributeType = DirectoryServer.getDefaultAttributeType("server-state");
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
        for (String string : this.domain.getServerState().toStringSet()) {
            linkedHashSet.add(new AttributeValue(attributeType, string));
        }
        attribute = new Attribute(attributeType, "server-state", linkedHashSet);
        arrayList.add(attribute);
        return arrayList;
    }

    private void addMonitorData(ArrayList<Attribute> arrayList, String string, int n) {
        AttributeType attributeType = DirectoryServer.getDefaultAttributeType(string);
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>();
        linkedHashSet.add(new AttributeValue(attributeType, String.valueOf(n)));
        Attribute attribute = new Attribute(attributeType, string, linkedHashSet);
        arrayList.add(attribute);
    }

    @Override
    public long getUpdateInterval() {
        return 0L;
    }

    @Override
    public void updateMonitorData() {
    }
}

