/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.zip.DataFormatException;
import org.opends.server.api.ConfigurableComponent;
import org.opends.server.api.DirectoryThread;
import org.opends.server.config.BooleanConfigAttribute;
import org.opends.server.config.ConfigAttribute;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.config.DNConfigAttribute;
import org.opends.server.config.IntegerConfigAttribute;
import org.opends.server.config.StringConfigAttribute;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.Operation;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.synchronization.AckMessage;
import org.opends.server.synchronization.AddContext;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.ChangeNumberGenerator;
import org.opends.server.synchronization.ChangelogBroker;
import org.opends.server.synchronization.DeleteContext;
import org.opends.server.synchronization.Historical;
import org.opends.server.synchronization.ListenerThread;
import org.opends.server.synchronization.ModifyContext;
import org.opends.server.synchronization.ModifyDNMsg;
import org.opends.server.synchronization.ModifyDnContext;
import org.opends.server.synchronization.OperationContext;
import org.opends.server.synchronization.PendingChange;
import org.opends.server.synchronization.ServerState;
import org.opends.server.synchronization.SynchronizationMessage;
import org.opends.server.synchronization.SynchronizationMonitor;
import org.opends.server.synchronization.UpdateMessage;
import org.opends.server.types.ConfigChangeResult;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.RDN;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;
import org.opends.server.types.SynchronizationProviderResult;
import org.opends.server.util.StaticUtils;
import org.opends.server.util.TimeThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronizationDomain
extends DirectoryThread
implements ConfigurableComponent {
    private SynchronizationMonitor monitor;
    private ChangeNumberGenerator changeNumberGenerator;
    private ChangelogBroker broker;
    private List<ListenerThread> synchroThreads = new ArrayList<ListenerThread>();
    private final SortedMap<ChangeNumber, PendingChange> pendingChanges = new TreeMap<ChangeNumber, PendingChange>();
    private SortedMap<ChangeNumber, UpdateMessage> waitingAckMsgs = new TreeMap<ChangeNumber, UpdateMessage>();
    private int numRcvdUpdates = 0;
    private int numSentUpdates = 0;
    private int numProcessedUpdates = 0;
    private int debugCount = 0;
    private ServerState state;
    private int numReplayedPostOpCalled = 0;
    private int maxReceiveQueue = 0;
    private int maxSendQueue = 0;
    private int maxReceiveDelay = 0;
    private int maxSendDelay = 0;
    private short serverId;
    private BooleanConfigAttribute receiveStatusStub;
    private int listenerThreadNumber = 10;
    private boolean receiveStatus = true;
    private List<String> changelogServers;
    private DN baseDN;
    private List<ConfigAttribute> configAttributes = new ArrayList<ConfigAttribute>();
    private boolean shutdown = false;
    private DN configDn;
    private InternalClientConnection conn = new InternalClientConnection();
    static String CHANGELOG_SERVER_ATTR = "ds-cfg-changelog-server";
    static String BASE_DN_ATTR = "ds-cfg-synchronization-dn";
    static String SERVER_ID_ATTR = "ds-cfg-directory-server-id";
    static String RECEIVE_STATUS = "ds-cfg-receive-status";
    static String MAX_RECEIVE_QUEUE = "ds-cfg-max-receive-queue";
    static String MAX_RECEIVE_DELAY = "ds-cfg-max-receive-delay";
    static String MAX_SEND_QUEUE = "ds-cfg-max-send-queue";
    static String MAX_SEND_DELAY = "ds-cfg-max-send-delay";
    static String WINDOW_SIZE = "ds-cfg-window-size";
    private static final StringConfigAttribute changelogStub = new StringConfigAttribute(CHANGELOG_SERVER_ATTR, "changelog server information", true, true, false);
    private static final IntegerConfigAttribute serverIdStub = new IntegerConfigAttribute(SERVER_ID_ATTR, "server ID", true, false, false, true, 0L, true, 65535L);
    private static final DNConfigAttribute baseDnStub = new DNConfigAttribute(BASE_DN_ATTR, "synchronization base DN", true, false, false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SynchronizationDomain(ConfigEntry configEntry) throws ConfigException {
        super("Synchronization flush");
        Integer n;
        IntegerConfigAttribute integerConfigAttribute;
        IntegerConfigAttribute integerConfigAttribute2;
        StringConfigAttribute stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(changelogStub);
        if (stringConfigAttribute == null) {
            throw new ConfigException(16973826, MessageHandler.getMessage(16973826, configEntry.getDN().toString()));
        }
        this.changelogServers = stringConfigAttribute.activeValues();
        this.configAttributes.add(stringConfigAttribute);
        IntegerConfigAttribute integerConfigAttribute3 = (IntegerConfigAttribute)configEntry.getConfigAttribute(serverIdStub);
        if (integerConfigAttribute3 == null) {
            throw new ConfigException(0x1030003, MessageHandler.getMessage(0x1030003, configEntry.getDN().toString()));
        }
        this.serverId = (short)integerConfigAttribute3.activeIntValue();
        this.configAttributes.add(integerConfigAttribute3);
        DNConfigAttribute dNConfigAttribute = (DNConfigAttribute)configEntry.getConfigAttribute(baseDnStub);
        this.baseDN = dNConfigAttribute == null ? null : dNConfigAttribute.activeValue();
        this.configAttributes.add(dNConfigAttribute);
        this.state = new ServerState(this.baseDN);
        this.state.loadState();
        this.receiveStatusStub = new BooleanConfigAttribute(RECEIVE_STATUS, "receive status", false);
        BooleanConfigAttribute booleanConfigAttribute = (BooleanConfigAttribute)configEntry.getConfigAttribute(this.receiveStatusStub);
        if (booleanConfigAttribute != null) {
            this.receiveStatus = booleanConfigAttribute.activeValue();
            this.configAttributes.add(booleanConfigAttribute);
        }
        if ((integerConfigAttribute2 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute = new IntegerConfigAttribute(MAX_RECEIVE_QUEUE, "max receive queue", false, false, false, true, 0L, false, 0L))) == null) {
            this.maxReceiveQueue = 0;
        } else {
            this.maxReceiveQueue = integerConfigAttribute2.activeIntValue();
            this.configAttributes.add(integerConfigAttribute2);
        }
        IntegerConfigAttribute integerConfigAttribute4 = new IntegerConfigAttribute(MAX_RECEIVE_DELAY, "max receive delay", false, false, false, true, 0L, false, 0L);
        IntegerConfigAttribute integerConfigAttribute5 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute4);
        if (integerConfigAttribute5 == null) {
            this.maxReceiveDelay = 0;
        } else {
            this.maxReceiveDelay = integerConfigAttribute5.activeIntValue();
            this.configAttributes.add(integerConfigAttribute5);
        }
        IntegerConfigAttribute integerConfigAttribute6 = new IntegerConfigAttribute(MAX_SEND_QUEUE, "max send queue", false, false, false, true, 0L, false, 0L);
        IntegerConfigAttribute integerConfigAttribute7 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute6);
        if (integerConfigAttribute7 == null) {
            this.maxSendQueue = 0;
        } else {
            this.maxSendQueue = integerConfigAttribute7.activeIntValue();
            this.configAttributes.add(integerConfigAttribute7);
        }
        IntegerConfigAttribute integerConfigAttribute8 = new IntegerConfigAttribute(MAX_SEND_DELAY, "max send delay", false, false, false, true, 0L, false, 0L);
        IntegerConfigAttribute integerConfigAttribute9 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute8);
        if (integerConfigAttribute9 == null) {
            this.maxSendDelay = 0;
        } else {
            this.maxSendDelay = integerConfigAttribute9.activeIntValue();
            this.configAttributes.add(integerConfigAttribute9);
        }
        IntegerConfigAttribute integerConfigAttribute10 = new IntegerConfigAttribute(WINDOW_SIZE, "window size", false, false, false, true, 0L, false, 0L);
        IntegerConfigAttribute integerConfigAttribute11 = (IntegerConfigAttribute)configEntry.getConfigAttribute(integerConfigAttribute10);
        if (integerConfigAttribute11 == null) {
            n = 100;
        } else {
            n = integerConfigAttribute11.activeIntValue();
            this.configAttributes.add(integerConfigAttribute11);
        }
        this.configDn = configEntry.getDN();
        DirectoryServer.registerConfigurableComponent(this);
        this.monitor = new SynchronizationMonitor(this);
        DirectoryServer.registerMonitorProvider(this.monitor);
        long l = TimeThread.getTime();
        this.changeNumberGenerator = new ChangeNumberGenerator(this.serverId, l);
        try {
            ChangelogBroker changelogBroker = this.broker = new ChangelogBroker(this.state, this.baseDN, this.serverId, this.maxReceiveQueue, this.maxReceiveDelay, this.maxSendQueue, this.maxSendDelay, n);
            synchronized (changelogBroker) {
                this.broker.start(this.changelogServers);
                if (!this.receiveStatus) {
                    this.broker.suspendReceive();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public DN getConfigurableComponentEntryDN() {
        return this.configDn;
    }

    @Override
    public List<ConfigAttribute> getConfigurationAttributes() {
        return this.configAttributes;
    }

    @Override
    public boolean hasAcceptableConfiguration(ConfigEntry configEntry, List<String> list) {
        boolean bl = true;
        StringConfigAttribute stringConfigAttribute = null;
        try {
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(changelogStub);
        }
        catch (ConfigException configException) {
            bl = false;
            list.add("Need at least one changelog server.");
        }
        if (stringConfigAttribute == null) {
            bl = false;
            list.add("Need at least one changelog server.");
        }
        return bl;
    }

    @Override
    public ConfigChangeResult applyNewConfiguration(ConfigEntry configEntry, boolean bl) {
        StringConfigAttribute stringConfigAttribute = null;
        try {
            boolean bl2;
            stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(changelogStub);
            List<String> list = stringConfigAttribute.activeValues();
            boolean bl3 = true;
            for (String object : list) {
                if (this.changelogServers.contains(object)) continue;
                bl3 = false;
            }
            for (String string : this.changelogServers) {
                if (list.contains(string)) continue;
                bl3 = false;
            }
            if (!bl3) {
                this.broker.stop();
                this.changelogServers = list;
                this.broker.start(this.changelogServers);
            }
            if ((bl2 = ((BooleanConfigAttribute)configEntry.getConfigAttribute(this.receiveStatusStub)).activeValue()) != this.receiveStatus) {
                if (bl2) {
                    this.broker.restartReceive();
                    for (int i = 0; i < this.listenerThreadNumber; ++i) {
                        ListenerThread listenerThread = new ListenerThread(this);
                        listenerThread.start();
                        this.synchroThreads.add(listenerThread);
                    }
                } else {
                    this.broker.suspendReceive();
                    this.synchroThreads.clear();
                }
                this.receiveStatus = bl2;
            }
        }
        catch (Exception exception) {
            return new ConfigChangeResult(ResultCode.OPERATIONS_ERROR, false);
        }
        return new ConfigChangeResult(ResultCode.SUCCESS, false);
    }

    public DN getBaseDN() {
        return this.baseDN;
    }

    public SynchronizationProviderResult handleConflictResolution(DeleteOperation deleteOperation) {
        DeleteContext deleteContext = (DeleteContext)deleteOperation.getAttachment("synchronizationContext");
        Entry entry = deleteOperation.getEntryToDelete();
        if (deleteContext != null) {
            String string;
            String string2 = deleteContext.getEntryUid();
            if (!string2.equals(string = Historical.getEntryUuid(entry))) {
                deleteOperation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                return new SynchronizationProviderResult(false);
            }
        } else {
            ChangeNumber changeNumber = this.generateChangeNumber(deleteOperation);
            String string = Historical.getEntryUuid(entry);
            deleteContext = new DeleteContext(changeNumber, string);
            deleteOperation.setAttachment("synchronizationContext", deleteContext);
        }
        return new SynchronizationProviderResult(true);
    }

    public SynchronizationProviderResult handleConflictResolution(AddOperation addOperation) {
        AddContext addContext;
        String string;
        if (addOperation.isSynchronizationOperation() && this.findEntryDN(string = (addContext = (AddContext)addOperation.getAttachment("synchronizationContext")).getEntryUid()) != null) {
            addOperation.setResultCode(ResultCode.SUCCESS);
            return new SynchronizationProviderResult(false);
        }
        return new SynchronizationProviderResult(true);
    }

    public SynchronizationProviderResult handleConflictResolution(ModifyDNOperation modifyDNOperation) {
        ModifyDnContext modifyDnContext = (ModifyDnContext)modifyDNOperation.getAttachment("synchronizationContext");
        if (modifyDnContext != null) {
            String string;
            String string2 = Historical.getEntryUuid(modifyDNOperation.getOriginalEntry());
            if (!string2.equals(modifyDnContext.getEntryUid())) {
                modifyDNOperation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                return new SynchronizationProviderResult(false);
            }
            if (modifyDNOperation.getNewSuperior() != null && (string = this.findEntryId(modifyDNOperation.getNewSuperior())) != null && !string.equals(modifyDnContext.getNewParentId())) {
                modifyDNOperation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                return new SynchronizationProviderResult(false);
            }
        } else {
            ChangeNumber changeNumber = this.generateChangeNumber(modifyDNOperation);
            String string = null;
            if (modifyDNOperation.getNewSuperior() != null) {
                string = this.findEntryId(modifyDNOperation.getNewSuperior());
            }
            Entry entry = modifyDNOperation.getOriginalEntry();
            String string3 = Historical.getEntryUuid(entry);
            modifyDnContext = new ModifyDnContext(changeNumber, string3, string);
            modifyDNOperation.setAttachment("synchronizationContext", modifyDnContext);
        }
        return new SynchronizationProviderResult(true);
    }

    public SynchronizationProviderResult handleConflictResolution(ModifyOperation modifyOperation) {
        ModifyContext modifyContext = (ModifyContext)modifyOperation.getAttachment("synchronizationContext");
        Entry entry = modifyOperation.getModifiedEntry();
        if (modifyContext == null) {
            ChangeNumber changeNumber = this.generateChangeNumber(modifyOperation);
            String string = Historical.getEntryUuid(entry);
            modifyContext = new ModifyContext(changeNumber, string);
            modifyOperation.setAttachment("synchronizationContext", modifyContext);
        } else {
            String string = modifyContext.getEntryUid();
            String string2 = Historical.getEntryUuid(entry);
            if (!string2.equals(string)) {
                modifyOperation.setResultCode(ResultCode.NO_SUCH_OBJECT);
                return new SynchronizationProviderResult(false);
            }
            Historical historical = Historical.load(entry);
            modifyOperation.setAttachment("ds-synch-historical", historical);
            historical.replayOperation(modifyOperation, entry);
            if (modifyOperation.getModifications().isEmpty()) {
                modifyOperation.setResultCode(ResultCode.SUCCESS);
                return new SynchronizationProviderResult(false);
            }
        }
        return new SynchronizationProviderResult(true);
    }

    public void doPreOperation(AddOperation addOperation) {
        AddContext addContext = new AddContext(this.generateChangeNumber(addOperation), Historical.getEntryUuid(addOperation), this.findEntryId(addOperation.getEntryDN().getParentDNInSuffix()));
        addOperation.setAttachment("synchronizationContext", addContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpdateMessage receive() {
        ChangelogBroker changelogBroker = this.broker;
        synchronized (changelogBroker) {
            UpdateMessage updateMessage = null;
            while (updateMessage == null) {
                try {
                    SynchronizationMessage synchronizationMessage = this.broker.receive();
                    if (synchronizationMessage == null) {
                        return null;
                    }
                    updateMessage = synchronizationMessage.processReceive(this);
                }
                catch (SocketTimeoutException socketTimeoutException) {}
            }
            return updateMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveUpdate(UpdateMessage updateMessage) {
        ChangeNumber changeNumber = updateMessage.getChangeNumber();
        SortedMap<ChangeNumber, PendingChange> sortedMap = this.pendingChanges;
        synchronized (sortedMap) {
            if (this.pendingChanges.containsKey(changeNumber)) {
                // empty if block
            }
            this.pendingChanges.put(changeNumber, new PendingChange(changeNumber, null, updateMessage));
            ++this.numRcvdUpdates;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveAck(AckMessage ackMessage) {
        UpdateMessage updateMessage;
        ChangeNumber changeNumber = ackMessage.getChangeNumber();
        Object object = this.pendingChanges;
        synchronized (object) {
            updateMessage = (UpdateMessage)this.waitingAckMsgs.get(changeNumber);
            this.waitingAckMsgs.remove(changeNumber);
        }
        if (updateMessage != null) {
            object = updateMessage;
            synchronized (object) {
                updateMessage.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void synchronize(Operation operation) {
        ResultCode resultCode = operation.getResultCode();
        if (resultCode == ResultCode.SUCCESS && operation.isSynchronizationOperation()) {
            ++this.numReplayedPostOpCalled;
        }
        UpdateMessage updateMessage = null;
        ChangeNumber changeNumber = OperationContext.getChangeNumber(operation);
        boolean bl = this.isAssured(operation);
        if (resultCode == ResultCode.SUCCESS && !operation.isSynchronizationOperation() && (updateMessage = UpdateMessage.generateMsg(operation, bl)) == null) {
            SortedMap<ChangeNumber, PendingChange> sortedMap = this.pendingChanges;
            synchronized (sortedMap) {
                this.pendingChanges.remove(changeNumber);
                int n = 16973831;
                String string = MessageHandler.getMessage(n, operation.getOperationType().toString());
                Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                return;
            }
        }
        Object object = this.pendingChanges;
        synchronized (object) {
            if (resultCode == ResultCode.SUCCESS) {
                PendingChange pendingChange = (PendingChange)this.pendingChanges.get(changeNumber);
                if (pendingChange == null) {
                    int n = 16973833;
                    String string = MessageHandler.getMessage(n, changeNumber.toString(), operation.toString());
                    Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                    return;
                }
                pendingChange.setCommitted(true);
                if (operation.isSynchronizationOperation()) {
                    pendingChange.setOp(operation);
                } else {
                    pendingChange.setMsg(updateMessage);
                }
                if (updateMessage != null && bl) {
                    this.waitingAckMsgs.put(changeNumber, updateMessage);
                }
            } else if (!operation.isSynchronizationOperation() && changeNumber != null) {
                this.pendingChanges.remove(changeNumber);
            }
            this.pushCommittedChanges();
        }
        if (updateMessage != null && bl) {
            object = updateMessage;
            synchronized (object) {
                while (this.waitingAckMsgs.containsKey(updateMessage.getChangeNumber())) {
                    try {
                        updateMessage.wait(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    public int getNumRcvdUpdates() {
        return this.numRcvdUpdates;
    }

    public int getNumSentUpdates() {
        return this.numSentUpdates;
    }

    public int getPendingUpdatesCount() {
        return this.pendingChanges.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incProcessedUpdates() {
        SynchronizationDomain synchronizationDomain = this;
        synchronized (synchronizationDomain) {
            ++this.numProcessedUpdates;
        }
    }

    public int getNumProcessedUpdates() {
        return this.numProcessedUpdates;
    }

    public int getNumReplayedPostOpCalled() {
        return this.numReplayedPostOpCalled;
    }

    public ServerState getServerState() {
        return this.state;
    }

    public int getDebugCount() {
        return this.debugCount;
    }

    public void ack(ChangeNumber changeNumber) {
        this.broker.publish(new AckMessage(changeNumber));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        for (int i = 0; i < 10; ++i) {
            ListenerThread listenerThread = new ListenerThread(this);
            listenerThread.start();
            this.synchroThreads.add(listenerThread);
        }
        while (!this.shutdown) {
            try {
                SynchronizationDomain synchronizationDomain = this;
                synchronized (synchronizationDomain) {
                    this.wait(1000L);
                    this.state.save();
                }
            }
            catch (InterruptedException interruptedException) {
            }
        }
        this.state.save();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        for (ListenerThread listenerThread : this.synchroThreads) {
            listenerThread.shutdown();
        }
        this.shutdown = true;
        SynchronizationDomain synchronizationDomain = this;
        synchronized (synchronizationDomain) {
            this.notify();
        }
        this.broker.stop();
    }

    public DN getServerStateDN() {
        return this.state.getServerStateDn();
    }

    public String getChangelogServer() {
        return this.broker.getChangelogServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(UpdateMessage updateMessage) {
        Operation operation = null;
        boolean bl = false;
        ChangeNumber changeNumber = null;
        int n = 10;
        try {
            Object object;
            while (!bl && n-- > 0) {
                operation = updateMessage.createOperation(this.conn);
                operation.setInternalOperation(true);
                operation.setSynchronizationOperation(true);
                changeNumber = OperationContext.getChangeNumber(operation);
                if (changeNumber != null) {
                    this.changeNumberGenerator.adjust(changeNumber);
                }
                operation.run();
                ResultCode resultCode = operation.getResultCode();
                if (resultCode != ResultCode.SUCCESS) {
                    if (operation instanceof ModifyOperation) {
                        object = (ModifyOperation)operation;
                        bl = this.solveNamingConflict((ModifyOperation)object, updateMessage);
                    } else if (operation instanceof DeleteOperation) {
                        object = (DeleteOperation)operation;
                        bl = this.solveNamingConflict((DeleteOperation)object, updateMessage);
                    } else if (operation instanceof AddOperation) {
                        object = (AddOperation)operation;
                        bl = this.solveNamingConflict((AddOperation)object, updateMessage);
                    } else if (operation instanceof ModifyDNOperation) {
                        object = (ModifyDNOperation)operation;
                        bl = this.solveNamingConflict((ModifyDNOperation)object, updateMessage);
                    } else {
                        bl = true;
                    }
                    if (!bl) continue;
                    this.updateError(changeNumber);
                    continue;
                }
                bl = true;
            }
            if (!bl) {
                int n2 = 16973859;
                object = MessageHandler.getMessage(n2, operation.toString());
                Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, (String)object, n2);
                this.updateError(changeNumber);
            }
        }
        catch (ASN1Exception aSN1Exception) {
            int n3 = 17039385;
            String string = MessageHandler.getMessage(n3, updateMessage) + StaticUtils.stackTraceToSingleLineString(aSN1Exception);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n3);
        }
        catch (LDAPException lDAPException) {
            int n4 = 17039385;
            String string = MessageHandler.getMessage(n4, updateMessage) + StaticUtils.stackTraceToSingleLineString(lDAPException);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n4);
        }
        catch (DataFormatException dataFormatException) {
            int n5 = 17039385;
            String string = MessageHandler.getMessage(n5, updateMessage) + StaticUtils.stackTraceToSingleLineString(dataFormatException);
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n5);
        }
        catch (Exception exception) {
            if (changeNumber != null) {
                int n6 = 16973836;
                String string = MessageHandler.getMessage(n6, StaticUtils.stackTraceToSingleLineString(exception), operation.toString());
                Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n6);
                this.updateError(changeNumber);
            } else {
                int n7 = 17039385;
                String string = MessageHandler.getMessage(n7, StaticUtils.stackTraceToSingleLineString(exception), updateMessage.toString());
                Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n7);
            }
        }
        finally {
            if (updateMessage.isAssured()) {
                this.ack(updateMessage.getChangeNumber());
            }
            this.incProcessedUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateError(ChangeNumber changeNumber) {
        SortedMap<ChangeNumber, PendingChange> sortedMap = this.pendingChanges;
        synchronized (sortedMap) {
            this.pendingChanges.remove(changeNumber);
            this.pushCommittedChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChangeNumber generateChangeNumber(Operation operation) {
        ChangeNumber changeNumber;
        SortedMap<ChangeNumber, PendingChange> sortedMap = this.pendingChanges;
        synchronized (sortedMap) {
            changeNumber = this.changeNumberGenerator.NewChangeNumber();
            this.pendingChanges.put(changeNumber, new PendingChange(changeNumber, operation, null));
        }
        return changeNumber;
    }

    private String findEntryId(DN dN) {
        if (dN == null) {
            return null;
        }
        try {
            SearchResultEntry searchResultEntry;
            LinkedList<SearchResultEntry> linkedList;
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(1);
            linkedHashSet.add("entryuuid");
            InternalSearchOperation internalSearchOperation = this.conn.processSearch(dN, SearchScope.BASE_OBJECT, DereferencePolicy.NEVER_DEREF_ALIASES, 0, 0, false, SearchFilter.createFilterFromString("objectclass=*"), linkedHashSet);
            if (internalSearchOperation.getResultCode() == ResultCode.SUCCESS && !(linkedList = internalSearchOperation.getSearchEntries()).isEmpty() && (searchResultEntry = linkedList.getFirst()) != null) {
                return Historical.getEntryUuid(searchResultEntry);
            }
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        return null;
    }

    private DN findEntryDN(String string) {
        try {
            SearchResultEntry searchResultEntry;
            LinkedList<SearchResultEntry> linkedList;
            InternalSearchOperation internalSearchOperation = this.conn.processSearch(this.baseDN, SearchScope.WHOLE_SUBTREE, SearchFilter.createFilterFromString("entryuuid=" + string));
            if (internalSearchOperation.getResultCode() == ResultCode.SUCCESS && !(linkedList = internalSearchOperation.getSearchEntries()).isEmpty() && (searchResultEntry = linkedList.getFirst()) != null) {
                return searchResultEntry.getDN();
            }
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
        return null;
    }

    private boolean solveNamingConflict(ModifyOperation modifyOperation, UpdateMessage updateMessage) {
        ResultCode resultCode = modifyOperation.getResultCode();
        ModifyContext modifyContext = (ModifyContext)modifyOperation.getAttachment("synchronizationContext");
        String string = modifyContext.getEntryUid();
        if (resultCode == ResultCode.NO_SUCH_OBJECT) {
            DN dN = this.findEntryDN(string);
            if (dN != null) {
                updateMessage.setDn(dN.toString());
                return false;
            }
            return true;
        }
        return true;
    }

    private boolean solveNamingConflict(DeleteOperation deleteOperation, UpdateMessage updateMessage) {
        ResultCode resultCode = deleteOperation.getResultCode();
        DeleteContext deleteContext = (DeleteContext)deleteOperation.getAttachment("synchronizationContext");
        String string = deleteContext.getEntryUid();
        if (resultCode == ResultCode.NO_SUCH_OBJECT) {
            DN dN = this.findEntryDN(string);
            if (dN == null) {
                return true;
            }
            updateMessage.setDn(dN.toString());
            return false;
        }
        if (resultCode == ResultCode.NOT_ALLOWED_ON_NONLEAF) {
            // empty if block
        }
        return true;
    }

    private boolean solveNamingConflict(AddOperation addOperation, UpdateMessage updateMessage) throws Exception {
        ResultCode resultCode = addOperation.getResultCode();
        AddContext addContext = (AddContext)addOperation.getAttachment("synchronizationContext");
        String string = addContext.getEntryUid();
        String string2 = addContext.getParentUid();
        if (resultCode == ResultCode.NO_SUCH_OBJECT) {
            if (string2 == null) {
                return true;
            }
            DN dN = this.findEntryDN(string2);
            if (dN == null) {
                return true;
            }
            RDN rDN = DN.decode(updateMessage.getDn()).getRDN();
            updateMessage.setDn(rDN + "," + dN);
            return false;
        }
        if (resultCode == ResultCode.ENTRY_ALREADY_EXISTS) {
            if (this.findEntryDN(string) != null) {
                return true;
            }
            this.addConflict(addOperation);
            updateMessage.setDn(this.generateConflictDn(string, updateMessage.getDn()));
            return false;
        }
        return true;
    }

    private boolean solveNamingConflict(ModifyDNOperation modifyDNOperation, UpdateMessage updateMessage) throws Exception {
        DN dN;
        ResultCode resultCode = modifyDNOperation.getResultCode();
        ModifyDnContext modifyDnContext = (ModifyDnContext)modifyDNOperation.getAttachment("synchronizationContext");
        String string = modifyDnContext.getEntryUid();
        String string2 = modifyDnContext.getNewParentId();
        DN dN2 = modifyDNOperation.getEntryDN();
        DN dN3 = this.findEntryDN(string2);
        RDN rDN = modifyDNOperation.getNewRDN();
        DN dN4 = dN3 == null ? dN2.getParent() : dN3;
        if (dN4 == null || dN4.isNullDN()) {
            throw new Exception("operation parameters are invalid");
        }
        DN dN5 = dN4.concat(rDN);
        if (dN5.equals(dN = this.findEntryDN(string))) {
            return true;
        }
        if (resultCode == ResultCode.NO_SUCH_OBJECT) {
            ModifyDNMsg modifyDNMsg = (ModifyDNMsg)updateMessage;
            updateMessage.setDn(dN.toString());
            modifyDNMsg.setNewSuperior(dN3.toString());
            return false;
        }
        if (resultCode == ResultCode.ENTRY_ALREADY_EXISTS) {
            ModifyDNMsg modifyDNMsg = (ModifyDNMsg)updateMessage;
            this.generateAddConflictOp(modifyDNOperation);
            modifyDNMsg.setNewRDN(this.generateConflictDn(string, modifyDNMsg.getNewRDN()));
            modifyDNMsg.setNewSuperior(dN3.toString());
            return false;
        }
        return true;
    }

    private void generateAddConflictOp(ModifyDNOperation modifyDNOperation) {
    }

    private void addConflict(AddOperation addOperation) {
    }

    private String generateConflictDn(String string, String string2) {
        return "entryuuid=" + string + "+" + string2;
    }

    private boolean isAssured(Operation operation) {
        return false;
    }

    private void pushCommittedChanges() {
        if (this.pendingChanges.isEmpty()) {
            return;
        }
        ChangeNumber changeNumber = this.pendingChanges.firstKey();
        PendingChange pendingChange = (PendingChange)this.pendingChanges.get(changeNumber);
        while (pendingChange != null && pendingChange.isCommitted()) {
            if (!pendingChange.getOp().isSynchronizationOperation()) {
                ++this.numSentUpdates;
                this.broker.publish(pendingChange.getMsg());
            }
            this.state.update(changeNumber);
            this.pendingChanges.remove(changeNumber);
            if (this.pendingChanges.isEmpty()) {
                pendingChange = null;
                continue;
            }
            changeNumber = this.pendingChanges.firstKey();
            pendingChange = (PendingChange)this.pendingChanges.get(changeNumber);
        }
    }

    public static boolean checkConfigEntry(ConfigEntry configEntry, StringBuilder stringBuilder) {
        try {
            StringConfigAttribute stringConfigAttribute = (StringConfigAttribute)configEntry.getConfigAttribute(changelogStub);
            if (stringConfigAttribute == null) {
                stringBuilder.append(MessageHandler.getMessage(16973826, configEntry.getDN().toString()));
                return false;
            }
            IntegerConfigAttribute integerConfigAttribute = (IntegerConfigAttribute)configEntry.getConfigAttribute(serverIdStub);
            if (integerConfigAttribute == null) {
                stringBuilder.append(MessageHandler.getMessage(0x1030003, configEntry.getDN().toString()));
                return false;
            }
        }
        catch (ConfigException configException) {
            stringBuilder.append(configException.getMessage());
            return false;
        }
        return true;
    }

    public int getMaxRcvWindow() {
        return this.broker.getMaxRcvWindow();
    }

    public int getCurrentRcvWindow() {
        return this.broker.getCurrentRcvWindow();
    }

    public int getMaxSendWindow() {
        return this.broker.getMaxSendWindow();
    }

    public int getCurrentSendWindow() {
        return this.broker.getCurrentSendWindow();
    }
}

