/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.DataFormatException;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ModifyOperation;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.internal.InternalSearchOperation;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.protocols.ldap.LDAPModification;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ModificationType;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerState
implements Serializable {
    private static final long serialVersionUID = 314772980474416183L;
    private HashMap<Short, ChangeNumber> list;
    private static final transient String SYNCHRONIZATION_STATE = "ds-sync-state";
    private transient DN baseDn;
    transient boolean savedStatus = true;
    private transient InternalClientConnection conn = new InternalClientConnection();
    private transient ASN1OctetString serverStateAsn1Dn;
    private transient DN serverStateDn;

    public ServerState(DN dN) {
        this.list = new HashMap();
        this.baseDn = dN;
        this.serverStateAsn1Dn = new ASN1OctetString("dc=ffffffff-ffffffff-ffffffff-ffffffff," + dN.toString());
        try {
            this.serverStateDn = DN.decode(this.serverStateAsn1Dn);
        }
        catch (DirectoryException directoryException) {
            // empty catch block
        }
    }

    public ServerState(byte[] byArray, int n, int n2) throws DataFormatException {
        try {
            this.list = new HashMap();
            while (n2 > n) {
                int n3 = this.getNextLength(byArray, n);
                String string = new String(byArray, n, n3, "UTF-8");
                short s = Short.valueOf(string);
                n += n3 + 1;
                n3 = this.getNextLength(byArray, n);
                String string2 = new String(byArray, n, n3, "UTF-8");
                ChangeNumber changeNumber = new ChangeNumber(string2);
                n += n3 + 1;
                this.list.put(s, changeNumber);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new DataFormatException("UTF-8 is not supported by this jvm.");
        }
    }

    private int getNextLength(byte[] byArray, int n) throws DataFormatException {
        int n2 = n;
        int n3 = 0;
        while (byArray[n2++] != 0) {
            if (n2 >= byArray.length) {
                throw new DataFormatException("byte[] is not a valid modify msg");
            }
            ++n3;
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(ChangeNumber changeNumber) {
        if (changeNumber == null) {
            return false;
        }
        ServerState serverState = this;
        synchronized (serverState) {
            Short s = changeNumber.getServerId();
            ChangeNumber changeNumber2 = this.list.get(s);
            if (changeNumber2 == null || changeNumber.newer(changeNumber2)) {
                this.list.put(s, changeNumber);
                this.savedStatus = false;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> toStringSet() {
        HashSet<String> hashSet = new HashSet<String>();
        ServerState serverState = this;
        synchronized (serverState) {
            for (Short s : this.list.keySet()) {
                ChangeNumber changeNumber = this.list.get(s);
                Date date = new Date(changeNumber.getTime());
                hashSet.add(changeNumber.toString() + " " + date.toString());
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ServerState serverState = this;
        synchronized (serverState) {
            String string = null;
            for (Short s : this.list.keySet()) {
                ChangeNumber changeNumber = this.list.get(s);
                string = string + " " + changeNumber.toString();
            }
            return string;
        }
    }

    public ChangeNumber getMaxChangeNumber(short s) {
        return this.list.get(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        if (this.list.size() == 0 || this.savedStatus) {
            return;
        }
        ArrayList<ASN1OctetString> arrayList = new ArrayList<ASN1OctetString>();
        Object object = this;
        synchronized (object) {
            for (Short serializable2 : this.list.keySet()) {
                ASN1OctetString bl = new ASN1OctetString(this.list.get(serializable2).toString());
                arrayList.add(bl);
            }
            this.savedStatus = true;
        }
        object = new LDAPAttribute(SYNCHRONIZATION_STATE, arrayList);
        LDAPModification lDAPModification = new LDAPModification(ModificationType.REPLACE, (LDAPAttribute)object);
        ArrayList<LDAPModification> arrayList2 = new ArrayList<LDAPModification>(1);
        arrayList2.add(lDAPModification);
        boolean bl = false;
        while (!bl) {
            ModifyOperation modifyOperation = new ModifyOperation((ClientConnection)this.conn, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), new ArrayList<Control>(0), this.serverStateAsn1Dn, arrayList2);
            modifyOperation.setInternalOperation(true);
            modifyOperation.setSynchronizationOperation(true);
            modifyOperation.run();
            ResultCode resultCode = modifyOperation.getResultCode();
            if (resultCode != ResultCode.SUCCESS) {
                if (resultCode == ResultCode.NO_SUCH_OBJECT) {
                    this.createStateEntry();
                    continue;
                }
                this.savedStatus = false;
                int n = 16973838;
                String string = MessageHandler.getMessage(n, modifyOperation.getResultCode().getResultCodeName(), modifyOperation.toString(), modifyOperation.getErrorMessage(), this.baseDn.toString());
                Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
                break;
            }
            bl = true;
        }
    }

    public void loadState() {
        AttributeType attributeType;
        List<Attribute> list;
        Object object;
        LDAPFilter lDAPFilter;
        try {
            lDAPFilter = LDAPFilter.decode("objectclass=*");
        }
        catch (LDAPException lDAPException) {
            return;
        }
        InternalSearchOperation internalSearchOperation = this.conn.processSearch(this.serverStateAsn1Dn, SearchScope.BASE_OBJECT, DereferencePolicy.DEREF_ALWAYS, 0, 0, false, lDAPFilter, new LinkedHashSet<String>(0));
        if (internalSearchOperation.getResultCode() != ResultCode.SUCCESS && internalSearchOperation.getResultCode() != ResultCode.NO_SUCH_OBJECT) {
            int n = 16973839;
            object = MessageHandler.getMessage(n, internalSearchOperation.getResultCode().getResultCodeName(), internalSearchOperation.toString(), internalSearchOperation.getErrorMessage(), this.baseDn.toString());
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, (String)object, n);
        }
        SearchResultEntry searchResultEntry = null;
        if (internalSearchOperation.getResultCode() == ResultCode.SUCCESS && (searchResultEntry = ((LinkedList)(object = internalSearchOperation.getSearchEntries())).getFirst()) != null && (list = searchResultEntry.getAttribute(attributeType = DirectoryServer.getAttributeType(SYNCHRONIZATION_STATE))) != null) {
            Attribute attribute = list.get(0);
            LinkedHashSet<AttributeValue> linkedHashSet = attribute.getValues();
            for (AttributeValue attributeValue : linkedHashSet) {
                ChangeNumber changeNumber = new ChangeNumber(attributeValue.getStringValue());
                this.update(changeNumber);
            }
        }
        if (searchResultEntry == null || internalSearchOperation.getResultCode() != ResultCode.SUCCESS) {
            this.createStateEntry();
        }
    }

    private void createStateEntry() {
        ArrayList<LDAPAttribute> arrayList = new ArrayList<LDAPAttribute>();
        ArrayList<ASN1OctetString> arrayList2 = new ArrayList<ASN1OctetString>();
        ASN1OctetString aSN1OctetString = new ASN1OctetString("extensibleObject");
        arrayList2.add(aSN1OctetString);
        LDAPAttribute lDAPAttribute = new LDAPAttribute("objectClass", arrayList2);
        aSN1OctetString = new ASN1OctetString("domain");
        arrayList2.add(aSN1OctetString);
        lDAPAttribute = new LDAPAttribute("objectClass", arrayList2);
        arrayList.add(lDAPAttribute);
        arrayList2 = new ArrayList();
        aSN1OctetString = new ASN1OctetString("ffffffff-ffffffff-ffffffff-ffffffff");
        arrayList2.add(aSN1OctetString);
        lDAPAttribute = new LDAPAttribute("dc", arrayList2);
        arrayList.add(lDAPAttribute);
        AddOperation addOperation = this.conn.processAdd(this.serverStateAsn1Dn, arrayList);
        ResultCode resultCode = addOperation.getResultCode();
        if (resultCode != ResultCode.SUCCESS && resultCode != ResultCode.NO_SUCH_OBJECT) {
            int n = 16973838;
            String string = MessageHandler.getMessage(n, addOperation.getResultCode().getResultCodeName(), addOperation.toString(), addOperation.getErrorMessage(), this.baseDn.toString());
            Error.logError(ErrorLogCategory.SYNCHRONIZATION, ErrorLogSeverity.SEVERE_ERROR, string, n);
        }
    }

    public DN getServerStateDn() {
        return this.serverStateDn;
    }

    private int addByteArray(byte[] byArray, byte[] byArray2, int n) {
        int n2 = 0;
        while (n2 < byArray.length) {
            byArray2[n] = byArray[n2];
            ++n2;
            ++n;
        }
        byArray2[n++] = 0;
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes() throws UnsupportedEncodingException {
        ServerState serverState = this;
        synchronized (serverState) {
            int n = 0;
            ArrayList<String> arrayList = new ArrayList<String>(this.list.size());
            Object object = this.list.keySet().iterator();
            while (object.hasNext()) {
                short s = object.next();
                String object2 = String.valueOf(s);
                arrayList.add(object2);
                n += object2.length() + 1;
            }
            object = new ArrayList(this.list.size());
            for (ChangeNumber changeNumber : this.list.values()) {
                String string = changeNumber.toString();
                object.add(string);
                n += string.length() + 1;
            }
            Object object3 = new byte[n];
            boolean bl = false;
            for (int i = 0; i < this.list.size(); ++i) {
                int n2;
                String string = (String)arrayList.get(i);
                n2 = this.addByteArray(string.getBytes("UTF-8"), (byte[])object3, n2);
                string = (String)object.get(i);
                n2 = this.addByteArray(string.getBytes("UTF-8"), (byte[])object3, n2);
            }
            return object3;
        }
    }
}

