/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;

public class HistoricalCsnOrderingMatchingRule
extends OrderingMatchingRule {
    private static final long serialVersionUID = -3424403930225609943L;

    public int compareValues(ByteString byteString, ByteString byteString2) {
        String[] stringArray = byteString.stringValue().split(":", 3);
        String[] stringArray2 = byteString2.stringValue().split(":", 3);
        if (stringArray[1] == null || stringArray2[1] == null) {
            return -1;
        }
        return stringArray[1].compareTo(stringArray2[1]);
    }

    public void initializeMatchingRule(ConfigEntry configEntry) {
    }

    public String getName() {
        return "historicalCsnOrderingMatch";
    }

    public String getOID() {
        return "2.1.5.6.7.8.9.11.22.33.44";
    }

    public String getDescription() {
        return null;
    }

    public String getSyntaxOID() {
        return "2.1.5.6.7.8.9.11.22.33.445";
    }

    public ByteString normalizeValue(ByteString byteString) {
        String[] stringArray = byteString.stringValue().split(":", 3);
        return new ASN1OctetString(stringArray[1]);
    }

    public int compare(byte[] byArray, byte[] byArray2) {
        int n = Math.min(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            if (byArray[i] < byArray2[i]) {
                return -1;
            }
            if (byArray[i] <= byArray2[i]) continue;
            return 1;
        }
        if (byArray.length == byArray2.length) {
            return 0;
        }
        if (byArray.length < byArray2.length) {
            return -1;
        }
        return 1;
    }
}

