/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.ValueInfo;
import org.opends.server.types.AttributeValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttrInfo {
    private ChangeNumber deleteTime;
    private ChangeNumber lastUpdateTime;
    private ArrayList<ValueInfo> valuesInfo;

    public AttrInfo(ChangeNumber changeNumber, ChangeNumber changeNumber2, ArrayList<ValueInfo> arrayList) {
        this.deleteTime = changeNumber;
        this.lastUpdateTime = changeNumber2;
        this.valuesInfo = arrayList == null ? new ArrayList() : arrayList;
    }

    public AttrInfo() {
        this.deleteTime = null;
        this.lastUpdateTime = null;
        this.valuesInfo = new ArrayList();
    }

    ChangeNumber getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    ChangeNumber getDeleteTime() {
        return this.deleteTime;
    }

    void setDeleteTime(ChangeNumber changeNumber) {
        this.deleteTime = changeNumber;
    }

    void setLastUpdateTime(ChangeNumber changeNumber) {
        this.lastUpdateTime = changeNumber;
    }

    AttrInfo duplicate() {
        AttrInfo attrInfo = new AttrInfo(this.deleteTime, this.lastUpdateTime, this.valuesInfo);
        return attrInfo;
    }

    void delete(ChangeNumber changeNumber) {
        if (this.valuesInfo != null) {
            this.valuesInfo.clear();
        }
        this.deleteTime = changeNumber;
        this.lastUpdateTime = changeNumber;
    }

    void delete(AttributeValue attributeValue, ChangeNumber changeNumber) {
        ValueInfo valueInfo = new ValueInfo(attributeValue, null, changeNumber);
        this.valuesInfo.remove(valueInfo);
        this.valuesInfo.add(valueInfo);
        this.lastUpdateTime = changeNumber;
    }

    void delete(LinkedHashSet<AttributeValue> linkedHashSet, ChangeNumber changeNumber) {
        for (AttributeValue attributeValue : linkedHashSet) {
            ValueInfo valueInfo = new ValueInfo(attributeValue, null, changeNumber);
            this.valuesInfo.remove(valueInfo);
            this.valuesInfo.add(valueInfo);
            this.lastUpdateTime = changeNumber;
        }
    }

    void add(AttributeValue attributeValue, ChangeNumber changeNumber) {
        ValueInfo valueInfo = new ValueInfo(attributeValue, changeNumber, null);
        this.valuesInfo.remove(valueInfo);
        this.valuesInfo.add(valueInfo);
        this.lastUpdateTime = changeNumber;
    }

    void add(LinkedHashSet<AttributeValue> linkedHashSet, ChangeNumber changeNumber) {
        for (AttributeValue attributeValue : linkedHashSet) {
            ValueInfo valueInfo = new ValueInfo(attributeValue, changeNumber, null);
            this.valuesInfo.remove(valueInfo);
            this.valuesInfo.add(valueInfo);
            this.lastUpdateTime = changeNumber;
        }
    }

    public ArrayList<ValueInfo> getValuesInfo() {
        return this.valuesInfo;
    }
}

