/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.synchronization;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.zip.DataFormatException;
import org.opends.server.core.AddOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Exception;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.internal.InternalClientConnection;
import org.opends.server.protocols.ldap.LDAPAttribute;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.synchronization.AddContext;
import org.opends.server.synchronization.ChangeNumber;
import org.opends.server.synchronization.UpdateMessage;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddMsg
extends UpdateMessage {
    private static final long serialVersionUID = -4905520652801395185L;
    private final byte[] encodedAttributes;
    private final String parentUniqueId;

    public AddMsg(AddOperation addOperation) {
        super((AddContext)addOperation.getAttachment("synchronizationContext"), addOperation.getRawEntryDN().stringValue());
        AddContext addContext = (AddContext)addOperation.getAttachment("synchronizationContext");
        this.parentUniqueId = addContext.getParentUid();
        LinkedHashSet<AttributeValue> linkedHashSet = new LinkedHashSet<AttributeValue>(addOperation.getObjectClasses().size());
        for (String object2 : addOperation.getObjectClasses().values()) {
            linkedHashSet.add(new AttributeValue(new ASN1OctetString(object2), (ByteString)new ASN1OctetString(StaticUtils.toLowerCase(object2))));
        }
        Attribute attribute = new Attribute(DirectoryServer.getObjectClassAttributeType(), "objectClass", linkedHashSet);
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>();
        arrayList.add(new LDAPAttribute(attribute).encode());
        for (List<Attribute> list : addOperation.getUserAttributes().values()) {
            for (Attribute attribute2 : list) {
                arrayList.add(new LDAPAttribute(attribute2).encode());
            }
        }
        for (List<Attribute> list : addOperation.getOperationalAttributes().values()) {
            for (Attribute attribute2 : list) {
                arrayList.add(new LDAPAttribute(attribute2).encode());
            }
        }
        this.encodedAttributes = ASN1Element.encodeValue(arrayList);
    }

    public AddMsg(ChangeNumber changeNumber, String string, String string2, String string3, Attribute attribute, Collection<Attribute> collection, Collection<Attribute> collection2) {
        super(new AddContext(changeNumber, string2, string3), string);
        this.parentUniqueId = string3;
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>();
        arrayList.add(new LDAPAttribute(attribute).encode());
        for (Attribute attribute2 : collection) {
            arrayList.add(new LDAPAttribute(attribute2).encode());
        }
        for (Attribute attribute2 : collection2) {
            arrayList.add(new LDAPAttribute(attribute2).encode());
        }
        this.encodedAttributes = ASN1Element.encodeValue(arrayList);
    }

    public AddMsg(byte[] byArray) throws DataFormatException, UnsupportedEncodingException {
        super(byArray);
        int n = this.decodeHeader((byte)2, byArray);
        int n2 = this.getNextLength(byArray, n);
        if (n2 != 0) {
            this.parentUniqueId = new String(byArray, n, n2, "UTF-8");
            n += n2 + 1;
        } else {
            this.parentUniqueId = null;
            ++n;
        }
        this.encodedAttributes = new byte[byArray.length - n];
        int n3 = 0;
        while (n < byArray.length) {
            this.encodedAttributes[n3++] = byArray[n++];
        }
    }

    @Override
    public AddOperation createOperation(InternalClientConnection internalClientConnection, String string) throws LDAPException, ASN1Exception {
        ArrayList<LDAPAttribute> arrayList = new ArrayList<LDAPAttribute>();
        ArrayList<ASN1Element> arrayList2 = ASN1Element.decodeElements(this.encodedAttributes);
        for (ASN1Element object2 : arrayList2) {
            arrayList.add(LDAPAttribute.decode(object2));
        }
        AddOperation addOperation = new AddOperation(internalClientConnection, InternalClientConnection.nextOperationID(), InternalClientConnection.nextMessageID(), null, new ASN1OctetString(string), arrayList);
        AddContext addContext = new AddContext(this.getChangeNumber(), this.getUniqueId(), this.parentUniqueId);
        addOperation.setAttachment("synchronizationContext", addContext);
        return addOperation;
    }

    @Override
    public byte[] getBytes() {
        try {
            int n = this.encodedAttributes.length;
            byte[] byArray = null;
            if (this.parentUniqueId != null) {
                byArray = this.parentUniqueId.getBytes("UTF-8");
                n += byArray.length + 1;
            } else {
                ++n;
            }
            byte[] byArray2 = this.encodeHeader((byte)2, n);
            int n2 = byArray2.length - n;
            if (byArray != null) {
                n2 = this.addByteArray(byArray, byArray2, n2);
            } else {
                byArray2[n2++] = 0;
            }
            int n3 = 0;
            while (n3 < this.encodedAttributes.length) {
                byArray2[n2] = this.encodedAttributes[n3];
                ++n3;
                ++n2;
            }
            return byArray2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public String toString() {
        return "ADD " + this.getDn() + " " + this.getChangeNumber();
    }
}

