/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class UserPasswordSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.UserPasswordSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;

    public UserPasswordSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("1.3.6.1.4.1.26027.1.4.2");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "ds-mr-user-password-exact", "ds-syntax-user-password");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "ds-syntax-user-password";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.26027.1.3.1";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "User Password Syntax";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return null;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return null;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        return true;
    }

    public static String[] decodeUserPassword(String string) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "decodeUserPassword", String.valueOf(string)));
        if (string == null || string.length() == 0) {
            int n = 6553853;
            String string2 = MessageHandler.getMessage(n);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n);
        }
        if (string.charAt(0) != '{') {
            int n = 6553854;
            String string3 = MessageHandler.getMessage(n);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n);
        }
        int n = string.indexOf(125);
        if (n < 0) {
            int n2 = 6553855;
            String string4 = MessageHandler.getMessage(n2);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n2);
        }
        String string5 = string.substring(1, n);
        String string6 = string.substring(n + 1);
        if (string5.length() == 0) {
            int n3 = 6553856;
            String string7 = MessageHandler.getMessage(n3);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n3);
        }
        return new String[]{StaticUtils.toLowerCase(string5), string6};
    }

    public static boolean isEncoded(ByteString byteString) {
        byte[] byArray;
        assert (Debug.debugEnter(CLASS_NAME, "isEncoded", String.valueOf(byteString)));
        if (byteString == null || (byArray = byteString.value()).length == 0) {
            return false;
        }
        if (byArray[0] != 123) {
            return false;
        }
        int n = -1;
        for (int i = 1; i < byArray.length; ++i) {
            if (byArray[i] != 125) continue;
            n = i;
            break;
        }
        if (n < 0 || n == 1) {
            return false;
        }
        return n != byArray.length - 1;
    }
}

