/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.PrintableString;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;

public class TelexNumberSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.TelexNumberSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public TelexNumberSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "TelexNumber");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "TelexNumber");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "TelexNumber");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "TelexNumber";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.52";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Telex Number";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        int n;
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        String string = byteString.stringValue();
        int n3 = string.length();
        if (n3 < 5) {
            int n4 = 6488249;
            stringBuilder.append(MessageHandler.getMessage(n4, string));
            return false;
        }
        char c = string.charAt(0);
        if (!PrintableString.isPrintableCharacter(c)) {
            int n5 = 6488250;
            stringBuilder.append(MessageHandler.getMessage(n5, string, Character.valueOf(c), 0));
            return false;
        }
        for (n2 = 1; n2 < n3; ++n2) {
            c = string.charAt(n2);
            if (c == '$') {
                ++n2;
                break;
            }
            if (PrintableString.isPrintableCharacter(c)) continue;
            n = 6488251;
            stringBuilder.append(MessageHandler.getMessage(n, string, Character.valueOf(c), n2));
        }
        if (n2 >= n3) {
            n = 6488252;
            stringBuilder.append(MessageHandler.getMessage(n, string));
            return false;
        }
        if (!PrintableString.isPrintableCharacter(c = string.charAt(n2++))) {
            n = 6488250;
            stringBuilder.append(MessageHandler.getMessage(n, string, Character.valueOf(c), n2 - 1));
            return false;
        }
        while (n2 < n3) {
            c = string.charAt(n2);
            if (c == '$') {
                ++n2;
                break;
            }
            if (!PrintableString.isPrintableCharacter(c)) {
                n = 6488251;
                stringBuilder.append(MessageHandler.getMessage(n, string, Character.valueOf(c), n2));
                return false;
            }
            ++n2;
        }
        if (n2 >= n3) {
            n = 6488252;
            stringBuilder.append(MessageHandler.getMessage(n, string));
            return false;
        }
        if (!PrintableString.isPrintableCharacter(c = string.charAt(n2++))) {
            n = 6488250;
            stringBuilder.append(MessageHandler.getMessage(n, string, Character.valueOf(c), n2 - 1));
            return false;
        }
        while (n2 < n3) {
            c = string.charAt(n2);
            if (!PrintableString.isPrintableCharacter(c)) {
                n = 6488251;
                stringBuilder.append(MessageHandler.getMessage(n, string, Character.valueOf(c), n2));
                return false;
            }
            ++n2;
        }
        return true;
    }
}

