/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.MatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeType;
import org.opends.server.types.ByteString;
import org.opends.server.types.CommonSchemaElements;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.NameForm;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class ObjectIdentifierEqualityMatchingRule
extends EqualityMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.ObjectIdentifierEqualityMatchingRule";

    public ObjectIdentifierEqualityMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "objectIdentifierMatch";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "2.5.13.0";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return null;
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.38";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        StringBuilder stringBuilder = new StringBuilder();
        StaticUtils.toLowerCase(byteString.value(), stringBuilder, true);
        String string = stringBuilder.toString();
        String string2 = null;
        AttributeType attributeType = DirectoryServer.getAttributeType(string);
        if (attributeType != null) {
            string2 = attributeType.getNameOrOID();
        }
        if (string2 == null && (object = DirectoryServer.getObjectClass(string)) != null) {
            string2 = ((CommonSchemaElements)object).getNameOrOID();
        }
        if (string2 == null && (object = DirectoryServer.getMatchingRule(string)) != null) {
            string2 = ((MatchingRule)object).getNameOrOID();
        }
        if (string2 == null && (object = DirectoryServer.getNameForm(string)) != null) {
            string2 = ((NameForm)object).getNameOrOID();
        }
        if (string2 != null) {
            return new ASN1OctetString(StaticUtils.toLowerCase(string2));
        }
        switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
            case REJECT: {
                object = new StringBuilder();
                if (StaticUtils.isValidSchemaElement(string, 0, string.length(), (StringBuilder)object)) {
                    return new ASN1OctetString(string);
                }
                int n = 6488286;
                String string3 = MessageHandler.getMessage(n, string, ((StringBuilder)object).toString());
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n);
            }
            case WARN: {
                object = new StringBuilder();
                if (!StaticUtils.isValidSchemaElement(string, 0, string.length(), (StringBuilder)object)) {
                    int n = 6488286;
                    String string4 = MessageHandler.getMessage(n, string, ((StringBuilder)object).toString());
                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string4, n);
                }
                return new ASN1OctetString(string);
            }
        }
        return new ASN1OctetString(string);
    }

    public boolean areEqual(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "areEqual", String.valueOf(byteString), String.valueOf(byteString2)));
        return Arrays.equals(byteString.value(), byteString2.value());
    }
}

