/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class LDAPSyntaxDescriptionSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.LDAPSyntaxDescriptionSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public LDAPSyntaxDescriptionSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.2");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.2", "LDAPSyntaxDescription");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.3");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.3", "LDAPSyntaxDescription");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.4");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.4", "LDAPSyntaxDescription");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "LDAPSyntaxDescription";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.54";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "LDAP Syntax Description";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        String string;
        StringBuilder stringBuilder2;
        char c;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        String string2 = byteString.stringValue();
        String string3 = StaticUtils.toLowerCase(string2);
        int n2 = string2.length();
        for (n = 0; n < n2 && string2.charAt(n) == ' '; ++n) {
        }
        if (n >= n2) {
            int n3 = 6488156;
            stringBuilder.append(MessageHandler.getMessage(n3));
            return false;
        }
        if ((c = string2.charAt(n++)) != '(') {
            int n4 = 6488157;
            stringBuilder.append(MessageHandler.getMessage(n4, string2, n - 1, Character.valueOf(c)));
            return false;
        }
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488158;
            stringBuilder.append(MessageHandler.getMessage(n5, string2));
            return false;
        }
        int n6 = n;
        if (StaticUtils.isDigit(c)) {
            boolean bl = false;
            while (n < n2 && (c = string2.charAt(n++)) != ' ') {
                if (c == '.') {
                    if (bl) {
                        int n7 = 6488159;
                        stringBuilder.append(MessageHandler.getMessage(n7, string2, n - 1));
                        return false;
                    }
                    bl = true;
                    continue;
                }
                if (!StaticUtils.isDigit(c)) {
                    int n8 = 0x630060;
                    stringBuilder.append(MessageHandler.getMessage(n8, string2, Character.valueOf(c), n - 1));
                    return false;
                }
                bl = false;
            }
        } else {
            while (n < n2 && (c = string2.charAt(n++)) != ' ') {
                if (StaticUtils.isAlpha(c) || StaticUtils.isDigit(c) || c == '-' || c == '_' && DirectoryServer.allowAttributeNameExceptions()) continue;
                int n9 = 6488161;
                stringBuilder.append(MessageHandler.getMessage(n9, string2, Character.valueOf(c), n - 1));
                return false;
            }
        }
        if (n >= n2) {
            int n10 = 6488158;
            stringBuilder.append(MessageHandler.getMessage(n10, string2));
            return false;
        }
        String string4 = string3.substring(n6, n);
        while (n < n2 && (c = string2.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n11 = 6488158;
            stringBuilder.append(MessageHandler.getMessage(n11, string2));
            return false;
        }
        if (c == ')') {
            if (n < n2) {
                int n12 = 6488162;
                stringBuilder.append(MessageHandler.getMessage(n12, string2, n - 1));
                return false;
            }
            return true;
        }
        try {
            stringBuilder2 = new StringBuilder();
            n = LDAPSyntaxDescriptionSyntax.readTokenName(string3, stringBuilder2, n);
            string = stringBuilder2.toString();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", exception));
            int n13 = 0x630063;
            stringBuilder.append(MessageHandler.getMessage(n13, string2, n, StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        if (!string.equals("desc")) {
            int n14 = 6488164;
            stringBuilder.append(MessageHandler.getMessage(n14, string2, string));
            return false;
        }
        try {
            stringBuilder2 = new StringBuilder();
            n = LDAPSyntaxDescriptionSyntax.readQuotedString(string2, stringBuilder2, n);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "valueIsAcceptable", exception));
            int n15 = 6488165;
            stringBuilder.append(MessageHandler.getMessage(n15, string2, n, StaticUtils.stackTraceToSingleLineString(exception)));
            return false;
        }
        c = string2.charAt(n++);
        if (c != ')') {
            int n16 = 0x630066;
            stringBuilder.append(MessageHandler.getMessage(n16, string2, n, Character.valueOf(c)));
            return false;
        }
        while (n < n2) {
            if ((c = string2.charAt(n++)) == ' ') continue;
            int n17 = 6488167;
            stringBuilder.append(MessageHandler.getMessage(n17, string2, Character.valueOf(c), n));
            return false;
        }
        return true;
    }

    private static int readTokenName(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readTokenName", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488158;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        while (n < n2 && (c = string.charAt(n++)) != ' ') {
            stringBuilder.append(c);
        }
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        return n;
    }

    private static int readQuotedString(String string, StringBuilder stringBuilder, int n) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "readQuotedString", String.valueOf(string), "java.lang.StringBuilder", String.valueOf(n)));
        char c = '\u0000';
        int n2 = string.length();
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n3 = 6488158;
            String string2 = MessageHandler.getMessage(n3, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3);
        }
        if (c != '\'') {
            int n4 = 6422632;
            String string3 = MessageHandler.getMessage(n4, string, n, Character.valueOf(c));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
        }
        ++n;
        while (n < n2 && (c = string.charAt(n)) != '\'') {
            stringBuilder.append(c);
            ++n;
        }
        ++n;
        while (n < n2 && (c = string.charAt(n)) == ' ') {
            ++n;
        }
        if (n >= n2) {
            int n5 = 6488158;
            String string4 = MessageHandler.getMessage(n5, string);
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n5);
        }
        return n;
    }
}

