/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class IntegerFirstComponentEqualityMatchingRule
extends EqualityMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.IntegerFirstComponentEqualityMatchingRule";

    public IntegerFirstComponentEqualityMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "integerFirstComponentMatch";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "2.5.13.29";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return null;
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.27";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        StringBuilder stringBuilder = new StringBuilder();
        StaticUtils.toLowerCase(byteString.value(), stringBuilder, true);
        int n = stringBuilder.length();
        if (n == 0) {
            if (byteString.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return new ASN1OctetString();
        }
        for (int i = n - 1; i > 0; --i) {
            if (stringBuilder.charAt(i) != ' ' || stringBuilder.charAt(i - 1) != ' ') continue;
            stringBuilder.delete(i, i + 1);
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    public boolean areEqual(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "areEqual", String.valueOf(byteString), String.valueOf(byteString2)));
        try {
            int n = IntegerFirstComponentEqualityMatchingRule.extractIntValue(byteString.stringValue());
            int n2 = IntegerFirstComponentEqualityMatchingRule.extractIntValue(byteString2.stringValue());
            return n == n2;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "areEqual", exception));
            return false;
        }
    }

    public int generateHashCode(AttributeValue attributeValue) {
        assert (Debug.debugEnter(CLASS_NAME, "generateHashCode", String.valueOf(attributeValue)));
        return 1;
    }

    private static int extractIntValue(String string) throws DirectoryException {
        char c;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "extractIntValue", String.valueOf(string)));
        int n2 = string.length();
        if (n2 == 0 || string.charAt(0) != '(') {
            try {
                return Integer.parseInt(string);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "extractIntValue", exception));
                int n3 = 6553849;
                String string2 = MessageHandler.getMessage(n3, String.valueOf(string));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n3, exception);
            }
        }
        for (n = 1; n < n2 && (c = string.charAt(n)) == ' '; ++n) {
        }
        if (n >= n2) {
            int n4 = 6553850;
            String string3 = MessageHandler.getMessage(n4, String.valueOf(string));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n4);
        }
        int n5 = n++;
        while (n < n2 && (c = string.charAt(n)) != ' ') {
            ++n;
        }
        if (n >= n2) {
            int n6 = 6553851;
            String string4 = MessageHandler.getMessage(n6, String.valueOf(string));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n6);
        }
        try {
            return Integer.parseInt(string.substring(n5, n));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "extractIntValue", exception));
            int n7 = 6553852;
            String string5 = MessageHandler.getMessage(n7, String.valueOf(string));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n7);
        }
    }
}

