/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.api.AttributeSyntax;
import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.types.ByteString;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.util.StaticUtils;

public class GuideSyntax
extends AttributeSyntax {
    private static final String CLASS_NAME = "org.opends.server.schema.GuideSyntax";
    private EqualityMatchingRule defaultEqualityMatchingRule;
    private OrderingMatchingRule defaultOrderingMatchingRule;
    private SubstringMatchingRule defaultSubstringMatchingRule;

    public GuideSyntax() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeSyntax(ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeSyntax", String.valueOf(configEntry)));
        this.defaultEqualityMatchingRule = DirectoryServer.getEqualityMatchingRule("2.5.13.17");
        if (this.defaultEqualityMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553602, "2.5.13.17", "Guide");
        }
        this.defaultOrderingMatchingRule = DirectoryServer.getOrderingMatchingRule("2.5.13.18");
        if (this.defaultOrderingMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 6553603, "2.5.13.18", "Guide");
        }
        this.defaultSubstringMatchingRule = DirectoryServer.getSubstringMatchingRule("2.5.13.19");
        if (this.defaultSubstringMatchingRule == null) {
            Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_ERROR, 0x640004, "2.5.13.19", "Guide");
        }
    }

    public String getSyntaxName() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxName", new String[0]));
        return "Guide";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.25";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Guide";
    }

    public EqualityMatchingRule getEqualityMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getEqualityMatchingRule", new String[0]));
        return this.defaultEqualityMatchingRule;
    }

    public OrderingMatchingRule getOrderingMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getOrderingMatchingRule", new String[0]));
        return this.defaultOrderingMatchingRule;
    }

    public SubstringMatchingRule getSubstringMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getSubstringMatchingRule", new String[0]));
        return this.defaultSubstringMatchingRule;
    }

    public ApproximateMatchingRule getApproximateMatchingRule() {
        assert (Debug.debugEnter(CLASS_NAME, "getApproximateMatchingRule", new String[0]));
        return null;
    }

    public boolean valueIsAcceptable(ByteString byteString, StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "valueIsAcceptable", String.valueOf(byteString), "java.lang.StringBuilder"));
        String string = StaticUtils.toLowerCase(byteString.stringValue());
        int n = string.indexOf(35);
        if (n < 0) {
            return GuideSyntax.criteriaIsValid(string, string, stringBuilder);
        }
        String string2 = string.substring(0, n).trim();
        int n2 = string2.length();
        if (n2 == 0) {
            int n3 = 6488269;
            stringBuilder.append(MessageHandler.getMessage(n3, string));
            return false;
        }
        if (!StaticUtils.isValidSchemaElement(string2, 0, n2, stringBuilder)) {
            return false;
        }
        return GuideSyntax.criteriaIsValid(string.substring(n + 1), string, stringBuilder);
    }

    public static boolean criteriaIsValid(String string, String string2, StringBuilder stringBuilder) {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "criteriaIsValid", String.valueOf(string), String.valueOf(string2), "java.lang.StringBuilder"));
        char c = string.charAt(0);
        if (c == '!') {
            return GuideSyntax.criteriaIsValid(string.substring(1), string2, stringBuilder);
        }
        if (c == '(') {
            int n2;
            int n3 = string.length();
            int n4 = 1;
            for (n2 = 1; n2 < n3; ++n2) {
                c = string.charAt(n2);
                if (c == ')') {
                    if (--n4 != 0) continue;
                    String string3 = string.substring(1, n2);
                    if (!GuideSyntax.criteriaIsValid(string3, string2, stringBuilder)) {
                        return false;
                    }
                    if (n2 == n3 - 1) {
                        return true;
                    }
                    c = string.charAt(n2 + 1);
                    if (c == '|' || c == '&') {
                        return GuideSyntax.criteriaIsValid(string.substring(n2 + 2), string2, stringBuilder);
                    }
                    int n5 = 6488270;
                    stringBuilder.append(MessageHandler.getMessage(n5, string2, string, Character.valueOf(c), n2 + 1));
                    return false;
                }
                if (c != '(') continue;
                ++n4;
            }
            n2 = 6488271;
            stringBuilder.append(MessageHandler.getMessage(n2, string2, string));
            return false;
        }
        if (c == '?') {
            if (string.startsWith("?true")) {
                if (string.length() == 5) {
                    return true;
                }
                c = string.charAt(5);
                if (c == '|' || c == '&') {
                    return GuideSyntax.criteriaIsValid(string.substring(6), string2, stringBuilder);
                }
                int n6 = 6488270;
                stringBuilder.append(MessageHandler.getMessage(n6, string2, string, Character.valueOf(c), 5));
                return false;
            }
            if (string.startsWith("?false")) {
                if (string.length() == 6) {
                    return true;
                }
                c = string.charAt(6);
                if (c == '|' || c == '&') {
                    return GuideSyntax.criteriaIsValid(string.substring(7), string2, stringBuilder);
                }
                int n7 = 6488270;
                stringBuilder.append(MessageHandler.getMessage(n7, string2, string, Character.valueOf(c), 6));
                return false;
            }
            int n8 = 6488272;
            stringBuilder.append(MessageHandler.getMessage(n8, string2, string));
            return false;
        }
        if (string.equals("true") || string.equals("false")) {
            return true;
        }
        int n9 = string.indexOf(36);
        if (n9 < 0) {
            int n10 = 6488273;
            stringBuilder.append(MessageHandler.getMessage(n10, string2, string));
            return false;
        }
        if (n9 == 0) {
            int n11 = 6488274;
            stringBuilder.append(MessageHandler.getMessage(n11, string2, string));
            return false;
        }
        if (n9 == string.length() - 1) {
            int n12 = 6488275;
            stringBuilder.append(MessageHandler.getMessage(n12, string2, string));
            return false;
        }
        if (!StaticUtils.isValidSchemaElement(string, 0, n9, stringBuilder)) {
            return false;
        }
        c = string.charAt(n9 + 1);
        switch (c) {
            case 'e': {
                if (string.startsWith("eq", n9 + 1)) {
                    n = n9 + 3;
                    break;
                }
                int n13 = 6488276;
                stringBuilder.append(MessageHandler.getMessage(n13, string2, string, n9 + 1));
                return false;
            }
            case 's': {
                if (string.startsWith("substr", n9 + 1)) {
                    n = n9 + 7;
                    break;
                }
                int n14 = 6488276;
                stringBuilder.append(MessageHandler.getMessage(n14, string2, string, n9 + 1));
                return false;
            }
            case 'g': {
                if (string.startsWith("ge", n9 + 1)) {
                    n = n9 + 3;
                    break;
                }
                int n15 = 6488276;
                stringBuilder.append(MessageHandler.getMessage(n15, string2, string, n9 + 1));
                return false;
            }
            case 'l': {
                if (string.startsWith("le", n9 + 1)) {
                    n = n9 + 3;
                    break;
                }
                int n16 = 6488276;
                stringBuilder.append(MessageHandler.getMessage(n16, string2, string, n9 + 1));
                return false;
            }
            case 'a': {
                if (string.startsWith("approx", n9 + 1)) {
                    n = n9 + 7;
                    break;
                }
                int n17 = 6488276;
                stringBuilder.append(MessageHandler.getMessage(n17, string2, string, n9 + 1));
                return false;
            }
            default: {
                int n18 = 6488276;
                stringBuilder.append(MessageHandler.getMessage(n18, string2, string, n9 + 1));
                return false;
            }
        }
        if (n >= string.length()) {
            return true;
        }
        c = string.charAt(n);
        if (c == '|' || c == '&') {
            return GuideSyntax.criteriaIsValid(string.substring(n + 1), string2, stringBuilder);
        }
        int n19 = 6488270;
        stringBuilder.append(MessageHandler.getMessage(n19, string2, string, Character.valueOf(c), n));
        return false;
    }
}

