/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.text.SimpleDateFormat;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.OrderingMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.AcceptRejectWarn;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;
import org.opends.server.util.StaticUtils;

public class GeneralizedTimeOrderingMatchingRule
extends OrderingMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.GeneralizedTimeOrderingMatchingRule";
    private static final long serialVersionUID = -6343622924726948145L;
    private static ReentrantLock dateFormatLock;
    private static SimpleDateFormat dateFormat;
    private static TimeZone utcTimeZone;

    public GeneralizedTimeOrderingMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "generalizedTimeOrderingMatch";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "2.5.13.28";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return null;
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.24";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        String string = byteString.stringValue().toUpperCase();
        int n7 = string.length();
        if (n7 < 11) {
            int n8 = 6422541;
            String string2 = MessageHandler.getMessage(n8, string);
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n8);
                }
                case WARN: {
                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string2, n8);
                    return new ASN1OctetString(string);
                }
            }
            return new ASN1OctetString(string);
        }
        try {
            n6 = Integer.parseInt(string.substring(0, 4));
            n5 = Integer.parseInt(string.substring(4, 6));
            n4 = Integer.parseInt(string.substring(6, 8));
            n3 = Integer.parseInt(string.substring(8, 10));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "normalizeValue", exception));
            int n9 = 6422552;
            String string3 = MessageHandler.getMessage(n9, string, String.valueOf(exception));
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n9);
                }
                case WARN: {
                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string3, n9);
                    return new ASN1OctetString(string);
                }
            }
            return new ASN1OctetString(string);
        }
        if (StaticUtils.isDigit(string.charAt(10))) {
            try {
                n2 = Integer.parseInt(string.substring(10, 12));
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "normalizeValue", exception));
                int n10 = 6422552;
                String string4 = MessageHandler.getMessage(n10, string, String.valueOf(exception));
                switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                    case REJECT: {
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n10);
                    }
                    case WARN: {
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string4, n10);
                        return new ASN1OctetString(string);
                    }
                }
                return new ASN1OctetString(string);
            }
        } else {
            return this.processValueEnd(string, 10, n6, n5, n4, n3, 0, 0, 0);
        }
        if (n7 < 13) {
            if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
                int n11 = 6422541;
                String string5 = MessageHandler.getMessage(n11, string);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n11);
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n6, n5 - 1, n4, n3, n2, 0);
            gregorianCalendar.setTimeZone(utcTimeZone);
            dateFormatLock.lock();
            try {
                ASN1OctetString aSN1OctetString = new ASN1OctetString(dateFormat.format(gregorianCalendar.getTime()));
                return aSN1OctetString;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "normalizeValue", exception));
                int n12 = 6422751;
                String string6 = MessageHandler.getMessage(n12, string, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n12, exception);
            }
            finally {
                dateFormatLock.unlock();
            }
        }
        if (StaticUtils.isDigit(string.charAt(12))) {
            try {
                n = Integer.parseInt(string.substring(12, 14));
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "normalizeValue", exception));
                int n13 = 6422552;
                String string7 = MessageHandler.getMessage(n13, string, String.valueOf(exception));
                if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n13, exception);
                }
                Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.MILD_ERROR, string7, n13);
                return new ASN1OctetString(string);
            }
        } else {
            return this.processValueEnd(string, 12, n6, n5, n4, n3, n2, 0, 0);
        }
        if (n7 < 15) {
            if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
                int n14 = 6422541;
                String string8 = MessageHandler.getMessage(n14, string);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string8, n14);
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n6, n5 - 1, n4, n3, n2, n);
            gregorianCalendar.setTimeZone(utcTimeZone);
            dateFormatLock.lock();
            try {
                ASN1OctetString aSN1OctetString = new ASN1OctetString(dateFormat.format(gregorianCalendar.getTime()));
                return aSN1OctetString;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "normalizeValue", exception));
                int n15 = 6422751;
                String string9 = MessageHandler.getMessage(n15, string, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string9, n15, exception);
            }
            finally {
                dateFormatLock.unlock();
            }
        }
        if (string.charAt(14) == '.') {
            int n16;
            char c;
            int n17;
            StringBuilder stringBuilder = new StringBuilder(3);
            for (n17 = 15; n17 < n7 && StaticUtils.isDigit(c = string.charAt(n17)); ++n17) {
                stringBuilder.append(c);
            }
            switch (stringBuilder.length()) {
                case 0: {
                    n16 = 0;
                    break;
                }
                case 1: {
                    n16 = 100 * Integer.parseInt(stringBuilder.toString());
                    break;
                }
                case 2: {
                    n16 = 10 * Integer.parseInt(stringBuilder.toString());
                    break;
                }
                case 3: {
                    n16 = Integer.parseInt(stringBuilder.toString());
                    break;
                }
                default: {
                    n16 = Integer.parseInt(stringBuilder.toString().substring(0, 3));
                    switch (stringBuilder.charAt(3)) {
                        case '\u0005': 
                        case '\u0006': 
                        case '\u0007': 
                        case '\b': 
                        case '\t': {
                            ++n16;
                        }
                    }
                }
            }
            return this.processValueEnd(string, n17, n6, n5, n4, n3, n2, n, n16);
        }
        return this.processValueEnd(string, 14, n6, n5, n4, n3, n2, n, 0);
    }

    private ByteString processValueEnd(String string, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "processValueEnd", String.valueOf(string), String.valueOf(n), String.valueOf(n2), String.valueOf(n3), String.valueOf(n4), String.valueOf(n5), String.valueOf(n6), String.valueOf(n7), String.valueOf(n8)));
        int n9 = string.length();
        if (n >= n9) {
            if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
                int n10 = 6422541;
                String string2 = MessageHandler.getMessage(n10, string);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string2, n10);
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n2, n3 - 1, n4, n5, n6, n7);
            gregorianCalendar.setTimeZone(utcTimeZone);
            gregorianCalendar.set(14, n8);
            dateFormatLock.lock();
            try {
                ASN1OctetString aSN1OctetString = new ASN1OctetString(dateFormat.format(gregorianCalendar.getTime()));
                return aSN1OctetString;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "processValueEnd", exception));
                int n11 = 6422751;
                String string3 = MessageHandler.getMessage(n11, string, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string3, n11, exception);
            }
            finally {
                dateFormatLock.unlock();
            }
        }
        char c = string.charAt(n);
        if (c == 'Z') {
            if (n == n9 - 1) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar(n2, n3 - 1, n4, n5, n6, n7);
                gregorianCalendar.setTimeZone(utcTimeZone);
                gregorianCalendar.set(14, n8);
                dateFormatLock.lock();
                try {
                    ASN1OctetString aSN1OctetString = new ASN1OctetString(dateFormat.format(gregorianCalendar.getTime()));
                    return aSN1OctetString;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "processValueEnd", exception));
                    int n12 = 6422751;
                    String string4 = MessageHandler.getMessage(n12, string, StaticUtils.stackTraceToSingleLineString(exception));
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string4, n12, exception);
                }
                finally {
                    dateFormatLock.unlock();
                }
            }
            if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
                int n13 = 6422551;
                String string5 = MessageHandler.getMessage(n13, string, Character.valueOf('Z'), n);
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string5, n13);
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
            gregorianCalendar.setTimeZone(utcTimeZone);
            gregorianCalendar.set(n2, n3 - 1, n4, n5, n6, n7);
            gregorianCalendar.set(14, n8);
            dateFormatLock.lock();
            try {
                ASN1OctetString aSN1OctetString = new ASN1OctetString(dateFormat.format(gregorianCalendar.getTime()));
                return aSN1OctetString;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "processValueEnd", exception));
                int n14 = 6422751;
                String string6 = MessageHandler.getMessage(n14, string, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string6, n14, exception);
            }
            finally {
                dateFormatLock.unlock();
            }
        }
        if (c == '-' || c == '+') {
            String string7;
            int n15;
            int n16 = n9 - n - 1;
            if (n16 == 2) {
                try {
                    n15 = Integer.parseInt(string.substring(n + 1)) * 3600000;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "processValueEnd", exception));
                    int n17 = 6422550;
                    string7 = MessageHandler.getMessage(n17, string, string.substring(n));
                    if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n17);
                    }
                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.MILD_ERROR, string7, n17);
                    n15 = 0;
                }
            } else if (n16 == 4) {
                try {
                    String string8 = string.substring(n + 1, n + 3);
                    String string9 = string.substring(n + 3, n + 5);
                    n15 = Integer.parseInt(string8) * 3600000 + Integer.parseInt(string9) * 1000;
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "processValueEnd", exception));
                    int n18 = 6422550;
                    string7 = MessageHandler.getMessage(n18, string, string.substring(n));
                    if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
                        throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string7, n18);
                    }
                    Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.MILD_ERROR, string7, n18);
                    n15 = 0;
                }
            } else {
                int n19 = 6422550;
                String string10 = MessageHandler.getMessage(n19, string, string.substring(n));
                if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string10, n19);
                }
                Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.MILD_ERROR, string10, n19);
                n15 = TimeZone.getDefault().getRawOffset();
            }
            GregorianCalendar gregorianCalendar = new GregorianCalendar(n2, n3 - 1, n4, n5, n6, n7);
            gregorianCalendar.setTimeZone(utcTimeZone);
            gregorianCalendar.set(14, n8);
            gregorianCalendar.set(15, n15);
            dateFormatLock.lock();
            try {
                ASN1OctetString aSN1OctetString = new ASN1OctetString(dateFormat.format(gregorianCalendar.getTime()));
                return aSN1OctetString;
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "processValueEnd", exception));
                int n20 = 6422751;
                String string11 = MessageHandler.getMessage(n20, string, StaticUtils.stackTraceToSingleLineString(exception));
                throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string11, n20, exception);
            }
            finally {
                dateFormatLock.unlock();
            }
        }
        int n21 = 6422551;
        String string12 = MessageHandler.getMessage(n21, string, Character.valueOf(c), n);
        if (DirectoryServer.getSyntaxEnforcementPolicy() == AcceptRejectWarn.REJECT) {
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string12, n21);
        }
        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.MILD_ERROR, string12, n21);
        GregorianCalendar gregorianCalendar = new GregorianCalendar(n2, n3 - 1, n4, n5, n6, n7);
        gregorianCalendar.setTimeZone(utcTimeZone);
        gregorianCalendar.set(14, n8);
        dateFormatLock.lock();
        try {
            ASN1OctetString aSN1OctetString = new ASN1OctetString(dateFormat.format(gregorianCalendar.getTime()));
            return aSN1OctetString;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "processValueEnd", exception));
            n21 = 6422751;
            string12 = MessageHandler.getMessage(n21, string, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string12, n21, exception);
        }
        finally {
            dateFormatLock.unlock();
        }
    }

    public int compareValues(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "compareValues", String.valueOf(byteString), String.valueOf(byteString2)));
        return this.compare(byteString.value(), byteString2.value());
    }

    public int compare(byte[] byArray, byte[] byArray2) {
        assert (Debug.debugEnter(CLASS_NAME, "compare", String.valueOf(byArray), String.valueOf(byArray2)));
        int n = Math.min(byArray.length, byArray2.length);
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            if (byArray[i] < byArray2[i]) {
                return -1;
            }
            if (byArray[i] <= byArray2[i]) continue;
            return 1;
        }
        if (byArray.length == byArray2.length) {
            return 0;
        }
        if (byArray.length < byArray2.length) {
            return -1;
        }
        return 1;
    }

    static {
        utcTimeZone = TimeZone.getTimeZone("UTC");
        dateFormat = new SimpleDateFormat("yyyyMMddHHmmss.SSS'Z'");
        dateFormat.setLenient(false);
        dateFormat.setTimeZone(utcTimeZone);
        dateFormatLock = new ReentrantLock();
    }
}

