/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.Arrays;
import org.opends.server.api.ApproximateMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;

public class DoubleMetaphoneApproximateMatchingRule
extends ApproximateMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.DoubleMetaphoneApproximateMatchingRule";

    public DoubleMetaphoneApproximateMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "ds-mr-double-metaphone-approx";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.26027.1.4.1";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return "Double Metaphone Approximate Match";
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.15";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        String string = byteString.stringValue();
        int n = string.length();
        if (n == 0) {
            return new ASN1OctetString();
        }
        int n2 = n - 1;
        string = string.toUpperCase() + "     ";
        StringBuilder stringBuilder = new StringBuilder(4);
        int n3 = 0;
        String string2 = string.substring(0, 2);
        if (string2.equals("GN") || string2.equals("KN") || string2.equals("PN") || string2.equals("WR") || string2.equals("PS")) {
            ++n3;
        } else if (string.charAt(0) == 'X') {
            stringBuilder.append("S");
            ++n3;
        }
        block36: while (stringBuilder.length() < 4 && n3 < n) {
            switch (string.charAt(n3)) {
                case 'A': 
                case 'E': 
                case 'I': 
                case 'O': 
                case 'U': 
                case 'Y': {
                    if (n3 == 0) {
                        stringBuilder.append("A");
                    }
                    ++n3;
                    continue block36;
                }
                case 'B': {
                    stringBuilder.append("P");
                    if (string.charAt(++n3) != 'B') continue block36;
                    ++n3;
                    continue block36;
                }
                case 'C': {
                    char c;
                    char c2;
                    char c3;
                    if (n3 > 1 && !this.isVowel(c3 = string.charAt(n3 - 2)) && this.hasSubstring(string, n3 - 1, n3 + 2, "ACH") && (c2 = string.charAt(n3 + 2)) != 'I' && (c2 != 'E' || string.charAt(n3 + 3) == 'R' && (c3 == 'B' || c3 == 'M'))) {
                        stringBuilder.append("K");
                        n3 += 2;
                        continue block36;
                    }
                    if (n3 == 0 && this.hasSubstring(string, n3 + 1, n3 + 5, "AESAR")) {
                        stringBuilder.append("S");
                        n3 += 2;
                        continue block36;
                    }
                    char c4 = string.charAt(n3 + 1);
                    if (c4 == 'H') {
                        if (this.hasSubstring(string, n3 + 2, n3 + 4, "IA")) {
                            stringBuilder.append("K");
                            n3 += 2;
                            continue block36;
                        }
                        if (this.hasSubstring(string, n3 + 2, n3 + 4, "AE")) {
                            stringBuilder.append("K");
                            n3 += 2;
                            continue block36;
                        }
                        if (n3 == 0 && !this.hasSubstring(string, 2, 5, "ORE") && (this.hasSubstring(string, 2, 6, "ARAC") || this.hasSubstring(string, 2, 6, "ARIS") || this.hasSubstring(string, 2, 4, "OR") || this.hasSubstring(string, 2, 4, "YM") || this.hasSubstring(string, 2, 4, "IA") || this.hasSubstring(string, 2, 4, "EM"))) {
                            stringBuilder.append("K");
                            n3 += 2;
                            continue block36;
                        }
                        if (this.isGermanic(string) || this.hasSubstring(string, n3 - 2, n3 + 4, "ORCHES") || this.hasSubstring(string, n3 - 2, n3 + 4, "ARCHIT") || this.hasSubstring(string, n3 - 2, n3 + 4, "ORCHID") || (c2 = string.charAt(n3 + 2)) == 'T' || c2 == 'S' || (n3 == 0 || (c = string.charAt(n3 - 1)) == 'A' || c == 'O' || c == 'U' || c == 'E') && (c2 == 'L' || c2 == 'R' || c2 == 'N' || c2 == 'M' || c2 == 'B' || c2 == 'H' || c2 == 'F' || c2 == 'V' || c2 == 'W')) {
                            stringBuilder.append("K");
                            n3 += 2;
                            continue block36;
                        }
                        if (n3 > 0) {
                            if (this.hasSubstring(string, 0, 2, "MC")) {
                                stringBuilder.append("K");
                            } else {
                                stringBuilder.append("X");
                            }
                        } else {
                            stringBuilder.append("X");
                        }
                        n3 += 2;
                        continue block36;
                    }
                    if (c4 == 'Z' && !this.hasSubstring(string, n3 - 2, n3, "WI")) {
                        stringBuilder.append("S");
                        n3 += 2;
                        continue block36;
                    }
                    if (c4 == 'I' && string.charAt(n3 + 2) == 'A') {
                        stringBuilder.append("X");
                        n3 += 3;
                        continue block36;
                    }
                    if (c4 == 'C' && (n3 != 1 || string.charAt(0) != 'M')) {
                        c2 = string.charAt(n3 + 2);
                        if (!(c2 != 'I' && c2 != 'E' && c2 != 'H' || c2 == 'H' && string.charAt(n3 + 3) == 'U')) {
                            if (n3 == 1 && string.charAt(n3 - 1) == 'A' || this.hasSubstring(string, n3 - 1, n3 + 3, "UCCEE") || this.hasSubstring(string, n3 - 1, n3 + 3, "UCCES")) {
                                stringBuilder.append("K");
                                n3 += 2;
                                continue block36;
                            }
                            stringBuilder.append("X");
                            n3 += 3;
                            continue block36;
                        }
                        stringBuilder.append("K");
                        n3 += 2;
                        continue block36;
                    }
                    c4 = string.charAt(n3 + 1);
                    if (c4 == 'K' || c4 == 'G' || c4 == 'Q') {
                        stringBuilder.append("K");
                        n3 += 2;
                        continue block36;
                    }
                    if (c4 == 'I' || c4 == 'E' || c4 == 'Y') {
                        stringBuilder.append("S");
                        n3 += 2;
                        continue block36;
                    }
                    stringBuilder.append("K");
                    switch (string.charAt(n3 + 1)) {
                        case ' ': {
                            switch (string.charAt(n3 + 2)) {
                                case 'C': 
                                case 'G': 
                                case 'Q': {
                                    n3 += 3;
                                    continue block36;
                                }
                            }
                            ++n3;
                            continue block36;
                        }
                        case 'K': 
                        case 'Q': {
                            n3 += 2;
                            continue block36;
                        }
                        case 'C': {
                            switch (string.charAt(n3 + 2)) {
                                case 'E': 
                                case 'I': {
                                    ++n3;
                                    continue block36;
                                }
                            }
                            n3 += 2;
                            continue block36;
                        }
                    }
                    ++n3;
                    continue block36;
                }
                case 'D': {
                    char c2;
                    char c4 = string.charAt(n3 + 1);
                    if (c4 == 'G') {
                        c2 = string.charAt(n3 + 2);
                        if (c2 == 'I' || c2 == 'E' || c2 == 'Y') {
                            stringBuilder.append("J");
                            n3 += 3;
                            continue block36;
                        }
                        stringBuilder.append("TK");
                        n3 += 2;
                        continue block36;
                    }
                    if (c4 == 'T' || c4 == 'D') {
                        stringBuilder.append("T");
                        n3 += 2;
                        continue block36;
                    }
                    stringBuilder.append("T");
                    ++n3;
                    continue block36;
                }
                case 'F': {
                    stringBuilder.append("F");
                    if (string.charAt(++n3) != 'F') continue block36;
                    ++n3;
                    continue block36;
                }
                case 'G': {
                    char c;
                    char c3;
                    char c4 = string.charAt(n3 + 1);
                    if (c4 == 'H') {
                        char c5;
                        char c6;
                        if (n3 > 0 && !this.isVowel(string.charAt(n3 - 1))) {
                            stringBuilder.append("K");
                            n3 += 2;
                            continue block36;
                        }
                        if (n3 == 0) {
                            if (string.charAt(n3 + 2) == 'I') {
                                stringBuilder.append("J");
                            } else {
                                stringBuilder.append("K");
                            }
                            n3 += 2;
                            continue block36;
                        }
                        if (n3 > 1 && ((c3 = string.charAt(n3 - 2)) == 'B' || c3 == 'H' || c3 == 'D') || n3 > 2 && ((c6 = string.charAt(n3 - 3)) == 'B' || c6 == 'H' || c6 == 'D') || n3 > 3 && ((c5 = string.charAt(n3 - 4)) == 'B' || c5 == 'H')) {
                            n3 += 2;
                            continue block36;
                        }
                        if (n3 > 2 && string.charAt(n3 - 1) == 'U' && ((c6 = string.charAt(n3 - 3)) == 'C' || c6 == 'G' || c6 == 'L' || c6 == 'R' || c6 == 'T')) {
                            stringBuilder.append("F");
                        } else if (n3 > 0 && string.charAt(n3 - 1) != 'I') {
                            stringBuilder.append("K");
                        }
                        n3 += 2;
                        continue block36;
                    }
                    if (c4 == 'N') {
                        if (n3 == 1 && this.isVowel(string.charAt(0)) && !this.isSlavoGermanic(string)) {
                            stringBuilder.append("KN");
                            n3 += 2;
                            continue block36;
                        }
                        if (!this.hasSubstring(string, n3 + 2, n3 + 4, "EY") && !this.isSlavoGermanic(string)) {
                            stringBuilder.append("N");
                        } else {
                            stringBuilder.append("KN");
                        }
                        n3 += 2;
                        continue block36;
                    }
                    if (c4 == 'L' && string.charAt(n3 + 2) == 'I') {
                        stringBuilder.append("KL");
                        n3 += 2;
                        continue block36;
                    }
                    if (n3 == 0 && (c4 == 'Y' || (string2 = string.substring(n3 + 1, n3 + 3)).equals("ES") || string2.equals("EP") || string2.equals("EB") || string2.equals("EL") || string2.equals("EY") || string2.equals("IB") || string2.equals("IL") || string2.equals("IN") || string2.equals("IE") || string2.equals("EI") || string2.equals("ER"))) {
                        stringBuilder.append("K");
                        n3 += 2;
                        continue block36;
                    }
                    char c2 = string.charAt(n3 + 2);
                    if (!((c4 != 'E' || c2 != 'R') && c4 != 'Y' || (c = string.charAt(n3 - 1)) == 'E' || c == 'I' || this.hasSubstring(string, 0, 6, "DANGER") || this.hasSubstring(string, 0, 6, "RANGER") || this.hasSubstring(string, 0, 6, "MANGER") || this.hasSubstring(string, n3 - 1, n3 + 2, "RGY") || this.hasSubstring(string, n3 - 1, n3 + 2, "OGY"))) {
                        stringBuilder.append("K");
                        n3 += 2;
                        continue block36;
                    }
                    if (c4 == 'E' || c4 == 'I' || c4 == 'Y' || this.hasSubstring(string, n3 - 1, n3 + 3, "AGGI") || this.hasSubstring(string, n3 - 1, n3 + 3, "OGGI")) {
                        if (this.isGermanic(string) || this.hasSubstring(string, n3 + 1, n3 + 3, "ET")) {
                            stringBuilder.append("K");
                        } else {
                            stringBuilder.append("J");
                        }
                        n3 += 2;
                        continue block36;
                    }
                    stringBuilder.append("K");
                    ++n3;
                    if (c4 != 'G') continue block36;
                    ++n3;
                    continue block36;
                }
                case 'H': {
                    if (this.isVowel(string.charAt(n3 + 1)) && (n3 == 0 || this.isVowel(string.charAt(n3 - 1)))) {
                        stringBuilder.append("H");
                        ++n3;
                    }
                    ++n3;
                    continue block36;
                }
                case 'J': {
                    if (this.hasSubstring(string, 0, 4, "SAN ")) {
                        stringBuilder.append("H");
                        ++n3;
                        continue block36;
                    }
                    if (this.hasSubstring(string, n3, n3 + 4, "JOSE")) {
                        if (n3 == 0 && string.charAt(n3 + 4) == ' ') {
                            stringBuilder.append("H");
                        } else {
                            stringBuilder.append("J");
                        }
                        ++n3;
                        continue block36;
                    }
                    stringBuilder.append("J");
                    if (string.charAt(n3 + 1) == 'J') {
                        ++n3;
                    }
                    ++n3;
                    continue block36;
                }
                case 'K': {
                    stringBuilder.append("K");
                    if (string.charAt(n3 + 1) == 'K') {
                        ++n3;
                    }
                    ++n3;
                    continue block36;
                }
                case 'L': {
                    stringBuilder.append("L");
                    if (string.charAt(n3 + 1) == 'L') {
                        ++n3;
                    }
                    ++n3;
                    continue block36;
                }
                case 'M': {
                    stringBuilder.append("M");
                    if (string.charAt(n3 + 1) == 'M') {
                        ++n3;
                    } else if (this.hasSubstring(string, n3 - 1, n3 + 2, "UMB") && (n3 + 1 == n2 || this.hasSubstring(string, n3 + 2, n3 + 4, "ER"))) {
                        ++n3;
                    }
                    ++n3;
                    continue block36;
                }
                case 'N': {
                    stringBuilder.append("N");
                    if (string.charAt(n3 + 1) == 'N') {
                        ++n3;
                    }
                    ++n3;
                    continue block36;
                }
                case 'P': {
                    char c4 = string.charAt(n3 + 1);
                    if (c4 == 'H') {
                        stringBuilder.append("F");
                        n3 += 2;
                        continue block36;
                    }
                    stringBuilder.append("P");
                    if (c4 == 'P' || c4 == 'B') {
                        ++n3;
                    }
                    ++n3;
                    continue block36;
                }
                case 'Q': {
                    stringBuilder.append("K");
                    if (string.charAt(n3 + 1) == 'Q') {
                        ++n3;
                    }
                    ++n3;
                    continue block36;
                }
                case 'R': {
                    if (n3 == n2 && !this.isSlavoGermanic(string) && this.hasSubstring(string, n3 - 2, n3, "IE") && !this.hasSubstring(string, n3 - 4, n3 - 2, "ME") && !this.hasSubstring(string, n3 - 4, n3 - 2, "MA")) {
                        ++n3;
                        continue block36;
                    }
                    stringBuilder.append("R");
                    if (string.charAt(n3 + 1) == 'R') {
                        ++n3;
                    }
                    ++n3;
                    continue block36;
                }
                case 'S': {
                    char c2;
                    if (this.hasSubstring(string, n3 - 1, n3 + 2, "ISL") || this.hasSubstring(string, n3 - 1, n3 + 2, "YSL")) {
                        ++n3;
                        continue block36;
                    }
                    if (this.hasSubstring(string, n3 + 1, n3 + 5, "UGAR")) {
                        stringBuilder.append("X");
                        ++n3;
                        continue block36;
                    }
                    char c4 = string.charAt(n3 + 1);
                    if (c4 == 'H') {
                        if (this.hasSubstring(string, n3 + 1, n3 + 5, "HEIM") || this.hasSubstring(string, n3 + 1, n3 + 5, "HOEK") || this.hasSubstring(string, n3 + 1, n3 + 5, "HOLM") || this.hasSubstring(string, n3 + 1, n3 + 5, "HOLZ")) {
                            stringBuilder.append("S");
                        } else {
                            stringBuilder.append("X");
                        }
                        n3 += 2;
                        continue block36;
                    }
                    if (this.hasSubstring(string, n3 + 1, n3 + 3, "IO") || this.hasSubstring(string, n3 + 1, n3 + 3, "IA")) {
                        stringBuilder.append("S");
                        n3 += 3;
                        continue block36;
                    }
                    if (c4 == 'Z') {
                        stringBuilder.append("S");
                        n3 += 2;
                        continue block36;
                    }
                    if (n3 == 0 && (c4 == 'M' || c4 == 'N' || c4 == 'L' || c4 == 'W')) {
                        stringBuilder.append("S");
                        ++n3;
                        continue block36;
                    }
                    if (c4 == 'C') {
                        c2 = string.charAt(n3 + 2);
                        if (c2 == 'H') {
                            if (this.hasSubstring(string, n3 + 3, n3 + 5, "OO") || this.hasSubstring(string, n3 + 3, n3 + 5, "UY") || this.hasSubstring(string, n3 + 3, n3 + 5, "ED") || this.hasSubstring(string, n3 + 3, n3 + 5, "EM")) {
                                stringBuilder.append("SK");
                            } else {
                                stringBuilder.append("X");
                            }
                            n3 += 3;
                            continue block36;
                        }
                        if (c2 == 'I' || c2 == 'E' || c2 == 'Y') {
                            stringBuilder.append("S");
                            n3 += 3;
                            continue block36;
                        }
                        stringBuilder.append("SK");
                        n3 += 3;
                        continue block36;
                    }
                    if (n3 != n2 || !this.hasSubstring(string, n3 - 2, n3, "AI") && !this.hasSubstring(string, n3 - 2, n3, "OI")) {
                        stringBuilder.append("S");
                    }
                    if (c4 == 'S' || c4 == 'Z') {
                        ++n3;
                    }
                    ++n3;
                    continue block36;
                }
                case 'T': {
                    if (this.hasSubstring(string, n3, n3 + 4, "TION") || this.hasSubstring(string, n3, n3 + 3, "TIA") || this.hasSubstring(string, n3, n3 + 3, "TCH")) {
                        stringBuilder.append("X");
                        n3 += 3;
                        continue block36;
                    }
                    char c4 = string.charAt(n3 + 1);
                    if (c4 == 'H' || c4 == 'T' && string.charAt(n3 + 2) == 'H') {
                        if (this.isGermanic(string) || this.hasSubstring(string, n3 + 2, n3 + 4, "OM") || this.hasSubstring(string, n3 + 2, n3 + 4, "AM")) {
                            stringBuilder.append("T");
                        } else {
                            stringBuilder.append("O");
                        }
                        n3 += 2;
                        continue block36;
                    }
                    stringBuilder.append("T");
                    if (c4 == 'T' || c4 == 'D') {
                        ++n3;
                    }
                    ++n3;
                    continue block36;
                }
                case 'V': {
                    stringBuilder.append("F");
                    if (string.charAt(n3 + 1) == 'V') {
                        ++n3;
                    }
                    ++n3;
                    continue block36;
                }
                case 'W': {
                    char c4 = string.charAt(n3 + 1);
                    if (c4 == 'R') {
                        stringBuilder.append("R");
                        n3 += 2;
                        continue block36;
                    }
                    if (n3 == 0 && (this.isVowel(c4) || c4 == 'H')) {
                        stringBuilder.append("A");
                        n3 += 2;
                        continue block36;
                    }
                    if (this.hasSubstring(string, n3 + 1, n3 + 4, "WICZ") || this.hasSubstring(string, n3 + 1, n3 + 4, "WITZ")) {
                        stringBuilder.append("TS");
                        n3 += 4;
                        continue block36;
                    }
                    ++n3;
                    continue block36;
                }
                case 'X': {
                    char c4;
                    if (n3 != n2 || !this.hasSubstring(string, n3 - 3, n3, "IAU") && !this.hasSubstring(string, n3 - 3, n3, "EAU") && !this.hasSubstring(string, n3 - 2, n3, "AU") && !this.hasSubstring(string, n3 - 2, n3, "OU")) {
                        stringBuilder.append("KS");
                    }
                    if ((c4 = string.charAt(n3 + 1)) == 'C' || c4 == 'X') {
                        ++n3;
                    }
                    ++n3;
                    continue block36;
                }
                case 'Z': {
                    char c4 = string.charAt(n3 + 1);
                    if (c4 == 'H') {
                        stringBuilder.append("J");
                        n3 += 2;
                        continue block36;
                    }
                    stringBuilder.append("S");
                    if (c4 == 'Z') {
                        ++n3;
                    }
                    ++n3;
                    continue block36;
                }
                case '\u00c7': {
                    stringBuilder.append("S");
                    ++n3;
                    continue block36;
                }
                case '\u00d1': {
                    stringBuilder.append("N");
                    ++n3;
                    continue block36;
                }
            }
            ++n3;
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    public boolean approximatelyMatch(ByteString byteString, ByteString byteString2) {
        assert (Debug.debugEnter(CLASS_NAME, "approximatelyMatch", String.valueOf(byteString), String.valueOf(byteString2)));
        return Arrays.equals(byteString.value(), byteString2.value());
    }

    private boolean hasSubstring(String string, int n, int n2, String string2) {
        assert (Debug.debugEnter(CLASS_NAME, "hasSubstring", String.valueOf(string), String.valueOf(n), String.valueOf(n2), String.valueOf(string2)));
        try {
            int n3 = 0;
            for (int i = n; i < n2; ++i) {
                if (string.charAt(i) != string2.charAt(n3)) {
                    return false;
                }
                ++n3;
            }
            return true;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "hasSubstring", exception));
            return false;
        }
    }

    private boolean isVowel(char c) {
        assert (Debug.debugEnter(CLASS_NAME, "isVowel", String.valueOf(c)));
        switch (c) {
            case 'A': 
            case 'E': 
            case 'I': 
            case 'O': 
            case 'U': 
            case 'Y': {
                return true;
            }
        }
        return false;
    }

    private boolean isSlavoGermanic(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isSlavoGermanic", String.valueOf(string)));
        return string.contains("W") || string.contains("K") || string.contains("CZ") || string.contains("WITZ");
    }

    private boolean isGermanic(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "isGermanic", String.valueOf(string)));
        return string.startsWith("VAN ") || string.startsWith("VON ") || string.startsWith("SCH");
    }
}

