/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import org.opends.server.api.EqualityMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

public class CaseIgnoreEqualityMatchingRule
extends EqualityMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.CaseIgnoreEqualityMatchingRule";

    public CaseIgnoreEqualityMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "caseIgnoreMatch";
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "2.5.13.2";
    }

    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return null;
    }

    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.15";
    }

    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        int n;
        int n2;
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        byte[] byArray = byteString.value();
        int n3 = byArray.length;
        for (n2 = 0; n2 < n3 && byArray[n2] == 32; ++n2) {
        }
        if (n2 == n3) {
            return new ASN1OctetString(" ");
        }
        for (n = n3 - 1; n > n2 && byArray[n] == 32; --n) {
        }
        StringBuilder stringBuilder = new StringBuilder(n - n2 + 1);
        boolean bl = false;
        block31: for (int i = n2; i <= n; ++i) {
            byte by = byArray[i];
            if ((by & 0x7F) != by) {
                return this.normalizeNonASCII(byteString);
            }
            switch (by) {
                case 32: {
                    if (bl) continue block31;
                    stringBuilder.append(' ');
                    bl = true;
                    continue block31;
                }
                case 65: {
                    stringBuilder.append('a');
                    bl = false;
                    continue block31;
                }
                case 66: {
                    stringBuilder.append('b');
                    bl = false;
                    continue block31;
                }
                case 67: {
                    stringBuilder.append('c');
                    bl = false;
                    continue block31;
                }
                case 68: {
                    stringBuilder.append('d');
                    bl = false;
                    continue block31;
                }
                case 69: {
                    stringBuilder.append('e');
                    bl = false;
                    continue block31;
                }
                case 70: {
                    stringBuilder.append('f');
                    bl = false;
                    continue block31;
                }
                case 71: {
                    stringBuilder.append('g');
                    bl = false;
                    continue block31;
                }
                case 72: {
                    stringBuilder.append('h');
                    bl = false;
                    continue block31;
                }
                case 73: {
                    stringBuilder.append('i');
                    bl = false;
                    continue block31;
                }
                case 74: {
                    stringBuilder.append('j');
                    bl = false;
                    continue block31;
                }
                case 75: {
                    stringBuilder.append('k');
                    bl = false;
                    continue block31;
                }
                case 76: {
                    stringBuilder.append('l');
                    bl = false;
                    continue block31;
                }
                case 77: {
                    stringBuilder.append('m');
                    bl = false;
                    continue block31;
                }
                case 78: {
                    stringBuilder.append('n');
                    bl = false;
                    continue block31;
                }
                case 79: {
                    stringBuilder.append('o');
                    bl = false;
                    continue block31;
                }
                case 80: {
                    stringBuilder.append('p');
                    bl = false;
                    continue block31;
                }
                case 81: {
                    stringBuilder.append('q');
                    bl = false;
                    continue block31;
                }
                case 82: {
                    stringBuilder.append('r');
                    bl = false;
                    continue block31;
                }
                case 83: {
                    stringBuilder.append('s');
                    bl = false;
                    continue block31;
                }
                case 84: {
                    stringBuilder.append('t');
                    bl = false;
                    continue block31;
                }
                case 85: {
                    stringBuilder.append('u');
                    bl = false;
                    continue block31;
                }
                case 86: {
                    stringBuilder.append('v');
                    bl = false;
                    continue block31;
                }
                case 87: {
                    stringBuilder.append('w');
                    bl = false;
                    continue block31;
                }
                case 88: {
                    stringBuilder.append('x');
                    bl = false;
                    continue block31;
                }
                case 89: {
                    stringBuilder.append('y');
                    bl = false;
                    continue block31;
                }
                case 90: {
                    stringBuilder.append('z');
                    bl = false;
                    continue block31;
                }
                default: {
                    stringBuilder.append((char)by);
                    bl = false;
                }
            }
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    private ByteString normalizeNonASCII(ByteString byteString) {
        StringBuilder stringBuilder = new StringBuilder();
        StaticUtils.toLowerCase(byteString.value(), stringBuilder, true);
        int n = stringBuilder.length();
        if (n == 0) {
            if (byteString.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return new ASN1OctetString();
        }
        for (int i = n - 1; i > 0; --i) {
            if (stringBuilder.charAt(i) != ' ' || stringBuilder.charAt(i - 1) != ' ') continue;
            stringBuilder.delete(i, i + 1);
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    public boolean areEqual(ByteString byteString, ByteString byteString2) {
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "areEqual", String.valueOf(byteString), String.valueOf(byteString2)));
        byte[] byArray = byteString.value();
        byte[] byArray2 = byteString2.value();
        if (byArray2.length != (n = byArray.length)) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }
}

