/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.schema;

import java.util.List;
import org.opends.server.api.SubstringMatchingRule;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.types.ByteString;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.types.ResultCode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CaseExactIA5SubstringMatchingRule
extends SubstringMatchingRule {
    private static final String CLASS_NAME = "org.opends.server.schema.CaseExactIA5SubstringMatchingRule";

    public CaseExactIA5SubstringMatchingRule() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
    }

    @Override
    public void initializeMatchingRule(ConfigEntry configEntry) throws ConfigException, InitializationException {
        assert (Debug.debugEnter(CLASS_NAME, "initializeMatchingRule", String.valueOf(configEntry)));
    }

    @Override
    public String getName() {
        assert (Debug.debugEnter(CLASS_NAME, "getName", new String[0]));
        return "caseExactIA5SubstringsMatch";
    }

    @Override
    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return "1.3.6.1.4.1.26027.1.4.902";
    }

    @Override
    public String getDescription() {
        assert (Debug.debugEnter(CLASS_NAME, "getDescription", new String[0]));
        return null;
    }

    @Override
    public String getSyntaxOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getSyntaxOID", new String[0]));
        return "1.3.6.1.4.1.1466.115.121.1.58";
    }

    @Override
    public ByteString normalizeValue(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "normalizeValue", String.valueOf(byteString)));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(byteString.stringValue().trim());
        int n = stringBuilder.length();
        if (n == 0) {
            if (byteString.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return new ASN1OctetString();
        }
        boolean bl = false;
        block4: for (int i = n - 1; i > 0; --i) {
            char c = stringBuilder.charAt(i);
            if (c == ' ') {
                if (stringBuilder.charAt(i - 1) != ' ') continue;
                stringBuilder.delete(i, i + 1);
                continue;
            }
            if ((c & 0x7F) == c) continue;
            int n2 = 6422610;
            String string = MessageHandler.getMessage(n2, byteString.stringValue(), Character.valueOf(c));
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n2);
                }
                case WARN: {
                    if (!bl) {
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n2);
                        bl = true;
                    }
                    stringBuilder.delete(i, i + 1);
                    continue block4;
                }
                default: {
                    stringBuilder.delete(i, i + 1);
                }
            }
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    @Override
    public ByteString normalizeSubstring(ByteString byteString) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "normalizeSubstring", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(byteString.stringValue());
        int n = stringBuilder.length();
        if (n == 0) {
            if (byteString.value().length > 0) {
                return new ASN1OctetString(" ");
            }
            return byteString;
        }
        boolean bl = false;
        block4: for (int i = n - 1; i > 0; --i) {
            char c = stringBuilder.charAt(i);
            if (c == ' ') {
                if (stringBuilder.charAt(i - 1) != ' ') continue;
                stringBuilder.delete(i, i + 1);
                continue;
            }
            if ((c & 0x7F) == c) continue;
            int n2 = 6422610;
            String string = MessageHandler.getMessage(n2, byteString.stringValue(), Character.valueOf(c));
            switch (DirectoryServer.getSyntaxEnforcementPolicy()) {
                case REJECT: {
                    throw new DirectoryException(ResultCode.INVALID_ATTRIBUTE_SYNTAX, string, n2);
                }
                case WARN: {
                    if (!bl) {
                        Error.logError(ErrorLogCategory.SCHEMA, ErrorLogSeverity.SEVERE_WARNING, string, n2);
                        bl = true;
                    }
                    stringBuilder.delete(i, i + 1);
                    continue block4;
                }
                default: {
                    stringBuilder.delete(i, i + 1);
                }
            }
        }
        return new ASN1OctetString(stringBuilder.toString());
    }

    @Override
    public boolean valueMatchesSubstring(ByteString byteString, ByteString byteString2, List<ByteString> list, ByteString byteString3) {
        int n;
        int n2;
        Object object;
        assert (Debug.debugEnter(CLASS_NAME, "valueMatchesSubstring", String.valueOf(byteString), String.valueOf(byteString2), String.valueOf(list), String.valueOf(byteString3)));
        byte[] byArray = byteString.value();
        int n3 = byArray.length;
        if (byteString2 != null) {
            object = byteString2.value();
            n2 = ((byte[])object).length;
            if (n2 > n3) {
                return false;
            }
            for (n = 0; n < n2; ++n) {
                if (object[n] == byArray[n]) continue;
                return false;
            }
        }
        if (list != null && !list.isEmpty()) {
            object = list.iterator();
            while (object.hasNext()) {
                ByteString byteString4 = (ByteString)object.next();
                byte[] byArray2 = byteString4.value();
                int n4 = byArray2.length;
                int n5 = n3 - n4;
                boolean bl = false;
                while (n <= n5) {
                    if (byArray2[0] == byArray[n]) {
                        boolean bl2 = true;
                        for (int i = 1; i < n4; ++i) {
                            if (byArray2[i] == byArray[n + i]) continue;
                            bl2 = false;
                            break;
                        }
                        if (bl2) {
                            bl = bl2;
                            break;
                        }
                    }
                    ++n;
                }
                if (bl) {
                    n += n4;
                    continue;
                }
                return false;
            }
        }
        if (byteString3 != null) {
            object = byteString3.value();
            n2 = ((byte[])object).length;
            if (n3 - n2 < n) {
                return false;
            }
            n = n3 - n2;
            int n6 = 0;
            while (n6 < n2) {
                if (object[n6] != byArray[n]) {
                    return false;
                }
                ++n6;
                ++n;
            }
        }
        return true;
    }
}

