/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.SearchResultReference;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchResultReferenceProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp";
    private List<String> referralURLs;

    public SearchResultReferenceProtocolOp(List<String> list) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(list)));
        this.referralURLs = list == null ? new ArrayList<String>() : list;
    }

    public SearchResultReferenceProtocolOp(SearchResultReference searchResultReference) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(searchResultReference)));
        this.referralURLs = searchResultReference.getReferralURLs();
        if (this.referralURLs == null) {
            this.referralURLs = new ArrayList<String>();
        }
    }

    public List<String> getReferralURLs() {
        assert (Debug.debugEnter(CLASS_NAME, "getReferralURLs", new String[0]));
        return this.referralURLs;
    }

    @Override
    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 115;
    }

    @Override
    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Search Result Reference";
    }

    @Override
    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(this.referralURLs.size());
        for (String string : this.referralURLs) {
            arrayList.add(new ASN1OctetString(string));
        }
        return new ASN1Sequence(115, arrayList);
    }

    public static SearchResultReferenceProtocolOp decodeSearchReference(ASN1Element aSN1Element) throws LDAPException {
        ArrayList<ASN1Element> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "decodeSearchReference", String.valueOf(aSN1Element)));
        try {
            arrayList = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSearchReference", exception));
            int n = 2293882;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        ArrayList<String> arrayList2 = new ArrayList<String>(arrayList.size());
        try {
            for (ASN1Element aSN1Element2 : arrayList) {
                arrayList2.add(aSN1Element2.decodeAsOctetString().stringValue());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeSearchReference", exception));
            int n = 2293883;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        return new SearchResultReferenceProtocolOp(arrayList2);
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("SearchReference(referralURLs={");
        if (!this.referralURLs.isEmpty()) {
            Iterator<String> iterator = this.referralURLs.iterator();
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                stringBuilder.append(iterator.next());
            }
        }
        stringBuilder.append("})");
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Search Result Reference");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Referral URLs:");
        stringBuilder.append(ServerConstants.EOL);
        for (String string : this.referralURLs) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("    ");
            stringBuilder.append(string);
            stringBuilder.append(ServerConstants.EOL);
        }
    }
}

