/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.ldap.AbandonRequestProtocolOp;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.IntermediateResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyDNResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.protocols.ldap.UnbindRequestProtocolOp;

public abstract class ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.ProtocolOp";

    public abstract byte getType();

    public abstract String getProtocolOpName();

    public abstract ASN1Element encode();

    public static ProtocolOp decode(ASN1Element aSN1Element) throws LDAPException {
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(aSN1Element)));
        if (aSN1Element == null) {
            int n = 2293896;
            String string = MessageHandler.getMessage(n);
            throw new LDAPException(2, n, string);
        }
        switch (aSN1Element.getType()) {
            case 66: {
                return UnbindRequestProtocolOp.decodeUnbindRequest(aSN1Element);
            }
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                int n = 2293897;
                String string = MessageHandler.getMessage(n, aSN1Element.getType());
                throw new LDAPException(2, n, string);
            }
            case 74: {
                return DeleteRequestProtocolOp.decodeDeleteRequest(aSN1Element);
            }
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: {
                int n = 2293897;
                String string = MessageHandler.getMessage(n, aSN1Element.getType());
                throw new LDAPException(2, n, string);
            }
            case 80: {
                return AbandonRequestProtocolOp.decodeAbandonRequest(aSN1Element);
            }
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                int n = 2293897;
                String string = MessageHandler.getMessage(n, aSN1Element.getType());
                throw new LDAPException(2, n, string);
            }
            case 96: {
                return BindRequestProtocolOp.decodeBindRequest(aSN1Element);
            }
            case 97: {
                return BindResponseProtocolOp.decodeBindResponse(aSN1Element);
            }
            case 98: {
                int n = 2293897;
                String string = MessageHandler.getMessage(n, aSN1Element.getType());
                throw new LDAPException(2, n, string);
            }
            case 99: {
                return SearchRequestProtocolOp.decodeSearchRequest(aSN1Element);
            }
            case 100: {
                return SearchResultEntryProtocolOp.decodeSearchEntry(aSN1Element);
            }
            case 101: {
                return SearchResultDoneProtocolOp.decodeSearchDone(aSN1Element);
            }
            case 102: {
                return ModifyRequestProtocolOp.decodeModifyRequest(aSN1Element);
            }
            case 103: {
                return ModifyResponseProtocolOp.decodeModifyResponse(aSN1Element);
            }
            case 104: {
                return AddRequestProtocolOp.decodeAddRequest(aSN1Element);
            }
            case 105: {
                return AddResponseProtocolOp.decodeAddResponse(aSN1Element);
            }
            case 106: {
                int n = 2293897;
                String string = MessageHandler.getMessage(n, aSN1Element.getType());
                throw new LDAPException(2, n, string);
            }
            case 107: {
                return DeleteResponseProtocolOp.decodeDeleteResponse(aSN1Element);
            }
            case 108: {
                return ModifyDNRequestProtocolOp.decodeModifyDNRequest(aSN1Element);
            }
            case 109: {
                return ModifyDNResponseProtocolOp.decodeModifyDNResponse(aSN1Element);
            }
            case 110: {
                return CompareRequestProtocolOp.decodeCompareRequest(aSN1Element);
            }
            case 111: {
                return CompareResponseProtocolOp.decodeCompareResponse(aSN1Element);
            }
            case 112: 
            case 113: 
            case 114: {
                int n = 2293897;
                String string = MessageHandler.getMessage(n, aSN1Element.getType());
                throw new LDAPException(2, n, string);
            }
            case 115: {
                return SearchResultReferenceProtocolOp.decodeSearchReference(aSN1Element);
            }
            case 116: 
            case 117: 
            case 118: {
                int n = 2293897;
                String string = MessageHandler.getMessage(n, aSN1Element.getType());
                throw new LDAPException(2, n, string);
            }
            case 119: {
                return ExtendedRequestProtocolOp.decodeExtendedRequest(aSN1Element);
            }
            case 120: {
                return ExtendedResponseProtocolOp.decodeExtendedResponse(aSN1Element);
            }
            case 121: {
                return IntermediateResponseProtocolOp.decodeIntermediateResponse(aSN1Element);
            }
        }
        int n = 2293897;
        String string = MessageHandler.getMessage(n, aSN1Element.getType());
        throw new LDAPException(2, n, string);
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public abstract void toString(StringBuilder var1);

    public abstract void toString(StringBuilder var1, int var2);
}

