/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Boolean;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.util.ServerConstants;

public class ModifyDNRequestProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp";
    private ASN1OctetString entryDN;
    private ASN1OctetString newRDN;
    private ASN1OctetString newSuperior;
    private boolean deleteOldRDN;

    public ModifyDNRequestProtocolOp(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, String.valueOf(aSN1OctetString), String.valueOf(aSN1OctetString2), String.valueOf(bl)));
        this.entryDN = aSN1OctetString;
        this.newRDN = aSN1OctetString2;
        this.deleteOldRDN = bl;
        this.newSuperior = null;
    }

    public ModifyDNRequestProtocolOp(ASN1OctetString aSN1OctetString, ASN1OctetString aSN1OctetString2, boolean bl, ASN1OctetString aSN1OctetString3) {
        assert (Debug.debugEnter(CLASS_NAME, String.valueOf(aSN1OctetString), String.valueOf(aSN1OctetString2), String.valueOf(bl), String.valueOf(aSN1OctetString3)));
        this.entryDN = aSN1OctetString;
        this.newRDN = aSN1OctetString2;
        this.deleteOldRDN = bl;
        this.newSuperior = aSN1OctetString3;
    }

    public ASN1OctetString getEntryDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getEntryDN", new String[0]));
        return this.entryDN;
    }

    public void setEntryDN(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setEntryDN", String.valueOf(aSN1OctetString)));
        this.entryDN = aSN1OctetString;
    }

    public ASN1OctetString getNewRDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getNewRDN", new String[0]));
        return this.newRDN;
    }

    public void setNewRDN(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setNewRDN", String.valueOf(aSN1OctetString)));
        this.newRDN = aSN1OctetString;
    }

    public boolean deleteOldRDN() {
        assert (Debug.debugEnter(CLASS_NAME, "deleteOldRDN", new String[0]));
        return this.deleteOldRDN;
    }

    public void setDeleteOldRDN(boolean bl) {
        assert (Debug.debugEnter(CLASS_NAME, "setDeleteOldRDN", String.valueOf(bl)));
        this.deleteOldRDN = bl;
    }

    public ASN1OctetString getNewSuperior() {
        assert (Debug.debugEnter(CLASS_NAME, "getNewSuperior", new String[0]));
        return this.newSuperior;
    }

    public void setNewSuperior(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setNewSuperior", String.valueOf(aSN1OctetString)));
        this.newSuperior = aSN1OctetString;
    }

    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 108;
    }

    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Modify DN Request";
    }

    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(4);
        arrayList.add(this.entryDN);
        arrayList.add(this.newRDN);
        arrayList.add(new ASN1Boolean(this.deleteOldRDN));
        if (this.newSuperior != null) {
            this.newSuperior.setType((byte)-128);
            arrayList.add(this.newSuperior);
        }
        return new ASN1Sequence(108, arrayList);
    }

    public static ModifyDNRequestProtocolOp decodeModifyDNRequest(ASN1Element aSN1Element) throws LDAPException {
        ASN1OctetString aSN1OctetString;
        boolean bl;
        ASN1OctetString aSN1OctetString2;
        ASN1OctetString aSN1OctetString3;
        ArrayList<ASN1Element> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "decodeModifyDNRequest", String.valueOf(aSN1Element)));
        try {
            arrayList = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeModifyDNRequest", exception));
            int n = 2293855;
            String string = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string, exception);
        }
        int n = arrayList.size();
        if (n < 3 || n > 4) {
            int n2 = 2293856;
            String string = MessageHandler.getMessage(n2, n);
            throw new LDAPException(2, n2, string);
        }
        try {
            aSN1OctetString3 = arrayList.get(0).decodeAsOctetString();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeModifyDNRequest", exception));
            int n3 = 2293857;
            String string = MessageHandler.getMessage(n3, String.valueOf(exception));
            throw new LDAPException(2, n3, string, exception);
        }
        try {
            aSN1OctetString2 = arrayList.get(1).decodeAsOctetString();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeModifyDNRequest", exception));
            int n4 = 2293858;
            String string = MessageHandler.getMessage(n4, String.valueOf(exception));
            throw new LDAPException(2, n4, string, exception);
        }
        try {
            bl = arrayList.get(2).decodeAsBoolean().booleanValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeModifyDNRequest", exception));
            int n5 = 2293859;
            String string = MessageHandler.getMessage(n5, String.valueOf(exception));
            throw new LDAPException(2, n5, string, exception);
        }
        if (n == 4) {
            try {
                aSN1OctetString = arrayList.get(3).decodeAsOctetString();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "decodeModifyDNRequest", exception));
                int n6 = 2293860;
                String string = MessageHandler.getMessage(n6, String.valueOf(exception));
                throw new LDAPException(2, n6, string, exception);
            }
        } else {
            aSN1OctetString = null;
        }
        return new ModifyDNRequestProtocolOp(aSN1OctetString3, aSN1OctetString2, bl, aSN1OctetString);
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ModifyDNRequest(dn=");
        this.entryDN.toString(stringBuilder);
        stringBuilder.append(", newRDN=");
        this.newRDN.toString(stringBuilder);
        stringBuilder.append(", deleteOldRDN=");
        stringBuilder.append(this.deleteOldRDN);
        if (this.newSuperior != null) {
            stringBuilder.append(", newSuperior=");
            this.newSuperior.toString(stringBuilder);
        }
        stringBuilder.append(")");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Modify DN Request");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Entry DN:  ");
        this.entryDN.toString(stringBuilder);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  New RDN:  ");
        this.newRDN.toString(stringBuilder);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Delete Old RDN:  ");
        stringBuilder.append(this.deleteOldRDN);
        stringBuilder.append(ServerConstants.EOL);
        if (this.newSuperior != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  New Superior:  ");
            this.newSuperior.toString(stringBuilder);
            stringBuilder.append(ServerConstants.EOL);
        }
    }
}

