/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.spi.AbstractSelectableChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.api.DirectoryThread;
import org.opends.server.api.ServerShutdownListener;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.ldap.LDAPClientConnection;
import org.opends.server.protocols.ldap.LDAPConnectionHandler;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.InitializationException;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPRequestHandler
extends DirectoryThread
implements ServerShutdownListener {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.LDAPRequestHandler";
    public static final int BUFFER_SIZE = 8192;
    private boolean shutdownRequested;
    private ConcurrentLinkedQueue<LDAPClientConnection> pendingConnections;
    private LDAPConnectionHandler connectionHandler;
    private Selector selector;
    private String handlerName;

    public LDAPRequestHandler(LDAPConnectionHandler lDAPConnectionHandler, int n) throws InitializationException {
        block6: {
            super("LDAP Request Handler " + n + " for connection handler " + lDAPConnectionHandler.toString());
            assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(lDAPConnectionHandler)));
            this.connectionHandler = lDAPConnectionHandler;
            this.handlerName = this.getName();
            this.pendingConnections = new ConcurrentLinkedQueue();
            try {
                this.selector = Selector.open();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "<init>", exception));
                int n2 = 2425018;
                String string = MessageHandler.getMessage(n2, this.handlerName, String.valueOf(exception));
                throw new InitializationException(n2, string, exception);
            }
            try {
                this.selector.selectNow();
            }
            catch (IOException iOException) {
                StackTraceElement stackTraceElement;
                StackTraceElement[] stackTraceElementArray = iOException.getStackTrace();
                if (stackTraceElementArray == null || stackTraceElementArray.length <= 0 || !(stackTraceElement = stackTraceElementArray[0]).getClassName().equals("sun.nio.ch.DevPollArrayWrapper") || stackTraceElement.getMethodName().indexOf("poll") < 0 || !iOException.getMessage().equalsIgnoreCase("Invalid argument")) break block6;
                int n3 = 2425219;
                String string = MessageHandler.getMessage(n3, String.valueOf(iOException));
                throw new InitializationException(n3, string, iOException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        assert (Debug.debugEnter(CLASS_NAME, "run", new String[0]));
        while (!this.shutdownRequested) {
            Object object;
            Object object2;
            int n;
            block26: {
                n = 0;
                try {
                    n = this.selector.select();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "run", exception)) break block26;
                    throw new AssertionError();
                }
            }
            if (n > 0) {
                object2 = this.selector.selectedKeys().iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    try {
                        if (((SelectionKey)object).isReadable()) {
                            LDAPClientConnection lDAPClientConnection = null;
                            try {
                                lDAPClientConnection = (LDAPClientConnection)((SelectionKey)object).attachment();
                                try {
                                    ConnectionSecurityProvider connectionSecurityProvider = lDAPClientConnection.getConnectionSecurityProvider();
                                    if (connectionSecurityProvider.readData()) continue;
                                    ((SelectionKey)object).cancel();
                                }
                                catch (Exception exception) {
                                    assert (Debug.debugException(CLASS_NAME, "run", exception));
                                    ((SelectionKey)object).cancel();
                                    lDAPClientConnection.disconnect(DisconnectReason.SERVER_ERROR, false, String.valueOf(exception), -1);
                                }
                            }
                            catch (Exception exception) {
                                assert (Debug.debugException(CLASS_NAME, "run", exception));
                                ((SelectionKey)object).cancel();
                                if (lDAPClientConnection == null) continue;
                                lDAPClientConnection.disconnect(DisconnectReason.SERVER_ERROR, false, String.valueOf(exception), -1);
                            }
                            continue;
                        }
                        if (((SelectionKey)object).isValid()) continue;
                        ((SelectionKey)object).cancel();
                    }
                    catch (CancelledKeyException cancelledKeyException) {
                        assert (Debug.debugException(CLASS_NAME, "run", cancelledKeyException));
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "run", exception));
                        int n2 = 2359509;
                        String string = MessageHandler.getMessage(n2, this.getName(), StaticUtils.stackTraceToSingleLineString(exception));
                        Error.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.SEVERE_ERROR, string, n2);
                    }
                    finally {
                        object2.remove();
                    }
                }
            }
            while (!this.pendingConnections.isEmpty()) {
                object2 = (LDAPClientConnection)this.pendingConnections.remove();
                try {
                    object = ((LDAPClientConnection)object2).getSocketChannel();
                    ((AbstractSelectableChannel)object).configureBlocking(false);
                    ((AbstractSelectableChannel)object).register(this.selector, 1, object2);
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "run", exception));
                    ((ClientConnection)object2).disconnect(DisconnectReason.SERVER_ERROR, true, 2425019, this.handlerName, String.valueOf(exception));
                }
            }
        }
    }

    public boolean registerClient(LDAPClientConnection lDAPClientConnection) {
        assert (Debug.debugEnter(CLASS_NAME, "registerClient", String.valueOf(lDAPClientConnection)));
        if (this.shutdownRequested) {
            lDAPClientConnection.disconnect(DisconnectReason.SERVER_SHUTDOWN, true, 2425020, new Object[0]);
            return false;
        }
        if (this.pendingConnections.offer(lDAPClientConnection)) {
            this.selector.wakeup();
            return true;
        }
        lDAPClientConnection.disconnect(DisconnectReason.ADMIN_LIMIT_EXCEEDED, true, 2425021, this.handlerName);
        return false;
    }

    public void deregisterClient(LDAPClientConnection lDAPClientConnection) {
        SelectionKey[] selectionKeyArray;
        assert (Debug.debugEnter(CLASS_NAME, "deregisterClient", String.valueOf(lDAPClientConnection)));
        for (SelectionKey selectionKey : selectionKeyArray = this.selector.keys().toArray(new SelectionKey[0])) {
            block7: {
                LDAPClientConnection lDAPClientConnection2 = (LDAPClientConnection)selectionKey.attachment();
                if (!lDAPClientConnection.equals(lDAPClientConnection2)) continue;
                try {
                    selectionKey.channel().close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "deregisterClient", exception)) break block7;
                    throw new AssertionError();
                }
            }
            try {
                selectionKey.cancel();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "deregisterClient", exception));
            }
        }
    }

    public void deregisterAllClients() {
        SelectionKey[] selectionKeyArray;
        assert (Debug.debugEnter(CLASS_NAME, "deregisterAllClients", new String[0]));
        for (SelectionKey selectionKey : selectionKeyArray = this.selector.keys().toArray(new SelectionKey[0])) {
            block7: {
                try {
                    selectionKey.channel().close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "deregisterAllClients", exception)) break block7;
                    throw new AssertionError();
                }
            }
            try {
                selectionKey.cancel();
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "deregisterAllClients", exception));
            }
        }
    }

    public Collection<LDAPClientConnection> getClientConnections() {
        assert (Debug.debugEnter(CLASS_NAME, "getClientConnections", new String[0]));
        SelectionKey[] selectionKeyArray = this.selector.keys().toArray(new SelectionKey[0]);
        ArrayList<LDAPClientConnection> arrayList = new ArrayList<LDAPClientConnection>(selectionKeyArray.length);
        for (SelectionKey selectionKey : selectionKeyArray) {
            arrayList.add((LDAPClientConnection)selectionKey.attachment());
        }
        return arrayList;
    }

    @Override
    public String getShutdownListenerName() {
        assert (Debug.debugEnter(CLASS_NAME, "getShutdownListenerName", new String[0]));
        return this.handlerName;
    }

    public void registerShutdownListener() {
        assert (Debug.debugEnter(CLASS_NAME, "registerShutdownListener", new String[0]));
        DirectoryServer.registerShutdownListener(this);
    }

    @Override
    public void processServerShutdown(String string) {
        block9: {
            assert (Debug.debugEnter(CLASS_NAME, "processServerShutdown", String.valueOf(string)));
            this.shutdownRequested = true;
            Collection<LDAPClientConnection> collection = this.getClientConnections();
            this.deregisterAllClients();
            if (collection != null) {
                for (LDAPClientConnection lDAPClientConnection : collection) {
                    try {
                        lDAPClientConnection.disconnect(DisconnectReason.SERVER_SHUTDOWN, true, 2425022, string);
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "processServerShutdown", exception));
                    }
                }
            }
            try {
                if (this.selector != null) {
                    this.selector.wakeup();
                }
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "processServerShutdown", exception)) break block9;
                throw new AssertionError();
            }
        }
    }
}

