/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import org.opends.server.api.ProtocolElement;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.AbandonRequestProtocolOp;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyDNResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.protocols.ldap.UnbindRequestProtocolOp;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPMessage
implements ProtocolElement {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.LDAPMessage";
    private ArrayList<LDAPControl> controls;
    private int messageID;
    private ProtocolOp protocolOp;

    public LDAPMessage(int n, ProtocolOp protocolOp) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(n), String.valueOf(protocolOp)));
        this.messageID = n;
        this.protocolOp = protocolOp;
        this.controls = new ArrayList(0);
    }

    public LDAPMessage(int n, ProtocolOp protocolOp, ArrayList<LDAPControl> arrayList) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(n), String.valueOf(protocolOp), String.valueOf(arrayList)));
        this.messageID = n;
        this.protocolOp = protocolOp;
        this.controls = arrayList == null ? new ArrayList(0) : arrayList;
    }

    public int getMessageID() {
        assert (Debug.debugEnter(CLASS_NAME, "getMessageID", new String[0]));
        return this.messageID;
    }

    public void setMessageID(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setMessageID", String.valueOf(n)));
        this.messageID = n;
    }

    public ProtocolOp getProtocolOp() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOp", new String[0]));
        return this.protocolOp;
    }

    public byte getProtocolOpType() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpType", new String[0]));
        return this.protocolOp.getType();
    }

    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return this.protocolOp.getProtocolOpName();
    }

    public AbandonRequestProtocolOp getAbandonRequestProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getAbandonRequestProtocolOp", new String[0]));
        return (AbandonRequestProtocolOp)this.protocolOp;
    }

    public AddRequestProtocolOp getAddRequestProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getAddRequestProtocolOp", new String[0]));
        return (AddRequestProtocolOp)this.protocolOp;
    }

    public AddResponseProtocolOp getAddResponseProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getAddResponseProtocolOp", new String[0]));
        return (AddResponseProtocolOp)this.protocolOp;
    }

    public BindRequestProtocolOp getBindRequestProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getBindRequestProtocolOp", new String[0]));
        return (BindRequestProtocolOp)this.protocolOp;
    }

    public BindResponseProtocolOp getBindResponseProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getBindResponseProtocolOp", new String[0]));
        return (BindResponseProtocolOp)this.protocolOp;
    }

    public CompareRequestProtocolOp getCompareRequestProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getCompareRequestProtocolOp", new String[0]));
        return (CompareRequestProtocolOp)this.protocolOp;
    }

    public CompareResponseProtocolOp getCompareResponseProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getCompareResponseProtocolOp", new String[0]));
        return (CompareResponseProtocolOp)this.protocolOp;
    }

    public DeleteRequestProtocolOp getDeleteRequestProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getDeleteRequestProtocolOp", new String[0]));
        return (DeleteRequestProtocolOp)this.protocolOp;
    }

    public DeleteResponseProtocolOp getDeleteResponseProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getDeleteResponseProtocolOp", new String[0]));
        return (DeleteResponseProtocolOp)this.protocolOp;
    }

    public ExtendedRequestProtocolOp getExtendedRequestProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getExtendedRequestProtocolOp", new String[0]));
        return (ExtendedRequestProtocolOp)this.protocolOp;
    }

    public ExtendedResponseProtocolOp getExtendedResponseProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getExtendedResponseProtocolOp", new String[0]));
        return (ExtendedResponseProtocolOp)this.protocolOp;
    }

    public ModifyRequestProtocolOp getModifyRequestProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getModifyRequestProtocolOp", new String[0]));
        return (ModifyRequestProtocolOp)this.protocolOp;
    }

    public ModifyResponseProtocolOp getModifyResponseProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getModifyResponseProtocolOp", new String[0]));
        return (ModifyResponseProtocolOp)this.protocolOp;
    }

    public ModifyDNRequestProtocolOp getModifyDNRequestProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getModifyDNRequestProtocolOp", new String[0]));
        return (ModifyDNRequestProtocolOp)this.protocolOp;
    }

    public ModifyDNResponseProtocolOp getModifyDNResponseProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getModifyDNResponseProtocolOp", new String[0]));
        return (ModifyDNResponseProtocolOp)this.protocolOp;
    }

    public SearchRequestProtocolOp getSearchRequestProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getSearchRequestProtocolOp", new String[0]));
        return (SearchRequestProtocolOp)this.protocolOp;
    }

    public SearchResultDoneProtocolOp getSearchResultDoneProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getSearchResultDoneProtocolOp", new String[0]));
        return (SearchResultDoneProtocolOp)this.protocolOp;
    }

    public SearchResultEntryProtocolOp getSearchResultEntryProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getSearchResultEntryProtocolOp", new String[0]));
        return (SearchResultEntryProtocolOp)this.protocolOp;
    }

    public SearchResultReferenceProtocolOp getSearchResultReferenceProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getSearchResultReferenceProtocolOp", new String[0]));
        return (SearchResultReferenceProtocolOp)this.protocolOp;
    }

    public UnbindRequestProtocolOp getUnbindRequestProtocolOp() throws ClassCastException {
        assert (Debug.debugEnter(CLASS_NAME, "getUnbindRequestProtocolOp", new String[0]));
        return (UnbindRequestProtocolOp)this.protocolOp;
    }

    public void setProtocolOp(ProtocolOp protocolOp) {
        assert (Debug.debugEnter(CLASS_NAME, "setProtocolOp", String.valueOf(protocolOp)));
        this.protocolOp = protocolOp;
    }

    public ArrayList<LDAPControl> getControls() {
        assert (Debug.debugEnter(CLASS_NAME, "getControls", new String[0]));
        return this.controls;
    }

    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(3);
        arrayList.add(new ASN1Integer(this.messageID));
        arrayList.add(this.protocolOp.encode());
        if (!this.controls.isEmpty()) {
            arrayList.add(LDAPControl.encodeControls(this.controls));
        }
        return new ASN1Sequence(arrayList);
    }

    public static LDAPMessage decode(ASN1Sequence aSN1Sequence) throws LDAPException {
        ArrayList<LDAPControl> arrayList;
        ProtocolOp protocolOp;
        int n;
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(aSN1Sequence)));
        if (aSN1Sequence == null) {
            int n2 = 2293805;
            String string = MessageHandler.getMessage(n2);
            throw new LDAPException(2, n2, string);
        }
        ArrayList<ASN1Element> arrayList2 = aSN1Sequence.elements();
        int n3 = arrayList2.size();
        if (n3 < 2 || n3 > 3) {
            int n4 = 2293806;
            String string = MessageHandler.getMessage(n4, n3);
            throw new LDAPException(2, n4, string);
        }
        try {
            n = arrayList2.get(0).decodeAsInteger().intValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n5 = 2293807;
            String string = MessageHandler.getMessage(n5, String.valueOf(exception));
            throw new LDAPException(2, n5, string, exception);
        }
        try {
            protocolOp = ProtocolOp.decode(arrayList2.get(1));
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n6 = 0x230030;
            String string = MessageHandler.getMessage(n6, String.valueOf(exception));
            throw new LDAPException(2, n6, string, exception);
        }
        if (n3 == 3) {
            try {
                arrayList = LDAPControl.decodeControls(arrayList2.get(2));
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "decode", exception));
                int n7 = 2293809;
                String string = MessageHandler.getMessage(n7, String.valueOf(exception));
                throw new LDAPException(2, n7, string, exception);
            }
        } else {
            arrayList = new ArrayList(0);
        }
        return new LDAPMessage(n, protocolOp, arrayList);
    }

    @Override
    public String getProtocolElementName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolElementName", new String[0]));
        return "LDAP";
    }

    @Override
    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("LDAPMessage(msgID=");
        stringBuilder.append(this.messageID);
        stringBuilder.append(", protocolOp=");
        this.protocolOp.toString(stringBuilder);
        if (!this.controls.isEmpty()) {
            stringBuilder.append(", controls={ ");
            Iterator<LDAPControl> iterator = this.controls.iterator();
            iterator.next().toString(stringBuilder);
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                iterator.next().toString(stringBuilder);
            }
            stringBuilder.append(" }");
        }
        stringBuilder.append(")");
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("LDAP Message");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Message ID:  ");
        stringBuilder.append(this.messageID);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Protocol Op:");
        stringBuilder.append(ServerConstants.EOL);
        this.protocolOp.toString(stringBuilder, n + 4);
        if (!this.controls.isEmpty()) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Controls:");
            for (LDAPControl lDAPControl : this.controls) {
                lDAPControl.toString(stringBuilder, n + 4);
            }
        }
    }
}

