/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.io.Serializable;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import org.opends.server.api.ClientConnection;
import org.opends.server.api.ConnectionHandler;
import org.opends.server.api.ConnectionSecurityProvider;
import org.opends.server.api.ProtocolElement;
import org.opends.server.core.AbandonOperation;
import org.opends.server.core.AddOperation;
import org.opends.server.core.BindOperation;
import org.opends.server.core.CompareOperation;
import org.opends.server.core.DeleteOperation;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.ExtendedOperation;
import org.opends.server.core.ModifyDNOperation;
import org.opends.server.core.ModifyOperation;
import org.opends.server.core.Operation;
import org.opends.server.core.PersistentSearch;
import org.opends.server.core.PluginConfigManager;
import org.opends.server.core.SearchOperation;
import org.opends.server.core.UnbindOperation;
import org.opends.server.extensions.NullConnectionSecurityProvider;
import org.opends.server.extensions.TLSCapableConnection;
import org.opends.server.extensions.TLSConnectionSecurityProvider;
import org.opends.server.loggers.Access;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.AbandonRequestProtocolOp;
import org.opends.server.protocols.ldap.AddRequestProtocolOp;
import org.opends.server.protocols.ldap.AddResponseProtocolOp;
import org.opends.server.protocols.ldap.BindRequestProtocolOp;
import org.opends.server.protocols.ldap.BindResponseProtocolOp;
import org.opends.server.protocols.ldap.CompareRequestProtocolOp;
import org.opends.server.protocols.ldap.CompareResponseProtocolOp;
import org.opends.server.protocols.ldap.DeleteRequestProtocolOp;
import org.opends.server.protocols.ldap.DeleteResponseProtocolOp;
import org.opends.server.protocols.ldap.ExtendedRequestProtocolOp;
import org.opends.server.protocols.ldap.ExtendedResponseProtocolOp;
import org.opends.server.protocols.ldap.IntermediateResponseProtocolOp;
import org.opends.server.protocols.ldap.LDAPConnectionHandler;
import org.opends.server.protocols.ldap.LDAPControl;
import org.opends.server.protocols.ldap.LDAPMessage;
import org.opends.server.protocols.ldap.LDAPRequestHandler;
import org.opends.server.protocols.ldap.LDAPStatistics;
import org.opends.server.protocols.ldap.ModifyDNRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyDNResponseProtocolOp;
import org.opends.server.protocols.ldap.ModifyRequestProtocolOp;
import org.opends.server.protocols.ldap.ModifyResponseProtocolOp;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.protocols.ldap.SearchRequestProtocolOp;
import org.opends.server.protocols.ldap.SearchResultDoneProtocolOp;
import org.opends.server.protocols.ldap.SearchResultEntryProtocolOp;
import org.opends.server.protocols.ldap.SearchResultReferenceProtocolOp;
import org.opends.server.types.ByteString;
import org.opends.server.types.CancelRequest;
import org.opends.server.types.CancelResult;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DirectoryException;
import org.opends.server.types.DisconnectReason;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.IntermediateResponse;
import org.opends.server.types.ResultCode;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPClientConnection
extends ClientConnection
implements TLSCapableConnection {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.LDAPClientConnection";
    private AtomicLong nextOperationID;
    private boolean connectionValid;
    private boolean disconnectRequested;
    private boolean keepStats;
    private byte elementType;
    private byte[] elementValue;
    private ConcurrentHashMap<Integer, Operation> operationsInProgress;
    private ConnectionSecurityProvider clearSecurityProvider;
    private ConnectionSecurityProvider securityProvider;
    private int clientPort;
    private int elementLength;
    private int elementLengthBytesNeeded;
    private int elementReadState;
    private int elementValueBytesRead;
    private int elementValueBytesNeeded;
    private int ldapVersion;
    private int serverPort;
    private LDAPConnectionHandler connectionHandler;
    private LDAPRequestHandler requestHandler;
    private LDAPStatistics statTracker;
    private long connectionID;
    private ReentrantLock opsInProgressLock;
    private ReentrantLock transmitLock;
    private SocketChannel clientChannel;
    private String clientAddress;
    private String serverAddress;
    private TLSConnectionSecurityProvider tlsSecurityProvider;

    public LDAPClientConnection(LDAPConnectionHandler lDAPConnectionHandler, SocketChannel socketChannel) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(lDAPConnectionHandler), String.valueOf(socketChannel)));
        this.connectionHandler = lDAPConnectionHandler;
        this.clientChannel = socketChannel;
        this.securityProvider = null;
        this.clearSecurityProvider = null;
        this.opsInProgressLock = new ReentrantLock();
        this.transmitLock = new ReentrantLock();
        this.elementReadState = 0;
        this.elementType = 0;
        this.elementLength = 0;
        this.elementLengthBytesNeeded = 0;
        this.elementValue = null;
        this.elementValueBytesRead = 0;
        this.elementValueBytesNeeded = 0;
        this.ldapVersion = 3;
        this.requestHandler = null;
        this.nextOperationID = new AtomicLong(0L);
        this.connectionValid = true;
        this.disconnectRequested = false;
        this.operationsInProgress = new ConcurrentHashMap();
        this.keepStats = lDAPConnectionHandler.keepStats();
        this.clientAddress = socketChannel.socket().getInetAddress().getHostAddress();
        this.clientPort = socketChannel.socket().getPort();
        this.serverAddress = socketChannel.socket().getLocalAddress().getHostAddress();
        this.serverPort = socketChannel.socket().getLocalPort();
        LDAPStatistics lDAPStatistics = lDAPConnectionHandler.getStatTracker();
        String string = lDAPStatistics.getMonitorInstanceName() + " for " + this.toString();
        this.statTracker = new LDAPStatistics(string, lDAPStatistics);
        if (this.keepStats) {
            this.statTracker.updateConnect();
        }
        this.connectionID = DirectoryServer.newConnectionAccepted(this);
        if (this.connectionID < 0L) {
            this.disconnect(DisconnectReason.ADMIN_LIMIT_EXCEEDED, true, 2293974, new Object[0]);
        }
    }

    @Override
    public long getConnectionID() {
        assert (Debug.debugEnter(CLASS_NAME, "getConnectionID", new String[0]));
        return this.connectionID;
    }

    @Override
    public ConnectionHandler getConnectionHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "getConnectionHandler", new String[0]));
        return this.connectionHandler;
    }

    public LDAPRequestHandler getRequestHandler() {
        assert (Debug.debugEnter(CLASS_NAME, "getRequestHandler", new String[0]));
        return this.requestHandler;
    }

    public void setRequestHandler(LDAPRequestHandler lDAPRequestHandler) {
        assert (Debug.debugEnter(CLASS_NAME, "setRequestHandler", String.valueOf(lDAPRequestHandler)));
        this.requestHandler = lDAPRequestHandler;
    }

    public SocketChannel getSocketChannel() {
        assert (Debug.debugEnter(CLASS_NAME, "getSocketChannel", new String[0]));
        return this.clientChannel;
    }

    @Override
    public String getProtocol() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocol", new String[0]));
        return "LDAP";
    }

    @Override
    public String getClientAddress() {
        assert (Debug.debugEnter(CLASS_NAME, "getClientAddress", new String[0]));
        return this.clientAddress;
    }

    public int getClientPort() {
        assert (Debug.debugEnter(CLASS_NAME, "getClientPort", new String[0]));
        return this.clientPort;
    }

    public String getClientHostPort() {
        return this.clientAddress + ":" + this.clientPort;
    }

    @Override
    public String getServerAddress() {
        assert (Debug.debugEnter(CLASS_NAME, "getServerAddress", new String[0]));
        return this.serverAddress;
    }

    public int getServerPort() {
        assert (Debug.debugEnter(CLASS_NAME, "getServerPort", new String[0]));
        return this.serverPort;
    }

    public String getServerHostPort() {
        return this.serverAddress + ":" + this.serverPort;
    }

    @Override
    public InetAddress getRemoteAddress() {
        assert (Debug.debugEnter(CLASS_NAME, "getRemoteAddress", new String[0]));
        return this.clientChannel.socket().getInetAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        assert (Debug.debugEnter(CLASS_NAME, "getLocalAddress", new String[0]));
        return this.clientChannel.socket().getLocalAddress();
    }

    @Override
    public boolean isSecure() {
        assert (Debug.debugEnter(CLASS_NAME, "isSecure", new String[0]));
        return this.securityProvider.isSecure();
    }

    @Override
    public ConnectionSecurityProvider getConnectionSecurityProvider() {
        assert (Debug.debugEnter(CLASS_NAME, "getConnectionSecurityProvider", new String[0]));
        return this.securityProvider;
    }

    @Override
    public void setConnectionSecurityProvider(ConnectionSecurityProvider connectionSecurityProvider) {
        assert (Debug.debugEnter(CLASS_NAME, "setConnectionSecurityProvider", String.valueOf(connectionSecurityProvider)));
        this.securityProvider = connectionSecurityProvider;
    }

    @Override
    public String getSecurityMechanism() {
        assert (Debug.debugEnter(CLASS_NAME, "getSecurityMechanism", new String[0]));
        return this.securityProvider.getSecurityMechanismName();
    }

    public long nextOperationID() {
        assert (Debug.debugEnter(CLASS_NAME, "nextOperationID", new String[0]));
        return this.nextOperationID.getAndIncrement();
    }

    @Override
    public void sendResponse(Operation operation) {
        assert (Debug.debugEnter(CLASS_NAME, "sendResponse", String.valueOf(operation)));
        LDAPMessage lDAPMessage = this.operationToResponseLDAPMessage(operation);
        if (lDAPMessage != null) {
            this.sendLDAPMessage(this.securityProvider, lDAPMessage);
        }
    }

    private LDAPMessage operationToResponseLDAPMessage(Operation operation) {
        List<Control> list;
        Serializable serializable;
        Object object;
        List<String> list2;
        assert (Debug.debugEnter(CLASS_NAME, "operationToResponseLDAPMessage", String.valueOf(operation)));
        ResultCode resultCode = operation.getResultCode();
        if (resultCode == null) {
            Error.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.MILD_ERROR, 2293919, operation.getOperationType().toString(), operation.getConnectionID(), operation.getOperationID());
            resultCode = DirectoryServer.getServerErrorResultCode();
        }
        StringBuilder stringBuilder = operation.getErrorMessage();
        DN dN = operation.getMatchedDN();
        if (this.ldapVersion == 2) {
            list2 = null;
            if (resultCode == ResultCode.REFERRAL) {
                resultCode = ResultCode.CONSTRAINT_VIOLATION;
                stringBuilder.append(MessageHandler.getMessage(2293968));
            }
            if ((object = operation.getReferralURLs()) != null && !object.isEmpty()) {
                serializable = new StringBuilder();
                list = object.iterator();
                ((StringBuilder)serializable).append((String)list.next());
                while (list.hasNext()) {
                    ((StringBuilder)serializable).append(", ");
                    ((StringBuilder)serializable).append((String)list.next());
                }
                stringBuilder.append(MessageHandler.getMessage(2293969, String.valueOf(serializable)));
            }
        } else {
            list2 = operation.getReferralURLs();
        }
        switch (operation.getOperationType()) {
            case ADD: {
                object = new AddResponseProtocolOp(resultCode.getIntValue(), stringBuilder.toString(), dN, list2);
                break;
            }
            case BIND: {
                serializable = ((BindOperation)operation).getServerSASLCredentials();
                object = new BindResponseProtocolOp(resultCode.getIntValue(), stringBuilder.toString(), dN, list2, (ASN1OctetString)serializable);
                break;
            }
            case COMPARE: {
                object = new CompareResponseProtocolOp(resultCode.getIntValue(), stringBuilder.toString(), dN, list2);
                break;
            }
            case DELETE: {
                object = new DeleteResponseProtocolOp(resultCode.getIntValue(), stringBuilder.toString(), dN, list2);
                break;
            }
            case EXTENDED: {
                if (this.ldapVersion == 2) {
                    Error.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.MILD_WARNING, 2293966, this.getConnectionID(), String.valueOf(operation));
                    return null;
                }
                list = (ExtendedOperation)operation;
                object = new ExtendedResponseProtocolOp(resultCode.getIntValue(), stringBuilder.toString(), dN, list2, ((ExtendedOperation)((Object)list)).getResponseOID(), ((ExtendedOperation)((Object)list)).getResponseValue());
                break;
            }
            case MODIFY: {
                object = new ModifyResponseProtocolOp(resultCode.getIntValue(), stringBuilder.toString(), dN, list2);
                break;
            }
            case MODIFY_DN: {
                object = new ModifyDNResponseProtocolOp(resultCode.getIntValue(), stringBuilder.toString(), dN, list2);
                break;
            }
            case SEARCH: {
                object = new SearchResultDoneProtocolOp(resultCode.getIntValue(), stringBuilder.toString(), dN, list2);
                break;
            }
            default: {
                Error.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.MILD_ERROR, 2293920, String.valueOf(operation));
                return null;
            }
        }
        if (this.ldapVersion == 2) {
            serializable = null;
        } else {
            list = operation.getResponseControls();
            if (list == null || list.isEmpty()) {
                serializable = null;
            } else {
                serializable = new ArrayList(list.size());
                for (Control control : list) {
                    ((ArrayList)serializable).add(new LDAPControl(control));
                }
            }
        }
        return new LDAPMessage(operation.getMessageID(), (ProtocolOp)object, (ArrayList<LDAPControl>)serializable);
    }

    @Override
    public void sendSearchEntry(SearchOperation searchOperation, SearchResultEntry searchResultEntry) {
        ArrayList<LDAPControl> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "sendSearchEntry", String.valueOf(searchOperation), String.valueOf(searchResultEntry)));
        SearchResultEntryProtocolOp searchResultEntryProtocolOp = new SearchResultEntryProtocolOp(searchResultEntry);
        List<Control> list = searchResultEntry.getControls();
        if (list == null || list.isEmpty()) {
            arrayList = null;
        } else {
            arrayList = new ArrayList<LDAPControl>(list.size());
            for (Control control : list) {
                arrayList.add(new LDAPControl(control));
            }
        }
        this.sendLDAPMessage(this.securityProvider, new LDAPMessage(searchOperation.getMessageID(), searchResultEntryProtocolOp, arrayList));
    }

    @Override
    public boolean sendSearchReference(SearchOperation searchOperation, SearchResultReference searchResultReference) {
        ArrayList<LDAPControl> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "sendSearchReference", String.valueOf(searchOperation), String.valueOf(searchResultReference)));
        if (this.ldapVersion == 2) {
            int n = 2293967;
            String string = MessageHandler.getMessage(n, this.getConnectionID(), searchOperation.getOperationID(), String.valueOf(searchResultReference));
            Error.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.MILD_WARNING, string, n);
            return false;
        }
        SearchResultReferenceProtocolOp searchResultReferenceProtocolOp = new SearchResultReferenceProtocolOp(searchResultReference);
        List<Control> list = searchResultReference.getControls();
        if (list == null || list.isEmpty()) {
            arrayList = null;
        } else {
            arrayList = new ArrayList<LDAPControl>(list.size());
            for (Control control : list) {
                arrayList.add(new LDAPControl(control));
            }
        }
        this.sendLDAPMessage(this.securityProvider, new LDAPMessage(searchOperation.getMessageID(), searchResultReferenceProtocolOp, arrayList));
        return true;
    }

    @Override
    protected boolean sendIntermediateResponseMessage(IntermediateResponse intermediateResponse) {
        assert (Debug.debugEnter(CLASS_NAME, "sendIntermediateResponseMessage", String.valueOf(intermediateResponse)));
        IntermediateResponseProtocolOp intermediateResponseProtocolOp = new IntermediateResponseProtocolOp(intermediateResponse.getOID(), intermediateResponse.getValue());
        Operation operation = intermediateResponse.getOperation();
        List<Control> list = intermediateResponse.getControls();
        ArrayList<LDAPControl> arrayList = new ArrayList<LDAPControl>(list.size());
        for (Control control : list) {
            arrayList.add(new LDAPControl(control));
        }
        LDAPMessage lDAPMessage = new LDAPMessage(operation.getMessageID(), intermediateResponseProtocolOp, arrayList);
        this.sendLDAPMessage(this.securityProvider, lDAPMessage);
        return this.connectionValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLDAPMessage(ConnectionSecurityProvider connectionSecurityProvider, LDAPMessage lDAPMessage) {
        assert (Debug.debugEnter(CLASS_NAME, "sendLDAPMessage", String.valueOf(lDAPMessage)));
        ASN1Element aSN1Element = lDAPMessage.encode();
        ByteBuffer byteBuffer = ByteBuffer.wrap(aSN1Element.encode());
        this.transmitLock.lock();
        try {
            int n = byteBuffer.limit() - byteBuffer.position();
            if (!connectionSecurityProvider.writeData(byteBuffer)) {
                return;
            }
            try {
                assert (Debug.debugProtocolElementWritten(CLASS_NAME, "sendLDAPMessage", lDAPMessage));
                assert (Debug.debugProtocolElementWritten(CLASS_NAME, "sendLDAPMessage", aSN1Element));
                byteBuffer.rewind();
                assert (Debug.debugBytesWritten(CLASS_NAME, "sendLDAPMessage", byteBuffer));
                if (this.keepStats) {
                    this.statTracker.updateMessageWritten(lDAPMessage, n);
                }
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "sendLDAPMessage", exception));
                this.disconnect(DisconnectReason.SERVER_ERROR, true, -1, String.valueOf(exception), StaticUtils.getBacktrace(exception));
                return;
            }
        }
        finally {
            this.transmitLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect(DisconnectReason disconnectReason, boolean bl, String string, int n) {
        block33: {
            block32: {
                block31: {
                    assert (Debug.debugEnter(CLASS_NAME, "disconnect", String.valueOf((Object)disconnectReason), String.valueOf(bl), String.valueOf(string), String.valueOf(n)));
                    if (this.disconnectRequested) {
                        return;
                    }
                    if (this.keepStats) {
                        this.statTracker.updateDisconnect();
                    }
                    if (this.connectionID >= 0L) {
                        DirectoryServer.connectionClosed(this);
                    }
                    this.connectionValid = false;
                    this.opsInProgressLock.lock();
                    try {
                        this.disconnectRequested = true;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "disconnect", exception));
                    }
                    finally {
                        this.opsInProgressLock.unlock();
                    }
                    this.cancelAllOperations(new CancelRequest(true, string));
                    if (bl && this.ldapVersion != 2) {
                        try {
                            int n2;
                            switch (disconnectReason) {
                                case PROTOCOL_ERROR: {
                                    n2 = 2;
                                    break;
                                }
                                case SERVER_SHUTDOWN: {
                                    n2 = 52;
                                    break;
                                }
                                case SERVER_ERROR: {
                                    n2 = DirectoryServer.getServerErrorResultCode().getIntValue();
                                    break;
                                }
                                case ADMIN_LIMIT_EXCEEDED: 
                                case IDLE_TIME_LIMIT_EXCEEDED: 
                                case MAX_REQUEST_SIZE_EXCEEDED: 
                                case IO_TIMEOUT: {
                                    n2 = 11;
                                    break;
                                }
                                case CONNECTION_REJECTED: {
                                    n2 = 19;
                                    break;
                                }
                                default: {
                                    n2 = 80;
                                }
                            }
                            String string2 = string == null ? MessageHandler.getMessage(2097317) : string;
                            ExtendedResponseProtocolOp extendedResponseProtocolOp = new ExtendedResponseProtocolOp(n2, string2, null, null, "1.3.6.1.4.1.1466.20036", null);
                            byte[] byArray = new LDAPMessage(0, extendedResponseProtocolOp, null).encode().encode();
                            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
                            try {
                                this.securityProvider.writeData(byteBuffer);
                            }
                            catch (Exception exception) {}
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        this.securityProvider.disconnect(bl);
                    }
                    catch (Exception exception) {
                        if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "disconnect", exception)) break block31;
                        throw new AssertionError();
                    }
                }
                try {
                    this.clientChannel.close();
                }
                catch (Exception exception) {
                    if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "disconnect", exception)) break block32;
                    throw new AssertionError();
                }
            }
            if (n == -1) {
                Access.logDisconnect(this, disconnectReason, null);
            } else {
                Access.logDisconnect(this, disconnectReason, string);
            }
            try {
                PluginConfigManager pluginConfigManager = DirectoryServer.getPluginConfigManager();
                pluginConfigManager.invokePostDisconnectPlugins(this, disconnectReason, n, string);
            }
            catch (Exception exception) {
                if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "disconnect", exception)) break block33;
                throw new AssertionError();
            }
        }
    }

    @Override
    public Collection<Operation> getOperationsInProgress() {
        assert (Debug.debugEnter(CLASS_NAME, "getOperationsInProgress", new String[0]));
        return this.operationsInProgress.values();
    }

    @Override
    public Operation getOperationInProgress(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "getOperationInProgress", String.valueOf(n)));
        return this.operationsInProgress.get(n);
    }

    public void addOperationInProgress(Operation operation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "addOperationInProgress", String.valueOf(operation)));
        int n = operation.getMessageID();
        this.opsInProgressLock.lock();
        try {
            if (this.disconnectRequested) {
                int n2 = 2162854;
                String string = MessageHandler.getMessage(n2);
                throw new DirectoryException(ResultCode.UNWILLING_TO_PERFORM, string, n2);
            }
            Operation operation2 = this.operationsInProgress.get(n);
            if (operation2 != null) {
                int n3 = 2163033;
                String string = MessageHandler.getMessage(n3, n);
                throw new DirectoryException(ResultCode.PROTOCOL_ERROR, string, n3);
            }
            this.operationsInProgress.put(n, operation);
            DirectoryServer.enqueueRequest(operation);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "addOperationInProgress", directoryException));
            this.operationsInProgress.remove(n);
            throw directoryException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "addOperationInProgress", exception));
            int n4 = 2163034;
            String string = MessageHandler.getMessage(n4, StaticUtils.stackTraceToSingleLineString(exception));
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n4, exception);
        }
        finally {
            this.opsInProgressLock.unlock();
        }
    }

    @Override
    public boolean removeOperationInProgress(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "removeOperationInProgress", String.valueOf(n)));
        Operation operation = this.operationsInProgress.remove(n);
        return operation != null;
    }

    @Override
    public CancelResult cancelOperation(int n, CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancelOperation", String.valueOf(n), String.valueOf(cancelRequest)));
        Operation operation = this.operationsInProgress.get(n);
        if (operation == null) {
            for (PersistentSearch persistentSearch : this.getPersistentSearches()) {
                if (persistentSearch.getSearchOperation().getMessageID() != n) continue;
                return persistentSearch.getSearchOperation().cancel(cancelRequest);
            }
            return CancelResult.NO_SUCH_OPERATION;
        }
        return operation.cancel(cancelRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAllOperations(CancelRequest cancelRequest) {
        assert (Debug.debugEnter(CLASS_NAME, "cancelAllOperations", String.valueOf(cancelRequest)));
        this.opsInProgressLock.lock();
        try {
            for (Operation object : this.operationsInProgress.values()) {
                try {
                    object.cancel(cancelRequest);
                }
                catch (Exception exception) {
                    assert (Debug.debugException(CLASS_NAME, "cancelAllOperations", exception));
                }
            }
            this.operationsInProgress.clear();
            for (PersistentSearch persistentSearch : this.getPersistentSearches()) {
                DirectoryServer.deregisterPersistentSearch(persistentSearch);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "cancelAllOperations", exception));
        }
        finally {
            this.opsInProgressLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelAllOperationsExcept(CancelRequest cancelRequest, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "cancelAllOperationsExcept", String.valueOf(cancelRequest), String.valueOf(n)));
        this.opsInProgressLock.lock();
        try {
            Iterator<Object> iterator = this.operationsInProgress.keySet().iterator();
            while (iterator.hasNext()) {
                int n2;
                block12: {
                    n2 = (Integer)iterator.next();
                    if (n2 == n) continue;
                    Operation operation = this.operationsInProgress.get(n2);
                    if (operation != null) {
                        try {
                            operation.cancel(cancelRequest);
                        }
                        catch (Exception exception) {
                            if ($assertionsDisabled || Debug.debugException(CLASS_NAME, "cancelAllOperationsExcept", exception)) break block12;
                            throw new AssertionError();
                        }
                    }
                }
                this.operationsInProgress.remove(n2);
            }
            for (PersistentSearch persistentSearch : this.getPersistentSearches()) {
                DirectoryServer.deregisterPersistentSearch(persistentSearch);
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "cancelAllOperationsExcept", exception));
        }
        finally {
            this.opsInProgressLock.unlock();
        }
    }

    @Override
    public boolean processDataRead(ByteBuffer byteBuffer) {
        assert (Debug.debugEnter(CLASS_NAME, "processDataRead", String.valueOf(byteBuffer)));
        assert (Debug.debugBytesRead(CLASS_NAME, "processDataRead", byteBuffer));
        int n = byteBuffer.limit() - byteBuffer.position();
        if (this.keepStats) {
            this.statTracker.updateBytesRead(n);
        }
        block10: while (n > 0) {
            Object object;
            switch (this.elementReadState) {
                case 0: {
                    this.elementType = byteBuffer.get();
                    --n;
                    this.elementReadState = 1;
                    continue block10;
                }
                case 1: {
                    byte by = byteBuffer.get();
                    --n;
                    this.elementLengthBytesNeeded = by & 0x7F;
                    if (this.elementLengthBytesNeeded == by) {
                        this.elementLength = by;
                        if (this.elementLength == 0) {
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, 2293927, new Object[0]);
                            return false;
                        }
                        if (this.connectionHandler.getMaxRequestSize() > 0 && this.elementLength > this.connectionHandler.getMaxRequestSize()) {
                            this.disconnect(DisconnectReason.MAX_REQUEST_SIZE_EXCEEDED, true, 2293928, this.elementLength, this.connectionHandler.getMaxRequestSize());
                            return false;
                        }
                        this.elementValue = new byte[this.elementLength];
                        this.elementValueBytesRead = 0;
                        this.elementValueBytesNeeded = this.elementLength;
                        this.elementReadState = 3;
                        continue block10;
                    }
                    if (this.elementLengthBytesNeeded > 4) {
                        this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, 2293929, this.elementLengthBytesNeeded);
                        return false;
                    }
                    this.elementLength = 0;
                    if (this.elementLengthBytesNeeded <= n) {
                        while (this.elementLengthBytesNeeded > 0) {
                            this.elementLength = this.elementLength << 8 | byteBuffer.get() & 0xFF;
                            --n;
                            --this.elementLengthBytesNeeded;
                        }
                        if (this.elementLength == 0) {
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, 2293927, new Object[0]);
                            return false;
                        }
                        if (this.connectionHandler.getMaxRequestSize() > 0 && this.elementLength > this.connectionHandler.getMaxRequestSize()) {
                            this.disconnect(DisconnectReason.MAX_REQUEST_SIZE_EXCEEDED, true, 2293928, this.elementLength, this.connectionHandler.getMaxRequestSize());
                            return false;
                        }
                        this.elementValue = new byte[this.elementLength];
                        this.elementValueBytesRead = 0;
                        this.elementValueBytesNeeded = this.elementLength;
                        this.elementReadState = 3;
                        continue block10;
                    }
                    while (n > 0) {
                        this.elementLength = this.elementLength << 8 | byteBuffer.get() & 0xFF;
                        --n;
                        --this.elementLengthBytesNeeded;
                    }
                    return true;
                }
                case 2: {
                    if (n >= this.elementLengthBytesNeeded) {
                        while (this.elementLengthBytesNeeded > 0) {
                            this.elementLength = this.elementLength << 8 | byteBuffer.get() & 0xFF;
                            --n;
                            --this.elementLengthBytesNeeded;
                        }
                        if (this.elementLength == 0) {
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, 2293927, new Object[0]);
                            return false;
                        }
                        if (this.connectionHandler.getMaxRequestSize() > 0 && this.elementLength > this.connectionHandler.getMaxRequestSize()) {
                            this.disconnect(DisconnectReason.MAX_REQUEST_SIZE_EXCEEDED, true, 2293928, this.elementLength, this.connectionHandler.getMaxRequestSize());
                            return false;
                        }
                        this.elementValue = new byte[this.elementLength];
                        this.elementValueBytesRead = 0;
                        this.elementValueBytesNeeded = this.elementLength;
                        this.elementReadState = 3;
                        continue block10;
                    }
                    while (n > 0) {
                        this.elementLength = this.elementLength << 8 | byteBuffer.get() & 0xFF;
                        --n;
                        --this.elementLengthBytesNeeded;
                    }
                    return true;
                }
                case 3: {
                    if (n >= this.elementValueBytesNeeded) {
                        ASN1Sequence aSN1Sequence;
                        byteBuffer.get(this.elementValue, this.elementValueBytesRead, this.elementValueBytesNeeded);
                        this.elementValueBytesRead += this.elementValueBytesNeeded;
                        n -= this.elementValueBytesNeeded;
                        this.elementReadState = 0;
                        try {
                            aSN1Sequence = ASN1Sequence.decodeAsSequence(this.elementType, this.elementValue);
                            assert (Debug.debugProtocolElementRead(CLASS_NAME, "processDataRead", aSN1Sequence));
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "processDataRead", exception));
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, 2293930, String.valueOf(exception));
                            return false;
                        }
                        try {
                            object = LDAPMessage.decode(aSN1Sequence);
                            assert (Debug.debugProtocolElementRead(CLASS_NAME, "processDataRead", (ProtocolElement)object));
                        }
                        catch (Exception exception) {
                            assert (Debug.debugException(CLASS_NAME, "processDataRead", exception));
                            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, 2293931, String.valueOf(exception));
                            return false;
                        }
                        if (this.processLDAPMessage((LDAPMessage)object)) continue block10;
                        return false;
                    }
                    byteBuffer.get(this.elementValue, this.elementValueBytesRead, n);
                    this.elementValueBytesRead += n;
                    this.elementValueBytesNeeded -= n;
                    return true;
                }
            }
            int n2 = 2359468;
            object = MessageHandler.getMessage(n2, this.elementReadState);
            Error.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.SEVERE_ERROR, (String)object, n2);
            this.disconnect(DisconnectReason.SERVER_ERROR, true, (String)object, n2);
            return false;
        }
        return true;
    }

    private boolean processLDAPMessage(LDAPMessage lDAPMessage) {
        ArrayList<Control> arrayList;
        ArrayList<LDAPControl> arrayList2;
        assert (Debug.debugEnter(CLASS_NAME, "processLDAPMessage", String.valueOf(lDAPMessage)));
        if (this.keepStats) {
            this.statTracker.updateMessageRead(lDAPMessage);
        }
        if ((arrayList2 = lDAPMessage.getControls()) == null || arrayList2.isEmpty()) {
            arrayList = null;
        } else {
            arrayList = new ArrayList<Control>(arrayList2.size());
            for (LDAPControl object : arrayList2) {
                arrayList.add(object.getControl());
            }
        }
        try {
            switch (lDAPMessage.getProtocolOpType()) {
                case 80: {
                    return this.processAbandonRequest(lDAPMessage, arrayList);
                }
                case 104: {
                    return this.processAddRequest(lDAPMessage, arrayList);
                }
                case 96: {
                    return this.processBindRequest(lDAPMessage, arrayList);
                }
                case 110: {
                    return this.processCompareRequest(lDAPMessage, arrayList);
                }
                case 74: {
                    return this.processDeleteRequest(lDAPMessage, arrayList);
                }
                case 119: {
                    return this.processExtendedRequest(lDAPMessage, arrayList);
                }
                case 102: {
                    return this.processModifyRequest(lDAPMessage, arrayList);
                }
                case 108: {
                    return this.processModifyDNRequest(lDAPMessage, arrayList);
                }
                case 99: {
                    return this.processSearchRequest(lDAPMessage, arrayList);
                }
                case 66: {
                    return this.processUnbindRequest(lDAPMessage, arrayList);
                }
            }
            int n = 2293962;
            String n2 = MessageHandler.getMessage(n, lDAPMessage.getProtocolOpName(), lDAPMessage.getMessageID());
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, n2, n);
            return false;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "processLDAPMessage", exception));
            int n = 2359499;
            String string = MessageHandler.getMessage(n, lDAPMessage.getProtocolOpName(), lDAPMessage.getMessageID(), String.valueOf(exception));
            this.disconnect(DisconnectReason.SERVER_ERROR, true, string, n);
            return false;
        }
    }

    private boolean processAbandonRequest(LDAPMessage lDAPMessage, ArrayList<Control> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "processAbandonRequest", String.valueOf(lDAPMessage)));
        AbandonRequestProtocolOp abandonRequestProtocolOp = lDAPMessage.getAbandonRequestProtocolOp();
        AbandonOperation abandonOperation = new AbandonOperation(this, this.nextOperationID.getAndIncrement(), lDAPMessage.getMessageID(), arrayList, abandonRequestProtocolOp.getIDToAbandon());
        abandonOperation.run();
        return this.connectionValid;
    }

    private boolean processAddRequest(LDAPMessage lDAPMessage, ArrayList<Control> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "processAddRequest", String.valueOf(lDAPMessage)));
        AddRequestProtocolOp addRequestProtocolOp = lDAPMessage.getAddRequestProtocolOp();
        AddOperation addOperation = new AddOperation(this, this.nextOperationID.getAndIncrement(), lDAPMessage.getMessageID(), arrayList, addRequestProtocolOp.getDN(), addRequestProtocolOp.getAttributes());
        try {
            this.addOperationInProgress(addOperation);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "processAddRequest", directoryException));
            AddResponseProtocolOp addResponseProtocolOp = new AddResponseProtocolOp(directoryException.getResultCode().getIntValue(), directoryException.getErrorMessage(), directoryException.getMatchedDN(), directoryException.getReferralURLs());
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(lDAPMessage.getMessageID(), addResponseProtocolOp));
        }
        return this.connectionValid;
    }

    private boolean processBindRequest(LDAPMessage lDAPMessage, ArrayList<Control> arrayList) {
        block9: {
            BindOperation bindOperation;
            assert (Debug.debugEnter(CLASS_NAME, "processBindRequest", String.valueOf(lDAPMessage)));
            BindRequestProtocolOp bindRequestProtocolOp = lDAPMessage.getBindRequestProtocolOp();
            this.ldapVersion = bindRequestProtocolOp.getProtocolVersion();
            if (this.ldapVersion == 2 && !this.connectionHandler.allowLDAPv2()) {
                BindResponseProtocolOp bindResponseProtocolOp = new BindResponseProtocolOp(48, MessageHandler.getMessage(2293970));
                this.sendLDAPMessage(this.securityProvider, new LDAPMessage(lDAPMessage.getMessageID(), bindResponseProtocolOp));
                this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, null, -1);
                return false;
            }
            ASN1OctetString aSN1OctetString = bindRequestProtocolOp.getDN();
            switch (bindRequestProtocolOp.getAuthenticationType()) {
                case SIMPLE: {
                    bindOperation = new BindOperation((ClientConnection)this, this.nextOperationID.getAndIncrement(), lDAPMessage.getMessageID(), arrayList, aSN1OctetString, (ByteString)bindRequestProtocolOp.getSimplePassword());
                    break;
                }
                case SASL: {
                    bindOperation = new BindOperation((ClientConnection)this, this.nextOperationID.getAndIncrement(), lDAPMessage.getMessageID(), arrayList, aSN1OctetString, bindRequestProtocolOp.getSASLMechanism(), bindRequestProtocolOp.getSASLCredentials());
                    break;
                }
                default: {
                    int n = 2293964;
                    String string = MessageHandler.getMessage(n, lDAPMessage.getMessageID(), String.valueOf((Object)bindRequestProtocolOp.getAuthenticationType()));
                    this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, string, n);
                    return false;
                }
            }
            try {
                this.addOperationInProgress(bindOperation);
            }
            catch (DirectoryException directoryException) {
                assert (Debug.debugException(CLASS_NAME, "processBindRequest", directoryException));
                BindResponseProtocolOp bindResponseProtocolOp = new BindResponseProtocolOp(directoryException.getResultCode().getIntValue(), directoryException.getErrorMessage(), directoryException.getMatchedDN(), directoryException.getReferralURLs());
                this.sendLDAPMessage(this.securityProvider, new LDAPMessage(lDAPMessage.getMessageID(), bindResponseProtocolOp));
                if (directoryException.getResultCode() != ResultCode.PROTOCOL_ERROR) break block9;
                int n = 2293965;
                String string = MessageHandler.getMessage(n, lDAPMessage.getMessageID(), directoryException.getErrorMessage());
                this.disconnect(DisconnectReason.PROTOCOL_ERROR, true, string, n);
            }
        }
        return this.connectionValid;
    }

    private boolean processCompareRequest(LDAPMessage lDAPMessage, ArrayList<Control> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "processCompareRequest", String.valueOf(lDAPMessage)));
        CompareRequestProtocolOp compareRequestProtocolOp = lDAPMessage.getCompareRequestProtocolOp();
        CompareOperation compareOperation = new CompareOperation((ClientConnection)this, this.nextOperationID.getAndIncrement(), lDAPMessage.getMessageID(), arrayList, compareRequestProtocolOp.getDN(), compareRequestProtocolOp.getAttributeType(), (ByteString)compareRequestProtocolOp.getAssertionValue());
        try {
            this.addOperationInProgress(compareOperation);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "processCompareRequest", directoryException));
            CompareResponseProtocolOp compareResponseProtocolOp = new CompareResponseProtocolOp(directoryException.getResultCode().getIntValue(), directoryException.getErrorMessage(), directoryException.getMatchedDN(), directoryException.getReferralURLs());
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(lDAPMessage.getMessageID(), compareResponseProtocolOp));
        }
        return this.connectionValid;
    }

    private boolean processDeleteRequest(LDAPMessage lDAPMessage, ArrayList<Control> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "processDeleteRequest", String.valueOf(lDAPMessage)));
        DeleteRequestProtocolOp deleteRequestProtocolOp = lDAPMessage.getDeleteRequestProtocolOp();
        DeleteOperation deleteOperation = new DeleteOperation((ClientConnection)this, this.nextOperationID.getAndIncrement(), lDAPMessage.getMessageID(), arrayList, deleteRequestProtocolOp.getDN());
        try {
            this.addOperationInProgress(deleteOperation);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "processDeleteRequest", directoryException));
            DeleteResponseProtocolOp deleteResponseProtocolOp = new DeleteResponseProtocolOp(directoryException.getResultCode().getIntValue(), directoryException.getErrorMessage(), directoryException.getMatchedDN(), directoryException.getReferralURLs());
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(lDAPMessage.getMessageID(), deleteResponseProtocolOp));
        }
        return this.connectionValid;
    }

    private boolean processExtendedRequest(LDAPMessage lDAPMessage, ArrayList<Control> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "processExtendedRequest", String.valueOf(lDAPMessage)));
        if (this.ldapVersion == 2) {
            int n = 2293971;
            String string = MessageHandler.getMessage(n, this.getConnectionID(), lDAPMessage.getMessageID());
            Error.logError(ErrorLogCategory.REQUEST_HANDLING, ErrorLogSeverity.MILD_ERROR, string, n);
            this.disconnect(DisconnectReason.PROTOCOL_ERROR, false, string, n);
            return false;
        }
        ExtendedRequestProtocolOp extendedRequestProtocolOp = lDAPMessage.getExtendedRequestProtocolOp();
        ExtendedOperation extendedOperation = new ExtendedOperation(this, this.nextOperationID.getAndIncrement(), lDAPMessage.getMessageID(), arrayList, extendedRequestProtocolOp.getOID(), extendedRequestProtocolOp.getValue());
        try {
            this.addOperationInProgress(extendedOperation);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "processExtendedRequest", directoryException));
            ExtendedResponseProtocolOp extendedResponseProtocolOp = new ExtendedResponseProtocolOp(directoryException.getResultCode().getIntValue(), directoryException.getErrorMessage(), directoryException.getMatchedDN(), directoryException.getReferralURLs());
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(lDAPMessage.getMessageID(), extendedResponseProtocolOp));
        }
        return this.connectionValid;
    }

    private boolean processModifyRequest(LDAPMessage lDAPMessage, ArrayList<Control> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "processModifyRequest", String.valueOf(lDAPMessage)));
        ModifyRequestProtocolOp modifyRequestProtocolOp = lDAPMessage.getModifyRequestProtocolOp();
        ModifyOperation modifyOperation = new ModifyOperation((ClientConnection)this, this.nextOperationID.getAndIncrement(), lDAPMessage.getMessageID(), arrayList, modifyRequestProtocolOp.getDN(), modifyRequestProtocolOp.getModifications());
        try {
            this.addOperationInProgress(modifyOperation);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "processModifyRequest", directoryException));
            ModifyResponseProtocolOp modifyResponseProtocolOp = new ModifyResponseProtocolOp(directoryException.getResultCode().getIntValue(), directoryException.getErrorMessage(), directoryException.getMatchedDN(), directoryException.getReferralURLs());
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(lDAPMessage.getMessageID(), modifyResponseProtocolOp));
        }
        return this.connectionValid;
    }

    private boolean processModifyDNRequest(LDAPMessage lDAPMessage, ArrayList<Control> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "processModifyDNRequest", String.valueOf(lDAPMessage)));
        ModifyDNRequestProtocolOp modifyDNRequestProtocolOp = lDAPMessage.getModifyDNRequestProtocolOp();
        ModifyDNOperation modifyDNOperation = new ModifyDNOperation((ClientConnection)this, this.nextOperationID.getAndIncrement(), lDAPMessage.getMessageID(), arrayList, modifyDNRequestProtocolOp.getEntryDN(), modifyDNRequestProtocolOp.getNewRDN(), modifyDNRequestProtocolOp.deleteOldRDN(), modifyDNRequestProtocolOp.getNewSuperior());
        try {
            this.addOperationInProgress(modifyDNOperation);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "processModifyDNRequest", directoryException));
            ModifyDNResponseProtocolOp modifyDNResponseProtocolOp = new ModifyDNResponseProtocolOp(directoryException.getResultCode().getIntValue(), directoryException.getErrorMessage(), directoryException.getMatchedDN(), directoryException.getReferralURLs());
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(lDAPMessage.getMessageID(), modifyDNResponseProtocolOp));
        }
        return this.connectionValid;
    }

    private boolean processSearchRequest(LDAPMessage lDAPMessage, ArrayList<Control> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "processSearchRequest", String.valueOf(lDAPMessage)));
        SearchRequestProtocolOp searchRequestProtocolOp = lDAPMessage.getSearchRequestProtocolOp();
        SearchOperation searchOperation = new SearchOperation((ClientConnection)this, this.nextOperationID.getAndIncrement(), lDAPMessage.getMessageID(), arrayList, searchRequestProtocolOp.getBaseDN(), searchRequestProtocolOp.getScope(), searchRequestProtocolOp.getDereferencePolicy(), searchRequestProtocolOp.getSizeLimit(), searchRequestProtocolOp.getTimeLimit(), searchRequestProtocolOp.getTypesOnly(), searchRequestProtocolOp.getFilter(), searchRequestProtocolOp.getAttributes());
        try {
            this.addOperationInProgress(searchOperation);
        }
        catch (DirectoryException directoryException) {
            assert (Debug.debugException(CLASS_NAME, "processSearchRequest", directoryException));
            SearchResultDoneProtocolOp searchResultDoneProtocolOp = new SearchResultDoneProtocolOp(directoryException.getResultCode().getIntValue(), directoryException.getErrorMessage(), directoryException.getMatchedDN(), directoryException.getReferralURLs());
            this.sendLDAPMessage(this.securityProvider, new LDAPMessage(lDAPMessage.getMessageID(), searchResultDoneProtocolOp));
        }
        return this.connectionValid;
    }

    private boolean processUnbindRequest(LDAPMessage lDAPMessage, ArrayList<Control> arrayList) {
        assert (Debug.debugEnter(CLASS_NAME, "processUnbindRequest", String.valueOf(lDAPMessage)));
        UnbindOperation unbindOperation = new UnbindOperation((ClientConnection)this, this.nextOperationID.getAndIncrement(), lDAPMessage.getMessageID(), arrayList);
        unbindOperation.run();
        return false;
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("LDAP client connection from ");
        stringBuilder.append(this.clientAddress);
        stringBuilder.append(":");
        stringBuilder.append(this.clientPort);
        stringBuilder.append(" to ");
        stringBuilder.append(this.serverAddress);
        stringBuilder.append(":");
        stringBuilder.append(this.serverPort);
    }

    @Override
    public boolean tlsProtectionAvailable(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "tlsProtectionAvailable", "java.lang.StringBuilder"));
        if (!(this.securityProvider instanceof NullConnectionSecurityProvider)) {
            int n = 2294031;
            stringBuilder.append(MessageHandler.getMessage(n, this.securityProvider.getSecurityMechanismName()));
            return false;
        }
        if (!this.connectionHandler.allowStartTLS()) {
            int n = 2294032;
            stringBuilder.append(MessageHandler.getMessage(n));
            return false;
        }
        if (this.tlsSecurityProvider == null) {
            try {
                TLSConnectionSecurityProvider tLSConnectionSecurityProvider = new TLSConnectionSecurityProvider();
                tLSConnectionSecurityProvider.initializeConnectionSecurityProvider(null);
                tLSConnectionSecurityProvider.setSSLClientAuthPolicy(this.connectionHandler.getSSLClientAuthPolicy());
                tLSConnectionSecurityProvider.setEnabledProtocols(this.connectionHandler.getEnabledSSLProtocols());
                tLSConnectionSecurityProvider.setEnabledCipherSuites(this.connectionHandler.getEnabledSSLCipherSuites());
                this.tlsSecurityProvider = (TLSConnectionSecurityProvider)tLSConnectionSecurityProvider.newInstance(this, this.clientChannel);
            }
            catch (Exception exception) {
                assert (Debug.debugException(CLASS_NAME, "tlsProtectionAvailable", exception));
                this.tlsSecurityProvider = null;
                int n = 2294033;
                stringBuilder.append(MessageHandler.getMessage(n, StaticUtils.stackTraceToSingleLineString(exception)));
                return false;
            }
        }
        return true;
    }

    @Override
    public void enableTLSConnectionSecurityProvider() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "enableTLSConnectionSecurityProvider", new String[0]));
        if (this.tlsSecurityProvider == null) {
            int n = 2294034;
            String string = MessageHandler.getMessage(n);
            this.disconnect(DisconnectReason.OTHER, false, string, n);
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
        }
        this.clearSecurityProvider = this.securityProvider;
        this.securityProvider = this.tlsSecurityProvider;
    }

    @Override
    public void disableTLSConnectionSecurityProvider() throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "disableTLSConnectionSecurityProvider", new String[0]));
        int n = 2294035;
        String string = MessageHandler.getMessage(n);
        this.disconnect(DisconnectReason.OTHER, false, string, n);
        throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
    }

    @Override
    public void sendClearResponse(Operation operation) throws DirectoryException {
        assert (Debug.debugEnter(CLASS_NAME, "sendClearResponse", String.valueOf(operation)));
        if (this.clearSecurityProvider == null) {
            int n = 2294143;
            String string = MessageHandler.getMessage(n, this.toString());
            throw new DirectoryException(DirectoryServer.getServerErrorResultCode(), string, n);
        }
        this.sendLDAPMessage(this.clearSecurityProvider, this.operationToResponseLDAPMessage(operation));
    }
}

