/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.opends.server.core.DirectoryServer;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.asn1.ASN1Set;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.util.ServerConstants;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LDAPAttribute {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.LDAPAttribute";
    private ArrayList<ASN1OctetString> values;
    private String attributeType;

    public LDAPAttribute(String string) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string)));
        this.attributeType = string;
        this.values = new ArrayList(0);
    }

    public LDAPAttribute(String string, ArrayList<ASN1OctetString> arrayList) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(string)));
        this.attributeType = string;
        this.values = arrayList == null ? new ArrayList(0) : arrayList;
    }

    public LDAPAttribute(Attribute attribute) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(attribute)));
        StringBuilder stringBuilder = new StringBuilder(attribute.getName());
        for (String object : attribute.getOptions()) {
            stringBuilder.append(";");
            stringBuilder.append(object);
        }
        this.attributeType = stringBuilder.toString();
        LinkedHashSet<AttributeValue> linkedHashSet = attribute.getValues();
        if (linkedHashSet == null || linkedHashSet.isEmpty()) {
            this.values = new ArrayList(0);
            return;
        }
        this.values = new ArrayList(linkedHashSet.size());
        for (AttributeValue attributeValue : linkedHashSet) {
            this.values.add(attributeValue.getValue().toASN1OctetString());
        }
    }

    public String getAttributeType() {
        assert (Debug.debugEnter(CLASS_NAME, "getAttributeType", new String[0]));
        return this.attributeType;
    }

    public void setAttributeType(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setAttributeType", String.valueOf(string)));
        this.attributeType = string;
    }

    public ArrayList<ASN1OctetString> getValues() {
        assert (Debug.debugEnter(CLASS_NAME, "getValues", new String[0]));
        return this.values;
    }

    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(2);
        arrayList.add(new ASN1OctetString(this.attributeType));
        if (this.values == null || this.values.isEmpty()) {
            arrayList.add(new ASN1Set());
        } else {
            ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>(this.values.size());
            for (ASN1OctetString aSN1OctetString : this.values) {
                arrayList2.add(aSN1OctetString);
            }
            arrayList.add(new ASN1Set(arrayList2));
        }
        return new ASN1Sequence(arrayList);
    }

    public static LDAPAttribute decode(ASN1Element aSN1Element) throws LDAPException {
        ArrayList<ASN1OctetString> arrayList;
        String string;
        ArrayList<ASN1Element> arrayList2;
        assert (Debug.debugEnter(CLASS_NAME, "decode", String.valueOf(aSN1Element)));
        try {
            arrayList2 = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n = 2293861;
            String string2 = MessageHandler.getMessage(n, String.valueOf(exception));
            throw new LDAPException(2, n, string2, exception);
        }
        int n = arrayList2.size();
        if (n != 2) {
            int n2 = 2293862;
            String string3 = MessageHandler.getMessage(n2, n);
            throw new LDAPException(2, n2, string3);
        }
        try {
            string = arrayList2.get(0).decodeAsOctetString().stringValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n3 = 2293863;
            String string4 = MessageHandler.getMessage(n3, String.valueOf(exception));
            throw new LDAPException(2, n3, string4, exception);
        }
        try {
            ArrayList<ASN1Element> arrayList3 = arrayList2.get(1).decodeAsSet().elements();
            arrayList = new ArrayList<ASN1OctetString>(arrayList3.size());
            for (ASN1Element aSN1Element2 : arrayList3) {
                arrayList.add(aSN1Element2.decodeAsOctetString());
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decode", exception));
            int n4 = 2293864;
            String string5 = MessageHandler.getMessage(n4, String.valueOf(exception));
            throw new LDAPException(2, n4, string5, exception);
        }
        return new LDAPAttribute(string, arrayList);
    }

    public Attribute toAttribute() throws LDAPException {
        Object object;
        LinkedHashSet<String> linkedHashSet;
        String string;
        assert (Debug.debugEnter(CLASS_NAME, "toAttribute", new String[0]));
        int n = this.attributeType.indexOf(59);
        if (n > 0) {
            string = this.attributeType.substring(0, n);
            linkedHashSet = new LinkedHashSet();
            int n2 = this.attributeType.indexOf(59, n + 1);
            while (n2 > 0) {
                object = this.attributeType.substring(n + 1, n2);
                if (((String)object).length() > 0) {
                    linkedHashSet.add((String)object);
                }
                n = n2;
                n2 = this.attributeType.indexOf(59, n + 1);
            }
            object = this.attributeType.substring(n + 1);
            if (((String)object).length() > 0) {
                linkedHashSet.add((String)object);
            }
        } else {
            string = this.attributeType;
            linkedHashSet = new LinkedHashSet<String>(0);
        }
        String string2 = StaticUtils.toLowerCase(string);
        AttributeType attributeType = DirectoryServer.getAttributeType(string2);
        if (attributeType == null) {
            attributeType = DirectoryServer.getDefaultAttributeType(string2);
        }
        object = new LinkedHashSet(this.values.size());
        for (ASN1OctetString aSN1OctetString : this.values) {
            if (((HashSet)object).add(new AttributeValue(attributeType, (ByteString)aSN1OctetString))) continue;
            int n3 = 2294144;
            String string3 = MessageHandler.getMessage(n3, this.attributeType);
            throw new LDAPException(20, n3, string3);
        }
        return new Attribute(attributeType, string, linkedHashSet, (LinkedHashSet<AttributeValue>)object);
    }

    public String toString() {
        assert (Debug.debugEnter(CLASS_NAME, "toString", new String[0]));
        StringBuilder stringBuilder = new StringBuilder();
        this.toString(stringBuilder);
        return stringBuilder.toString();
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("LDAPAttribute(type=");
        stringBuilder.append(this.attributeType);
        stringBuilder.append(", values={");
        if (!this.values.isEmpty()) {
            Iterator<ASN1OctetString> iterator = this.values.iterator();
            iterator.next().toString(stringBuilder);
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                iterator.next().toString(stringBuilder);
            }
        }
        stringBuilder.append("})");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("LDAP Attribute");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Attribute Type:  ");
        stringBuilder.append(this.attributeType);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append("  Attribute Values:");
        stringBuilder.append(ServerConstants.EOL);
        for (ASN1OctetString aSN1OctetString : this.values) {
            aSN1OctetString.toString(stringBuilder, n + 4);
        }
    }
}

