/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Enumerated;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.DN;
import org.opends.server.util.ServerConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedResponseProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.ExtendedResponseProtocolOp";
    private ASN1OctetString value;
    private DN matchedDN;
    private int resultCode;
    private List<String> referralURLs;
    private String errorMessage;
    private String oid;

    public ExtendedResponseProtocolOp(int n) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(n)));
        this.resultCode = n;
        this.errorMessage = null;
        this.matchedDN = null;
        this.referralURLs = null;
        this.oid = null;
        this.value = null;
    }

    public ExtendedResponseProtocolOp(int n, String string) {
        assert (Debug.debugEnter(CLASS_NAME, String.valueOf(n), String.valueOf(string)));
        this.resultCode = n;
        this.errorMessage = string;
        this.matchedDN = null;
        this.referralURLs = null;
        this.oid = null;
        this.value = null;
    }

    public ExtendedResponseProtocolOp(int n, String string, DN dN, List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, String.valueOf(n), String.valueOf(string), String.valueOf(dN), String.valueOf(list)));
        this.resultCode = n;
        this.errorMessage = string;
        this.matchedDN = dN;
        this.referralURLs = list;
        this.oid = null;
        this.value = null;
    }

    public ExtendedResponseProtocolOp(int n, String string, DN dN, List<String> list, String string2, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, String.valueOf(n), String.valueOf(string), String.valueOf(dN), String.valueOf(list)));
        this.resultCode = n;
        this.errorMessage = string;
        this.matchedDN = dN;
        this.referralURLs = list;
        this.oid = string2;
        this.value = aSN1OctetString;
    }

    public int getResultCode() {
        assert (Debug.debugEnter(CLASS_NAME, "getResultCode", new String[0]));
        return this.resultCode;
    }

    public void setResultCode(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setResultCode", String.valueOf(n)));
        this.resultCode = n;
    }

    public String getErrorMessage() {
        assert (Debug.debugEnter(CLASS_NAME, "getErrorMessage", new String[0]));
        return this.errorMessage;
    }

    public void setErrorMessage(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setErrorMessage", String.valueOf(string)));
        this.errorMessage = string;
    }

    public DN getMatchedDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getMatchedDN", new String[0]));
        return this.matchedDN;
    }

    public void setMatchedDN(DN dN) {
        assert (Debug.debugEnter(CLASS_NAME, "setMatchedDN", String.valueOf(dN)));
        this.matchedDN = dN;
    }

    public List<String> getReferralURLs() {
        assert (Debug.debugEnter(CLASS_NAME, "getReferralURLs", new String[0]));
        return this.referralURLs;
    }

    public void setReferralURLs(List<String> list) {
        assert (Debug.debugEnter(CLASS_NAME, "setReferralURLs", String.valueOf(list)));
        this.referralURLs = list;
    }

    public String getOID() {
        assert (Debug.debugEnter(CLASS_NAME, "getOID", new String[0]));
        return this.oid;
    }

    public void setOID(String string) {
        assert (Debug.debugEnter(CLASS_NAME, "setOID", String.valueOf(string)));
        this.oid = string;
    }

    public ASN1OctetString getValue() {
        assert (Debug.debugEnter(CLASS_NAME, "getValue", new String[0]));
        return this.value;
    }

    public void setValue(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setValue", String.valueOf(aSN1OctetString)));
        this.value = aSN1OctetString;
    }

    @Override
    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 120;
    }

    @Override
    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Extended Response";
    }

    @Override
    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(6);
        arrayList.add(new ASN1Enumerated(this.resultCode));
        if (this.matchedDN == null) {
            arrayList.add(new ASN1OctetString());
        } else {
            arrayList.add(new ASN1OctetString(this.matchedDN.toString()));
        }
        arrayList.add(new ASN1OctetString(this.errorMessage));
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>(this.referralURLs.size());
            for (String string : this.referralURLs) {
                arrayList2.add(new ASN1OctetString(string));
            }
            arrayList.add(new ASN1Sequence(-93, arrayList2));
        }
        if (this.oid != null && this.oid.length() > 0) {
            arrayList.add(new ASN1OctetString(-118, this.oid));
        }
        if (this.value != null) {
            this.value.setType((byte)-117);
            arrayList.add(this.value);
        }
        return new ASN1Sequence(120, arrayList);
    }

    public static ExtendedResponseProtocolOp decodeExtendedResponse(ASN1Element aSN1Element) throws LDAPException {
        DN dN;
        String string;
        int n;
        ArrayList<ASN1Element> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "decodeExtendedResponse", String.valueOf(aSN1Element)));
        try {
            arrayList = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeExtendedResponse", exception));
            int n2 = 2293820;
            String string2 = MessageHandler.getMessage(n2, String.valueOf(exception));
            throw new LDAPException(2, n2, string2, exception);
        }
        int n3 = arrayList.size();
        if (n3 < 3 || n3 > 6) {
            int n4 = 2293829;
            String string3 = MessageHandler.getMessage(n4, n3);
            throw new LDAPException(2, n4, string3);
        }
        try {
            n = arrayList.get(0).decodeAsInteger().intValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeExtendedResponse", exception));
            int n5 = 2293822;
            String string4 = MessageHandler.getMessage(n5, String.valueOf(exception));
            throw new LDAPException(2, n5, string4, exception);
        }
        try {
            string = arrayList.get(1).decodeAsOctetString().stringValue();
            dN = string.length() == 0 ? null : DN.decode(string);
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeExtendedResponse", exception));
            int n6 = 2293823;
            String string5 = MessageHandler.getMessage(n6, String.valueOf(exception));
            throw new LDAPException(2, n6, string5, exception);
        }
        try {
            string = arrayList.get(2).decodeAsOctetString().stringValue();
            if (string.length() == 0) {
                string = null;
            }
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeExtendedResponse", exception));
            int n7 = 2293824;
            String string6 = MessageHandler.getMessage(n7, String.valueOf(exception));
            throw new LDAPException(2, n7, string6, exception);
        }
        ArrayList<String> arrayList2 = null;
        String string7 = null;
        ASN1OctetString aSN1OctetString = null;
        block19: for (int i = 3; i < arrayList.size(); ++i) {
            aSN1Element = arrayList.get(i);
            switch (aSN1Element.getType()) {
                case -93: {
                    try {
                        ArrayList<ASN1Element> arrayList3 = aSN1Element.decodeAsSequence().elements();
                        arrayList2 = new ArrayList<String>(arrayList3.size());
                        for (ASN1Element object2 : arrayList3) {
                            arrayList2.add(object2.decodeAsOctetString().stringValue());
                        }
                        continue block19;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "decodeExtendedResponse", exception));
                        int n8 = 2293830;
                        String string2 = MessageHandler.getMessage(n8, String.valueOf(exception));
                        throw new LDAPException(2, n8, string2, exception);
                    }
                }
                case -118: {
                    try {
                        string7 = aSN1Element.decodeAsOctetString().stringValue();
                        continue block19;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "decodeExtendedResponse", exception));
                        int n9 = 2293831;
                        String string3 = MessageHandler.getMessage(n9, String.valueOf(exception));
                        throw new LDAPException(2, n9, string3, exception);
                    }
                }
                case -117: {
                    try {
                        aSN1OctetString = aSN1Element.decodeAsOctetString();
                        continue block19;
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "decodeExtendedResponse", exception));
                        int n10 = 2293832;
                        String string4 = MessageHandler.getMessage(n10, String.valueOf(exception));
                        throw new LDAPException(2, n10, string4, exception);
                    }
                }
                default: {
                    int n11 = 2293833;
                    String string8 = MessageHandler.getMessage(n11, aSN1Element.getType());
                    throw new LDAPException(2, n11, string8);
                }
            }
        }
        return new ExtendedResponseProtocolOp(n, string, dN, arrayList2, string7, aSN1OctetString);
    }

    @Override
    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("ExtendedResponse(resultCode=");
        stringBuilder.append(this.resultCode);
        if (this.errorMessage != null && this.errorMessage.length() > 0) {
            stringBuilder.append(", errorMessage=");
            stringBuilder.append(this.errorMessage);
        }
        if (this.matchedDN != null) {
            stringBuilder.append(", matchedDN=");
            stringBuilder.append(this.matchedDN.toString());
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            stringBuilder.append(", referralURLs={");
            Iterator<String> iterator = this.referralURLs.iterator();
            stringBuilder.append(iterator.next());
            while (iterator.hasNext()) {
                stringBuilder.append(", ");
                stringBuilder.append(iterator.next());
            }
            stringBuilder.append("}");
        }
        if (this.oid != null && this.oid.length() > 0) {
            stringBuilder.append(", oid=");
            stringBuilder.append(this.oid);
        }
        if (this.value != null) {
            stringBuilder.append(", value=");
            this.value.toString(stringBuilder);
        }
        stringBuilder.append(")");
    }

    @Override
    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Extended Response");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Result Code:  ");
        stringBuilder.append(this.resultCode);
        stringBuilder.append(ServerConstants.EOL);
        if (this.errorMessage != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Error Message:  ");
            stringBuilder.append(this.errorMessage);
            stringBuilder.append(ServerConstants.EOL);
        }
        if (this.matchedDN != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Matched DN:  ");
            this.matchedDN.toString(stringBuilder);
            stringBuilder.append(ServerConstants.EOL);
        }
        if (this.referralURLs != null && !this.referralURLs.isEmpty()) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Referral URLs:  ");
            stringBuilder.append(ServerConstants.EOL);
            for (String string : this.referralURLs) {
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append("  ");
                stringBuilder.append(string);
                stringBuilder.append(ServerConstants.EOL);
            }
        }
        if (this.oid != null && this.oid.length() > 0) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Response OID:  ");
            stringBuilder.append(this.oid);
            stringBuilder.append(ServerConstants.EOL);
        }
        if (this.value != null) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Response Value:  ");
            this.value.toString(stringBuilder);
            stringBuilder.append(ServerConstants.EOL);
        }
    }
}

