/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.ldap;

import java.util.ArrayList;
import org.opends.server.loggers.Debug;
import org.opends.server.messages.MessageHandler;
import org.opends.server.protocols.asn1.ASN1Element;
import org.opends.server.protocols.asn1.ASN1Integer;
import org.opends.server.protocols.asn1.ASN1OctetString;
import org.opends.server.protocols.asn1.ASN1Sequence;
import org.opends.server.protocols.ldap.LDAPException;
import org.opends.server.protocols.ldap.ProtocolOp;
import org.opends.server.types.AuthenticationType;
import org.opends.server.util.ServerConstants;

public class BindRequestProtocolOp
extends ProtocolOp {
    private static final String CLASS_NAME = "org.opends.server.protocols.ldap.BindRequestProtocolOp";
    private ASN1OctetString dn;
    private ASN1OctetString saslCredentials;
    private ASN1OctetString simplePassword;
    private AuthenticationType authenticationType;
    private int protocolVersion;
    private String saslMechanism;

    public BindRequestProtocolOp(ASN1OctetString aSN1OctetString, int n, ASN1OctetString aSN1OctetString2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(aSN1OctetString), String.valueOf(n), String.valueOf(aSN1OctetString2)));
        this.dn = aSN1OctetString;
        this.protocolVersion = n;
        this.simplePassword = aSN1OctetString2;
        this.authenticationType = AuthenticationType.SIMPLE;
        this.saslMechanism = null;
        this.saslCredentials = null;
    }

    public BindRequestProtocolOp(ASN1OctetString aSN1OctetString, String string, ASN1OctetString aSN1OctetString2) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(aSN1OctetString), String.valueOf(string), String.valueOf(aSN1OctetString2)));
        this.dn = aSN1OctetString;
        this.saslMechanism = string;
        this.saslCredentials = aSN1OctetString2;
        this.authenticationType = AuthenticationType.SASL;
        this.protocolVersion = 3;
        this.simplePassword = null;
    }

    private BindRequestProtocolOp(ASN1OctetString aSN1OctetString, int n, AuthenticationType authenticationType, ASN1OctetString aSN1OctetString2, String string, ASN1OctetString aSN1OctetString3) {
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(aSN1OctetString), String.valueOf(n), String.valueOf((Object)authenticationType), String.valueOf(aSN1OctetString2), String.valueOf(string), String.valueOf(aSN1OctetString3)));
        this.dn = aSN1OctetString;
        this.protocolVersion = n;
        this.authenticationType = authenticationType;
        this.simplePassword = aSN1OctetString2;
        this.saslMechanism = string;
        this.saslCredentials = aSN1OctetString3;
    }

    public ASN1OctetString getDN() {
        assert (Debug.debugEnter(CLASS_NAME, "getDN", new String[0]));
        return this.dn;
    }

    public void setDN(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setDN", String.valueOf(aSN1OctetString)));
        this.dn = aSN1OctetString;
    }

    public int getProtocolVersion() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolVersion", new String[0]));
        return this.protocolVersion;
    }

    public void setProtocolVersion(int n) {
        assert (Debug.debugEnter(CLASS_NAME, "setProtocolVersion", String.valueOf(n)));
        this.protocolVersion = n;
    }

    public AuthenticationType getAuthenticationType() {
        assert (Debug.debugEnter(CLASS_NAME, "getAuthenticationType", new String[0]));
        return this.authenticationType;
    }

    public void setAuthenticationType(AuthenticationType authenticationType) {
        assert (Debug.debugEnter(CLASS_NAME, "setAuthenticationType", String.valueOf((Object)authenticationType)));
        this.authenticationType = authenticationType;
    }

    public ASN1OctetString getSimplePassword() {
        assert (Debug.debugEnter(CLASS_NAME, "getSimplePassword", new String[0]));
        return this.simplePassword;
    }

    public void setSimplePassword(ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setSimplePassword", String.valueOf(aSN1OctetString)));
        this.simplePassword = aSN1OctetString;
        this.authenticationType = AuthenticationType.SIMPLE;
        this.saslMechanism = null;
        this.saslCredentials = null;
    }

    public String getSASLMechanism() {
        assert (Debug.debugEnter(CLASS_NAME, "getSASLMechanism", new String[0]));
        return this.saslMechanism;
    }

    public ASN1OctetString getSASLCredentials() {
        assert (Debug.debugEnter(CLASS_NAME, "getSASLCredentials", new String[0]));
        return this.saslCredentials;
    }

    public void setSASLAuthenticationInfo(String string, ASN1OctetString aSN1OctetString) {
        assert (Debug.debugEnter(CLASS_NAME, "setSASLAuthenticationInfo", String.valueOf(string), String.valueOf(aSN1OctetString)));
        this.saslMechanism = string;
        this.saslCredentials = aSN1OctetString;
        this.authenticationType = AuthenticationType.SASL;
        this.simplePassword = null;
    }

    public byte getType() {
        assert (Debug.debugEnter(CLASS_NAME, "getType", new String[0]));
        return 96;
    }

    public String getProtocolOpName() {
        assert (Debug.debugEnter(CLASS_NAME, "getProtocolOpName", new String[0]));
        return "Bind Request";
    }

    public ASN1Element encode() {
        assert (Debug.debugEnter(CLASS_NAME, "encode", new String[0]));
        ArrayList<ASN1Element> arrayList = new ArrayList<ASN1Element>(3);
        arrayList.add(new ASN1Integer(this.protocolVersion));
        arrayList.add(this.dn);
        if (this.authenticationType == AuthenticationType.SIMPLE) {
            this.simplePassword.setType((byte)-128);
            arrayList.add(this.simplePassword);
        } else {
            ArrayList<ASN1Element> arrayList2 = new ArrayList<ASN1Element>(2);
            arrayList2.add(new ASN1OctetString(this.saslMechanism));
            if (this.saslCredentials != null) {
                arrayList2.add(this.saslCredentials);
            }
            arrayList.add(new ASN1Sequence(-93, arrayList2));
        }
        return new ASN1Sequence(96, arrayList);
    }

    public static BindRequestProtocolOp decodeBindRequest(ASN1Element aSN1Element) throws LDAPException {
        AuthenticationType authenticationType;
        ASN1OctetString aSN1OctetString;
        int n;
        ArrayList<ASN1Element> arrayList;
        assert (Debug.debugEnter(CLASS_NAME, "decodeBindRequest", String.valueOf(aSN1Element)));
        try {
            arrayList = aSN1Element.decodeAsSequence().elements();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeBindRequest", exception));
            int n2 = 2293835;
            String string = MessageHandler.getMessage(n2, String.valueOf(exception));
            throw new LDAPException(2, n2, string, exception);
        }
        int n3 = arrayList.size();
        if (n3 != 3) {
            int n4 = 2293836;
            String string = MessageHandler.getMessage(n4, String.valueOf(n3));
            throw new LDAPException(2, n4, string);
        }
        try {
            n = arrayList.get(0).decodeAsInteger().intValue();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeBindRequest", exception));
            int n5 = 2293837;
            String string = MessageHandler.getMessage(n5, String.valueOf(exception));
            throw new LDAPException(2, n5, string, exception);
        }
        try {
            aSN1OctetString = arrayList.get(1).decodeAsOctetString();
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeBindRequest", exception));
            int n6 = 2293838;
            String string = MessageHandler.getMessage(n6, String.valueOf(exception));
            throw new LDAPException(2, n6, string, exception);
        }
        ASN1OctetString aSN1OctetString2 = null;
        String string = null;
        ASN1OctetString aSN1OctetString3 = null;
        try {
            aSN1Element = arrayList.get(2);
            switch (aSN1Element.getType()) {
                case -128: {
                    authenticationType = AuthenticationType.SIMPLE;
                    try {
                        aSN1OctetString2 = aSN1Element.decodeAsOctetString();
                        break;
                    }
                    catch (Exception exception) {
                        int n7 = 2293839;
                        String string2 = MessageHandler.getMessage(n7, String.valueOf(exception));
                        throw new LDAPException(2, n7, string2, exception);
                    }
                }
                case -93: {
                    authenticationType = AuthenticationType.SASL;
                    try {
                        arrayList = aSN1Element.decodeAsSequence().elements();
                        string = arrayList.get(0).decodeAsOctetString().stringValue();
                        if (arrayList.size() == 2) {
                            aSN1OctetString3 = arrayList.get(1).decodeAsOctetString();
                        }
                        break;
                    }
                    catch (Exception exception) {
                        int n8 = 2293840;
                        String string3 = MessageHandler.getMessage(n8, String.valueOf(exception));
                        throw new LDAPException(2, n8, string3, exception);
                    }
                }
                default: {
                    int n9 = 2293841;
                    String string4 = MessageHandler.getMessage(n9, aSN1Element.getType());
                    throw new LDAPException(7, n9, string4);
                }
            }
        }
        catch (LDAPException lDAPException) {
            throw lDAPException;
        }
        catch (Exception exception) {
            assert (Debug.debugException(CLASS_NAME, "decodeBindRequest", exception));
            int n10 = 2293842;
            String string5 = MessageHandler.getMessage(n10, String.valueOf(exception));
            throw new LDAPException(2, n10, string5, exception);
        }
        return new BindRequestProtocolOp(aSN1OctetString, n, authenticationType, aSN1OctetString2, string, aSN1OctetString3);
    }

    public void toString(StringBuilder stringBuilder) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder"));
        stringBuilder.append("BindRequest(version=");
        stringBuilder.append(this.protocolVersion);
        stringBuilder.append(", dn=");
        if (this.dn != null) {
            this.dn.toString(stringBuilder);
        }
        if (this.authenticationType == AuthenticationType.SIMPLE) {
            stringBuilder.append(", password=");
            this.simplePassword.toString(stringBuilder);
        } else {
            stringBuilder.append(", saslMechanism=");
            stringBuilder.append(this.saslMechanism);
            if (this.saslCredentials != null) {
                stringBuilder.append(", saslCredentials=");
                this.saslCredentials.toString(stringBuilder);
            }
        }
        stringBuilder.append(")");
    }

    public void toString(StringBuilder stringBuilder, int n) {
        assert (Debug.debugEnter(CLASS_NAME, "toString", "java.lang.StringBuilder", String.valueOf(n)));
        StringBuilder stringBuilder2 = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            stringBuilder2.append(' ');
        }
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("Bind Request");
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  Protocol Version:  ");
        stringBuilder.append(this.protocolVersion);
        stringBuilder.append(ServerConstants.EOL);
        stringBuilder.append((CharSequence)stringBuilder2);
        stringBuilder.append("  DN:  ");
        if (this.dn != null) {
            this.dn.toString(stringBuilder);
        }
        stringBuilder.append(ServerConstants.EOL);
        if (this.authenticationType == AuthenticationType.SIMPLE) {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  Simple Password:  ");
            stringBuilder.append(String.valueOf(this.simplePassword));
            stringBuilder.append(ServerConstants.EOL);
        } else {
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("  SASL Mechanism:  ");
            stringBuilder.append(this.saslMechanism);
            stringBuilder.append(ServerConstants.EOL);
            if (this.saslCredentials != null) {
                stringBuilder.append((CharSequence)stringBuilder2);
                stringBuilder.append("  SASL Credentials:");
                stringBuilder.append(ServerConstants.EOL);
                this.saslCredentials.toString(stringBuilder, n + 4);
            }
        }
    }
}

