/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.protocols.internal;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import org.opends.server.api.ClientConnection;
import org.opends.server.core.SearchOperation;
import org.opends.server.loggers.Debug;
import org.opends.server.protocols.internal.InternalSearchListener;
import org.opends.server.protocols.ldap.LDAPFilter;
import org.opends.server.types.ByteString;
import org.opends.server.types.Control;
import org.opends.server.types.DN;
import org.opends.server.types.DereferencePolicy;
import org.opends.server.types.SearchFilter;
import org.opends.server.types.SearchResultEntry;
import org.opends.server.types.SearchResultReference;
import org.opends.server.types.SearchScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalSearchOperation
extends SearchOperation {
    private static final String CLASS_NAME = "org.opends.server.protocols.internal.InternalSearchOperation";
    private InternalSearchListener searchListener;
    private LinkedList<SearchResultEntry> entryList;
    private LinkedList<SearchResultReference> referenceList;

    public InternalSearchOperation(ClientConnection clientConnection, long l, int n, List<Control> list, ByteString byteString, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n2, int n3, boolean bl, LDAPFilter lDAPFilter, LinkedHashSet<String> linkedHashSet, InternalSearchListener internalSearchListener) {
        super(clientConnection, l, n, list, byteString, searchScope, dereferencePolicy, n2, n3, bl, lDAPFilter, linkedHashSet);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(byteString), String.valueOf((Object)searchScope), String.valueOf((Object)dereferencePolicy), String.valueOf(n2), String.valueOf(n3), String.valueOf(bl), String.valueOf(lDAPFilter), String.valueOf(linkedHashSet), String.valueOf(internalSearchListener)));
        if (internalSearchListener == null) {
            this.searchListener = null;
            this.entryList = new LinkedList();
            this.referenceList = new LinkedList();
        } else {
            this.searchListener = internalSearchListener;
            this.entryList = null;
            this.referenceList = null;
        }
        this.setInternalOperation(true);
    }

    public InternalSearchOperation(ClientConnection clientConnection, long l, int n, List<Control> list, DN dN, SearchScope searchScope, DereferencePolicy dereferencePolicy, int n2, int n3, boolean bl, SearchFilter searchFilter, LinkedHashSet<String> linkedHashSet, InternalSearchListener internalSearchListener) {
        super(clientConnection, l, n, list, dN, searchScope, dereferencePolicy, n2, n3, bl, searchFilter, linkedHashSet);
        assert (Debug.debugConstructor(CLASS_NAME, String.valueOf(clientConnection), String.valueOf(l), String.valueOf(n), String.valueOf(list), String.valueOf(dN), String.valueOf((Object)searchScope), String.valueOf((Object)dereferencePolicy), String.valueOf(n2), String.valueOf(n3), String.valueOf(bl), String.valueOf(searchFilter), String.valueOf(linkedHashSet), String.valueOf(internalSearchListener)));
        if (internalSearchListener == null) {
            this.searchListener = null;
            this.entryList = new LinkedList();
            this.referenceList = new LinkedList();
        } else {
            this.searchListener = internalSearchListener;
            this.entryList = null;
            this.referenceList = null;
        }
        this.setInternalOperation(true);
    }

    public LinkedList<SearchResultEntry> getSearchEntries() {
        assert (Debug.debugEnter(CLASS_NAME, "getSearchEntries", new String[0]));
        return this.entryList;
    }

    public void addSearchEntry(SearchResultEntry searchResultEntry) {
        assert (Debug.debugEnter(CLASS_NAME, "addSearchEntry", String.valueOf(searchResultEntry)));
        if (this.searchListener == null) {
            this.entryList.add(searchResultEntry);
        } else {
            this.searchListener.handleInternalSearchEntry(this, searchResultEntry);
        }
    }

    public LinkedList<SearchResultReference> getSearchReferences() {
        assert (Debug.debugEnter(CLASS_NAME, "getSearchReferences", new String[0]));
        return this.referenceList;
    }

    public void addSearchReference(SearchResultReference searchResultReference) {
        assert (Debug.debugEnter(CLASS_NAME, "addSearchReference", String.valueOf(searchResultReference)));
        if (this.searchListener == null) {
            this.referenceList.add(searchResultReference);
        } else {
            this.searchListener.handleInternalSearchReference(this, searchResultReference);
        }
    }
}

