/*
 * Decompiled with CFR 0.152.
 */
package org.opends.server.plugins;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.opends.server.api.PasswordStorageScheme;
import org.opends.server.api.plugin.DirectoryServerPlugin;
import org.opends.server.api.plugin.LDIFPluginResult;
import org.opends.server.api.plugin.PluginType;
import org.opends.server.config.ConfigEntry;
import org.opends.server.config.ConfigException;
import org.opends.server.core.DirectoryServer;
import org.opends.server.core.PasswordPolicy;
import org.opends.server.loggers.Debug;
import org.opends.server.loggers.Error;
import org.opends.server.messages.MessageHandler;
import org.opends.server.schema.AuthPasswordSyntax;
import org.opends.server.schema.UserPasswordSyntax;
import org.opends.server.types.Attribute;
import org.opends.server.types.AttributeType;
import org.opends.server.types.AttributeValue;
import org.opends.server.types.ByteString;
import org.opends.server.types.Entry;
import org.opends.server.types.ErrorLogCategory;
import org.opends.server.types.ErrorLogSeverity;
import org.opends.server.types.LDIFImportConfig;
import org.opends.server.util.StaticUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PasswordPolicyImportPlugin
extends DirectoryServerPlugin {
    private static final String CLASS_NAME = "org.opends.server.plugins.PasswordPolicyImportPlugin";
    private final HashMap<AttributeType, PasswordStorageScheme[]> authPasswordSchemes;
    private final HashMap<AttributeType, PasswordStorageScheme[]> userPasswordSchemes;

    public PasswordPolicyImportPlugin() {
        assert (Debug.debugConstructor(CLASS_NAME, new String[0]));
        this.authPasswordSchemes = new HashMap();
        this.userPasswordSchemes = new HashMap();
        for (PasswordPolicy passwordPolicy : DirectoryServer.getPasswordPolicies().values()) {
            Cloneable cloneable;
            PasswordStorageScheme[] passwordStorageSchemeArray;
            AttributeType attributeType = passwordPolicy.getPasswordAttribute();
            if (passwordPolicy.usesAuthPasswordSyntax()) {
                passwordStorageSchemeArray = this.authPasswordSchemes.get(attributeType);
                if (passwordStorageSchemeArray == null) {
                    cloneable = passwordPolicy.getDefaultStorageSchemes();
                    passwordStorageSchemeArray = new PasswordStorageScheme[((CopyOnWriteArrayList)cloneable).size()];
                    ((CopyOnWriteArrayList)cloneable).toArray(passwordStorageSchemeArray);
                    this.authPasswordSchemes.put(attributeType, passwordStorageSchemeArray);
                    continue;
                }
                cloneable = new LinkedHashSet();
                for (PasswordStorageScheme passwordStorageScheme : passwordStorageSchemeArray) {
                    ((HashSet)cloneable).add(passwordStorageScheme);
                }
                for (PasswordStorageScheme passwordStorageScheme : passwordPolicy.getDefaultStorageSchemes()) {
                    ((HashSet)cloneable).add(passwordStorageScheme);
                }
                passwordStorageSchemeArray = new PasswordStorageScheme[((HashSet)cloneable).size()];
                ((HashSet)cloneable).toArray(passwordStorageSchemeArray);
                this.authPasswordSchemes.put(attributeType, passwordStorageSchemeArray);
                continue;
            }
            passwordStorageSchemeArray = this.userPasswordSchemes.get(attributeType);
            if (passwordStorageSchemeArray == null) {
                cloneable = passwordPolicy.getDefaultStorageSchemes();
                passwordStorageSchemeArray = new PasswordStorageScheme[((CopyOnWriteArrayList)cloneable).size()];
                ((CopyOnWriteArrayList)cloneable).toArray(passwordStorageSchemeArray);
                this.userPasswordSchemes.put(attributeType, passwordStorageSchemeArray);
                continue;
            }
            cloneable = new LinkedHashSet();
            for (PasswordStorageScheme passwordStorageScheme : passwordStorageSchemeArray) {
                ((HashSet)cloneable).add(passwordStorageScheme);
            }
            for (PasswordStorageScheme passwordStorageScheme : passwordPolicy.getDefaultStorageSchemes()) {
                ((HashSet)cloneable).add(passwordStorageScheme);
            }
            passwordStorageSchemeArray = new PasswordStorageScheme[((HashSet)cloneable).size()];
            ((HashSet)cloneable).toArray(passwordStorageSchemeArray);
            this.userPasswordSchemes.put(attributeType, passwordStorageSchemeArray);
        }
    }

    @Override
    public final void initializePlugin(Set<PluginType> set, ConfigEntry configEntry) throws ConfigException {
        assert (Debug.debugEnter(CLASS_NAME, "initializePlugin", String.valueOf(set), String.valueOf(configEntry)));
        block3: for (PluginType pluginType : set) {
            switch (pluginType) {
                case LDIF_IMPORT: {
                    continue block3;
                }
            }
            int n = 7602241;
            String string = MessageHandler.getMessage(n, pluginType.toString());
            throw new ConfigException(n, string);
        }
    }

    @Override
    public final LDIFPluginResult doLDIFImport(LDIFImportConfig lDIFImportConfig, Entry entry) {
        int n;
        ByteString byteString2;
        Object object;
        Iterator iterator;
        LinkedHashSet<AttributeValue> linkedHashSet;
        PasswordStorageScheme[] passwordStorageSchemeArray;
        List<Attribute> list;
        assert (Debug.debugEnter(CLASS_NAME, "doLDIFImport", String.valueOf(lDIFImportConfig), String.valueOf(entry)));
        ArrayList<ByteString> arrayList = new ArrayList<ByteString>();
        for (AttributeType attributeType : this.authPasswordSchemes.keySet()) {
            list = entry.getAttribute(attributeType);
            if (list == null || list.isEmpty()) continue;
            passwordStorageSchemeArray = this.authPasswordSchemes.get(attributeType);
            for (Attribute attribute : list) {
                arrayList.clear();
                linkedHashSet = attribute.getValues();
                iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    object = (AttributeValue)iterator.next();
                    byteString2 = ((AttributeValue)object).getValue();
                    if (AuthPasswordSyntax.isEncoded(byteString2)) continue;
                    try {
                        for (PasswordStorageScheme passwordStorageScheme : passwordStorageSchemeArray) {
                            arrayList.add(passwordStorageScheme.encodeAuthPassword(byteString2));
                        }
                        iterator.remove();
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "doLDIFImport", exception));
                        n = 7602242;
                        String string = MessageHandler.getMessage(n, attributeType.getNameOrOID(), String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                        Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                        arrayList.clear();
                        break;
                    }
                }
                for (ByteString byteString2 : arrayList) {
                    linkedHashSet.add(new AttributeValue(attributeType, byteString2));
                }
            }
        }
        for (AttributeType attributeType : this.userPasswordSchemes.keySet()) {
            list = entry.getAttribute(attributeType);
            if (list == null || list.isEmpty()) continue;
            passwordStorageSchemeArray = this.userPasswordSchemes.get(attributeType);
            for (Attribute attribute : list) {
                arrayList.clear();
                linkedHashSet = attribute.getValues();
                iterator = linkedHashSet.iterator();
                while (iterator.hasNext()) {
                    object = (AttributeValue)iterator.next();
                    byteString2 = ((AttributeValue)object).getValue();
                    if (UserPasswordSyntax.isEncoded(byteString2)) continue;
                    try {
                        for (PasswordStorageScheme passwordStorageScheme : passwordStorageSchemeArray) {
                            arrayList.add(passwordStorageScheme.encodePasswordWithScheme(byteString2));
                        }
                        iterator.remove();
                    }
                    catch (Exception exception) {
                        assert (Debug.debugException(CLASS_NAME, "doLDIFImport", exception));
                        n = 7602242;
                        String string = MessageHandler.getMessage(n, attributeType.getNameOrOID(), String.valueOf(entry.getDN()), StaticUtils.stackTraceToSingleLineString(exception));
                        Error.logError(ErrorLogCategory.PLUGIN, ErrorLogSeverity.SEVERE_ERROR, string, n);
                        arrayList.clear();
                        break;
                    }
                }
                for (ByteString byteString2 : arrayList) {
                    linkedHashSet.add(new AttributeValue(attributeType, byteString2));
                }
            }
        }
        return LDIFPluginResult.SUCCESS;
    }
}

